// Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
//     http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/awslabs/amazon-ecr-credential-helper/ecr-login/api (interfaces: ClientFactory,Client)

// Package mock_api is a generated GoMock package.
package mock_api

import (
	reflect "reflect"

	aws "github.com/aws/aws-sdk-go/aws"
	session "github.com/aws/aws-sdk-go/aws/session"
	api "github.com/awslabs/amazon-ecr-credential-helper/ecr-login/api"
	gomock "github.com/golang/mock/gomock"
)

// MockClientFactory is a mock of ClientFactory interface
type MockClientFactory struct {
	ctrl     *gomock.Controller
	recorder *MockClientFactoryMockRecorder
}

// MockClientFactoryMockRecorder is the mock recorder for MockClientFactory
type MockClientFactoryMockRecorder struct {
	mock *MockClientFactory
}

// NewMockClientFactory creates a new mock instance
func NewMockClientFactory(ctrl *gomock.Controller) *MockClientFactory {
	mock := &MockClientFactory{ctrl: ctrl}
	mock.recorder = &MockClientFactoryMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockClientFactory) EXPECT() *MockClientFactoryMockRecorder {
	return m.recorder
}

// NewClient mocks base method
func (m *MockClientFactory) NewClient(arg0 *session.Session, arg1 *aws.Config) api.Client {
	ret := m.ctrl.Call(m, "NewClient", arg0, arg1)
	ret0, _ := ret[0].(api.Client)
	return ret0
}

// NewClient indicates an expected call of NewClient
func (mr *MockClientFactoryMockRecorder) NewClient(arg0, arg1 interface{}) *gomock.Call {
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NewClient", reflect.TypeOf((*MockClientFactory)(nil).NewClient), arg0, arg1)
}

// NewClientFromRegion mocks base method
func (m *MockClientFactory) NewClientFromRegion(arg0 string) api.Client {
	ret := m.ctrl.Call(m, "NewClientFromRegion", arg0)
	ret0, _ := ret[0].(api.Client)
	return ret0
}

// NewClientFromRegion indicates an expected call of NewClientFromRegion
func (mr *MockClientFactoryMockRecorder) NewClientFromRegion(arg0 interface{}) *gomock.Call {
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NewClientFromRegion", reflect.TypeOf((*MockClientFactory)(nil).NewClientFromRegion), arg0)
}

// NewClientWithDefaults mocks base method
func (m *MockClientFactory) NewClientWithDefaults() api.Client {
	ret := m.ctrl.Call(m, "NewClientWithDefaults")
	ret0, _ := ret[0].(api.Client)
	return ret0
}

// NewClientWithDefaults indicates an expected call of NewClientWithDefaults
func (mr *MockClientFactoryMockRecorder) NewClientWithDefaults() *gomock.Call {
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NewClientWithDefaults", reflect.TypeOf((*MockClientFactory)(nil).NewClientWithDefaults))
}

// NewClientWithFipsEndpoint mocks base method
func (m *MockClientFactory) NewClientWithFipsEndpoint(arg0 string) api.Client {
	ret := m.ctrl.Call(m, "NewClientWithFipsEndpoint", arg0)
	ret0, _ := ret[0].(api.Client)
	return ret0
}

// NewClientWithFipsEndpoint indicates an expected call of NewClientWithFipsEndpoint
func (mr *MockClientFactoryMockRecorder) NewClientWithFipsEndpoint(arg0 interface{}) *gomock.Call {
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NewClientWithFipsEndpoint", reflect.TypeOf((*MockClientFactory)(nil).NewClientWithFipsEndpoint), arg0)
}

// NewClientWithOptions mocks base method
func (m *MockClientFactory) NewClientWithOptions(arg0 api.Options) api.Client {
	ret := m.ctrl.Call(m, "NewClientWithOptions", arg0)
	ret0, _ := ret[0].(api.Client)
	return ret0
}

// NewClientWithOptions indicates an expected call of NewClientWithOptions
func (mr *MockClientFactoryMockRecorder) NewClientWithOptions(arg0 interface{}) *gomock.Call {
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NewClientWithOptions", reflect.TypeOf((*MockClientFactory)(nil).NewClientWithOptions), arg0)
}

// MockClient is a mock of Client interface
type MockClient struct {
	ctrl     *gomock.Controller
	recorder *MockClientMockRecorder
}

// MockClientMockRecorder is the mock recorder for MockClient
type MockClientMockRecorder struct {
	mock *MockClient
}

// NewMockClient creates a new mock instance
func NewMockClient(ctrl *gomock.Controller) *MockClient {
	mock := &MockClient{ctrl: ctrl}
	mock.recorder = &MockClientMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockClient) EXPECT() *MockClientMockRecorder {
	return m.recorder
}

// GetCredentials mocks base method
func (m *MockClient) GetCredentials(arg0 string) (*api.Auth, error) {
	ret := m.ctrl.Call(m, "GetCredentials", arg0)
	ret0, _ := ret[0].(*api.Auth)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCredentials indicates an expected call of GetCredentials
func (mr *MockClientMockRecorder) GetCredentials(arg0 interface{}) *gomock.Call {
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCredentials", reflect.TypeOf((*MockClient)(nil).GetCredentials), arg0)
}

// GetCredentialsByRegistryID mocks base method
func (m *MockClient) GetCredentialsByRegistryID(arg0 string) (*api.Auth, error) {
	ret := m.ctrl.Call(m, "GetCredentialsByRegistryID", arg0)
	ret0, _ := ret[0].(*api.Auth)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCredentialsByRegistryID indicates an expected call of GetCredentialsByRegistryID
func (mr *MockClientMockRecorder) GetCredentialsByRegistryID(arg0 interface{}) *gomock.Call {
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCredentialsByRegistryID", reflect.TypeOf((*MockClient)(nil).GetCredentialsByRegistryID), arg0)
}

// ListCredentials mocks base method
func (m *MockClient) ListCredentials() ([]*api.Auth, error) {
	ret := m.ctrl.Call(m, "ListCredentials")
	ret0, _ := ret[0].([]*api.Auth)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListCredentials indicates an expected call of ListCredentials
func (mr *MockClientMockRecorder) ListCredentials() *gomock.Call {
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListCredentials", reflect.TypeOf((*MockClient)(nil).ListCredentials))
}
