#include "mmxnow_private.h"

static void rgb16_to_rgb24(STDCONV_PARAMS)
{

    col* dest;
    const uint16_t* src;
    uint16_t sh;
    int i;
    dest=(col*)to+width*height-1;

    if(!flip_dir)
	src=(const uint16_t*)from+width*height-1;
    else
	src=(const uint16_t*)from+width-1;

    for(i = height-1; i>=0; i--)
    {
        int j;
	for(j = width - 1; j >= 0; j--)
	{
	    sh = *src;
	    dest->r=(sh & 0xF800) >> 8;
	    dest->g=(sh & 0x7E0) >> 3;
	    dest->b=(sh & 0x1F) << 3;
	    dest--;
	    src--;
	}
	if (flip_dir)
	    src+=2*width;
    }
}

static rgb32ToRgb24(STDCONV_PARAMS)
{
    col* dest;
    dest=(col*)to+width*height-1;
    if(!flip_dir)
	from+=4*(width*height-1);
    else
	from+=4*(width-1);
    for(int i=height-1; i>=0; i--)
    {
	for(int j=width-1; j>=0; j--)
	{
	    *dest=*(const col*)from;
	    dest--;
	    from-=4;
	}
	if(flip_dir)from+=8*width;
    }
}
