/* blepvco - minBLEP-based, hard-sync-capable LADSPA VCOs.
 *
 * Copyright (C) 2004-2005 Sean Bolton.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#include "minblep_tables.h"

/* minBLEP tables
 *
 * sinc cutoff frequency: 0.9 nyquist
 * oversampling: 64
 * zero crossings: 32
 * Blackman window width: 4553
 *
 * run-time phase calculation simplified by shifting minBLEP discontinuity
 * center from 3.410565541 samples forward to 4 samples (using cubic
 * interpolation)
 *
 * forward-shifted step discontinuity delta truncated after local minimum
 * at the 4606th oversample (yielding a 72 sample pulse)
 *
 * forward-shifted slope discontinuity delta truncated after local minimum
 * at 4513th oversample (yielding a 71 sample pulse)
 *
 * For more information, see:
 *
 *    Stilson and Smith, "Alias Free Digital Synthesis of Classic Analog
 *        Waveforms" (1996)
 *
 *    Brandt, "Hard Sync Without Aliasing" (2001)
 */

float_value_delta
step_dd_table[MINBLEP_PHASES * STEP_DD_PULSE_LENGTH + 1] =
{
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 3.120482e-10},{ 3.120482e-10, 2.206609e-10},
 { 5.327092e-10, 3.324312e-10},{ 8.651403e-10, 5.145088e-10},{ 1.379649e-09, 7.942354e-10},{ 2.173885e-09, 1.204876e-09},
 { 3.378760e-09, 1.786398e-09},{ 5.165158e-09, 2.586320e-09},{ 7.751479e-09, 3.660623e-09},{ 1.141210e-08, 5.074729e-09},
 { 1.648683e-08, 6.904565e-09},{ 2.339140e-08, 9.237687e-09},{ 3.262908e-08, 1.217450e-08},{ 4.480358e-08, 1.582954e-08},
 { 6.063312e-08, 2.033287e-08},{ 8.096600e-08, 2.583154e-08},{ 1.067975e-07, 3.249112e-08},{ 1.392887e-07, 4.049741e-08},
 { 1.797861e-07, 5.005814e-08},{ 2.298442e-07, 6.140481e-08},{ 2.912490e-07, 7.479471e-08},{ 3.660437e-07, 9.051290e-08},
 { 4.565566e-07, 1.088744e-07},{ 5.654310e-07, 1.302265e-07},{ 6.956576e-07, 1.549511e-07},{ 8.506087e-07, 1.834673e-07},
 { 1.034076e-06, 2.162337e-07},{ 1.250310e-06, 2.537516e-07},{ 1.504061e-06, 2.965676e-07},{ 1.800629e-06, 3.452766e-07},
 { 2.145905e-06, 4.005248e-07},{ 2.546430e-06, 4.630131e-07},{ 3.009443e-06, 5.335006e-07},{ 3.542944e-06, 6.128074e-07},
 { 4.155751e-06, 7.018190e-07},{ 4.857570e-06, 8.014896e-07},{ 5.659060e-06, 9.128461e-07},{ 6.571906e-06, 1.036992e-06},
 { 7.608898e-06, 1.175111e-06},{ 8.784009e-06, 1.328473e-06},{ 1.011248e-05, 1.498436e-06},{ 1.161092e-05, 1.686453e-06},
 { 1.329737e-05, 1.894074e-06},{ 1.519145e-05, 2.122953e-06},{ 1.731440e-05, 2.374853e-06},{ 1.968925e-05, 2.651647e-06},
 { 2.234090e-05, 2.955330e-06},{ 2.529623e-05, 3.288017e-06},{ 2.858425e-05, 3.651953e-06},{ 3.223620e-05, 4.049517e-06},
 { 3.628572e-05, 4.483227e-06},{ 4.076894e-05, 4.955747e-06},{ 4.572469e-05, 5.469889e-06},{ 5.119458e-05, 6.028626e-06},
 { 5.722321e-05, 6.635089e-06},{ 6.385829e-05, 7.292579e-06},{ 7.115087e-05, 8.004571e-06},{ 7.915544e-05, 8.774720e-06},
 { 8.793016e-05, 9.606867e-06},{ 9.753703e-05, 1.050505e-05},{ 1.080421e-04, 1.147349e-05},{ 1.195156e-04, 1.251663e-05},
 { 1.320322e-04, 1.363912e-05},{ 1.456713e-04, 1.484582e-05},{ 1.605171e-04, 1.614182e-05},{ 1.766590e-04, 1.753243e-05},
 { 1.941914e-04, 1.902321e-05},{ 2.132146e-04, 2.061994e-05},{ 2.338345e-04, 2.232867e-05},{ 2.561632e-04, 2.415570e-05},
 { 2.803189e-04, 2.610756e-05},{ 3.064265e-04, 2.819109e-05},{ 3.346175e-04, 3.041336e-05},{ 3.650309e-04, 3.278175e-05},
 { 3.978127e-04, 3.530389e-05},{ 4.331165e-04, 3.798772e-05},{ 4.711043e-04, 4.084145e-05},{ 5.119457e-04, 4.387362e-05},
 { 5.558193e-04, 4.709304e-05},{ 6.029124e-04, 5.050884e-05},{ 6.534212e-04, 5.413046e-05},{ 7.075517e-04, 5.796764e-05},
 { 7.655193e-04, 6.203045e-05},{ 8.275498e-04, 6.632929e-05},{ 8.938791e-04, 7.087487e-05},{ 9.647539e-04, 7.567823e-05},
 { 1.040432e-03, 8.075075e-05},{ 1.121183e-03, 8.610411e-05},{ 1.207287e-03, 9.175038e-05},{ 1.299037e-03, 9.770190e-05},
 { 1.396739e-03, 1.039714e-04},{ 1.500711e-03, 1.105719e-04},{ 1.611283e-03, 1.175168e-04},{ 1.728799e-03, 1.248199e-04},
 { 1.853619e-03, 1.324951e-04},{ 1.986114e-03, 1.405569e-04},{ 2.126671e-03, 1.490200e-04},{ 2.275691e-03, 1.578994e-04},
 { 2.433591e-03, 1.672105e-04},{ 2.600801e-03, 1.769690e-04},{ 2.777770e-03, 1.871910e-04},{ 2.964961e-03, 1.978928e-04},
 { 3.162854e-03, 2.090910e-04},{ 3.371945e-03, 2.208027e-04},{ 3.592748e-03, 2.330449e-04},{ 3.825793e-03, 2.458354e-04},
 { 4.071628e-03, 2.591919e-04},{ 4.330820e-03, 2.731325e-04},{ 4.603952e-03, 2.876756e-04},{ 4.891628e-03, 3.028398e-04},
 { 5.194468e-03, 3.186440e-04},{ 5.513112e-03, 3.351072e-04},{ 5.848219e-03, 3.522489e-04},{ 6.200468e-03, 3.700886e-04},
 { 6.570556e-03, 3.886459e-04},{ 6.959202e-03, 4.079409e-04},{ 7.367143e-03, 4.279935e-04},{ 7.795137e-03, 4.488240e-04},
 { 8.243961e-03, 4.704527e-04},{ 8.714413e-03, 4.929003e-04},{ 9.207314e-03, 5.161871e-04},{ 9.723501e-03, 5.403339e-04},
 { 1.026383e-02, 5.653614e-04},{ 1.082920e-02, 5.912904e-04},{ 1.142049e-02, 6.181416e-04},{ 1.203863e-02, 6.459359e-04},
 { 1.268456e-02, 6.746938e-04},{ 1.335926e-02, 7.044362e-04},{ 1.406369e-02, 7.351837e-04},{ 1.479888e-02, 7.669568e-04},
 { 1.556583e-02, 7.997758e-04},{ 1.636561e-02, 8.336610e-04},{ 1.719927e-02, 8.686325e-04},{ 1.806790e-02, 9.047101e-04},
 { 1.897261e-02, 9.419135e-04},{ 1.991453e-02, 9.802619e-04},{ 2.089479e-02, 1.019775e-03},{ 2.191456e-02, 1.060470e-03},
 { 2.297503e-02, 1.102367e-03},{ 2.407740e-02, 1.145483e-03},{ 2.522288e-02, 1.189835e-03},{ 2.641272e-02, 1.235442e-03},
 { 2.764816e-02, 1.282319e-03},{ 2.893048e-02, 1.330483e-03},{ 3.026096e-02, 1.379949e-03},{ 3.164091e-02, 1.430732e-03},
 { 3.307164e-02, 1.482847e-03},{ 3.455449e-02, 1.536306e-03},{ 3.609080e-02, 1.591124e-03},{ 3.768192e-02, 1.647312e-03},
 { 3.932923e-02, 1.704882e-03},{ 4.103411e-02, 1.763844e-03},{ 4.279796e-02, 1.824208e-03},{ 4.462217e-02, 1.885984e-03},
 { 4.650815e-02, 1.949179e-03},{ 4.845733e-02, 2.013800e-03},{ 5.047113e-02, 2.079853e-03},{ 5.255098e-02, 2.147344e-03},
 { 5.469833e-02, 2.216276e-03},{ 5.691460e-02, 2.286653e-03},{ 5.920126e-02, 2.358476e-03},{ 6.155973e-02, 2.431746e-03},
 { 6.399148e-02, 2.506461e-03},{ 6.649794e-02, 2.582621e-03},{ 6.908056e-02, 2.660222e-03},{ 7.174078e-02, 2.739260e-03},
 { 7.448004e-02, 2.819729e-03},{ 7.729977e-02, 2.901622e-03},{ 8.020139e-02, 2.984930e-03},{ 8.318632e-02, 3.069643e-03},
 { 8.625597e-02, 3.155751e-03},{ 8.941172e-02, 3.243239e-03},{ 9.265496e-02, 3.332094e-03},{ 9.598705e-02, 3.422299e-03},
 { 9.940935e-02, 3.513838e-03},{ 1.029232e-01, 3.606690e-03},{ 1.065299e-01, 3.700835e-03},{ 1.102307e-01, 3.796251e-03},
 { 1.140270e-01, 3.892913e-03},{ 1.179199e-01, 3.990795e-03},{ 1.219107e-01, 4.089871e-03},{ 1.260005e-01, 4.190110e-03},
 { 1.301907e-01, 4.291482e-03},{ 1.344821e-01, 4.393954e-03},{ 1.388761e-01, 4.497491e-03},{ 1.433736e-01, 4.602058e-03},
 { 1.479756e-01, 4.707615e-03},{ 1.526833e-01, 4.814124e-03},{ 1.574974e-01, 4.921543e-03},{ 1.624189e-01, 5.029827e-03},
 { 1.674487e-01, 5.138932e-03},{ 1.725877e-01, 5.248810e-03},{ 1.778365e-01, 5.359413e-03},{ 1.831959e-01, 5.470691e-03},
 { 1.886666e-01, 5.582589e-03},{ 1.942492e-01, 5.695055e-03},{ 1.999442e-01, 5.808032e-03},{ 2.057523e-01, 5.921462e-03},
 { 2.116737e-01, 6.035286e-03},{ 2.177090e-01, 6.149442e-03},{ 2.238585e-01, 6.263868e-03},{ 2.301223e-01, 6.378499e-03},
 { 2.365008e-01, 6.493268e-03},{ 2.429941e-01, 6.608108e-03},{ 2.496022e-01, 6.722950e-03},{ 2.563251e-01, 6.837721e-03},
 { 2.631629e-01, 6.952350e-03},{ 2.701152e-01, 7.066762e-03},{ 2.771820e-01, 7.180882e-03},{ 2.843629e-01, 7.294633e-03},
 { 2.916575e-01, 7.407937e-03},{ 2.990654e-01, 7.520713e-03},{ 3.065861e-01, 7.632882e-03},{ 3.142190e-01, 7.744361e-03},
 { 3.219634e-01, 7.855066e-03},{ 3.298185e-01, 7.964915e-03},{ 3.377834e-01, 8.073820e-03},{ 3.458572e-01, 8.181696e-03},
 {-6.459611e-01, 8.288455e-03},{-6.376727e-01, 8.394011e-03},{-6.292786e-01, 8.498272e-03},{-6.207804e-01, 8.601151e-03},
 {-6.121792e-01, 8.702557e-03},{-6.034767e-01, 8.802399e-03},{-5.946743e-01, 8.900586e-03},{-5.857737e-01, 8.997026e-03},
 {-5.767767e-01, 9.091628e-03},{-5.676850e-01, 9.184299e-03},{-5.585007e-01, 9.274948e-03},{-5.492258e-01, 9.363481e-03},
 {-5.398623e-01, 9.449807e-03},{-5.304125e-01, 9.533834e-03},{-5.208787e-01, 9.615469e-03},{-5.112632e-01, 9.694621e-03},
 {-5.015686e-01, 9.771199e-03},{-4.917974e-01, 9.845112e-03},{-4.819523e-01, 9.916271e-03},{-4.720360e-01, 9.984585e-03},
 {-4.620514e-01, 1.004997e-02},{-4.520014e-01, 1.011233e-02},{-4.418891e-01, 1.017158e-02},{-4.317175e-01, 1.022764e-02},
 {-4.214899e-01, 1.028043e-02},{-4.112095e-01, 1.032986e-02},{-4.008796e-01, 1.037584e-02},{-3.905038e-01, 1.041831e-02},
 {-3.800854e-01, 1.045717e-02},{-3.696283e-01, 1.049236e-02},{-3.591359e-01, 1.052380e-02},{-3.486121e-01, 1.055141e-02},
 {-3.380607e-01, 1.057514e-02},{-3.274856e-01, 1.059489e-02},{-3.168907e-01, 1.061062e-02},{-3.062801e-01, 1.062226e-02},
 {-2.956578e-01, 1.062974e-02},{-2.850280e-01, 1.063301e-02},{-2.743950e-01, 1.063201e-02},{-2.637630e-01, 1.062669e-02},
 {-2.531363e-01, 1.061699e-02},{-2.425193e-01, 1.060288e-02},{-2.319165e-01, 1.058429e-02},{-2.213322e-01, 1.056120e-02},
 {-2.107710e-01, 1.053356e-02},{-2.002374e-01, 1.050135e-02},{-1.897361e-01, 1.046452e-02},{-1.792715e-01, 1.042305e-02},
 {-1.688485e-01, 1.037691e-02},{-1.584716e-01, 1.032609e-02},{-1.481455e-01, 1.027056e-02},{-1.378749e-01, 1.021032e-02},
 {-1.276646e-01, 1.014535e-02},{-1.175193e-01, 1.007565e-02},{-1.074436e-01, 1.000122e-02},{-9.744240e-02, 9.922048e-03},
 {-8.752035e-02, 9.838154e-03},{-7.768220e-02, 9.749546e-03},{-6.793265e-02, 9.656236e-03},{-5.827642e-02, 9.558243e-03},
 {-4.871817e-02, 9.455591e-03},{-3.926258e-02, 9.348307e-03},{-2.991427e-02, 9.236422e-03},{-2.067785e-02, 9.119972e-03},
 {-1.155788e-02, 8.998997e-03},{-2.558884e-03, 8.873541e-03},{ 6.314658e-03, 8.743654e-03},{ 1.505831e-02, 8.609388e-03},
 { 2.366770e-02, 8.470802e-03},{ 3.213850e-02, 8.327956e-03},{ 4.046646e-02, 8.180917e-03},{ 4.864737e-02, 8.029757e-03},
 { 5.667713e-02, 7.874549e-03},{ 6.455168e-02, 7.715372e-03},{ 7.226705e-02, 7.552312e-03},{ 7.981936e-02, 7.385454e-03},
 { 8.720482e-02, 7.214891e-03},{ 9.441971e-02, 7.040720e-03},{ 1.014604e-01, 6.863039e-03},{ 1.083235e-01, 6.681954e-03},
 { 1.150054e-01, 6.497572e-03},{ 1.215030e-01, 6.310005e-03},{ 1.278130e-01, 6.119370e-03},{ 1.339324e-01, 5.925786e-03},
 { 1.398582e-01, 5.729376e-03},{ 1.455875e-01, 5.530267e-03},{ 1.511178e-01, 5.328589e-03},{ 1.564464e-01, 5.124477e-03},
 { 1.615709e-01, 4.918068e-03},{ 1.664889e-01, 4.709501e-03},{ 1.711984e-01, 4.498921e-03},{ 1.756974e-01, 4.286473e-03},
 { 1.799838e-01, 4.072307e-03},{ 1.840561e-01, 3.856574e-03},{ 1.879127e-01, 3.639430e-03},{ 1.915521e-01, 3.421032e-03},
 { 1.949732e-01, 3.201538e-03},{ 1.981747e-01, 2.981110e-03},{ 2.011558e-01, 2.759911e-03},{ 2.039157e-01, 2.538108e-03},
 { 2.064538e-01, 2.315867e-03},{ 2.087697e-01, 2.093357e-03},{ 2.108631e-01, 1.870748e-03},{ 2.127338e-01, 1.648211e-03},
 { 2.143820e-01, 1.425919e-03},{ 2.158079e-01, 1.204046e-03},{ 2.170120e-01, 9.827644e-04},{ 2.179947e-01, 7.622504e-04},
 { 2.187570e-01, 5.426784e-04},{ 2.192997e-01, 3.242237e-04},{ 2.196239e-01, 1.070617e-04},{ 2.197310e-01,-1.086325e-04},
 { 2.196223e-01,-3.226842e-04},{ 2.192996e-01,-5.349190e-04},{ 2.187647e-01,-7.451636e-04},{ 2.180196e-01,-9.532451e-04},
 { 2.170663e-01,-1.158992e-03},{ 2.159073e-01,-1.362235e-03},{ 2.145451e-01,-1.562803e-03},{ 2.129823e-01,-1.760532e-03},
 { 2.112218e-01,-1.955254e-03},{ 2.092665e-01,-2.146807e-03},{ 2.071197e-01,-2.335030e-03},{ 2.047847e-01,-2.519764e-03},
 { 2.022649e-01,-2.700854e-03},{ 1.995640e-01,-2.878146e-03},{ 1.966859e-01,-3.051490e-03},{ 1.936344e-01,-3.220738e-03},
 { 1.904137e-01,-3.385748e-03},{ 1.870279e-01,-3.546378e-03},{ 1.834815e-01,-3.702493e-03},{ 1.797791e-01,-3.853960e-03},
 { 1.759251e-01,-4.000649e-03},{ 1.719244e-01,-4.142436e-03},{ 1.677820e-01,-4.279202e-03},{ 1.635028e-01,-4.410830e-03},
 { 1.590920e-01,-4.537209e-03},{ 1.545548e-01,-4.658234e-03},{ 1.498965e-01,-4.773802e-03},{ 1.451227e-01,-4.883817e-03},
 { 1.402389e-01,-4.988190e-03},{ 1.352507e-01,-5.086832e-03},{ 1.301639e-01,-5.179666e-03},{ 1.249842e-01,-5.266615e-03},
 { 1.197176e-01,-5.347611e-03},{ 1.143700e-01,-5.422591e-03},{ 1.089474e-01,-5.491498e-03},{ 1.034559e-01,-5.554279e-03},
 { 9.790163e-02,-5.610891e-03},{ 9.229074e-02,-5.661293e-03},{ 8.662945e-02,-5.705453e-03},{ 8.092399e-02,-5.743345e-03},
 { 7.518065e-02,-5.774949e-03},{ 6.940570e-02,-5.800250e-03},{ 6.360545e-02,-5.819241e-03},{ 5.778621e-02,-5.831922e-03},
 { 5.195429e-02,-5.838298e-03},{ 4.611599e-02,-5.838382e-03},{ 4.027761e-02,-5.832192e-03},{ 3.444542e-02,-5.819753e-03},
 { 2.862566e-02,-5.801098e-03},{ 2.282457e-02,-5.776266e-03},{ 1.704830e-02,-5.745300e-03},{ 1.130300e-02,-5.708254e-03},
 { 5.594745e-03,-5.665184e-03},{-7.043896e-05,-5.616156e-03},{-5.686595e-03,-5.561240e-03},{-1.124783e-02,-5.500513e-03},
 {-1.674835e-02,-5.434059e-03},{-2.218241e-02,-5.361968e-03},{-2.754437e-02,-5.284335e-03},{-3.282871e-02,-5.201263e-03},
 {-3.802997e-02,-5.112859e-03},{-4.314283e-02,-5.019236e-03},{-4.816207e-02,-4.920515e-03},{-5.308258e-02,-4.816820e-03},
 {-5.789940e-02,-4.708281e-03},{-6.260768e-02,-4.595035e-03},{-6.720272e-02,-4.477222e-03},{-7.167994e-02,-4.354988e-03},
 {-7.603493e-02,-4.228484e-03},{-8.026341e-02,-4.097866e-03},{-8.436128e-02,-3.963294e-03},{-8.832457e-02,-3.824933e-03},
 {-9.214951e-02,-3.682952e-03},{-9.583246e-02,-3.537523e-03},{-9.936998e-02,-3.388823e-03},{-1.027588e-01,-3.237033e-03},
 {-1.059958e-01,-3.082336e-03},{-1.090782e-01,-2.924919e-03},{-1.120031e-01,-2.764972e-03},{-1.147681e-01,-2.602689e-03},
 {-1.173708e-01,-2.438264e-03},{-1.198090e-01,-2.271895e-03},{-1.220809e-01,-2.103782e-03},{-1.241847e-01,-1.934127e-03},
 {-1.261188e-01,-1.763134e-03},{-1.278820e-01,-1.591006e-03},{-1.294730e-01,-1.417950e-03},{-1.308909e-01,-1.244172e-03},
 {-1.321351e-01,-1.069881e-03},{-1.332050e-01,-8.952843e-04},{-1.341002e-01,-7.205895e-04},{-1.348208e-01,-5.460051e-04},
 {-1.353668e-01,-3.717387e-04},{-1.357386e-01,-1.979973e-04},{-1.359366e-01,-2.498729e-05},{-1.359616e-01, 1.470862e-04},
 {-1.358145e-01, 3.180193e-04},{-1.354965e-01, 4.876097e-04},{-1.350089e-01, 6.556572e-04},{-1.343532e-01, 8.219633e-04},
 {-1.335312e-01, 9.863321e-04},{-1.325449e-01, 1.148570e-03},{-1.313963e-01, 1.308487e-03},{-1.300878e-01, 1.465895e-03},
 {-1.286219e-01, 1.620610e-03},{-1.270013e-01, 1.772452e-03},{-1.252289e-01, 1.921243e-03},{-1.233076e-01, 2.066810e-03},
 {-1.212408e-01, 2.208985e-03},{-1.190318e-01, 2.347604e-03},{-1.166842e-01, 2.482506e-03},{-1.142017e-01, 2.613537e-03},
 {-1.115882e-01, 2.740547e-03},{-1.088477e-01, 2.863391e-03},{-1.059843e-01, 2.981930e-03},{-1.030023e-01, 3.096031e-03},
 {-9.990630e-02, 3.205565e-03},{-9.670073e-02, 3.310411e-03},{-9.339032e-02, 3.410452e-03},{-8.997987e-02, 3.505579e-03},
 {-8.647429e-02, 3.595688e-03},{-8.287860e-02, 3.680684e-03},{-7.919792e-02, 3.760474e-03},{-7.543745e-02, 3.834977e-03},
 {-7.160247e-02, 3.904115e-03},{-6.769835e-02, 3.967820e-03},{-6.373053e-02, 4.026027e-03},{-5.970451e-02, 4.078682e-03},
 {-5.562582e-02, 4.125737e-03},{-5.150009e-02, 4.167151e-03},{-4.733294e-02, 4.202889e-03},{-4.313005e-02, 4.232926e-03},
 {-3.889712e-02, 4.257242e-03},{-3.463988e-02, 4.275827e-03},{-3.036405e-02, 4.288676e-03},{-2.607538e-02, 4.295792e-03},
 {-2.177959e-02, 4.297187e-03},{-1.748240e-02, 4.292878e-03},{-1.318952e-02, 4.282892e-03},{-8.906630e-03, 4.267261e-03},
 {-4.639369e-03, 4.246026e-03},{-3.933437e-04, 4.219234e-03},{ 3.825890e-03, 4.186940e-03},{ 8.012830e-03, 4.149207e-03},
 { 1.216204e-02, 4.106102e-03},{ 1.626814e-02, 4.057703e-03},{ 2.032584e-02, 4.004091e-03},{ 2.432993e-02, 3.945357e-03},
 { 2.827529e-02, 3.881597e-03},{ 3.215689e-02, 3.812913e-03},{ 3.596980e-02, 3.739414e-03},{ 3.970921e-02, 3.661215e-03},
 { 4.337043e-02, 3.578438e-03},{ 4.694887e-02, 3.491210e-03},{ 5.044008e-02, 3.399664e-03},{ 5.383974e-02, 3.303937e-03},
 { 5.714368e-02, 3.204174e-03},{ 6.034785e-02, 3.100524e-03},{ 6.344838e-02, 2.993139e-03},{ 6.644152e-02, 2.882180e-03},
 { 6.932370e-02, 2.767807e-03},{ 7.209150e-02, 2.650190e-03},{ 7.474169e-02, 2.529499e-03},{ 7.727119e-02, 2.405908e-03},
 { 7.967710e-02, 2.279598e-03},{ 8.195670e-02, 2.150750e-03},{ 8.410745e-02, 2.019549e-03},{ 8.612700e-02, 1.886182e-03},
 { 8.801318e-02, 1.750841e-03},{ 8.976402e-02, 1.613718e-03},{ 9.137774e-02, 1.475009e-03},{ 9.285275e-02, 1.334908e-03},
 { 9.418766e-02, 1.193615e-03},{ 9.538127e-02, 1.051330e-03},{ 9.643260e-02, 9.082508e-04},{ 9.734085e-02, 7.645800e-04},
 { 9.810543e-02, 6.205184e-04},{ 9.872595e-02, 4.762674e-04},{ 9.920222e-02, 3.320281e-04},{ 9.953425e-02, 1.880014e-04},
 { 9.972225e-02, 4.438725e-05},{ 9.976663e-02,-9.861543e-05},{ 9.966802e-02,-2.408089e-04},{ 9.942721e-02,-3.819970e-04},
 { 9.904521e-02,-5.219854e-04},{ 9.852323e-02,-6.605820e-04},{ 9.786264e-02,-7.975969e-04},{ 9.706505e-02,-9.328430e-04},
 { 9.613221e-02,-1.066136e-03},{ 9.506607e-02,-1.197294e-03},{ 9.386877e-02,-1.326141e-03},{ 9.254263e-02,-1.452502e-03},
 { 9.109013e-02,-1.576206e-03},{ 8.951393e-02,-1.697088e-03},{ 8.781684e-02,-1.814986e-03},{ 8.600185e-02,-1.929743e-03},
 { 8.407211e-02,-2.041206e-03},{ 8.203090e-02,-2.149229e-03},{ 7.988167e-02,-2.253670e-03},{ 7.762800e-02,-2.354391e-03},
 { 7.527361e-02,-2.451262e-03},{ 7.282235e-02,-2.544157e-03},{ 7.027819e-02,-2.632957e-03},{ 6.764524e-02,-2.717550e-03},
 { 6.492769e-02,-2.797827e-03},{ 6.212986e-02,-2.873690e-03},{ 5.925617e-02,-2.945043e-03},{ 5.631113e-02,-3.011799e-03},
 { 5.329933e-02,-3.073879e-03},{ 5.022545e-02,-3.131209e-03},{ 4.709424e-02,-3.183721e-03},{ 4.391052e-02,-3.231358e-03},
 { 4.067916e-02,-3.274066e-03},{ 3.740509e-02,-3.311800e-03},{ 3.409329e-02,-3.344523e-03},{ 3.074877e-02,-3.372205e-03},
 { 2.737657e-02,-3.394822e-03},{ 2.398174e-02,-3.412360e-03},{ 2.056938e-02,-3.424809e-03},{ 1.714458e-02,-3.432169e-03},
 { 1.371241e-02,-3.434446e-03},{ 1.027796e-02,-3.431655e-03},{ 6.846306e-03,-3.423817e-03},{ 3.422489e-03,-3.410961e-03},
 { 1.152732e-05,-3.393123e-03},{-3.381595e-03,-3.370345e-03},{-6.751940e-03,-3.342678e-03},{-1.009462e-02,-3.310180e-03},
 {-1.340480e-02,-3.272914e-03},{-1.667771e-02,-3.230952e-03},{-1.990866e-02,-3.184371e-03},{-2.309304e-02,-3.133257e-03},
 {-2.622629e-02,-3.077699e-03},{-2.930399e-02,-3.017795e-03},{-3.232179e-02,-2.953649e-03},{-3.527544e-02,-2.885369e-03},
 {-3.816081e-02,-2.813072e-03},{-4.097388e-02,-2.736878e-03},{-4.371076e-02,-2.656913e-03},{-4.636767e-02,-2.573309e-03},
 {-4.894098e-02,-2.486203e-03},{-5.142718e-02,-2.395736e-03},{-5.382292e-02,-2.302055e-03},{-5.612497e-02,-2.205310e-03},
 {-5.833028e-02,-2.105656e-03},{-6.043594e-02,-2.003253e-03},{-6.243919e-02,-1.898262e-03},{-6.433745e-02,-1.790849e-03},
 {-6.612830e-02,-1.681184e-03},{-6.780948e-02,-1.569439e-03},{-6.937892e-02,-1.455788e-03},{-7.083471e-02,-1.340410e-03},
 {-7.217512e-02,-1.223483e-03},{-7.339860e-02,-1.105188e-03},{-7.450379e-02,-9.857091e-04},{-7.548950e-02,-8.652298e-04},
 {-7.635473e-02,-7.439355e-04},{-7.709867e-02,-6.220123e-04},{-7.772068e-02,-4.996466e-04},{-7.822032e-02,-3.770252e-04},
 {-7.859735e-02,-2.543346e-04},{-7.885168e-02,-1.317613e-04},{-7.898345e-02,-9.490755e-06},{-7.899294e-02, 1.122922e-04},
 {-7.888064e-02, 2.334042e-04},{-7.864724e-02, 3.536631e-04},{-7.829358e-02, 4.728887e-04},{-7.782069e-02, 5.909026e-04},
 {-7.722979e-02, 7.075290e-04},{-7.652226e-02, 8.225944e-04},{-7.569966e-02, 9.359282e-04},{-7.476373e-02, 1.047363e-03},
 {-7.371637e-02, 1.156734e-03},{-7.255964e-02, 1.263881e-03},{-7.129576e-02, 1.368648e-03},{-6.992711e-02, 1.470881e-03},
 {-6.845623e-02, 1.570431e-03},{-6.688580e-02, 1.667156e-03},{-6.521864e-02, 1.760914e-03},{-6.345773e-02, 1.851573e-03},
 {-6.160615e-02, 1.939002e-03},{-5.966715e-02, 2.023077e-03},{-5.764407e-02, 2.103680e-03},{-5.554039e-02, 2.180698e-03},
 {-5.335970e-02, 2.254023e-03},{-5.110567e-02, 2.323555e-03},{-4.878212e-02, 2.389198e-03},{-4.639292e-02, 2.450864e-03},
 {-4.394206e-02, 2.508469e-03},{-4.143359e-02, 2.561939e-03},{-3.887165e-02, 2.611203e-03},{-3.626044e-02, 2.656198e-03},
 {-3.360425e-02, 2.696869e-03},{-3.090738e-02, 2.733167e-03},{-2.817421e-02, 2.765049e-03},{-2.540916e-02, 2.792481e-03},
 {-2.261668e-02, 2.815433e-03},{-1.980125e-02, 2.833885e-03},{-1.696736e-02, 2.847822e-03},{-1.411954e-02, 2.857238e-03},
 {-1.126230e-02, 2.862132e-03},{-8.400170e-03, 2.862511e-03},{-5.537659e-03, 2.858390e-03},{-2.679269e-03, 2.849789e-03},
 { 1.705193e-04, 2.836736e-03},{ 3.007255e-03, 2.819266e-03},{ 5.826521e-03, 2.797421e-03},{ 8.623942e-03, 2.771249e-03},
 { 1.139519e-02, 2.740805e-03},{ 1.413600e-02, 2.706151e-03},{ 1.684215e-02, 2.667355e-03},{ 1.950950e-02, 2.624491e-03},
 { 2.213399e-02, 2.577640e-03},{ 2.471163e-02, 2.526888e-03},{ 2.723852e-02, 2.472328e-03},{ 2.971085e-02, 2.414059e-03},
 { 3.212491e-02, 2.352183e-03},{ 3.447709e-02, 2.286811e-03},{ 3.676390e-02, 2.218057e-03},{ 3.898196e-02, 2.146040e-03},
 { 4.112800e-02, 2.070885e-03},{ 4.319888e-02, 1.992721e-03},{ 4.519160e-02, 1.911681e-03},{ 4.710329e-02, 1.827904e-03},
 { 4.893119e-02, 1.741530e-03},{ 5.067272e-02, 1.652705e-03},{ 5.232543e-02, 1.561579e-03},{ 5.388700e-02, 1.468302e-03},
 { 5.535531e-02, 1.373031e-03},{ 5.672834e-02, 1.275924e-03},{ 5.800426e-02, 1.177140e-03},{ 5.918140e-02, 1.076843e-03},
 { 6.025824e-02, 9.751966e-04},{ 6.123344e-02, 8.723684e-04},{ 6.210581e-02, 7.685257e-04},{ 6.287434e-02, 6.638376e-04},
 { 6.353817e-02, 5.584743e-04},{ 6.409665e-02, 4.526062e-04},{ 6.454925e-02, 3.464043e-04},{ 6.489566e-02, 2.400398e-04},
 { 6.513570e-02, 1.336836e-04},{ 6.526938e-02, 2.750600e-05},{ 6.529689e-02,-7.832315e-05},{ 6.521856e-02,-1.836352e-04},
 { 6.503493e-02,-2.882626e-04},{ 6.474667e-02,-3.920394e-04},{ 6.435463e-02,-4.948016e-04},{ 6.385983e-02,-5.963871e-04},
 { 6.326344e-02,-6.966360e-04},{ 6.256680e-02,-7.953911e-04},{ 6.177141e-02,-8.924980e-04},{ 6.087891e-02,-9.878053e-04},
 { 5.989111e-02,-1.081165e-03},{ 5.880994e-02,-1.172433e-03},{ 5.763751e-02,-1.261467e-03},{ 5.637604e-02,-1.348132e-03},
 { 5.502791e-02,-1.432294e-03},{ 5.359562e-02,-1.513825e-03},{ 5.208179e-02,-1.592601e-03},{ 5.048919e-02,-1.668504e-03},
 { 4.882069e-02,-1.741420e-03},{ 4.707927e-02,-1.811239e-03},{ 4.526803e-02,-1.877858e-03},{ 4.339017e-02,-1.941179e-03},
 { 4.144899e-02,-2.001109e-03},{ 3.944788e-02,-2.057561e-03},{ 3.739032e-02,-2.110455e-03},{ 3.527987e-02,-2.159716e-03},
 { 3.312015e-02,-2.205274e-03},{ 3.091488e-02,-2.247068e-03},{ 2.866781e-02,-2.285040e-03},{ 2.638277e-02,-2.319140e-03},
 { 2.406363e-02,-2.349325e-03},{ 2.171430e-02,-2.375558e-03},{ 1.933875e-02,-2.397809e-03},{ 1.694094e-02,-2.416052e-03},
 { 1.452488e-02,-2.430271e-03},{ 1.209461e-02,-2.440455e-03},{ 9.654159e-03,-2.446599e-03},{ 7.207560e-03,-2.448706e-03},
 { 4.758854e-03,-2.446786e-03},{ 2.312068e-03,-2.440852e-03},{-1.287837e-04,-2.430928e-03},{-2.559712e-03,-2.417042e-03},
 {-4.976754e-03,-2.399229e-03},{-7.375983e-03,-2.377530e-03},{-9.753513e-03,-2.351993e-03},{-1.210551e-02,-2.322670e-03},
 {-1.442818e-02,-2.289623e-03},{-1.671780e-02,-2.252917e-03},{-1.897072e-02,-2.212623e-03},{-2.118334e-02,-2.168818e-03},
 {-2.335216e-02,-2.121586e-03},{-2.547374e-02,-2.071014e-03},{-2.754476e-02,-2.017196e-03},{-2.956195e-02,-1.960231e-03},
 {-3.152219e-02,-1.900222e-03},{-3.342241e-02,-1.837277e-03},{-3.525968e-02,-1.771510e-03},{-3.703119e-02,-1.703037e-03},
 {-3.873423e-02,-1.631979e-03},{-4.036621e-02,-1.558463e-03},{-4.192467e-02,-1.482616e-03},{-4.340729e-02,-1.404572e-03},
 {-4.481186e-02,-1.324466e-03},{-4.613633e-02,-1.242437e-03},{-4.737876e-02,-1.158628e-03},{-4.853739e-02,-1.073181e-03},
 {-4.961057e-02,-9.862440e-04},{-5.059682e-02,-8.979655e-04},{-5.149478e-02,-8.084960e-04},{-5.230328e-02,-7.179876e-04},
 {-5.302127e-02,-6.265937e-04},{-5.364786e-02,-5.344689e-04},{-5.418233e-02,-4.417684e-04},{-5.462410e-02,-3.486483e-04},
 {-5.497275e-02,-2.552646e-04},{-5.522801e-02,-1.617737e-04},{-5.538978e-02,-6.833136e-05},{-5.545811e-02, 2.490674e-05},
 {-5.543321e-02, 1.177859e-04},{-5.531542e-02, 2.101523e-04},{-5.510527e-02, 3.018534e-04},{-5.480342e-02, 3.927383e-04},
 {-5.441068e-02, 4.826576e-04},{-5.392802e-02, 5.714641e-04},{-5.335656e-02, 6.590127e-04},{-5.269754e-02, 7.451608e-04},
 {-5.195238e-02, 8.297687e-04},{-5.112261e-02, 9.126993e-04},{-5.020991e-02, 9.938189e-04},{-4.921610e-02, 1.072997e-03},
 {-4.814310e-02, 1.150107e-03},{-4.699299e-02, 1.225026e-03},{-4.576797e-02, 1.297634e-03},{-4.447033e-02, 1.367817e-03},
 {-4.310251e-02, 1.435465e-03},{-4.166705e-02, 1.500470e-03},{-4.016658e-02, 1.562733e-03},{-3.860385e-02, 1.622156e-03},
 {-3.698169e-02, 1.678649e-03},{-3.530304e-02, 1.732124e-03},{-3.357092e-02, 1.782501e-03},{-3.178842e-02, 1.829705e-03},
 {-2.995871e-02, 1.873665e-03},{-2.808505e-02, 1.914316e-03},{-2.617073e-02, 1.951601e-03},{-2.421913e-02, 1.985467e-03},
 {-2.223366e-02, 2.015865e-03},{-2.021780e-02, 2.042756e-03},{-1.817504e-02, 2.066105e-03},{-1.610894e-02, 2.085881e-03},
 {-1.402305e-02, 2.102064e-03},{-1.192099e-02, 2.114635e-03},{-9.806356e-03, 2.123584e-03},{-7.682772e-03, 2.128907e-03},
 {-5.553865e-03, 2.130605e-03},{-3.423259e-03, 2.128687e-03},{-1.294573e-03, 2.123165e-03},{ 8.285929e-04, 2.114061e-03},
 { 2.942654e-03, 2.101399e-03},{ 5.044053e-03, 2.085212e-03},{ 7.129265e-03, 2.065538e-03},{ 9.194803e-03, 2.042419e-03},
 { 1.123722e-02, 2.015906e-03},{ 1.325313e-02, 1.986053e-03},{ 1.523918e-02, 1.952921e-03},{ 1.719210e-02, 1.916575e-03},
 { 1.910868e-02, 1.877087e-03},{ 2.098577e-02, 1.834533e-03},{ 2.282030e-02, 1.788993e-03},{ 2.460929e-02, 1.740555e-03},
 { 2.634985e-02, 1.689308e-03},{ 2.803915e-02, 1.635349e-03},{ 2.967450e-02, 1.578777e-03},{ 3.125328e-02, 1.519696e-03},
 { 3.277298e-02, 1.458213e-03},{ 3.423119e-02, 1.394441e-03},{ 3.562563e-02, 1.328494e-03},{ 3.695412e-02, 1.260492e-03},
 { 3.821462e-02, 1.190556e-03},{ 3.940517e-02, 1.118812e-03},{ 4.052398e-02, 1.045386e-03},{ 4.156937e-02, 9.704092e-04},
 { 4.253978e-02, 8.940139e-04},{ 4.343379e-02, 8.163348e-04},{ 4.425013e-02, 7.375081e-04},{ 4.498764e-02, 6.576719e-04},
 { 4.564531e-02, 5.769656e-04},{ 4.622227e-02, 4.955297e-04},{ 4.671780e-02, 4.135056e-04},{ 4.713131e-02, 3.310354e-04},
 { 4.746234e-02, 2.482614e-04},{ 4.771060e-02, 1.653264e-04},{ 4.787593e-02, 8.237275e-05},{ 4.795830e-02,-4.572930e-07},
 { 4.795785e-02,-8.302216e-05},{ 4.787482e-02,-1.651811e-04},{ 4.770964e-02,-2.467943e-04},{ 4.746285e-02,-3.277233e-04},
 { 4.713513e-02,-4.078314e-04},{ 4.672729e-02,-4.869832e-04},{ 4.624031e-02,-5.650457e-04},{ 4.567527e-02,-6.418879e-04},
 { 4.503338e-02,-7.173812e-04},{ 4.431600e-02,-7.913999e-04},{ 4.352460e-02,-8.638208e-04},{ 4.266078e-02,-9.345240e-04},
 { 4.172625e-02,-1.003393e-03},{ 4.072286e-02,-1.070314e-03},{ 3.965255e-02,-1.135178e-03},{ 3.851737e-02,-1.197878e-03},
 { 3.731949e-02,-1.258314e-03},{ 3.606117e-02,-1.316387e-03},{ 3.474479e-02,-1.372005e-03},{ 3.337278e-02,-1.425077e-03},
 { 3.194771e-02,-1.475521e-03},{ 3.047218e-02,-1.523256e-03},{ 2.894893e-02,-1.568208e-03},{ 2.738072e-02,-1.610307e-03},
 { 2.577041e-02,-1.649489e-03},{ 2.412092e-02,-1.685694e-03},{ 2.243523e-02,-1.718868e-03},{ 2.071636e-02,-1.748962e-03},
 { 1.896740e-02,-1.775934e-03},{ 1.719147e-02,-1.799746e-03},{ 1.539172e-02,-1.820364e-03},{ 1.357136e-02,-1.837764e-03},
 { 1.173359e-02,-1.851923e-03},{ 9.881670e-03,-1.862826e-03},{ 8.018844e-03,-1.870465e-03},{ 6.148380e-03,-1.874834e-03},
 { 4.273546e-03,-1.875935e-03},{ 2.397611e-03,-1.873777e-03},{ 5.238338e-04,-1.868371e-03},{-1.344537e-03,-1.859737e-03},
 {-3.204275e-03,-1.847898e-03},{-5.052173e-03,-1.832885e-03},{-6.885058e-03,-1.814732e-03},{-8.699790e-03,-1.793479e-03},
 {-1.049327e-02,-1.769173e-03},{-1.226244e-02,-1.741864e-03},{-1.400431e-02,-1.711608e-03},{-1.571591e-02,-1.678465e-03},
 {-1.739438e-02,-1.642503e-03},{-1.903688e-02,-1.603791e-03},{-2.064067e-02,-1.562404e-03},{-2.220308e-02,-1.518422e-03},
 {-2.372150e-02,-1.471929e-03},{-2.519343e-02,-1.423013e-03},{-2.661644e-02,-1.371765e-03},{-2.798821e-02,-1.318282e-03},
 {-2.930649e-02,-1.262663e-03},{-3.056915e-02,-1.205011e-03},{-3.177416e-02,-1.145433e-03},{-3.291960e-02,-1.084037e-03},
 {-3.400363e-02,-1.020935e-03},{-3.502457e-02,-9.562436e-04},{-3.598081e-02,-8.900788e-04},{-3.687089e-02,-8.225606e-04},
 {-3.769345e-02,-7.538107e-04},{-3.844726e-02,-6.839526e-04},{-3.913121e-02,-6.131114e-04},{-3.974433e-02,-5.414137e-04},
 {-4.028574e-02,-4.689872e-04},{-4.075473e-02,-3.959605e-04},{-4.115069e-02,-3.224631e-04},{-4.147315e-02,-2.486248e-04},
 {-4.172178e-02,-1.745757e-04},{-4.189635e-02,-1.004461e-04},{-4.199680e-02,-2.636591e-05},{-4.202316e-02, 4.753532e-05},
 {-4.197563e-02, 1.211286e-04},{-4.185450e-02, 1.942860e-04},{-4.166021e-02, 2.668803e-04},{-4.139333e-02, 3.387861e-04},
 {-4.105455e-02, 4.098791e-04},{-4.064467e-02, 4.800370e-04},{-4.016463e-02, 5.491393e-04},{-3.961549e-02, 6.170677e-04},
 {-3.899842e-02, 6.837063e-04},{-3.831472e-02, 7.489417e-04},{-3.756578e-02, 8.126632e-04},{-3.675311e-02, 8.747633e-04},
 {-3.587835e-02, 9.351373e-04},{-3.494321e-02, 9.936839e-04},{-3.394953e-02, 1.050305e-03},{-3.289922e-02, 1.104907e-03},
 {-3.179432e-02, 1.157400e-03},{-3.063692e-02, 1.207696e-03},{-2.942922e-02, 1.255714e-03},{-2.817351e-02, 1.301375e-03},
 {-2.687213e-02, 1.344605e-03},{-2.552753e-02, 1.385335e-03},{-2.414219e-02, 1.423501e-03},{-2.271869e-02, 1.459042e-03},
 {-2.125965e-02, 1.491903e-03},{-1.976774e-02, 1.522033e-03},{-1.824571e-02, 1.549388e-03},{-1.669632e-02, 1.573925e-03},
 {-1.512240e-02, 1.595611e-03},{-1.352679e-02, 1.614414e-03},{-1.191237e-02, 1.630309e-03},{-1.028206e-02, 1.643277e-03},
 {-8.638788e-03, 1.653302e-03},{-6.985486e-03, 1.660375e-03},{-5.325111e-03, 1.664492e-03},{-3.660619e-03, 1.665654e-03},
 {-1.994965e-03, 1.663866e-03},{-3.310992e-04, 1.659140e-03},{ 1.328041e-03, 1.651493e-03},{ 2.979534e-03, 1.640945e-03},
 { 4.620479e-03, 1.627525e-03},{ 6.248004e-03, 1.611263e-03},{ 7.859267e-03, 1.592195e-03},{ 9.451462e-03, 1.570365e-03},
 { 1.102183e-02, 1.545817e-03},{ 1.256764e-02, 1.518602e-03},{ 1.408625e-02, 1.488777e-03},{ 1.557502e-02, 1.456401e-03},
 { 1.703142e-02, 1.421538e-03},{ 1.845296e-02, 1.384258e-03},{ 1.983722e-02, 1.344632e-03},{ 2.118185e-02, 1.302738e-03},
 { 2.248459e-02, 1.258657e-03},{ 2.374325e-02, 1.212471e-03},{ 2.495572e-02, 1.164269e-03},{ 2.611999e-02, 1.114142e-03},
 { 2.723413e-02, 1.062185e-03},{ 2.829631e-02, 1.008494e-03},{ 2.930481e-02, 9.531696e-04},{ 3.025798e-02, 8.963143e-04},
 { 3.115429e-02, 8.380335e-04},{ 3.199233e-02, 7.784345e-04},{ 3.277076e-02, 7.176269e-04},{ 3.348839e-02, 6.557219e-04},
 { 3.414411e-02, 5.928327e-04},{ 3.473694e-02, 5.290737e-04},{ 3.526602e-02, 4.645607e-04},{ 3.573058e-02, 3.994104e-04},
 { 3.612999e-02, 3.337406e-04},{ 3.646373e-02, 2.676694e-04},{ 3.673140e-02, 2.013156e-04},{ 3.693271e-02, 1.347980e-04},
 { 3.706751e-02, 6.823542e-05},{ 3.713575e-02, 1.746581e-06},{ 3.713749e-02,-6.455033e-05},{ 3.707294e-02,-1.305377e-04},
 { 3.694240e-02,-1.960989e-04},{ 3.674631e-02,-2.611182e-04},{ 3.648519e-02,-3.254813e-04},{ 3.615971e-02,-3.890750e-04},
 { 3.577063e-02,-4.517883e-04},{ 3.531884e-02,-5.135116e-04},{ 3.480533e-02,-5.741375e-04},{ 3.423119e-02,-6.335609e-04},
 { 3.359763e-02,-6.916790e-04},{ 3.290595e-02,-7.483916e-04},{ 3.215756e-02,-8.036014e-04},{ 3.135396e-02,-8.572138e-04},
 { 3.049675e-02,-9.091375e-04},{ 2.958761e-02,-9.592843e-04},{ 2.862833e-02,-1.007569e-03},{ 2.762076e-02,-1.053912e-03},
 { 2.656684e-02,-1.098234e-03},{ 2.546861e-02,-1.140462e-03},{ 2.432815e-02,-1.180526e-03},{ 2.314762e-02,-1.218360e-03},
 { 2.192926e-02,-1.253904e-03},{ 2.067536e-02,-1.287098e-03},{ 1.938826e-02,-1.317891e-03},{ 1.807037e-02,-1.346234e-03},
 { 1.672413e-02,-1.372083e-03},{ 1.535205e-02,-1.395398e-03},{ 1.395665e-02,-1.416145e-03},{ 1.254051e-02,-1.434292e-03},
 { 1.110622e-02,-1.449816e-03},{ 9.656400e-03,-1.462695e-03},{ 8.193706e-03,-1.472913e-03},{ 6.720793e-03,-1.480459e-03},
 { 5.240333e-03,-1.485328e-03},{ 3.755006e-03,-1.487516e-03},{ 2.267490e-03,-1.487029e-03},{ 7.804607e-04,-1.483873e-03},
 {-7.034128e-04,-1.478063e-03},{-2.181476e-03,-1.469615e-03},{-3.651091e-03,-1.458552e-03},{-5.109643e-03,-1.444901e-03},
 {-6.554543e-03,-1.428693e-03},{-7.983236e-03,-1.409964e-03},{-9.393200e-03,-1.388756e-03},{-1.078196e-02,-1.365112e-03},
 {-1.214707e-02,-1.339082e-03},{-1.348615e-02,-1.310719e-03},{-1.479687e-02,-1.280080e-03},{-1.607695e-02,-1.247227e-03},
 {-1.732418e-02,-1.212225e-03},{-1.853640e-02,-1.175142e-03},{-1.971154e-02,-1.136050e-03},{-2.084759e-02,-1.095027e-03},
 {-2.194262e-02,-1.052150e-03},{-2.299477e-02,-1.007501e-03},{-2.400227e-02,-9.611671e-04},{-2.496344e-02,-9.132346e-04},
 {-2.587667e-02,-8.637946e-04},{-2.674047e-02,-8.129403e-04},{-2.755341e-02,-7.607670e-04},{-2.831417e-02,-7.073723e-04},
 {-2.902155e-02,-6.528557e-04},{-2.967440e-02,-5.973185e-04},{-3.027172e-02,-5.408635e-04},{-3.081258e-02,-4.835950e-04},
 {-3.129618e-02,-4.256184e-04},{-3.172180e-02,-3.670403e-04},{-3.208884e-02,-3.079677e-04},{-3.239681e-02,-2.485088e-04},
 {-3.264531e-02,-1.887717e-04},{-3.283409e-02,-1.288650e-04},{-3.296295e-02,-6.889723e-05},{-3.303185e-02,-8.976889e-06},
 {-3.304082e-02, 5.078803e-05},{-3.299004e-02, 1.102900e-04},{-3.287975e-02, 1.694224e-04},{-3.271032e-02, 2.280793e-04},
 {-3.248224e-02, 2.861560e-04},{-3.219609e-02, 3.435492e-04},{-3.185254e-02, 4.001571e-04},{-3.145238e-02, 4.558794e-04},
 {-3.099650e-02, 5.106178e-04},{-3.048589e-02, 5.642760e-04},{-2.992161e-02, 6.167599e-04},{-2.930485e-02, 6.679777e-04},
 {-2.863687e-02, 7.178403e-04},{-2.791903e-02, 7.662610e-04},{-2.715277e-02, 8.131562e-04},{-2.633961e-02, 8.584451e-04},
 {-2.548117e-02, 9.020500e-04},{-2.457912e-02, 9.438966e-04},{-2.363522e-02, 9.839139e-04},{-2.265131e-02, 1.022034e-03},
 {-2.162927e-02, 1.058194e-03},{-2.057108e-02, 1.092333e-03},{-1.947875e-02, 1.124394e-03},{-1.835435e-02, 1.154325e-03},
 {-1.720003e-02, 1.182078e-03},{-1.601795e-02, 1.207608e-03},{-1.481034e-02, 1.230875e-03},{-1.357947e-02, 1.251843e-03},
 {-1.232763e-02, 1.270480e-03},{-1.105715e-02, 1.286758e-03},{-9.770387e-03, 1.300655e-03},{-8.469733e-03, 1.312151e-03},
 {-7.157582e-03, 1.321232e-03},{-5.836350e-03, 1.327888e-03},{-4.508461e-03, 1.332115e-03},{-3.176347e-03, 1.333909e-03},
 {-1.842438e-03, 1.333275e-03},{-5.091624e-04, 1.330221e-03},{ 8.210589e-04, 1.324759e-03},{ 2.145818e-03, 1.316904e-03},
 { 3.462722e-03, 1.306678e-03},{ 4.769400e-03, 1.294106e-03},{ 6.063506e-03, 1.279216e-03},{ 7.342722e-03, 1.262043e-03},
 { 8.604765e-03, 1.242623e-03},{ 9.847389e-03, 1.220998e-03},{ 1.106839e-02, 1.197214e-03},{ 1.226560e-02, 1.171318e-03},
 { 1.343692e-02, 1.143364e-03},{ 1.458028e-02, 1.113409e-03},{ 1.569369e-02, 1.081512e-03},{ 1.677520e-02, 1.047737e-03},
 { 1.782294e-02, 1.012149e-03},{ 1.883509e-02, 9.748196e-04},{ 1.980991e-02, 9.358203e-04},{ 2.074573e-02, 8.952269e-04},
 { 2.164096e-02, 8.531176e-04},{ 2.249407e-02, 8.095731e-04},{ 2.330365e-02, 7.646767e-04},{ 2.406832e-02, 7.185137e-04},
 { 2.478684e-02, 6.711718e-04},{ 2.545801e-02, 6.227402e-04},{ 2.608075e-02, 5.733103e-04},{ 2.665406e-02, 5.229748e-04},
 { 2.717703e-02, 4.718280e-04},{ 2.764886e-02, 4.199652e-04},{ 2.806883e-02, 3.674829e-04},{ 2.843631e-02, 3.144786e-04},
 { 2.875079e-02, 2.610504e-04},{ 2.901184e-02, 2.072968e-04},{ 2.921914e-02, 1.533167e-04},{ 2.937245e-02, 9.920944e-05},
 { 2.947166e-02, 4.507394e-05},{ 2.951674e-02,-8.990870e-06},{ 2.950775e-02,-6.288648e-05},{ 2.944486e-02,-1.165149e-04},
 { 2.932834e-02,-1.697790e-04},{ 2.915857e-02,-2.225825e-04},{ 2.893598e-02,-2.748301e-04},{ 2.866115e-02,-3.264278e-04},
 { 2.833472e-02,-3.772833e-04},{ 2.795744e-02,-4.273054e-04},{ 2.753014e-02,-4.764052e-04},{ 2.705373e-02,-5.244952e-04},
 { 2.652924e-02,-5.714903e-04},{ 2.595775e-02,-6.173076e-04},{ 2.534044e-02,-6.618664e-04},{ 2.467857e-02,-7.050886e-04},
 { 2.397348e-02,-7.468988e-04},{ 2.322658e-02,-7.872243e-04},{ 2.243936e-02,-8.259953e-04},{ 2.161336e-02,-8.631451e-04},
 { 2.075022e-02,-8.986100e-04},{ 1.985161e-02,-9.323296e-04},{ 1.891928e-02,-9.642470e-04},{ 1.795503e-02,-9.943086e-04},
 { 1.696072e-02,-1.022464e-03},{ 1.593826e-02,-1.048668e-03},{ 1.488959e-02,-1.072876e-03},{ 1.381672e-02,-1.095050e-03},
 { 1.272167e-02,-1.115156e-03},{ 1.160651e-02,-1.133160e-03},{ 1.047335e-02,-1.149037e-03},{ 9.324312e-03,-1.162763e-03},
 { 8.161549e-03,-1.174319e-03},{ 6.987230e-03,-1.183688e-03},{ 5.803542e-03,-1.190861e-03},{ 4.612681e-03,-1.195829e-03},
 { 3.416852e-03,-1.198590e-03},{ 2.218262e-03,-1.199144e-03},{ 1.019118e-03,-1.197496e-03},{-1.783783e-04,-1.193656e-03},
 {-1.372034e-03,-1.187636e-03},{-2.559670e-03,-1.179453e-03},{-3.739123e-03,-1.169128e-03},{-4.908251e-03,-1.156685e-03},
 {-6.064936e-03,-1.142154e-03},{-7.207091e-03,-1.125567e-03},{-8.332657e-03,-1.106959e-03},{-9.439616e-03,-1.086370e-03},
 {-1.052599e-02,-1.063844e-03},{-1.158983e-02,-1.039426e-03},{-1.262926e-02,-1.013167e-03},{-1.364242e-02,-9.851205e-04},
 {-1.462754e-02,-9.553423e-04},{-1.558289e-02,-9.238918e-04},{-1.650678e-02,-8.908315e-04},{-1.739761e-02,-8.562265e-04},
 {-1.825384e-02,-8.201444e-04},{-1.907398e-02,-7.826557e-04},{-1.985664e-02,-7.438330e-04},{-2.060047e-02,-7.037514e-04},
 {-2.130422e-02,-6.624879e-04},{-2.196671e-02,-6.201217e-04},{-2.258683e-02,-5.767336e-04},{-2.316356e-02,-5.324063e-04},
 {-2.369597e-02,-4.872239e-04},{-2.418319e-02,-4.412717e-04},{-2.462447e-02,-3.946365e-04},{-2.501910e-02,-3.474060e-04},
 {-2.536651e-02,-2.996686e-04},{-2.566618e-02,-2.515137e-04},{-2.591769e-02,-2.030311e-04},{-2.612072e-02,-1.543109e-04},
 {-2.627503e-02,-1.054434e-04},{-2.638048e-02,-5.651921e-05},{-2.643699e-02,-7.628481e-06},{-2.644462e-02, 4.113877e-05},
 {-2.640348e-02, 8.969301e-05},{-2.631379e-02, 1.379453e-04},{-2.617585e-02, 1.858077e-04},{-2.599004e-02, 2.331928e-04},
 {-2.575685e-02, 2.800146e-04},{-2.547683e-02, 3.261884e-04},{-2.515064e-02, 3.716307e-04},{-2.477901e-02, 4.162598e-04},
 {-2.436275e-02, 4.599954e-04},{-2.390276e-02, 5.027595e-04},{-2.340000e-02, 5.444756e-04},{-2.285552e-02, 5.850696e-04},
 {-2.227045e-02, 6.244698e-04},{-2.164598e-02, 6.626065e-04},{-2.098338e-02, 6.994129e-04},{-2.028396e-02, 7.348246e-04},
 {-1.954914e-02, 7.687800e-04},{-1.878036e-02, 8.012203e-04},{-1.797914e-02, 8.320899e-04},{-1.714705e-02, 8.613358e-04},
 {-1.628571e-02, 8.889085e-04},{-1.539680e-02, 9.147616e-04},{-1.448204e-02, 9.388520e-04},{-1.354319e-02, 9.611399e-04},
 {-1.258205e-02, 9.815891e-04},{-1.160046e-02, 1.000167e-03},{-1.060029e-02, 1.016844e-03},{-9.583451e-03, 1.031594e-03},
 {-8.551857e-03, 1.044396e-03},{-7.507462e-03, 1.055230e-03},{-6.452231e-03, 1.064084e-03},{-5.388147e-03, 1.070944e-03},
 {-4.317203e-03, 1.075805e-03},{-3.241398e-03, 1.078662e-03},{-2.162736e-03, 1.079516e-03},{-1.083220e-03, 1.078370e-03},
 {-4.849709e-06, 1.075233e-03},{ 1.070383e-03, 1.070114e-03},{ 2.140498e-03, 1.063030e-03},{ 3.203528e-03, 1.053999e-03},
 { 4.257526e-03, 1.043041e-03},{ 5.300568e-03, 1.030184e-03},{ 6.330752e-03, 1.015456e-03},{ 7.346208e-03, 9.988895e-04},
 { 8.345098e-03, 9.805198e-04},{ 9.325618e-03, 9.603860e-04},{ 1.028600e-02, 9.385302e-04},{ 1.122453e-02, 9.149976e-04},
 { 1.213953e-02, 8.898363e-04},{ 1.302937e-02, 8.630973e-04},{ 1.389247e-02, 8.348345e-04},{ 1.472730e-02, 8.051043e-04},
 { 1.553240e-02, 7.739659e-04},{ 1.630637e-02, 7.414808e-04},{ 1.704785e-02, 7.077129e-04},{ 1.775556e-02, 6.727282e-04},
 { 1.842829e-02, 6.365949e-04},{ 1.906489e-02, 5.993831e-04},{ 1.966427e-02, 5.611648e-04},{ 2.022543e-02, 5.220135e-04},
 { 2.074745e-02, 4.820045e-04},{ 2.122945e-02, 4.412142e-04},{ 2.167067e-02, 3.997205e-04},{ 2.207039e-02, 3.576022e-04},
 { 2.242799e-02, 3.149392e-04},{ 2.274293e-02, 2.718122e-04},{ 2.301474e-02, 2.283024e-04},{ 2.324304e-02, 1.844915e-04},
 { 2.342753e-02, 1.404619e-04},{ 2.356800e-02, 9.629574e-05},{ 2.366429e-02, 5.207544e-05},{ 2.371637e-02, 7.883230e-06},
 { 2.372425e-02,-3.619889e-05},{ 2.368805e-02,-8.008937e-05},{ 2.360796e-02,-1.237072e-04},{ 2.348426e-02,-1.669722e-04},
 { 2.331728e-02,-2.098048e-04},{ 2.310748e-02,-2.521267e-04},{ 2.285535e-02,-2.938607e-04},{ 2.256149e-02,-3.349308e-04},
 { 2.222656e-02,-3.752626e-04},{ 2.185130e-02,-4.147830e-04},{ 2.143651e-02,-4.534208e-04},{ 2.098309e-02,-4.911067e-04},
 { 2.049199e-02,-5.277731e-04},{ 1.996421e-02,-5.633548e-04},{ 1.940086e-02,-5.977884e-04},{ 1.880307e-02,-6.310131e-04},
 { 1.817206e-02,-6.629704e-04},{ 1.750909e-02,-6.936044e-04},{ 1.681548e-02,-7.228617e-04},{ 1.609262e-02,-7.506916e-04},
 { 1.534193e-02,-7.770462e-04},{ 1.456488e-02,-8.018806e-04},{ 1.376300e-02,-8.251527e-04},{ 1.293785e-02,-8.468235e-04},
 { 1.209103e-02,-8.668570e-04},{ 1.122417e-02,-8.852204e-04},{ 1.033895e-02,-9.018842e-04},{ 9.437065e-03,-9.168219e-04},
 { 8.520243e-03,-9.300104e-04},{ 7.590233e-03,-9.414301e-04},{ 6.648803e-03,-9.510644e-04},{ 5.697738e-03,-9.589005e-04},
 { 4.738838e-03,-9.649284e-04},{ 3.773910e-03,-9.691421e-04},{ 2.804767e-03,-9.715387e-04},{ 1.833229e-03,-9.721186e-04},
 { 8.611102e-04,-9.708857e-04},{-1.097755e-04,-9.678474e-04},{-1.077623e-03,-9.630143e-04},{-2.040637e-03,-9.564003e-04},
 {-2.997038e-03,-9.480225e-04},{-3.945060e-03,-9.379016e-04},{-4.882962e-03,-9.260611e-04},{-5.809023e-03,-9.125278e-04},
 {-6.721550e-03,-8.973316e-04},{-7.618882e-03,-8.805055e-04},{-8.499388e-03,-8.620853e-04},{-9.361473e-03,-8.421097e-04},
 {-1.020358e-02,-8.206202e-04},{-1.102420e-02,-7.976612e-04},{-1.182186e-02,-7.732795e-04},{-1.259514e-02,-7.475245e-04},
 {-1.334267e-02,-7.204480e-04},{-1.406312e-02,-6.921043e-04},{-1.475522e-02,-6.625496e-04},{-1.541777e-02,-6.318425e-04},
 {-1.604961e-02,-6.000435e-04},{-1.664966e-02,-5.672150e-04},{-1.721687e-02,-5.334210e-04},{-1.775029e-02,-4.987273e-04},
 {-1.824902e-02,-4.632012e-04},{-1.871222e-02,-4.269114e-04},{-1.913913e-02,-3.899276e-04},{-1.952906e-02,-3.523210e-04},
 {-1.988138e-02,-3.141633e-04},{-2.019554e-02,-2.755276e-04},{-2.047107e-02,-2.364872e-04},{-2.070756e-02,-1.971162e-04},
 {-2.090467e-02,-1.574890e-04},{-2.106216e-02,-1.176805e-04},{-2.117984e-02,-7.776555e-05},{-2.125761e-02,-3.781899e-05},
 {-2.129543e-02, 2.084388e-06},{-2.129334e-02, 4.187013e-05},{-2.125147e-02, 8.146418e-05},{-2.117001e-02, 1.207931e-04},
 {-2.104922e-02, 1.597839e-04},{-2.088943e-02, 1.983649e-04},{-2.069107e-02, 2.364649e-04},{-2.045460e-02, 2.740140e-04},
 {-2.018059e-02, 3.109435e-04},{-1.986965e-02, 3.471861e-04},{-1.952246e-02, 3.826758e-04},{-1.913978e-02, 4.173484e-04},
 {-1.872244e-02, 4.511412e-04},{-1.827129e-02, 4.839936e-04},{-1.778730e-02, 5.158465e-04},{-1.727145e-02, 5.466432e-04},
 {-1.672481e-02, 5.763290e-04},{-1.614848e-02, 6.048513e-04},{-1.554363e-02, 6.321601e-04},{-1.491147e-02, 6.582076e-04},
 {-1.425326e-02, 6.829485e-04},{-1.357031e-02, 7.063401e-04},{-1.286397e-02, 7.283425e-04},{-1.213563e-02, 7.489182e-04},
 {-1.138671e-02, 7.680326e-04},{-1.061868e-02, 7.856542e-04},{-9.833027e-03, 8.017539e-04},{-9.031273e-03, 8.163060e-04},
 {-8.214967e-03, 8.292873e-04},{-7.385680e-03, 8.406781e-04},{-6.545002e-03, 8.504614e-04},{-5.694540e-03, 8.586233e-04},
 {-4.835917e-03, 8.651531e-04},{-3.970764e-03, 8.700431e-04},{-3.100721e-03, 8.732886e-04},{-2.227432e-03, 8.748883e-04},
 {-1.352544e-03, 8.748437e-04},{-4.777002e-04, 8.731595e-04},{ 3.954593e-04, 8.698433e-04},{ 1.265303e-03, 8.649061e-04},
 { 2.130209e-03, 8.583616e-04},{ 2.988570e-03, 8.502265e-04},{ 3.838797e-03, 8.405205e-04},{ 4.679317e-03, 8.292664e-04},
 { 5.508584e-03, 8.164894e-04},{ 6.325073e-03, 8.022179e-04},{ 7.127291e-03, 7.864828e-04},{ 7.913774e-03, 7.693177e-04},
 { 8.683091e-03, 7.507588e-04},{ 9.433850e-03, 7.308449e-04},{ 1.016470e-02, 7.096171e-04},{ 1.087431e-02, 6.871189e-04},
 { 1.156143e-02, 6.633963e-04},{ 1.222483e-02, 6.384970e-04},{ 1.286332e-02, 6.124712e-04},{ 1.347580e-02, 5.853708e-04},
 { 1.406117e-02, 5.572499e-04},{ 1.461842e-02, 5.281640e-04},{ 1.514658e-02, 4.981704e-04},{ 1.564475e-02, 4.673281e-04},
 { 1.611208e-02, 4.356974e-04},{ 1.654778e-02, 4.033398e-04},{ 1.695112e-02, 3.703183e-04},{ 1.732143e-02, 3.366967e-04},
 { 1.765813e-02, 3.025398e-04},{ 1.796067e-02, 2.679133e-04},{ 1.822858e-02, 2.328837e-04},{ 1.846147e-02, 1.975179e-04},
 { 1.865899e-02, 1.618833e-04},{ 1.882087e-02, 1.260475e-04},{ 1.894692e-02, 9.007862e-05},{ 1.903700e-02, 5.404453e-05},
 { 1.909104e-02, 1.801318e-05},{ 1.910905e-02,-1.794772e-05},{ 1.909111e-02,-5.377074e-05},{ 1.903733e-02,-8.938893e-05},
 { 1.894795e-02,-1.247359e-04},{ 1.882321e-02,-1.597459e-04},{ 1.866346e-02,-1.943541e-04},{ 1.846911e-02,-2.284966e-04},
 { 1.824061e-02,-2.621104e-04},{ 1.797850e-02,-2.951338e-04},{ 1.768337e-02,-3.275063e-04},{ 1.735586e-02,-3.591690e-04},
 { 1.699669e-02,-3.900641e-04},{ 1.660663e-02,-4.201359e-04},{ 1.618649e-02,-4.493300e-04},{ 1.573716e-02,-4.775940e-04},
 { 1.525957e-02,-5.048773e-04},{ 1.475469e-02,-5.311313e-04},{ 1.422356e-02,-5.563096e-04},{ 1.366725e-02,-5.803679e-04},
 { 1.308688e-02,-6.032639e-04},{ 1.248362e-02,-6.249580e-04},{ 1.185866e-02,-6.454126e-04},{ 1.121325e-02,-6.645928e-04},
 { 1.054866e-02,-6.824662e-04},{ 9.866190e-03,-6.990027e-04},{ 9.167187e-03,-7.141750e-04},{ 8.453012e-03,-7.279584e-04},
 { 7.725054e-03,-7.403309e-04},{ 6.984723e-03,-7.512733e-04},{ 6.233450e-03,-7.607689e-04},{ 5.472681e-03,-7.688041e-04},
 { 4.703877e-03,-7.753678e-04},{ 3.928509e-03,-7.804519e-04},{ 3.148057e-03,-7.840510e-04},{ 2.364006e-03,-7.861626e-04},
 { 1.577843e-03,-7.867869e-04},{ 7.910564e-04,-7.859270e-04},{ 5.129416e-06,-7.835887e-04},{-7.784593e-04,-7.797808e-04},
 {-1.558240e-03,-7.745145e-04},{-2.332755e-03,-7.678040e-04},{-3.100559e-03,-7.596660e-04},{-3.860225e-03,-7.501200e-04},
 {-4.610345e-03,-7.391880e-04},{-5.349533e-03,-7.268946e-04},{-6.076427e-03,-7.132669e-04},{-6.789694e-03,-6.983344e-04},
 {-7.488029e-03,-6.821290e-04},{-8.170158e-03,-6.646849e-04},{-8.834842e-03,-6.460385e-04},{-9.480881e-03,-6.262286e-04},
 {-1.010711e-02,-6.052958e-04},{-1.071241e-02,-5.832828e-04},{-1.129569e-02,-5.602342e-04},{-1.185592e-02,-5.361966e-04},
 {-1.239212e-02,-5.112182e-04},{-1.290334e-02,-4.853487e-04},{-1.338869e-02,-4.586396e-04},{-1.384733e-02,-4.311437e-04},
 {-1.427847e-02,-4.029152e-04},{-1.468138e-02,-3.740094e-04},{-1.505539e-02,-3.444829e-04},{-1.539988e-02,-3.143933e-04},
 {-1.571427e-02,-2.837989e-04},{-1.599807e-02,-2.527590e-04},{-1.625083e-02,-2.213335e-04},{-1.647216e-02,-1.895828e-04},
 {-1.666174e-02,-1.575678e-04},{-1.681931e-02,-1.253499e-04},{-1.694466e-02,-9.299035e-05},{-1.703765e-02,-6.055078e-05},
 {-1.709820e-02,-2.809268e-05},{-1.712630e-02, 4.322565e-06},{-1.712197e-02, 3.663385e-05},{-1.708534e-02, 6.878040e-05},
 {-1.701656e-02, 1.007020e-04},{-1.691586e-02, 1.323389e-04},{-1.678352e-02, 1.636322e-04},{-1.661989e-02, 1.945237e-04},
 {-1.642536e-02, 2.249562e-04},{-1.620041e-02, 2.548735e-04},{-1.594553e-02, 2.842205e-04},{-1.566131e-02, 3.129435e-04},
 {-1.534837e-02, 3.409899e-04},{-1.500738e-02, 3.683087e-04},{-1.463907e-02, 3.948503e-04},{-1.424422e-02, 4.205667e-04},
 {-1.382365e-02, 4.454119e-04},{-1.337824e-02, 4.693412e-04},{-1.290890e-02, 4.923122e-04},{-1.241659e-02, 5.142840e-04},
 {-1.190230e-02, 5.352182e-04},{-1.136709e-02, 5.550781e-04},{-1.081201e-02, 5.738293e-04},{-1.023818e-02, 5.914395e-04},
 {-9.646738e-03, 6.078787e-04},{-9.038859e-03, 6.231193e-04},{-8.415740e-03, 6.371359e-04},{-7.778604e-03, 6.499055e-04},
 {-7.128699e-03, 6.614076e-04},{-6.467291e-03, 6.716242e-04},{-5.795667e-03, 6.805397e-04},{-5.115127e-03, 6.881410e-04},
 {-4.426986e-03, 6.944175e-04},{-3.732569e-03, 6.993613e-04},{-3.033207e-03, 7.029668e-04},{-2.330241e-03, 7.052312e-04},
 {-1.625009e-03, 7.061542e-04},{-9.188552e-04, 7.057378e-04},{-2.131175e-04, 7.039868e-04},{ 4.908693e-04, 7.009085e-04},
 { 1.191778e-03, 6.965125e-04},{ 1.888290e-03, 6.908110e-04},{ 2.579101e-03, 6.838188e-04},{ 3.262920e-03, 6.755527e-04},
 { 3.938473e-03, 6.660323e-04},{ 4.604505e-03, 6.552792e-04},{ 5.259784e-03, 6.433174e-04},{ 5.903102e-03, 6.301732e-04},
 { 6.533275e-03, 6.158749e-04},{ 7.149150e-03, 6.004531e-04},{ 7.749603e-03, 5.839401e-04},{ 8.333543e-03, 5.663707e-04},
 { 8.899914e-03, 5.477811e-04},{ 9.447695e-03, 5.282096e-04},{ 9.975905e-03, 5.076962e-04},{ 1.048360e-02, 4.862826e-04},
 { 1.096988e-02, 4.640120e-04},{ 1.143390e-02, 4.409292e-04},{ 1.187482e-02, 4.170803e-04},{ 1.229190e-02, 3.925128e-04},
 { 1.268442e-02, 3.672755e-04},{ 1.305169e-02, 3.414181e-04},{ 1.339311e-02, 3.149915e-04},{ 1.370810e-02, 2.880475e-04},
 { 1.399615e-02, 2.606388e-04},{ 1.425679e-02, 2.328188e-04},{ 1.448961e-02, 2.046413e-04},{ 1.469425e-02, 1.761610e-04},
 { 1.487041e-02, 1.474327e-04},{ 1.501784e-02, 1.185117e-04},{ 1.513635e-02, 8.945345e-05},{ 1.522581e-02, 6.031345e-05},
 { 1.528612e-02, 3.114727e-05},{ 1.531727e-02, 2.010309e-06},{ 1.531928e-02,-2.704221e-05},{ 1.529224e-02,-5.595540e-05},
 { 1.523628e-02,-8.467481e-05},{ 1.515161e-02,-1.131465e-04},{ 1.503846e-02,-1.413172e-04},{ 1.489714e-02,-1.691342e-04},
 { 1.472801e-02,-1.965459e-04},{ 1.453146e-02,-2.235015e-04},{ 1.430796e-02,-2.499510e-04},{ 1.405801e-02,-2.758458e-04},
 { 1.378216e-02,-3.011383e-04},{ 1.348103e-02,-3.257824e-04},{ 1.315524e-02,-3.497332e-04},{ 1.280551e-02,-3.729472e-04},
 { 1.243256e-02,-3.953826e-04},{ 1.203718e-02,-4.169991e-04},{ 1.162018e-02,-4.377581e-04},{ 1.118242e-02,-4.576227e-04},
 { 1.072480e-02,-4.765578e-04},{ 1.024824e-02,-4.945303e-04},{ 9.753713e-03,-5.115089e-04},{ 9.242204e-03,-5.274643e-04},
 { 8.714740e-03,-5.423693e-04},{ 8.172371e-03,-5.561987e-04},{ 7.616172e-03,-5.689294e-04},{ 7.047243e-03,-5.805406e-04},
 { 6.466702e-03,-5.910135e-04},{ 5.875688e-03,-6.003317e-04},{ 5.275357e-03,-6.084809e-04},{ 4.666876e-03,-6.154492e-04},
 { 4.051427e-03,-6.212268e-04},{ 3.430200e-03,-6.258064e-04},{ 2.804393e-03,-6.291828e-04},{ 2.175211e-03,-6.313533e-04},
 { 1.543857e-03,-6.323173e-04},{ 9.115401e-04,-6.320767e-04},{ 2.794634e-04,-6.306356e-04},{-3.511721e-04,-6.280003e-04},
 {-9.791724e-04,-6.241794e-04},{-1.603352e-03,-6.191838e-04},{-2.222536e-03,-6.130265e-04},{-2.835562e-03,-6.057228e-04},
 {-3.441285e-03,-5.972900e-04},{-4.038575e-03,-5.877476e-04},{-4.626323e-03,-5.771171e-04},{-5.203440e-03,-5.654219e-04},
 {-5.768862e-03,-5.526877e-04},{-6.321549e-03,-5.389416e-04},{-6.860491e-03,-5.242131e-04},{-7.384704e-03,-5.085331e-04},
 {-7.893237e-03,-4.919342e-04},{-8.385171e-03,-4.744509e-04},{-8.859622e-03,-4.561192e-04},{-9.315741e-03,-4.369765e-04},
 {-9.752718e-03,-4.170617e-04},{-1.016978e-02,-3.964151e-04},{-1.056619e-02,-3.750781e-04},{-1.094127e-02,-3.530936e-04},
 {-1.129437e-02,-3.305054e-04},{-1.162487e-02,-3.073582e-04},{-1.193223e-02,-2.836978e-04},{-1.221593e-02,-2.595710e-04},
 {-1.247550e-02,-2.350250e-04},{-1.271052e-02,-2.101078e-04},{-1.292063e-02,-1.848682e-04},{-1.310550e-02,-1.593550e-04},
 {-1.326485e-02,-1.336177e-04},{-1.339847e-02,-1.077061e-04},{-1.350618e-02,-8.167001e-05},{-1.358785e-02,-5.555942e-05},
 {-1.364341e-02,-2.942432e-05},{-1.367283e-02,-3.314550e-06},{-1.367615e-02, 2.272021e-05},{-1.365343e-02, 4.863059e-05},
 {-1.360480e-02, 7.436760e-05},{-1.353043e-02, 9.988273e-05},{-1.343055e-02, 1.251280e-04},{-1.330542e-02, 1.500562e-04},
 {-1.315536e-02, 1.746208e-04},{-1.298074e-02, 1.987760e-04},{-1.278196e-02, 2.224771e-04},{-1.255949e-02, 2.456804e-04},
 {-1.231381e-02, 2.683430e-04},{-1.204546e-02, 2.904234e-04},{-1.175504e-02, 3.118815e-04},{-1.144316e-02, 3.326781e-04},
 {-1.111048e-02, 3.527757e-04},{-1.075771e-02, 3.721380e-04},{-1.038557e-02, 3.907305e-04},{-9.994837e-03, 4.085201e-04},
 {-9.586317e-03, 4.254752e-04},{-9.160842e-03, 4.415663e-04},{-8.719275e-03, 4.567652e-04},{-8.262510e-03, 4.710456e-04},
 {-7.791465e-03, 4.843833e-04},{-7.307081e-03, 4.967557e-04},{-6.810326e-03, 5.081422e-04},{-6.302183e-03, 5.185241e-04},
 {-5.783659e-03, 5.278847e-04},{-5.255775e-03, 5.362093e-04},{-4.719565e-03, 5.434852e-04},{-4.176080e-03, 5.497019e-04},
 {-3.626378e-03, 5.548507e-04},{-3.071528e-03, 5.589252e-04},{-2.512602e-03, 5.619208e-04},{-1.950682e-03, 5.638353e-04},
 {-1.386846e-03, 5.646683e-04},{-8.221780e-04, 5.644217e-04},{-2.577563e-04, 5.630992e-04},{ 3.053428e-04, 5.607067e-04},
 { 8.660495e-04, 5.572521e-04},{ 1.423302e-03, 5.527453e-04},{ 1.976047e-03, 5.471983e-04},{ 2.523245e-03, 5.406248e-04},
 { 3.063870e-03, 5.330406e-04},{ 3.596911e-03, 5.244633e-04},{ 4.121374e-03, 5.149125e-04},{ 4.636287e-03, 5.044093e-04},
 { 5.140696e-03, 4.929769e-04},{ 5.633673e-03, 4.806399e-04},{ 6.114313e-03, 4.674248e-04},{ 6.581737e-03, 4.533595e-04},
 { 7.035097e-03, 4.384737e-04},{ 7.473571e-03, 4.227981e-04},{ 7.896369e-03, 4.063654e-04},{ 8.302734e-03, 3.892093e-04},
 { 8.691944e-03, 3.713647e-04},{ 9.063308e-03, 3.528680e-04},{ 9.416176e-03, 3.337566e-04},{ 9.749933e-03, 3.140689e-04},
 { 1.006400e-02, 2.938442e-04},{ 1.035785e-02, 2.731231e-04},{ 1.063097e-02, 2.519465e-04},{ 1.088292e-02, 2.303565e-04},
 { 1.111327e-02, 2.083956e-04},{ 1.132167e-02, 1.861069e-04},{ 1.150777e-02, 1.635340e-04},{ 1.167131e-02, 1.407210e-04},
 { 1.181203e-02, 1.177123e-04},{ 1.192974e-02, 9.455251e-05},{ 1.202429e-02, 7.128629e-05},{ 1.209558e-02, 4.795850e-05},
 { 1.214354e-02, 2.461393e-05},{ 1.216815e-02, 1.297279e-06},{ 1.216945e-02,-2.194697e-05},{ 1.214750e-02,-4.507460e-05},
 { 1.210243e-02,-6.804175e-05},{ 1.203439e-02,-9.080502e-05},{ 1.194358e-02,-1.133215e-04},{ 1.183026e-02,-1.355489e-04},
 { 1.169471e-02,-1.574457e-04},{ 1.153727e-02,-1.789710e-04},{ 1.135829e-02,-2.000849e-04},{ 1.115821e-02,-2.207482e-04},
 { 1.093746e-02,-2.409228e-04},{ 1.069654e-02,-2.605717e-04},{ 1.043597e-02,-2.796591e-04},{ 1.015631e-02,-2.981501e-04},
 { 9.858158e-03,-3.160113e-04},{ 9.542147e-03,-3.332105e-04},{ 9.208936e-03,-3.497169e-04},{ 8.859220e-03,-3.655012e-04},
 { 8.493718e-03,-3.805354e-04},{ 8.113183e-03,-3.947931e-04},{ 7.718390e-03,-4.082496e-04},{ 7.310140e-03,-4.208817e-04},
 { 6.889259e-03,-4.326678e-04},{ 6.456591e-03,-4.435881e-04},{ 6.013003e-03,-4.536243e-04},{ 5.559378e-03,-4.627603e-04},
 { 5.096618e-03,-4.709813e-04},{ 4.625637e-03,-4.782745e-04},{ 4.147362e-03,-4.846290e-04},{ 3.662733e-03,-4.900355e-04},
 { 3.172698e-03,-4.944869e-04},{ 2.678211e-03,-4.979775e-04},{ 2.180234e-03,-5.005039e-04},{ 1.679730e-03,-5.020643e-04},
 { 1.177665e-03,-5.026588e-04},{ 6.750064e-04,-5.022894e-04},{ 1.727170e-04,-5.009599e-04},{-3.282428e-04,-4.986758e-04},
 {-8.269186e-04,-4.954448e-04},{-1.322363e-03,-4.912760e-04},{-1.813639e-03,-4.861804e-04},{-2.299820e-03,-4.801707e-04},
 {-2.779990e-03,-4.732615e-04},{-3.253252e-03,-4.654689e-04},{-3.718721e-03,-4.568107e-04},{-4.175532e-03,-4.473062e-04},
 {-4.622838e-03,-4.369764e-04},{-5.059814e-03,-4.258437e-04},{-5.485658e-03,-4.139322e-04},{-5.899590e-03,-4.012671e-04},
 {-6.300857e-03,-3.878752e-04},{-6.688732e-03,-3.737844e-04},{-7.062517e-03,-3.590241e-04},{-7.421541e-03,-3.436248e-04},
 {-7.765166e-03,-3.276179e-04},{-8.092784e-03,-3.110362e-04},{-8.403820e-03,-2.939133e-04},{-8.697733e-03,-2.762838e-04},
 {-8.974017e-03,-2.581832e-04},{-9.232200e-03,-2.396477e-04},{-9.471848e-03,-2.207142e-04},{-9.692562e-03,-2.014203e-04},
 {-9.893982e-03,-1.818042e-04},{-1.007579e-02,-1.619047e-04},{-1.023769e-02,-1.417606e-04},{-1.037945e-02,-1.214116e-04},
 {-1.050086e-02,-1.008973e-04},{-1.060176e-02,-8.025749e-05},{-1.068202e-02,-5.953228e-05},{-1.074155e-02,-3.876166e-05},
 {-1.078031e-02,-1.798562e-05},{-1.079830e-02, 2.755952e-06},{-1.079554e-02, 2.342340e-05},{-1.077212e-02, 4.397730e-05},
 {-1.072814e-02, 6.437861e-05},{-1.066376e-02, 8.458868e-05},{-1.057917e-02, 1.045694e-04},{-1.047460e-02, 1.242831e-04},
 {-1.035032e-02, 1.436929e-04},{-1.020663e-02, 1.627625e-04},{-1.004387e-02, 1.814565e-04},{-9.862409e-03, 1.997402e-04},
 {-9.662669e-03, 2.175799e-04},{-9.445089e-03, 2.349427e-04},{-9.210147e-03, 2.517971e-04},{-8.958350e-03, 2.681122e-04},
 {-8.690237e-03, 2.838585e-04},{-8.406379e-03, 2.990078e-04},{-8.107371e-03, 3.135328e-04},{-7.793838e-03, 3.274077e-04},
 {-7.466431e-03, 3.406082e-04},{-7.125822e-03, 3.531109e-04},{-6.772712e-03, 3.648944e-04},{-6.407817e-03, 3.759382e-04},
 {-6.031879e-03, 3.862237e-04},{-5.645655e-03, 3.957336e-04},{-5.249922e-03, 4.044523e-04},{-4.845469e-03, 4.123655e-04},
 {-4.433104e-03, 4.194608e-04},{-4.013643e-03, 4.257273e-04},{-3.587916e-03, 4.311557e-04},{-3.156760e-03, 4.357383e-04},
 {-2.721022e-03, 4.394692e-04},{-2.281552e-03, 4.423440e-04},{-1.839208e-03, 4.443600e-04},{-1.394848e-03, 4.455163e-04},
 {-9.493322e-04, 4.458134e-04},{-5.035188e-04, 4.452537e-04},{-5.826512e-05, 4.438411e-04},{ 3.855760e-04, 4.415812e-04},
 { 8.271571e-04, 4.384810e-04},{ 1.265638e-03, 4.345495e-04},{ 1.700188e-03, 4.297969e-04},{ 2.129985e-03, 4.242351e-04},
 { 2.554220e-03, 4.178775e-04},{ 2.972097e-03, 4.107390e-04},{ 3.382836e-03, 4.028358e-04},{ 3.785672e-03, 3.941859e-04},
 { 4.179858e-03, 3.848082e-04},{ 4.564666e-03, 3.747233e-04},{ 4.939389e-03, 3.639529e-04},{ 5.303342e-03, 3.525200e-04},
 { 5.655862e-03, 3.404488e-04},{ 5.996311e-03, 3.277648e-04},{ 6.324076e-03, 3.144942e-04},{ 6.638570e-03, 3.006646e-04},
 { 6.939235e-03, 2.863045e-04},{ 7.225539e-03, 2.714433e-04},{ 7.496983e-03, 2.561112e-04},{ 7.753094e-03, 2.403394e-04},
 { 7.993433e-03, 2.241595e-04},{ 8.217593e-03, 2.076042e-04},{ 8.425197e-03, 1.907065e-04},{ 8.615904e-03, 1.735001e-04},
 { 8.789404e-03, 1.560191e-04},{ 8.945423e-03, 1.382980e-04},{ 9.083721e-03, 1.203718e-04},{ 9.204093e-03, 1.022757e-04},
 { 9.306368e-03, 8.404499e-05},{ 9.390413e-03, 6.571524e-05},{ 9.456128e-03, 4.732204e-05},{ 9.503451e-03, 2.890100e-05},
 { 9.532352e-03, 1.048765e-05},{ 9.542839e-03,-7.882599e-06},{ 9.534957e-03,-2.617455e-05},{ 9.508782e-03,-4.435327e-05},
 { 9.464429e-03,-6.238416e-05},{ 9.402045e-03,-8.023303e-05},{ 9.321812e-03,-9.786615e-05},{ 9.223945e-03,-1.152503e-04},
 { 9.108695e-03,-1.323529e-04},{ 8.976342e-03,-1.491420e-04},{ 8.827200e-03,-1.655863e-04},{ 8.661614e-03,-1.816553e-04},
 { 8.479959e-03,-1.973195e-04},{ 8.282639e-03,-2.125500e-04},{ 8.070089e-03,-2.273190e-04},{ 7.842770e-03,-2.415996e-04},
 { 7.601171e-03,-2.553660e-04},{ 7.345805e-03,-2.685935e-04},{ 7.077211e-03,-2.812584e-04},{ 6.795953e-03,-2.933383e-04},
 { 6.502614e-03,-3.048120e-04},{ 6.197802e-03,-3.156593e-04},{ 5.882143e-03,-3.258617e-04},{ 5.556281e-03,-3.354016e-04},
 { 5.220880e-03,-3.442629e-04},{ 4.876617e-03,-3.524309e-04},{ 4.524186e-03,-3.598923e-04},{ 4.164294e-03,-3.666351e-04},
 { 3.797659e-03,-3.726487e-04},{ 3.425010e-03,-3.779243e-04},{ 3.047086e-03,-3.824540e-04},{ 2.664632e-03,-3.862318e-04},
 { 2.278400e-03,-3.892529e-04},{ 1.889147e-03,-3.915142e-04},{ 1.497633e-03,-3.930140e-04},{ 1.104619e-03,-3.937519e-04},
 { 7.108669e-04,-3.937291e-04},{ 3.171377e-04,-3.929485e-04},{-7.581072e-05,-3.914140e-04},{-4.672247e-04,-3.891312e-04},
 {-8.563559e-04,-3.861072e-04},{-1.242463e-03,-3.823503e-04},{-1.624813e-03,-3.778703e-04},{-2.002684e-03,-3.726783e-04},
 {-2.375362e-03,-3.667869e-04},{-2.742149e-03,-3.602098e-04},{-3.102359e-03,-3.529621e-04},{-3.455321e-03,-3.450601e-04},
 {-3.800381e-03,-3.365212e-04},{-4.136902e-03,-3.273642e-04},{-4.464266e-03,-3.176088e-04},{-4.781875e-03,-3.072760e-04},
 {-5.089151e-03,-2.963878e-04},{-5.385539e-03,-2.849669e-04},{-5.670506e-03,-2.730373e-04},{-5.943543e-03,-2.606238e-04},
 {-6.204167e-03,-2.477520e-04},{-6.451919e-03,-2.344484e-04},{-6.686367e-03,-2.207400e-04},{-6.907107e-03,-2.066548e-04},
 {-7.113762e-03,-1.922212e-04},{-7.305983e-03,-1.774683e-04},{-7.483452e-03,-1.624257e-04},{-7.645877e-03,-1.471234e-04},
 {-7.793001e-03,-1.315918e-04},{-7.924592e-03,-1.158616e-04},{-8.040454e-03,-9.996406e-05},{-8.140418e-03,-8.393025e-05},
 {-8.224348e-03,-6.779165e-05},{-8.292140e-03,-5.157975e-05},{-8.343720e-03,-3.532609e-05},{-8.379046e-03,-1.906218e-05},
 {-8.398108e-03,-2.819438e-06},{-8.400927e-03, 1.337087e-05},{-8.387557e-03, 2.947769e-05},{-8.358079e-03, 4.547022e-05},
 {-8.312609e-03, 6.131802e-05},{-8.251291e-03, 7.699100e-05},{-8.174300e-03, 9.245954e-05},{-8.081840e-03, 1.076945e-04},
 {-7.974146e-03, 1.226673e-04},{-7.851478e-03, 1.373500e-04},{-7.714128e-03, 1.517152e-04},{-7.562413e-03, 1.657364e-04},
 {-7.396677e-03, 1.793876e-04},{-7.217289e-03, 1.926440e-04},{-7.024645e-03, 2.054812e-04},{-6.819164e-03, 2.178759e-04},
 {-6.601288e-03, 2.298059e-04},{-6.371482e-03, 2.412497e-04},{-6.130232e-03, 2.521870e-04},{-5.878045e-03, 2.625984e-04},
 {-5.615447e-03, 2.724657e-04},{-5.342981e-03, 2.817718e-04},{-5.061210e-03, 2.905007e-04},{-4.770709e-03, 2.986376e-04},
 {-4.472071e-03, 3.061690e-04},{-4.165902e-03, 3.130824e-04},{-3.852820e-03, 3.193666e-04},{-3.533453e-03, 3.250118e-04},
 {-3.208441e-03, 3.300095e-04},{-2.878432e-03, 3.343521e-04},{-2.544080e-03, 3.380337e-04},{-2.206046e-03, 3.410496e-04},
 {-1.864997e-03, 3.433962e-04},{-1.521600e-03, 3.450715e-04},{-1.176529e-03, 3.460747e-04},{-8.304541e-04, 3.464061e-04},
 {-4.840479e-04, 3.460677e-04},{-1.379803e-04, 3.450623e-04},{ 2.070820e-04, 3.433944e-04},{ 5.504765e-04, 3.410697e-04},
 { 8.915461e-04, 3.380948e-04},{ 1.229641e-03, 3.344779e-04},{ 1.564119e-03, 3.302284e-04},{ 1.894347e-03, 3.253567e-04},
 { 2.219704e-03, 3.198745e-04},{ 2.539579e-03, 3.137945e-04},{ 2.853373e-03, 3.071307e-04},{ 3.160504e-03, 2.998981e-04},
 { 3.460402e-03, 2.921127e-04},{ 3.752515e-03, 2.837916e-04},{ 4.036306e-03, 2.749527e-04},{ 4.311259e-03, 2.656151e-04},
 { 4.576874e-03, 2.557985e-04},{ 4.832673e-03, 2.455238e-04},{ 5.078196e-03, 2.348124e-04},{ 5.313009e-03, 2.236867e-04},
 { 5.536695e-03, 2.121696e-04},{ 5.748865e-03, 2.002848e-04},{ 5.949150e-03, 1.880567e-04},{ 6.137207e-03, 1.755102e-04},
 { 6.312717e-03, 1.626707e-04},{ 6.475388e-03, 1.495640e-04},{ 6.624952e-03, 1.362165e-04},{ 6.761168e-03, 1.226549e-04},
 { 6.883823e-03, 1.089062e-04},{ 6.992729e-03, 9.499772e-05},{ 7.087727e-03, 8.095689e-05},{ 7.168684e-03, 6.681137e-05},
 { 7.235495e-03, 5.258891e-05},{ 7.288084e-03, 3.831731e-05},{ 7.326401e-03, 2.402435e-05},{ 7.350426e-03, 9.737776e-06},
 { 7.360163e-03,-4.514801e-06},{ 7.355649e-03,-1.870593e-05},{ 7.336943e-03,-3.280837e-05},{ 7.304134e-03,-4.679516e-05},
 { 7.257339e-03,-6.063965e-05},{ 7.196700e-03,-7.431559e-05},{ 7.122384e-03,-8.779711e-05},{ 7.034587e-03,-1.010588e-04},
 { 6.933528e-03,-1.140759e-04},{ 6.819452e-03,-1.268241e-04},{ 6.692628e-03,-1.392796e-04},{ 6.553348e-03,-1.514195e-04},
 { 6.401929e-03,-1.632213e-04},{ 6.238708e-03,-1.746636e-04},{ 6.064044e-03,-1.857254e-04},{ 5.878319e-03,-1.963869e-04},
 { 5.681932e-03,-2.066287e-04},{ 5.475303e-03,-2.164326e-04},{ 5.258870e-03,-2.257813e-04},{ 5.033089e-03,-2.346584e-04},
 { 4.798431e-03,-2.430483e-04},{ 4.555382e-03,-2.509367e-04},{ 4.304446e-03,-2.583101e-04},{ 4.046136e-03,-2.651562e-04},
 { 3.780979e-03,-2.714637e-04},{ 3.509516e-03,-2.772223e-04},{ 3.232293e-03,-2.824229e-04},{ 2.949871e-03,-2.870576e-04},
 { 2.662813e-03,-2.911194e-04},{ 2.371694e-03,-2.946026e-04},{ 2.077091e-03,-2.975027e-04},{ 1.779588e-03,-2.998161e-04},
 { 1.479772e-03,-3.015406e-04},{ 1.178231e-03,-3.026751e-04},{ 8.755564e-04,-3.032194e-04},{ 5.723369e-04,-3.031749e-04},
 { 2.691621e-04,-3.025436e-04},{-3.338156e-05,-3.013292e-04},{-3.347108e-04,-2.995361e-04},{-6.342468e-04,-2.971699e-04},
 {-9.314167e-04,-2.942374e-04},{-1.225654e-03,-2.907463e-04},{-1.516400e-03,-2.867056e-04},{-1.803106e-03,-2.821251e-04},
 {-2.085231e-03,-2.770157e-04},{-2.362247e-03,-2.713892e-04},{-2.633636e-03,-2.652587e-04},{-2.898895e-03,-2.586377e-04},
 {-3.157532e-03,-2.515411e-04},{-3.409073e-03,-2.439843e-04},{-3.653058e-03,-2.359837e-04},{-3.889041e-03,-2.275565e-04},
 {-4.116598e-03,-2.187206e-04},{-4.335318e-03,-2.094947e-04},{-4.544813e-03,-1.998982e-04},{-4.744711e-03,-1.899511e-04},
 {-4.934663e-03,-1.796739e-04},{-5.114336e-03,-1.690879e-04},{-5.283424e-03,-1.582147e-04},{-5.441639e-03,-1.470765e-04},
 {-5.588715e-03,-1.356959e-04},{-5.724411e-03,-1.240959e-04},{-5.848507e-03,-1.122998e-04},{-5.960807e-03,-1.003313e-04},
 {-6.061138e-03,-8.821411e-05},{-6.149352e-03,-7.597243e-05},{-6.225325e-03,-6.363042e-05},{-6.288955e-03,-5.121242e-05},
 {-6.340168e-03,-3.874279e-05},{-6.378910e-03,-2.624592e-05},{-6.405156e-03,-1.374616e-05},{-6.418903e-03,-1.267764e-06},
 {-6.420170e-03, 1.116514e-05},{-6.409005e-03, 2.352861e-05},{-6.385477e-03, 3.579891e-05},{-6.349678e-03, 4.795261e-05},
 {-6.301725e-03, 5.996655e-05},{-6.241759e-03, 7.181797e-05},{-6.169941e-03, 8.348448e-05},{-6.086456e-03, 9.494416e-05},
 {-5.991512e-03, 1.061756e-04},{-5.885336e-03, 1.171577e-04},{-5.768179e-03, 1.278704e-04},{-5.640308e-03, 1.382937e-04},
 {-5.502015e-03, 1.484085e-04},{-5.353606e-03, 1.581965e-04},{-5.195410e-03, 1.676398e-04},{-5.027770e-03, 1.767215e-04},
 {-4.851048e-03, 1.854253e-04},{-4.665623e-03, 1.937357e-04},{-4.471887e-03, 2.016382e-04},{-4.270249e-03, 2.091190e-04},
 {-4.061130e-03, 2.161651e-04},{-3.844965e-03, 2.227646e-04},{-3.622200e-03, 2.289064e-04},{-3.393294e-03, 2.345803e-04},
 {-3.158714e-03, 2.397771e-04},{-2.918936e-03, 2.444886e-04},{-2.674448e-03, 2.487074e-04},{-2.425741e-03, 2.524273e-04},
 {-2.173313e-03, 2.556430e-04},{-1.917670e-03, 2.583502e-04},{-1.659320e-03, 2.605455e-04},{-1.398775e-03, 2.622268e-04},
 {-1.136548e-03, 2.633928e-04},{-8.731550e-04, 2.640431e-04},{-6.091118e-04, 2.641786e-04},{-3.449333e-04, 2.638008e-04},
 {-8.113245e-05, 2.629127e-04},{ 1.817802e-04, 2.615178e-04},{ 4.432981e-04, 2.596209e-04},{ 7.029190e-04, 2.572276e-04},
 { 9.601466e-04, 2.543445e-04},{ 1.214491e-03, 2.509790e-04},{ 1.465470e-03, 2.471397e-04},{ 1.712610e-03, 2.428357e-04},
 { 1.955446e-03, 2.380774e-04},{ 2.193523e-03, 2.328756e-04},{ 2.426399e-03, 2.272423e-04},{ 2.653641e-03, 2.211900e-04},
 { 2.874831e-03, 2.147322e-04},{ 3.089563e-03, 2.078831e-04},{ 3.297446e-03, 2.006573e-04},{ 3.498103e-03, 1.930705e-04},
 { 3.691174e-03, 1.851389e-04},{ 3.876313e-03, 1.768791e-04},{ 4.053192e-03, 1.683086e-04},{ 4.221501e-03, 1.594452e-04},
 { 4.380946e-03, 1.503073e-04},{ 4.531253e-03, 1.409137e-04},{ 4.672167e-03, 1.312837e-04},{ 4.803450e-03, 1.214369e-04},
 { 4.924887e-03, 1.113934e-04},{ 5.036281e-03, 1.011735e-04},{ 5.137454e-03, 9.079765e-05},{ 5.228252e-03, 8.028672e-05},
 { 5.308539e-03, 6.966165e-05},{ 5.378200e-03, 5.894357e-05},{ 5.437144e-03, 4.815368e-05},{ 5.485298e-03, 3.731325e-05},
 { 5.522611e-03, 2.644356e-05},{ 5.549054e-03, 1.556587e-05},{ 5.564620e-03, 4.701361e-06},{ 5.569322e-03,-6.128886e-06},
 { 5.563193e-03,-1.690394e-05},{ 5.546289e-03,-2.760306e-05},{ 5.518686e-03,-3.820575e-05},{ 5.480480e-03,-4.869174e-05},
 { 5.431788e-03,-5.904112e-05},{ 5.372747e-03,-6.923429e-05},{ 5.303513e-03,-7.925204e-05},{ 5.224261e-03,-8.907557e-05},
 { 5.135185e-03,-9.868655e-05},{ 5.036499e-03,-1.080671e-04},{ 4.928432e-03,-1.172000e-04},{ 4.811232e-03,-1.260683e-04},
 { 4.685163e-03,-1.346559e-04},{ 4.550508e-03,-1.429471e-04},{ 4.407560e-03,-1.509271e-04},{ 4.256633e-03,-1.585815e-04},
 { 4.098052e-03,-1.658968e-04},{ 3.932155e-03,-1.728601e-04},{ 3.759295e-03,-1.794592e-04},{ 3.579836e-03,-1.856827e-04},
 { 3.394153e-03,-1.915200e-04},{ 3.202633e-03,-1.969613e-04},{ 3.005672e-03,-2.019977e-04},{ 2.803674e-03,-2.066208e-04},
 { 2.597053e-03,-2.108235e-04},{ 2.386230e-03,-2.145991e-04},{ 2.171631e-03,-2.179421e-04},{ 1.953689e-03,-2.208477e-04},
 { 1.732841e-03,-2.233120e-04},{ 1.509529e-03,-2.253319e-04},{ 1.284197e-03,-2.269053e-04},{ 1.057292e-03,-2.280310e-04},
 { 8.292606e-04,-2.287086e-04},{ 6.005520e-04,-2.289386e-04},{ 3.716134e-04,-2.287222e-04},{ 1.428912e-04,-2.280618e-04},
 {-8.517055e-05,-2.269604e-04},{-3.121309e-04,-2.254219e-04},{-5.375529e-04,-2.234512e-04},{-7.610041e-04,-2.210538e-04},
 {-9.820578e-04,-2.182360e-04},{-1.200294e-03,-2.150051e-04},{-1.415299e-03,-2.113691e-04},{-1.626668e-03,-2.073367e-04},
 {-1.834005e-03,-2.029173e-04},{-2.036922e-03,-1.981212e-04},{-2.235043e-03,-1.929591e-04},{-2.428002e-03,-1.874427e-04},
 {-2.615445e-03,-1.815841e-04},{-2.797029e-03,-1.753962e-04},{-2.972425e-03,-1.688923e-04},{-3.141318e-03,-1.620864e-04},
 {-3.303404e-03,-1.549930e-04},{-3.458397e-03,-1.476271e-04},{-3.606024e-03,-1.400041e-04},{-3.746028e-03,-1.321400e-04},
 {-3.878168e-03,-1.240511e-04},{-4.002219e-03,-1.157540e-04},{-4.117973e-03,-1.072658e-04},{-4.225239e-03,-9.860385e-05},
 {-4.323843e-03,-8.978566e-05},{-4.413629e-03,-8.082911e-05},{-4.494458e-03,-7.175222e-05},{-4.566210e-03,-6.257317e-05},
 {-4.628783e-03,-5.331028e-05},{-4.682094e-03,-4.398196e-05},{-4.726076e-03,-3.460665e-05},{-4.760682e-03,-2.520283e-05},
 {-4.785885e-03,-1.578895e-05},{-4.801674e-03,-6.383407e-06},{-4.808057e-03, 2.995489e-06},{-4.805062e-03, 1.232956e-05},
 {-4.792732e-03, 2.160079e-05},{-4.771132e-03, 3.079137e-05},{-4.740340e-03, 3.988369e-05},{-4.700456e-03, 4.886043e-05},
 {-4.651596e-03, 5.770457e-05},{-4.593891e-03, 6.639940e-05},{-4.527492e-03, 7.492857e-05},{-4.452563e-03, 8.327615e-05},
 {-4.369287e-03, 9.142659e-05},{-4.277861e-03, 9.936482e-05},{-4.178496e-03, 1.070762e-04},{-4.071420e-03, 1.145467e-04},
 {-3.956873e-03, 1.217627e-04},{-3.835110e-03, 1.287112e-04},{-3.706399e-03, 1.353797e-04},{-3.571019e-03, 1.417564e-04},
 {-3.429263e-03, 1.478301e-04},{-3.281433e-03, 1.535901e-04},{-3.127843e-03, 1.590266e-04},{-2.968816e-03, 1.641303e-04},
 {-2.804686e-03, 1.688925e-04},{-2.635793e-03, 1.733055e-04},{-2.462488e-03, 1.773621e-04},{-2.285126e-03, 1.810558e-04},
 {-2.104070e-03, 1.843810e-04},{-1.919689e-03, 1.873327e-04},{-1.732356e-03, 1.899068e-04},{-1.542449e-03, 1.920997e-04},
 {-1.350350e-03, 1.939087e-04},{-1.156441e-03, 1.953321e-04},{-9.611089e-04, 1.963685e-04},{-7.647403e-04, 1.970177e-04},
 {-5.677227e-04, 1.972799e-04},{-3.704428e-04, 1.971562e-04},{-1.732866e-04, 1.966486e-04},{ 2.336206e-05, 1.957597e-04},
 { 2.191217e-04, 1.944927e-04},{ 4.136144e-04, 1.928518e-04},{ 6.064662e-04, 1.908417e-04},{ 7.973079e-04, 1.884679e-04},
 { 9.857757e-04, 1.857365e-04},{ 1.171512e-03, 1.826545e-04},{ 1.354167e-03, 1.792293e-04},{ 1.533396e-03, 1.754691e-04},
 { 1.708865e-03, 1.713825e-04},{ 1.880248e-03, 1.669791e-04},{ 2.047227e-03, 1.622686e-04},{ 2.209495e-03, 1.572617e-04},
 { 2.366757e-03, 1.519694e-04},{ 2.518727e-03, 1.464031e-04},{ 2.665130e-03, 1.405750e-04},{ 2.805705e-03, 1.344975e-04},
 { 2.940202e-03, 1.281836e-04},{ 3.068386e-03, 1.216466e-04},{ 3.190032e-03, 1.149002e-04},{ 3.304932e-03, 1.079585e-04},
 { 3.412891e-03, 1.008359e-04},{ 3.513727e-03, 9.354707e-05},{ 3.607274e-03, 8.610699e-05},{ 3.693381e-03, 7.853082e-05},
 { 3.771912e-03, 7.083396e-05},{ 3.842746e-03, 6.303196e-05},{ 3.905778e-03, 5.514051e-05},{ 3.960918e-03, 4.717542e-05},
 { 4.008094e-03, 3.915258e-05},{ 4.047246e-03, 3.108791e-05},{ 4.078334e-03, 2.299736e-05},{ 4.101331e-03, 1.489685e-05},
 { 4.116228e-03, 6.802253e-06},{ 4.123030e-03,-1.270623e-06},{ 4.121760e-03,-9.306094e-06},{ 4.112454e-03,-1.728861e-05},
 { 4.095165e-03,-2.520279e-05},{ 4.069962e-03,-3.303346e-05},{ 4.036929e-03,-4.076566e-05},{ 3.996163e-03,-4.838470e-05},
 { 3.947779e-03,-5.587617e-05},{ 3.891902e-03,-6.322597e-05},{ 3.828676e-03,-7.042033e-05},{ 3.758256e-03,-7.744586e-05},
 { 3.680810e-03,-8.428955e-05},{ 3.596521e-03,-9.093879e-05},{ 3.505582e-03,-9.738142e-05},{ 3.408200e-03,-1.036057e-04},
 { 3.304595e-03,-1.096005e-04},{ 3.194994e-03,-1.153550e-04},{ 3.079639e-03,-1.208590e-04},{ 2.958780e-03,-1.261028e-04},
 { 2.832677e-03,-1.310773e-04},{ 2.701600e-03,-1.357739e-04},{ 2.565826e-03,-1.401847e-04},{ 2.425642e-03,-1.443022e-04},
 { 2.281339e-03,-1.481197e-04},{ 2.133220e-03,-1.516310e-04},{ 1.981589e-03,-1.548306e-04},{ 1.826758e-03,-1.577135e-04},
 { 1.669045e-03,-1.602755e-04},{ 1.508769e-03,-1.625130e-04},{ 1.346256e-03,-1.644231e-04},{ 1.181833e-03,-1.660033e-04},
 { 1.015830e-03,-1.672521e-04},{ 8.485775e-04,-1.681685e-04},{ 6.804090e-04,-1.687520e-04},{ 5.116570e-04,-1.690031e-04},
 { 3.426538e-04,-1.689227e-04},{ 1.737311e-04,-1.685124e-04},{ 5.218663e-06,-1.677745e-04},{-1.625558e-04,-1.667117e-04},
 {-3.292675e-04,-1.653277e-04},{-4.945952e-04,-1.636265e-04},{-6.582217e-04,-1.616129e-04},{-8.198346e-04,-1.592922e-04},
 {-9.791268e-04,-1.566703e-04},{-1.135797e-03,-1.537536e-04},{-1.289551e-03,-1.505491e-04},{-1.440100e-03,-1.470644e-04},
 {-1.587164e-03,-1.433075e-04},{-1.730472e-03,-1.392871e-04},{-1.869759e-03,-1.350121e-04},{-2.004771e-03,-1.304920e-04},
 {-2.135263e-03,-1.257367e-04},{-2.260999e-03,-1.207567e-04},{-2.381756e-03,-1.155626e-04},{-2.497319e-03,-1.101656e-04},
 {-2.607484e-03,-1.045772e-04},{-2.712062e-03,-9.880906e-05},{-2.810871e-03,-9.287339e-05},{-2.903744e-03,-8.678252e-05},
 {-2.990527e-03,-8.054908e-05},{-3.071076e-03,-7.418591e-05},{-3.145262e-03,-6.770606e-05},{-3.212968e-03,-6.112273e-05},
 {-3.274090e-03,-5.444929e-05},{-3.328540e-03,-4.769921e-05},{-3.376239e-03,-4.088606e-05},{-3.417125e-03,-3.402348e-05},
 {-3.451148e-03,-2.712512e-05},{-3.478274e-03,-2.020468e-05},{-3.498478e-03,-1.327580e-05},{-3.511754e-03,-6.352118e-06},
 {-3.518106e-03, 5.528323e-07},{-3.517553e-03, 7.425598e-06},{-3.510128e-03, 1.425285e-05},{-3.495875e-03, 2.102141e-05},
 {-3.474853e-03, 2.771828e-05},{-3.447135e-03, 3.433064e-05},{-3.412805e-03, 4.084591e-05},{-3.371959e-03, 4.725175e-05},
 {-3.324707e-03, 5.353610e-05},{-3.271171e-03, 5.968718e-05},{-3.211484e-03, 6.569353e-05},{-3.145790e-03, 7.154402e-05},
 {-3.074246e-03, 7.722788e-05},{-2.997018e-03, 8.273471e-05},{-2.914283e-03, 8.805451e-05},{-2.826229e-03, 9.317769e-05},
 {-2.733051e-03, 9.809509e-05},{-2.634956e-03, 1.027980e-04},{-2.532158e-03, 1.072781e-04},{-2.424880e-03, 1.115278e-04},
 {-2.313352e-03, 1.155395e-04},{-2.197813e-03, 1.193067e-04},{-2.078506e-03, 1.228229e-04},{-1.955683e-03, 1.260825e-04},
 {-1.829601e-03, 1.290802e-04},{-1.700520e-03, 1.318113e-04},{-1.568709e-03, 1.342716e-04},{-1.434438e-03, 1.364576e-04},
 {-1.297980e-03, 1.383661e-04},{-1.159614e-03, 1.399948e-04},{-1.019619e-03, 1.413417e-04},{-8.782772e-04, 1.424055e-04},
 {-7.358718e-04, 1.431852e-04},{-5.926865e-04, 1.436808e-04},{-4.490057e-04, 1.438925e-04},{-3.051133e-04, 1.438211e-04},
 {-1.612922e-04, 1.434682e-04},{-1.782396e-05, 1.428357e-04},{ 1.250117e-04, 1.419261e-04},{ 2.669378e-04, 1.407425e-04},
 { 4.076803e-04, 1.392884e-04},{ 5.469686e-04, 1.375679e-04},{ 6.845365e-04, 1.355857e-04},{ 8.201222e-04, 1.333467e-04},
 { 9.534689e-04, 1.308567e-04},{ 1.084326e-03, 1.281216e-04},{ 1.212447e-03, 1.251479e-04},{ 1.337595e-03, 1.219425e-04},
 { 1.459538e-03, 1.185129e-04},{ 1.578050e-03, 1.148667e-04},{ 1.692917e-03, 1.110122e-04},{ 1.803929e-03, 1.069578e-04},
 { 1.910887e-03, 1.027124e-04},{ 2.013599e-03, 9.828526e-05},{ 2.111885e-03, 9.368592e-05},{ 2.205571e-03, 8.892418e-05},
 { 2.294495e-03, 8.401015e-05},{ 2.378505e-03, 7.895418e-05},{ 2.457459e-03, 7.376686e-05},{ 2.531226e-03, 6.845898e-05},
 { 2.599685e-03, 6.304153e-05},{ 2.662727e-03, 5.752565e-05},{ 2.720252e-03, 5.192263e-05},{ 2.772175e-03, 4.624390e-05},
 { 2.818419e-03, 4.050095e-05},{ 2.858920e-03, 3.470536e-05},{ 2.893625e-03, 2.886877e-05},{ 2.922494e-03, 2.300284e-05},
 { 2.945497e-03, 1.711922e-05},{ 2.962616e-03, 1.122957e-05},{ 2.973845e-03, 5.345475e-06},{ 2.979191e-03,-5.215152e-07},
 { 2.978669e-03,-6.359953e-06},{ 2.972309e-03,-1.215850e-05},{ 2.960151e-03,-1.790594e-05},{ 2.942245e-03,-2.359122e-05},
 { 2.918654e-03,-2.920345e-05},{ 2.889450e-03,-3.473194e-05},{ 2.854718e-03,-4.016622e-05},{ 2.814552e-03,-4.549604e-05},
 { 2.769056e-03,-5.071141e-05},{ 2.718345e-03,-5.580261e-05},{ 2.662542e-03,-6.076023e-05},{ 2.601782e-03,-6.557513e-05},
 { 2.536207e-03,-7.023851e-05},{ 2.465968e-03,-7.474192e-05},{ 2.391226e-03,-7.907725e-05},{ 2.312149e-03,-8.323677e-05},
 { 2.228912e-03,-8.721312e-05},{ 2.141699e-03,-9.099935e-05},{ 2.050700e-03,-9.458889e-05},{ 1.956111e-03,-9.797562e-05},
 { 1.858135e-03,-1.011538e-04},{ 1.756981e-03,-1.041182e-04},{ 1.652863e-03,-1.068641e-04},{ 1.545999e-03,-1.093869e-04},
 { 1.436612e-03,-1.116828e-04},{ 1.324929e-03,-1.137484e-04},{ 1.211181e-03,-1.155807e-04},{ 1.095600e-03,-1.171771e-04},
 { 9.784233e-04,-1.185357e-04},{ 8.598876e-04,-1.196549e-04},{ 7.402327e-04,-1.205337e-04},{ 6.196990e-04,-1.211714e-04},
 { 4.985276e-04,-1.215679e-04},{ 3.769596e-04,-1.217237e-04},{ 2.552359e-04,-1.216395e-04},{ 1.335965e-04,-1.213166e-04},
 { 1.227985e-05,-1.207568e-04},{-1.084770e-04,-1.199624e-04},{-2.284394e-04,-1.189360e-04},{-3.473754e-04,-1.176807e-04},
 {-4.650561e-04,-1.162002e-04},{-5.812563e-04,-1.144983e-04},{-6.957546e-04,-1.125795e-04},{-8.083341e-04,-1.104487e-04},
 {-9.187828e-04,-1.081109e-04},{-1.026894e-03,-1.055719e-04},{-1.132466e-03,-1.028375e-04},{-1.235303e-03,-9.991408e-05},
 {-1.335217e-03,-9.680833e-05},{-1.432025e-03,-9.352721e-05},{-1.525553e-03,-9.007802e-05},{-1.615631e-03,-8.646836e-05},
 {-1.702099e-03,-8.270611e-05},{-1.784805e-03,-7.879941e-05},{-1.863605e-03,-7.475665e-05},{-1.938361e-03,-7.058644e-05},
 {-2.008948e-03,-6.629761e-05},{-2.075245e-03,-6.189918e-05},{-2.137144e-03,-5.740034e-05},{-2.194545e-03,-5.281042e-05},
 {-2.247355e-03,-4.813893e-05},{-2.295494e-03,-4.339544e-05},{-2.338890e-03,-3.858966e-05},{-2.377479e-03,-3.373134e-05},
 {-2.411211e-03,-2.883032e-05},{-2.440041e-03,-2.389647e-05},{-2.463937e-03,-1.893965e-05},{-2.482877e-03,-1.396974e-05},
 {-2.496847e-03,-8.996617e-06},{-2.505843e-03,-4.030079e-06},{-2.509873e-03, 9.201145e-07},{-2.508953e-03, 5.844286e-06},
 {-2.503109e-03, 1.073286e-05},{-2.492376e-03, 1.557637e-05},{-2.476800e-03, 2.036549e-05},{-2.456434e-03, 2.509105e-05},
 {-2.431343e-03, 2.974403e-05},{-2.401599e-03, 3.431563e-05},{-2.367284e-03, 3.879722e-05},{-2.328486e-03, 4.318041e-05},
 {-2.285306e-03, 4.745704e-05},{-2.237849e-03, 5.161920e-05},{-2.186230e-03, 5.565923e-05},{-2.130571e-03, 5.956977e-05},
 {-2.071001e-03, 6.334375e-05},{-2.007657e-03, 6.697438e-05},{-1.940683e-03, 7.045521e-05},{-1.870227e-03, 7.378012e-05},
 {-1.796447e-03, 7.694329e-05},{-1.719504e-03, 7.993930e-05},{-1.639565e-03, 8.276306e-05},{-1.556802e-03, 8.540983e-05},
 {-1.471392e-03, 8.787526e-05},{-1.383517e-03, 9.015539e-05},{-1.293361e-03, 9.224663e-05},{-1.201115e-03, 9.414579e-05},
 {-1.106969e-03, 9.585005e-05},{-1.011119e-03, 9.735703e-05},{-9.137617e-04, 9.866472e-05},{-8.150969e-04, 9.977152e-05},
 {-7.153254e-04, 1.006762e-04},{-6.146492e-04, 1.013781e-04},{-5.132711e-04, 1.018767e-04},{-4.113944e-04, 1.021721e-04},
 {-3.092223e-04, 1.022647e-04},{-2.069577e-04, 1.021552e-04},{-1.048024e-04, 1.018451e-04},{-2.957333e-06, 1.013357e-04},
 { 9.837841e-05, 1.006293e-04},{ 1.990077e-04, 9.972796e-05},{ 2.987356e-04, 9.863463e-05},{ 3.973703e-04, 9.735237e-05},
 { 4.947226e-04, 9.588465e-05},{ 5.906073e-04, 9.423529e-05},{ 6.848426e-04, 9.240845e-05},{ 7.772510e-04, 9.040862e-05},
 { 8.676597e-04, 8.824062e-05},{ 9.559003e-04, 8.590956e-05},{ 1.041810e-03, 8.342087e-05},{ 1.125231e-03, 8.078024e-05},
 { 1.206011e-03, 7.799364e-05},{ 1.284005e-03, 7.506732e-05},{ 1.359072e-03, 7.200775e-05},{ 1.431080e-03, 6.882164e-05},
 { 1.499901e-03, 6.551592e-05},{ 1.565417e-03, 6.209772e-05},{ 1.627515e-03, 5.857436e-05},{ 1.686089e-03, 5.495332e-05},
 { 1.741043e-03, 5.124225e-05},{ 1.792285e-03, 4.744894e-05},{ 1.839734e-03, 4.358129e-05},{ 1.883315e-03, 3.964732e-05},
 { 1.922962e-03, 3.565514e-05},{ 1.958618e-03, 3.161292e-05},{ 1.990230e-03, 2.752892e-05},{ 2.017759e-03, 2.341142e-05},
 { 2.041171e-03, 1.926871e-05},{ 2.060440e-03, 1.510912e-05},{ 2.075549e-03, 1.094096e-05},{ 2.086490e-03, 6.772498e-06},
 { 2.093262e-03, 2.611989e-06},{ 2.095874e-03,-1.532386e-06},{ 2.094342e-03,-5.652515e-06},{ 2.088689e-03,-9.740375e-06},
 { 2.078949e-03,-1.378805e-05},{ 2.065161e-03,-1.778773e-05},{ 2.047373e-03,-2.173176e-05},{ 2.025641e-03,-2.561261e-05},
 { 2.000029e-03,-2.942295e-05},{ 1.970606e-03,-3.315558e-05},{ 1.937450e-03,-3.680352e-05},{ 1.900647e-03,-4.035998e-05},
 { 1.860287e-03,-4.381841e-05},{ 1.816468e-03,-4.717245e-05},{ 1.769296e-03,-5.041600e-05},{ 1.718880e-03,-5.354321e-05},
 { 1.665337e-03,-5.654849e-05},{ 1.608788e-03,-5.942652e-05},{ 1.549362e-03,-6.217224e-05},{ 1.487189e-03,-6.478091e-05},
 { 1.422408e-03,-6.724806e-05},{ 1.355160e-03,-6.956954e-05},{ 1.285591e-03,-7.174149e-05},{ 1.213849e-03,-7.376040e-05},
 { 1.140089e-03,-7.562303e-05},{ 1.064466e-03,-7.732652e-05},{ 9.871394e-04,-7.886830e-05},{ 9.082711e-04,-8.024616e-05},
 { 8.280249e-04,-8.145821e-05},{ 7.465667e-04,-8.250290e-05},{ 6.640638e-04,-8.337903e-05},{ 5.806848e-04,-8.408573e-05},
 { 4.965990e-04,-8.462248e-05},{ 4.119766e-04,-8.498909e-05},{ 3.269875e-04,-8.518570e-05},{ 2.418018e-04,-8.521282e-05},
 { 1.565890e-04,-8.507126e-05},{ 7.151769e-05,-8.476218e-05},{-1.324449e-05,-8.428705e-05},{-9.753153e-05,-8.364767e-05},
 {-1.811792e-04,-8.284616e-05},{-2.640254e-04,-8.188496e-05},{-3.459103e-04,-8.076678e-05},{-4.266771e-04,-7.949467e-05},
 {-5.061718e-04,-7.807194e-05},{-5.842437e-04,-7.650219e-05},{-6.607459e-04,-7.478930e-05},{-7.355352e-04,-7.293740e-05},
 {-8.084726e-04,-7.095090e-05},{-8.794235e-04,-6.883442e-05},{-9.482579e-04,-6.659285e-05},{-1.014851e-03,-6.423126e-05},
 {-1.079082e-03,-6.175498e-05},{-1.140837e-03,-5.916951e-05},{-1.200007e-03,-5.648055e-05},{-1.256487e-03,-5.369396e-05},
 {-1.310181e-03,-5.081578e-05},{-1.360997e-03,-4.785221e-05},{-1.408849e-03,-4.480955e-05},{-1.453659e-03,-4.169426e-05},
 {-1.495353e-03,-3.851291e-05},{-1.533866e-03,-3.527213e-05},{-1.569138e-03,-3.197868e-05},{-1.601117e-03,-2.863936e-05},
 {-1.629756e-03,-2.526104e-05},{-1.655017e-03,-2.185062e-05},{-1.676868e-03,-1.841504e-05},{-1.695283e-03,-1.496124e-05},
 {-1.710244e-03,-1.149618e-05},{-1.721740e-03,-8.026791e-06},{-1.729767e-03,-4.559976e-06},{-1.734327e-03,-1.102603e-06},
 {-1.735429e-03, 2.338516e-06},{-1.733091e-03, 5.756638e-06},{-1.727334e-03, 9.145100e-06},{-1.718189e-03, 1.249733e-05},
 {-1.705692e-03, 1.580687e-05},{-1.689885e-03, 1.906738e-05},{-1.670818e-03, 2.227263e-05},{-1.648545e-03, 2.541657e-05},
 {-1.623128e-03, 2.849327e-05},{-1.594635e-03, 3.149698e-05},{-1.563138e-03, 3.442212e-05},{-1.528716e-03, 3.726330e-05},
 {-1.491453e-03, 4.001532e-05},{-1.451437e-03, 4.267319e-05},{-1.408764e-03, 4.523214e-05},{-1.363532e-03, 4.768760e-05},
 {-1.315844e-03, 5.003525e-05},{-1.265809e-03, 5.227100e-05},{-1.213538e-03, 5.439100e-05},{-1.159147e-03, 5.639166e-05},
 {-1.102756e-03, 5.826964e-05},{-1.044486e-03, 6.002186e-05},{-9.844640e-04, 6.164550e-05},{-9.228185e-04, 6.313804e-05},
 {-8.596805e-04, 6.449720e-05},{-7.951833e-04, 6.572099e-05},{-7.294623e-04, 6.680771e-05},{-6.626546e-04, 6.775593e-05},
 {-5.948987e-04, 6.856450e-05},{-5.263341e-04, 6.923257e-05},{-4.571016e-04, 6.975956e-05},{-3.873420e-04, 7.014518e-05},
 {-3.171968e-04, 7.038941e-05},{-2.468074e-04, 7.049253e-05},{-1.763149e-04, 7.045510e-05},{-1.058598e-04, 7.027794e-05},
 {-3.558185e-05, 6.996216e-05},{ 3.438031e-05, 6.950912e-05},{ 1.038894e-04, 6.892047e-05},{ 1.728099e-04, 6.819811e-05},
 { 2.410080e-04, 6.734420e-05},{ 3.083522e-04, 6.636113e-05},{ 3.747133e-04, 6.525156e-05},{ 4.399649e-04, 6.401839e-05},
 { 5.039833e-04, 6.266473e-05},{ 5.666480e-04, 6.119392e-05},{ 6.278420e-04, 5.960953e-05},{ 6.874515e-04, 5.791532e-05},
 { 7.453668e-04, 5.611525e-05},{ 8.014820e-04, 5.421348e-05},{ 8.556955e-04, 5.221434e-05},{ 9.079099e-04, 5.012235e-05},
 { 9.580322e-04, 4.794216e-05},{ 1.005974e-03, 4.567860e-05},{ 1.051653e-03, 4.333662e-05},{ 1.094990e-03, 4.092130e-05},
 { 1.135911e-03, 3.843787e-05},{ 1.174349e-03, 3.589162e-05},{ 1.210240e-03, 3.328798e-05},{ 1.243528e-03, 3.063243e-05},
 { 1.274161e-03, 2.793055e-05},{ 1.302091e-03, 2.518797e-05},{ 1.327279e-03, 2.241037e-05},{ 1.349690e-03, 1.960348e-05},
 { 1.369293e-03, 1.677305e-05},{ 1.386066e-03, 1.392484e-05},{ 1.399991e-03, 1.106463e-05},{ 1.411056e-03, 8.198168e-06},
 { 1.419254e-03, 5.331211e-06},{ 1.424585e-03, 2.469471e-06},{ 1.427055e-03,-3.813783e-07},{ 1.426673e-03,-3.215716e-06},
 { 1.423457e-03,-6.027985e-06},{ 1.417429e-03,-8.812701e-06},{ 1.408617e-03,-1.156447e-05},{ 1.397052e-03,-1.427797e-05},
 { 1.382774e-03,-1.694803e-05},{ 1.365826e-03,-1.956954e-05},{ 1.346257e-03,-2.213756e-05},{ 1.324119e-03,-2.464725e-05},
 { 1.299472e-03,-2.709393e-05},{ 1.272378e-03,-2.947307e-05},{ 1.242905e-03,-3.178030e-05},{ 1.211125e-03,-3.401141e-05},
 { 1.177113e-03,-3.616237e-05},{ 1.140951e-03,-3.822933e-05},{ 1.102722e-03,-4.020863e-05},{ 1.062513e-03,-4.209681e-05},
 { 1.020416e-03,-4.389061e-05},{ 9.765255e-04,-4.558695e-05},{ 9.309386e-04,-4.718301e-05},{ 8.837556e-04,-4.867614e-05},
 { 8.350794e-04,-5.006394e-05},{ 7.850155e-04,-5.134422e-05},{ 7.336712e-04,-5.251502e-05},{ 6.811562e-04,-5.357460e-05},
 { 6.275816e-04,-5.452147e-05},{ 5.730602e-04,-5.535436e-05},{ 5.177058e-04,-5.607224e-05},{ 4.616335e-04,-5.667432e-05},
 { 4.049592e-04,-5.716003e-05},{ 3.477992e-04,-5.752904e-05},{ 2.902702e-04,-5.778128e-05},{ 2.324889e-04,-5.791687e-05},
 { 1.745720e-04,-5.793621e-05},{ 1.166358e-04,-5.783989e-05},{ 5.879591e-05,-5.762875e-05},{ 1.167165e-06,-5.730385e-05},
 {-5.613669e-05,-5.686647e-05},{-1.130032e-04,-5.631811e-05},{-1.693213e-04,-5.566048e-05},{-2.249817e-04,-5.489551e-05},
 {-2.798773e-04,-5.402531e-05},{-3.339026e-04,-5.305222e-05},{-3.869548e-04,-5.197875e-05},{-4.389335e-04,-5.080760e-05},
 {-4.897411e-04,-4.954166e-05},{-5.392828e-04,-4.818399e-05},{-5.874668e-04,-4.673782e-05},{-6.342046e-04,-4.520651e-05},
 {-6.794111e-04,-4.359362e-05},{-7.230048e-04,-4.190282e-05},{-7.649076e-04,-4.013793e-05},{-8.050455e-04,-3.830288e-05},
 {-8.433484e-04,-3.640174e-05},{-8.797501e-04,-3.443868e-05},{-9.141888e-04,-3.241797e-05},{-9.466068e-04,-3.034397e-05},
 {-9.769508e-04,-2.822112e-05},{-1.005172e-03,-2.605395e-05},{-1.031226e-03,-2.384704e-05},{-1.055073e-03,-2.160502e-05},
 {-1.076678e-03,-1.933257e-05},{-1.096010e-03,-1.703441e-05},{-1.113045e-03,-1.471527e-05},{-1.127760e-03,-1.237992e-05},
 {-1.140140e-03,-1.003312e-05},{-1.150173e-03,-7.679625e-06},{-1.157853e-03,-5.324178e-06},{-1.163177e-03,-2.971503e-06},
 {-1.166148e-03,-6.262933e-07},{-1.166775e-03, 1.706803e-06},{-1.165068e-03, 4.023186e-06},{-1.161045e-03, 6.318316e-06},
 {-1.154726e-03, 8.587719e-06},{-1.146139e-03, 1.082700e-05},{-1.135312e-03, 1.303185e-05},{-1.122280e-03, 1.519804e-05},
 {-1.107082e-03, 1.732147e-05},{-1.089760e-03, 1.939813e-05},{-1.070362e-03, 2.142411e-05},{-1.048938e-03, 2.339566e-05},
 {-1.025542e-03, 2.530913e-05},{-1.000233e-03, 2.716103e-05},{-9.730723e-04, 2.894800e-05},{-9.441243e-04, 3.066681e-05},
 {-9.134575e-04, 3.231443e-05},{-8.811431e-04, 3.388796e-05},{-8.472551e-04, 3.538466e-05},{-8.118705e-04, 3.680198e-05},
 {-7.750685e-04, 3.813752e-05},{-7.369310e-04, 3.938908e-05},{-6.975419e-04, 4.055463e-05},{-6.569872e-04, 4.163233e-05},
 {-6.153549e-04, 4.262051e-05},{-5.727344e-04, 4.351770e-05},{-5.292167e-04, 4.432264e-05},{-4.848941e-04, 4.503422e-05},
 {-4.398598e-04, 4.565156e-05},{-3.942083e-04, 4.617396e-05},{-3.480343e-04, 4.660091e-05},{-3.014334e-04, 4.693210e-05},
 {-2.545013e-04, 4.716742e-05},{-2.073339e-04, 4.730694e-05},{-1.600270e-04, 4.735093e-05},{-1.126760e-04, 4.729985e-05},
 {-6.537619e-05, 4.715435e-05},{-1.822184e-05, 4.691525e-05},{ 2.869341e-05, 4.658358e-05},{ 7.527699e-05, 4.616053e-05},
 { 1.214375e-04, 4.564747e-05},{ 1.670850e-04, 4.504594e-05},{ 2.121309e-04, 4.435766e-05},{ 2.564886e-04, 4.358452e-05},
 { 3.000731e-04, 4.272854e-05},{ 3.428016e-04, 4.179192e-05},{ 3.845936e-04, 4.077700e-05},{ 4.253706e-04, 3.968626e-05},
 { 4.650568e-04, 3.852234e-05},{ 5.035792e-04, 3.728798e-05},{ 5.408671e-04, 3.598608e-05},{ 5.768532e-04, 3.461962e-05},
 { 6.114728e-04, 3.319173e-05},{ 6.446646e-04, 3.170562e-05},{ 6.763702e-04, 3.016461e-05},{ 7.065348e-04, 2.857211e-05},
 { 7.351069e-04, 2.693161e-05},{ 7.620385e-04, 2.524669e-05},{ 7.872852e-04, 2.352097e-05},{ 8.108062e-04, 2.175817e-05},
 { 8.325643e-04, 1.996202e-05},{ 8.525264e-04, 1.813634e-05},{ 8.706627e-04, 1.628496e-05},{ 8.869477e-04, 1.441174e-05},
 { 9.013594e-04, 1.252056e-05},{ 9.138800e-04, 1.061534e-05},{ 9.244953e-04, 8.699982e-06},{ 9.331953e-04, 6.778382e-06},
 { 9.399737e-04, 4.854441e-06},{ 9.448281e-04, 2.932035e-06},{ 9.477601e-04, 1.015016e-06},{ 9.487752e-04,-8.927963e-07},
 { 9.478824e-04,-2.787624e-06},{ 9.450947e-04,-4.665736e-06},{ 9.404290e-04,-6.523456e-06},{ 9.339055e-04,-8.357172e-06},
 { 9.255484e-04,-1.016334e-05},{ 9.153850e-04,-1.193849e-05},{ 9.034465e-04,-1.367924e-05},{ 8.897673e-04,-1.538228e-05},
 { 8.743850e-04,-1.704442e-05},{ 8.573406e-04,-1.866256e-05},{ 8.386780e-04,-2.023370e-05},{ 8.184443e-04,-2.175495e-05},
 { 7.966894e-04,-2.322355e-05},{ 7.734658e-04,-2.463686e-05},{ 7.488290e-04,-2.599235e-05},{ 7.228366e-04,-2.728765e-05},
 { 6.955490e-04,-2.852049e-05},{ 6.670285e-04,-2.968877e-05},{ 6.373397e-04,-3.079052e-05},{ 6.065492e-04,-3.182390e-05},
 { 5.747253e-04,-3.278724e-05},{ 5.419381e-04,-3.367902e-05},{ 5.082590e-04,-3.449786e-05},{ 4.737612e-04,-3.524253e-05},
 { 4.385186e-04,-3.591199e-05},{ 4.026067e-04,-3.650532e-05},{ 3.661013e-04,-3.702178e-05},{ 3.290796e-04,-3.746077e-05},
 { 2.916188e-04,-3.782188e-05},{ 2.537969e-04,-3.810483e-05},{ 2.156921e-04,-3.830951e-05},{ 1.773826e-04,-3.843598e-05},
 { 1.389466e-04,-3.848443e-05},{ 1.004621e-04,-3.845523e-05},{ 6.200692e-05,-3.834890e-05},{ 2.365801e-05,-3.816610e-05},
 {-1.450809e-05,-3.790766e-05},{-5.241575e-05,-3.757453e-05},{-8.999028e-05,-3.716783e-05},{-1.271581e-04,-3.668882e-05},
 {-1.638469e-04,-3.613888e-05},{-1.999858e-04,-3.551954e-05},{-2.355053e-04,-3.483246e-05},{-2.703378e-04,-3.407941e-05},
 {-3.044172e-04,-3.326232e-05},{-3.376795e-04,-3.238319e-05},{-3.700627e-04,-3.144418e-05},{-4.015069e-04,-3.044752e-05},
 {-4.319544e-04,-2.939556e-05},{-4.613500e-04,-2.829075e-05},{-4.896407e-04,-2.713563e-05},{-5.167764e-04,-2.593282e-05},
 {-5.427092e-04,-2.468502e-05},{-5.673942e-04,-2.339503e-05},{-5.907892e-04,-2.206569e-05},{-6.128549e-04,-2.069990e-05},
 {-6.335548e-04,-1.930065e-05},{-6.528555e-04,-1.787094e-05},{-6.707264e-04,-1.641384e-05},{-6.871402e-04,-1.493244e-05},
 {-7.020727e-04,-1.342989e-05},{-7.155026e-04,-1.190932e-05},{-7.274119e-04,-1.037392e-05},{-7.377858e-04,-8.826869e-06},
 {-7.466127e-04,-7.271349e-06},{-7.538840e-04,-5.710549e-06},{-7.595946e-04,-4.147648e-06},{-7.637422e-04,-2.585808e-06},
 {-7.663280e-04,-1.028172e-06},{-7.673562e-04, 5.221454e-07},{-7.668341e-04, 2.062061e-06},{-7.647720e-04, 3.588532e-06},
 {-7.611835e-04, 5.098561e-06},{-7.560849e-04, 6.589201e-06},{-7.494957e-04, 8.057562e-06},{-7.414381e-04, 9.500816e-06},
 {-7.319373e-04, 1.091620e-05},{-7.210211e-04, 1.230103e-05},{-7.087201e-04, 1.365270e-05},{-6.950674e-04, 1.496867e-05},
 {-6.800987e-04, 1.624650e-05},{-6.638522e-04, 1.748386e-05},{-6.463684e-04, 1.867847e-05},{-6.276899e-04, 1.982820e-05},
 {-6.078617e-04, 2.093098e-05},{-5.869307e-04, 2.198488e-05},{-5.649458e-04, 2.298806e-05},{-5.419578e-04, 2.393881e-05},
 {-5.180190e-04, 2.483551e-05},{-4.931835e-04, 2.567669e-05},{-4.675068e-04, 2.646098e-05},{-4.410458e-04, 2.718715e-05},
 {-4.138586e-04, 2.785407e-05},{-3.860046e-04, 2.846075e-05},{-3.575438e-04, 2.900634e-05},{-3.285375e-04, 2.949011e-05},
 {-2.990474e-04, 2.991144e-05},{-2.691359e-04, 3.026986e-05},{-2.388661e-04, 3.056504e-05},{-2.083010e-04, 3.079676e-05},
 {-1.775043e-04, 3.096492e-05},{-1.465393e-04, 3.106959e-05},{-1.154698e-04, 3.111093e-05},{-8.435883e-05, 3.108923e-05},
 {-5.326960e-05, 3.100493e-05},{-2.226466e-05, 3.085858e-05},{ 8.593913e-06, 3.065084e-05},{ 3.924475e-05, 3.038251e-05},
 { 6.962727e-05, 3.005450e-05},{ 9.968177e-05, 2.966784e-05},{ 1.293496e-04, 2.922365e-05},{ 1.585733e-04, 2.872319e-05},
 { 1.872964e-04, 2.816781e-05},{ 2.154643e-04, 2.755897e-05},{ 2.430232e-04, 2.689822e-05},{ 2.699214e-04, 2.618721e-05},
 { 2.961087e-04, 2.542769e-05},{ 3.215363e-04, 2.462148e-05},{ 3.461578e-04, 2.377051e-05},{ 3.699283e-04, 2.287676e-05},
 { 3.928051e-04, 2.194230e-05},{ 4.147474e-04, 2.096926e-05},{ 4.357167e-04, 1.995986e-05},{ 4.556765e-04, 1.891636e-05},
 { 4.745929e-04, 1.784106e-05},{ 4.924339e-04, 1.673635e-05},{ 5.091703e-04, 1.560463e-05},{ 5.247749e-04, 1.444836e-05},
 { 5.392233e-04, 1.327003e-05},{ 5.524933e-04, 1.207215e-05},{ 5.645654e-04, 1.085727e-05},{ 5.754227e-04, 9.627949e-06},
 { 5.850507e-04, 8.386764e-06},{ 5.934374e-04, 7.136298e-06},{ 6.005737e-04, 5.879138e-06},{ 6.064529e-04, 4.617868e-06},
 { 6.110707e-04, 3.355066e-06},{ 6.144258e-04, 2.093296e-06},{ 6.165191e-04, 8.351063e-07},{ 6.173542e-04,-4.169797e-07},
 { 6.169372e-04,-1.660465e-06},{ 6.152768e-04,-2.892886e-06},{ 6.123839e-04,-4.111816e-06},{ 6.082721e-04,-5.314870e-06},
 { 6.029572e-04,-6.499711e-06},{ 5.964575e-04,-7.664052e-06},{ 5.887934e-04,-8.805662e-06},{ 5.799878e-04,-9.922369e-06},
 { 5.700654e-04,-1.101207e-05},{ 5.590533e-04,-1.207271e-05},{ 5.469806e-04,-1.310234e-05},{ 5.338783e-04,-1.409906e-05},
 { 5.197792e-04,-1.506105e-05},{ 5.047182e-04,-1.598657e-05},{ 4.887316e-04,-1.687398e-05},{ 4.718576e-04,-1.772172e-05},
 { 4.541359e-04,-1.852832e-05},{ 4.356076e-04,-1.929238e-05},{ 4.163152e-04,-2.001264e-05},{ 3.963025e-04,-2.068790e-05},
 { 3.756146e-04,-2.131707e-05},{ 3.542976e-04,-2.189916e-05},{ 3.323984e-04,-2.243329e-05},{ 3.099651e-04,-2.291866e-05},
 { 2.870465e-04,-2.335460e-05},{ 2.636919e-04,-2.374054e-05},{ 2.399513e-04,-2.407599e-05},{ 2.158753e-04,-2.436059e-05},
 { 1.915147e-04,-2.459408e-05},{ 1.669207e-04,-2.477631e-05},{ 1.421444e-04,-2.490722e-05},{ 1.172371e-04,-2.498687e-05},
 { 9.225028e-05,-2.501541e-05},{ 6.723487e-05,-2.499310e-05},{ 4.224177e-05,-2.492031e-05},{ 1.732146e-05,-2.479750e-05},
 {-7.476042e-06,-2.462522e-05},{-3.210127e-05,-2.440415e-05},{-5.650541e-05,-2.413501e-05},{-8.064043e-05,-2.381868e-05},
 {-1.044591e-04,-2.345607e-05},{-1.279152e-04,-2.304821e-05},{-1.509634e-04,-2.259622e-05},{-1.735596e-04,-2.210128e-05},
 {-1.956609e-04,-2.156467e-05},{-2.172255e-04,-2.098773e-05},{-2.382133e-04,-2.037190e-05},{-2.585852e-04,-1.971865e-05},
 {-2.783038e-04,-1.902956e-05},{-2.973334e-04,-1.830624e-05},{-3.156396e-04,-1.755038e-05},{-3.331900e-04,-1.676371e-05},
 {-3.499537e-04,-1.594802e-05},{-3.659017e-04,-1.510516e-05},{-3.810069e-04,-1.423699e-05},{-3.952439e-04,-1.334545e-05},
 {-4.085893e-04,-1.243249e-05},{-4.210218e-04,-1.150010e-05},{-4.325219e-04,-1.055029e-05},{-4.430722e-04,-9.585098e-06},
 {-4.526573e-04,-8.606583e-06},{-4.612639e-04,-7.616815e-06},{-4.688807e-04,-6.617875e-06},{-4.754986e-04,-5.611849e-06},
 {-4.811104e-04,-4.600825e-06},{-4.857113e-04,-3.586887e-06},{-4.892981e-04,-2.572114e-06},{-4.918703e-04,-1.558572e-06},
 {-4.934288e-04,-5.483112e-07},{-4.939771e-04, 4.566357e-07},{-4.935205e-04, 1.454261e-06},{-4.920662e-04, 2.442584e-06},
 {-4.896237e-04, 3.419655e-06},{-4.862040e-04, 4.383561e-06},{-4.818204e-04, 5.332425e-06},{-4.764880e-04, 6.264415e-06},
 {-4.702236e-04, 7.177743e-06},{-4.630459e-04, 8.070671e-06},{-4.549752e-04, 8.941514e-06},{-4.460337e-04, 9.788640e-06},
 {-4.362450e-04, 1.061048e-05},{-4.256345e-04, 1.140552e-05},{-4.142290e-04, 1.217232e-05},{-4.020567e-04, 1.290949e-05},
 {-3.891472e-04, 1.361573e-05},{-3.755315e-04, 1.428979e-05},{-3.612417e-04, 1.493051e-05},{-3.463112e-04, 1.553679e-05},
 {-3.307744e-04, 1.610764e-05},{-3.146668e-04, 1.664209e-05},{-2.980247e-04, 1.713931e-05},{-2.808854e-04, 1.759852e-05},
 {-2.632868e-04, 1.801902e-05},{-2.452678e-04, 1.840021e-05},{-2.268676e-04, 1.874156e-05},{-2.081261e-04, 1.904263e-05},
 {-1.890834e-04, 1.930306e-05},{-1.697804e-04, 1.952259e-05},{-1.502578e-04, 1.970102e-05},{-1.305568e-04, 1.983826e-05},
 {-1.107185e-04, 1.993428e-05},{-9.078423e-05, 1.998917e-05},{-7.079505e-05, 2.000306e-05},{-5.079199e-05, 1.997620e-05},
 {-3.081579e-05, 1.990889e-05},{-1.090690e-05, 1.980154e-05},{ 8.894640e-06, 1.965461e-05},{ 2.854925e-05, 1.946866e-05},
 { 4.801791e-05, 1.924432e-05},{ 6.726223e-05, 1.898229e-05},{ 8.624451e-05, 1.868334e-05},{ 1.049279e-04, 1.834832e-05},
 { 1.232762e-04, 1.797815e-05},{ 1.412543e-04, 1.757379e-05},{ 1.588281e-04, 1.713631e-05},{ 1.759644e-04, 1.666679e-05},
 { 1.926312e-04, 1.616640e-05},{ 2.087976e-04, 1.563636e-05},{ 2.244340e-04, 1.507794e-05},{ 2.395119e-04, 1.449246e-05},
 { 2.540044e-04, 1.388128e-05},{ 2.678856e-04, 1.324581e-05},{ 2.811315e-04, 1.258751e-05},{ 2.937190e-04, 1.190787e-05},
 { 3.056268e-04, 1.120840e-05},{ 3.168352e-04, 1.049066e-05},{ 3.273259e-04, 9.756228e-06},{ 3.370821e-04, 9.006712e-06},
 { 3.460888e-04, 8.243734e-06},{ 3.543326e-04, 7.468937e-06},{ 3.618015e-04, 6.683976e-06},{ 3.684855e-04, 5.890517e-06},
 { 3.743760e-04, 5.090231e-06},{ 3.794662e-04, 4.284796e-06},{ 3.837510e-04, 3.475885e-06},{ 3.872269e-04, 2.665171e-06},
 { 3.898921e-04, 1.854319e-06},{ 3.917464e-04, 1.044982e-06},{ 3.927914e-04, 2.388016e-07},{ 3.930302e-04,-5.625989e-07},
 { 3.924676e-04,-1.357616e-06},{ 3.911100e-04,-2.144670e-06},{ 3.889653e-04,-2.922206e-06},{ 3.860431e-04,-3.688701e-06},
 { 3.823544e-04,-4.442662e-06},{ 3.779117e-04,-5.182633e-06},{ 3.727291e-04,-5.907195e-06},{ 3.668219e-04,-6.614970e-06},
 { 3.602069e-04,-7.304623e-06},{ 3.529023e-04,-7.974863e-06},{ 3.449274e-04,-8.624451e-06},{ 3.363030e-04,-9.252194e-06},
 { 3.270508e-04,-9.856953e-06},{ 3.171939e-04,-1.043764e-05},{ 3.067562e-04,-1.099324e-05},{ 2.957630e-04,-1.152276e-05},
 { 2.842402e-04,-1.202531e-05},{ 2.722149e-04,-1.250003e-05},{ 2.597149e-04,-1.294614e-05},{ 2.467687e-04,-1.336290e-05},
 { 2.334058e-04,-1.374966e-05},{ 2.196562e-04,-1.410583e-05},{ 2.055503e-04,-1.443088e-05},{ 1.911195e-04,-1.472435e-05},
 { 1.763951e-04,-1.498584e-05},{ 1.614093e-04,-1.521503e-05},{ 1.461942e-04,-1.541167e-05},{ 1.307826e-04,-1.557556e-05},
 { 1.152070e-04,-1.570658e-05},{ 9.950042e-05,-1.580469e-05},{ 8.369573e-05,-1.586990e-05},{ 6.782583e-05,-1.590228e-05},
 { 5.192355e-05,-1.590199e-05},{ 3.602156e-05,-1.586925e-05},{ 2.015231e-05,-1.580433e-05},{ 4.347984e-06,-1.570757e-05},
 {-1.135959e-05,-1.557939e-05},{-2.693898e-05,-1.542026e-05},{-4.235924e-05,-1.523069e-05},{-5.758993e-05,-1.501128e-05},
 {-7.260121e-05,-1.476267e-05},{-8.736388e-05,-1.448557e-05},{-1.018494e-04,-1.418072e-05},{-1.160302e-04,-1.384894e-05},
 {-1.298791e-04,-1.349108e-05},{-1.433702e-04,-1.310803e-05},{-1.564782e-04,-1.270076e-05},{-1.691790e-04,-1.227026e-05},
 {-1.814492e-04,-1.181755e-05},{-1.932668e-04,-1.134371e-05},{-2.046105e-04,-1.084985e-05},{-2.154603e-04,-1.033711e-05},
 {-2.257975e-04,-9.806666e-06},{-2.356041e-04,-9.259719e-06},{-2.448638e-04,-8.697496e-06},{-2.535613e-04,-8.121249e-06},
 {-2.616826e-04,-7.532250e-06},{-2.692148e-04,-6.931788e-06},{-2.761466e-04,-6.321168e-06},{-2.824678e-04,-5.701707e-06},
 {-2.881695e-04,-5.074731e-06},{-2.932442e-04,-4.441574e-06},{-2.976858e-04,-3.803571e-06},{-3.014894e-04,-3.162062e-06},
 {-3.046514e-04,-2.518382e-06},{-3.071698e-04,-1.873864e-06},{-3.090437e-04,-1.229833e-06},{-3.102735e-04,-5.876039e-07},
 {-3.108611e-04, 5.151975e-08},{-3.108096e-04, 6.862501e-07},{-3.101234e-04, 1.315317e-06},{-3.088080e-04, 1.937469e-06},
 {-3.068706e-04, 2.551478e-06},{-3.043191e-04, 3.156142e-06},{-3.011629e-04, 3.750283e-06},{-2.974127e-04, 4.332754e-06},
 {-2.930799e-04, 4.902442e-06},{-2.881775e-04, 5.458262e-06},{-2.827192e-04, 5.999170e-06},{-2.767200e-04, 6.524156e-06},
 {-2.701959e-04, 7.032251e-06},{-2.631636e-04, 7.522526e-06},{-2.556411e-04, 7.994097e-06},{-2.476470e-04, 8.446120e-06},
 {-2.392009e-04, 8.877802e-06},{-2.303231e-04, 9.288392e-06},{-2.210347e-04, 9.677190e-06},{-2.113575e-04, 1.004355e-05},
 {-2.013140e-04, 1.038686e-05},{-1.909271e-04, 1.070658e-05},{-1.802205e-04, 1.100220e-05},{-1.692183e-04, 1.127330e-05},
 {-1.579450e-04, 1.151946e-05},{-1.464256e-04, 1.174036e-05},{-1.346852e-04, 1.193572e-05},{-1.227495e-04, 1.210529e-05},
 {-1.106442e-04, 1.224892e-05},{-9.839528e-05, 1.236647e-05},{-8.602881e-05, 1.245788e-05},{-7.357093e-05, 1.252315e-05},
 {-6.104779e-05, 1.256230e-05},{-4.848549e-05, 1.257544e-05},{-3.591004e-05, 1.256272e-05},{-2.334732e-05, 1.252434e-05},
 {-1.082298e-05, 1.246054e-05},{ 1.637558e-06, 1.237163e-05},{ 1.400919e-05, 1.225796e-05},{ 2.626715e-05, 1.211993e-05},
 { 3.838708e-05, 1.195800e-05},{ 5.034508e-05, 1.177264e-05},{ 6.211772e-05, 1.156441e-05},{ 7.368213e-05, 1.133388e-05},
 { 8.501601e-05, 1.108167e-05},{ 9.609768e-05, 1.080846e-05},{ 1.069061e-04, 1.051494e-05},{ 1.174211e-04, 1.020186e-05},
 { 1.276229e-04, 9.869985e-06},{ 1.374929e-04, 9.520130e-06},{ 1.470131e-04, 9.153133e-06},{ 1.561662e-04, 8.769866e-06},
 { 1.649361e-04, 8.371225e-06},{ 1.733073e-04, 7.958133e-06},{ 1.812654e-04, 7.531538e-06},{ 1.887969e-04, 7.092406e-06},
 { 1.958894e-04, 6.641726e-06},{ 2.025311e-04, 6.180503e-06},{ 2.087116e-04, 5.709754e-06},{ 2.144213e-04, 5.230513e-06},
 { 2.196519e-04, 4.743823e-06},{ 2.243957e-04, 4.250733e-06},{ 2.286464e-04, 3.752302e-06},{ 2.323987e-04, 3.249590e-06},
 { 2.356483e-04, 2.743660e-06},{ 2.383920e-04, 2.235573e-06},{ 2.406275e-04, 1.726390e-06},{ 2.423539e-04, 1.217164e-06},
 { 2.435711e-04, 7.089439e-07},{ 2.442800e-04, 2.027666e-07},{ 2.444828e-04,-3.003403e-07},{ 2.441825e-04,-7.993630e-07},
 { 2.433831e-04,-1.293303e-06},{ 2.420898e-04,-1.781179e-06},{ 2.403086e-04,-2.262029e-06},{ 2.380466e-04,-2.734911e-06},
 { 2.353117e-04,-3.198907e-06},{ 2.321128e-04,-3.653124e-06},{ 2.284596e-04,-4.096693e-06},{ 2.243629e-04,-4.528775e-06},
 { 2.198342e-04,-4.948558e-06},{ 2.148856e-04,-5.355264e-06},{ 2.095304e-04,-5.748145e-06},{ 2.037822e-04,-6.126486e-06},
 { 1.976557e-04,-6.489610e-06},{ 1.911661e-04,-6.836871e-06},{ 1.843292e-04,-7.167666e-06},{ 1.771616e-04,-7.481424e-06},
 { 1.696801e-04,-7.777619e-06},{ 1.619025e-04,-8.055759e-06},{ 1.538468e-04,-8.315397e-06},{ 1.455314e-04,-8.556124e-06},
 { 1.369753e-04,-8.777576e-06},{ 1.281977e-04,-8.979428e-06},{ 1.192182e-04,-9.161400e-06},{ 1.100568e-04,-9.323254e-06},
 { 1.007336e-04,-9.464795e-06},{ 9.126880e-05,-9.585870e-06},{ 8.168293e-05,-9.686373e-06},{ 7.199655e-05,-9.766237e-06},
 { 6.223032e-05,-9.825440e-06},{ 5.240488e-05,-9.864004e-06},{ 4.254087e-05,-9.881990e-06},{ 3.265888e-05,-9.879504e-06},
 { 2.277938e-05,-9.856692e-06},{ 1.292269e-05,-9.813743e-06},{ 3.108943e-06,-9.750883e-06},{-6.641939e-06,-9.668380e-06},
 {-1.631032e-05,-9.566540e-06},{-2.587686e-05,-9.445707e-06},{-3.532257e-05,-9.306261e-06},{-4.462883e-05,-9.148620e-06},
 {-5.377745e-05,-8.973234e-06},{-6.275068e-05,-8.780587e-06},{-7.153127e-05,-8.571198e-06},{-8.010247e-05,-8.345614e-06},
 {-8.844808e-05,-8.104412e-06},{-9.655249e-05,-7.848200e-06},{-1.044007e-04,-7.577609e-06},{-1.119783e-04,-7.293298e-06},
 {-1.192716e-04,-6.995950e-06},{-1.262675e-04,-6.686268e-06},{-1.329538e-04,-6.364977e-06},{-1.393188e-04,-6.032821e-06},
 {-1.453516e-04,-5.690562e-06},{-1.510422e-04,-5.338977e-06},{-1.563812e-04,-4.978855e-06},{-1.613600e-04,-4.611001e-06},
 {-1.659710e-04,-4.236228e-06},{-1.702072e-04,-3.855357e-06},{-1.740626e-04,-3.469218e-06},{-1.775318e-04,-3.078645e-06},
 {-1.806105e-04,-2.684476e-06},{-1.832949e-04,-2.287551e-06},{-1.855825e-04,-1.888707e-06},{-1.874712e-04,-1.488783e-06},
 {-1.889600e-04,-1.088612e-06},{-1.900486e-04,-6.890235e-07},{-1.907376e-04,-2.908383e-07},{-1.910285e-04, 1.051303e-07},
 {-1.909233e-04, 4.980796e-07},{-1.904252e-04, 8.872185e-07},{-1.895380e-04, 1.271770e-06},{-1.882663e-04, 1.650970e-06},
 {-1.866153e-04, 2.024073e-06},{-1.845912e-04, 2.390351e-06},{-1.822009e-04, 2.749093e-06},{-1.794518e-04, 3.099612e-06},
 {-1.763522e-04, 3.441239e-06},{-1.729109e-04, 3.773332e-06},{-1.691376e-04, 4.095270e-06},{-1.650423e-04, 4.406458e-06},
 {-1.606359e-04, 4.706329e-06},{-1.559295e-04, 4.994342e-06},{-1.509352e-04, 5.269985e-06},{-1.456652e-04, 5.532774e-06},
 {-1.401324e-04, 5.782256e-06},{-1.343502e-04, 6.018009e-06},{-1.283322e-04, 6.239642e-06},{-1.220925e-04, 6.446795e-06},
 {-1.156457e-04, 6.639141e-06},{-1.090066e-04, 6.816388e-06},{-1.021902e-04, 6.978275e-06},{-9.521192e-05, 7.124575e-06},
 {-8.808734e-05, 7.255095e-06},{-8.083225e-05, 7.369678e-06},{-7.346257e-05, 7.468197e-06},{-6.599437e-05, 7.550563e-06},
 {-5.844381e-05, 7.616719e-06},{-5.082709e-05, 7.666643e-06},{-4.316045e-05, 7.700347e-06},{-3.546010e-05, 7.717876e-06},
 {-2.774223e-05, 7.719307e-06},{-2.002292e-05, 7.704753e-06},{-1.231816e-05, 7.674356e-06},{-4.643808e-06, 7.628293e-06},
 { 2.984484e-06, 7.566768e-06},{ 1.055125e-05, 7.490021e-06},{ 1.804127e-05, 7.398317e-06},{ 2.543959e-05, 7.291954e-06},
 { 3.273155e-05, 7.171256e-06},{ 3.990280e-05, 7.036575e-06},{ 4.693938e-05, 6.888290e-06},{ 5.382767e-05, 6.726805e-06},
 { 6.055447e-05, 6.552548e-06},{ 6.710702e-05, 6.365973e-06},{ 7.347299e-05, 6.167553e-06},{ 7.964055e-05, 5.957785e-06},
 { 8.559833e-05, 5.737185e-06},{ 9.133552e-05, 5.506288e-06},{ 9.684180e-05, 5.265645e-06},{ 1.021074e-04, 5.015826e-06},
 { 1.071233e-04, 4.757415e-06},{ 1.118807e-04, 4.491009e-06},{ 1.163717e-04, 4.217218e-06},{ 1.205889e-04, 3.936664e-06},
 { 1.245256e-04, 3.649976e-06},{ 1.281756e-04, 3.357794e-06},{ 1.315334e-04, 3.060764e-06},{ 1.345941e-04, 2.759537e-06},
 { 1.373537e-04, 2.454768e-06},{ 1.398084e-04, 2.147116e-06},{ 1.419555e-04, 1.837240e-06},{ 1.437928e-04, 1.525800e-06},
 { 1.453186e-04, 1.213454e-06},{ 1.465320e-04, 9.008569e-07},{ 1.474329e-04, 5.886601e-07},{ 1.480215e-04, 2.775092e-07},
 { 1.482991e-04,-3.195682e-08},{ 1.482671e-04,-3.391070e-07},{ 1.479280e-04,-6.433196e-07},{ 1.472847e-04,-9.439838e-07},
 { 1.463407e-04,-1.240500e-06},{ 1.451002e-04,-1.532282e-06},{ 1.435679e-04,-1.818757e-06},{ 1.417491e-04,-2.099367e-06},
 { 1.396498e-04,-2.373573e-06},{ 1.372762e-04,-2.640849e-06},{ 1.346354e-04,-2.900689e-06},{ 1.317347e-04,-3.152608e-06},
 { 1.285821e-04,-3.396138e-06},{ 1.251859e-04,-3.630833e-06},{ 1.215551e-04,-3.856269e-06},{ 1.176988e-04,-4.072043e-06},
 { 1.136268e-04,-4.277777e-06},{ 1.093490e-04,-4.473115e-06},{ 1.048759e-04,-4.657725e-06},{ 1.002182e-04,-4.831302e-06},
 { 9.538686e-05,-4.993563e-06},{ 9.039330e-05,-5.144253e-06},{ 8.524905e-05,-5.283141e-06},{ 7.996590e-05,-5.410024e-06},
 { 7.455588e-05,-5.524726e-06},{ 6.903115e-05,-5.627094e-06},{ 6.340406e-05,-5.717006e-06},{ 5.768705e-05,-5.794365e-06},
 { 5.189269e-05,-5.859101e-06},{ 4.603359e-05,-5.911169e-06},{ 4.012242e-05,-5.950554e-06},{ 3.417186e-05,-5.977267e-06},
 { 2.819460e-05,-5.991342e-06},{ 2.220325e-05,-5.992843e-06},{ 1.621041e-05,-5.981859e-06},{ 1.022855e-05,-5.958502e-06},
 { 4.270051e-06,-5.922911e-06},{-1.652860e-06,-5.875250e-06},{-7.528111e-06,-5.815706e-06},{-1.334382e-05,-5.744490e-06},
 {-1.908831e-05,-5.661834e-06},{-2.475014e-05,-5.567996e-06},{-3.031814e-05,-5.463251e-06},{-3.578139e-05,-5.347899e-06},
 {-4.112929e-05,-5.222256e-06},{-4.635154e-05,-5.086661e-06},{-5.143820e-05,-4.941468e-06},{-5.637967e-05,-4.787052e-06},
 {-6.116672e-05,-4.623800e-06},{-6.579052e-05,-4.452120e-06},{-7.024264e-05,-4.272430e-06},{-7.451507e-05,-4.085164e-06},
 {-7.860024e-05,-3.890768e-06},{-8.249101e-05,-3.689702e-06},{-8.618071e-05,-3.482432e-06},{-8.966314e-05,-3.269437e-06},
 {-9.293258e-05,-3.051205e-06},{-9.598378e-05,-2.828229e-06},{-9.881201e-05,-2.601010e-06},{-1.014130e-04,-2.370053e-06},
 {-1.037831e-04,-2.135868e-06},{-1.059189e-04,-1.898968e-06},{-1.078179e-04,-1.659869e-06},{-1.094778e-04,-1.419086e-06},
 {-1.108969e-04,-1.177134e-06},{-1.120740e-04,-9.345273e-07},{-1.130085e-04,-6.917787e-07},{-1.137003e-04,-4.493962e-07},
 {-1.141497e-04,-2.078838e-07},{-1.143576e-04, 3.225990e-08},{-1.143253e-04, 2.705429e-07},{-1.140548e-04, 5.064805e-07},
 {-1.135483e-04, 7.395967e-07},{-1.128087e-04, 9.694247e-07},{-1.118393e-04, 1.195508e-06},{-1.106438e-04, 1.417401e-06},
 {-1.092264e-04, 1.634671e-06},{-1.075917e-04, 1.846896e-06},{-1.057448e-04, 2.053672e-06},{-1.036911e-04, 2.254603e-06},
 {-1.014365e-04, 2.449315e-06},{-9.898721e-05, 2.637444e-06},{-9.634977e-05, 2.818646e-06},{-9.353112e-05, 2.992592e-06},
 {-9.053853e-05, 3.158972e-06},{-8.737956e-05, 3.317494e-06},{-8.406206e-05, 3.467884e-06},{-8.059418e-05, 3.609888e-06},
 {-7.698429e-05, 3.743269e-06},{-7.324102e-05, 3.867812e-06},{-6.937321e-05, 3.983323e-06},{-6.538989e-05, 4.089625e-06},
 {-6.130026e-05, 4.186565e-06},{-5.711370e-05, 4.274010e-06},{-5.283969e-05, 4.351845e-06},{-4.848784e-05, 4.419980e-06},
 {-4.406786e-05, 4.478344e-06},{-3.958952e-05, 4.526887e-06},{-3.506263e-05, 4.565581e-06},{-3.049705e-05, 4.594417e-06},
 {-2.590263e-05, 4.613409e-06},{-2.128922e-05, 4.622590e-06},{-1.666663e-05, 4.622014e-06},{-1.204462e-05, 4.611755e-06},
 {-7.432865e-06, 4.591906e-06},{-2.840959e-06, 4.562582e-06},{ 1.721623e-06, 4.523913e-06},{ 6.245536e-06, 4.476051e-06},
 { 1.072159e-05, 4.419166e-06},{ 1.514075e-05, 4.353444e-06},{ 1.949420e-05, 4.279089e-06},{ 2.377329e-05, 4.196322e-06},
 { 2.796961e-05, 4.105379e-06},{ 3.207499e-05, 4.006513e-06},{ 3.608150e-05, 3.899991e-06},{ 3.998149e-05, 3.786094e-06},
 { 4.376758e-05, 3.665116e-06},{ 4.743270e-05, 3.537365e-06},{ 5.097007e-05, 3.403161e-06},{ 5.437323e-05, 3.262832e-06},
 { 5.763606e-05, 3.116722e-06},{ 6.075278e-05, 2.965179e-06},{ 6.371796e-05, 2.808564e-06},{ 6.652652e-05, 2.647243e-06},
 { 6.917377e-05, 2.481593e-06},{ 7.165536e-05, 2.311992e-06},{ 7.396735e-05, 2.138829e-06},{ 7.610618e-05, 1.962493e-06},
 { 7.806867e-05, 1.783381e-06},{ 7.985206e-05, 1.601889e-06},{ 8.145394e-05, 1.418418e-06},{ 8.287236e-05, 1.233369e-06},
 { 8.410573e-05, 1.047143e-06},{ 8.515288e-05, 8.601409e-07},{ 8.601302e-05, 6.727625e-07},{ 8.668578e-05, 4.854051e-07},
 { 8.717118e-05, 2.984633e-07},{ 8.746965e-05, 1.123275e-07},{ 8.758197e-05,-7.261613e-08},{ 8.750936e-05,-2.559870e-07},
 { 8.725337e-05,-4.374107e-07},{ 8.681596e-05,-6.165195e-07},{ 8.619944e-05,-7.929535e-07},{ 8.540649e-05,-9.663611e-07},
 { 8.444013e-05,-1.136400e-06},{ 8.330373e-05,-1.302736e-06},{ 8.200099e-05,-1.465047e-06},{ 8.053594e-05,-1.623022e-06},
 { 7.891292e-05,-1.776361e-06},{ 7.713656e-05,-1.924774e-06},{ 7.521179e-05,-2.067986e-06},{ 7.314380e-05,-2.205734e-06},
 { 7.093807e-05,-2.337770e-06},{ 6.860030e-05,-2.463857e-06},{ 6.613644e-05,-2.583776e-06},{ 6.355267e-05,-2.697319e-06},
 { 6.085535e-05,-2.804296e-06},{ 5.805105e-05,-2.904531e-06},{ 5.514652e-05,-2.997862e-06},{ 5.214866e-05,-3.084147e-06},
 { 4.906451e-05,-3.163255e-06},{ 4.590125e-05,-3.235075e-06},{ 4.266618e-05,-3.299511e-06},{ 3.936667e-05,-3.356482e-06},
 { 3.601019e-05,-3.405925e-06},{ 3.260426e-05,-3.447794e-06},{ 2.915647e-05,-3.482056e-06},{ 2.567441e-05,-3.508699e-06},
 { 2.216571e-05,-3.527724e-06},{ 1.863799e-05,-3.539148e-06},{ 1.509884e-05,-3.543006e-06},{ 1.155583e-05,-3.539348e-06},
 { 8.016485e-06,-3.528238e-06},{ 4.488247e-06,-3.509758e-06},{ 9.784887e-07,-3.484003e-06},{-2.505514e-06,-3.451083e-06},
 {-5.956597e-06,-3.411122e-06},{-9.367719e-06,-3.364260e-06},{-1.273198e-05,-3.310648e-06},{-1.604263e-05,-3.250451e-06},
 {-1.929308e-05,-3.183849e-06},{-2.247693e-05,-3.111030e-06},{-2.558796e-05,-3.032197e-06},{-2.862015e-05,-2.947564e-06},
 {-3.156772e-05,-2.857354e-06},{-3.442507e-05,-2.761800e-06},{-3.718687e-05,-2.661148e-06},{-3.984802e-05,-2.555649e-06},
 {-4.240367e-05,-2.445565e-06},{-4.484923e-05,-2.331164e-06},{-4.718040e-05,-2.212722e-06},{-4.939312e-05,-2.090521e-06},
 {-5.148364e-05,-1.964851e-06},{-5.344849e-05,-1.836003e-06},{-5.528449e-05,-1.704276e-06},{-5.698877e-05,-1.569972e-06},
 {-5.855874e-05,-1.433396e-06},{-5.999214e-05,-1.294855e-06},{-6.128699e-05,-1.154659e-06},{-6.244165e-05,-1.013118e-06},
 {-6.345477e-05,-8.705428e-07},{-6.432531e-05,-7.272447e-07},{-6.505256e-05,-5.835336e-07},{-6.563609e-05,-4.397180e-07},
 {-6.607581e-05,-2.961044e-07},{-6.637191e-05,-1.529963e-07},{-6.652491e-05,-1.069413e-08},{-6.653560e-05, 1.305059e-07},
 {-6.640510e-05, 2.703122e-07},{-6.613479e-05, 4.084382e-07},{-6.572635e-05, 5.446032e-07},{-6.518175e-05, 6.785328e-07},
 {-6.450321e-05, 8.099595e-07},{-6.369325e-05, 9.386229e-07},{-6.275463e-05, 1.064271e-06},{-6.169036e-05, 1.186660e-06},
 {-6.050370e-05, 1.305554e-06},{-5.919815e-05, 1.420727e-06},{-5.777742e-05, 1.531964e-06},{-5.624546e-05, 1.639057e-06},
 {-5.460640e-05, 1.741812e-06},{-5.286459e-05, 1.840043e-06},{-5.102454e-05, 1.933577e-06},{-4.909097e-05, 2.022249e-06},
 {-4.706872e-05, 2.105911e-06},{-4.496280e-05, 2.184421e-06},{-4.277838e-05, 2.257654e-06},{-4.052073e-05, 2.325494e-06},
 {-3.819524e-05, 2.387839e-06},{-3.580740e-05, 2.444599e-06},{-3.336280e-05, 2.495696e-06},{-3.086710e-05, 2.541066e-06},
 {-2.832603e-05, 2.580657e-06},{-2.574538e-05, 2.614430e-06},{-2.313095e-05, 2.642358e-06},{-2.048859e-05, 2.664427e-06},
 {-1.782416e-05, 2.680637e-06},{-1.514353e-05, 2.690999e-06},{-1.245253e-05, 2.695536e-06},{-9.756991e-06, 2.694284e-06},
 {-7.062707e-06, 2.687293e-06},{-4.375414e-06, 2.674621e-06},{-1.700793e-06, 2.656341e-06},{ 9.555488e-07, 2.632537e-06},
 { 3.588085e-06, 2.603301e-06},{ 6.191386e-06, 2.568740e-06},{ 8.760126e-06, 2.528970e-06},{ 1.128910e-05, 2.484116e-06},
 { 1.377321e-05, 2.434315e-06},{ 1.620753e-05, 2.379713e-06},{ 1.858724e-05, 2.320464e-06},{ 2.090770e-05, 2.256731e-06},
 { 2.316443e-05, 2.188687e-06},{ 2.535312e-05, 2.116511e-06},{ 2.746963e-05, 2.040391e-06},{ 2.951002e-05, 1.960521e-06},
 { 3.147054e-05, 1.877101e-06},{ 3.334765e-05, 1.790339e-06},{ 3.513799e-05, 1.700447e-06},{ 3.683843e-05, 1.607643e-06},
 { 3.844608e-05, 1.512147e-06},{ 3.995822e-05, 1.414188e-06},{ 4.137241e-05, 1.313993e-06},{ 4.268640e-05, 1.211797e-06},
 { 4.389820e-05, 1.107833e-06},{ 4.500603e-05, 1.002340e-06},{ 4.600837e-05, 8.955554e-07},{ 4.690393e-05, 7.877189e-07},
 { 4.769165e-05, 6.790706e-07},{ 4.837072e-05, 5.698500e-07},{ 4.894057e-05, 4.602963e-07},{ 4.940086e-05, 3.506475e-07},
 { 4.975151e-05, 2.411399e-07},{ 4.999265e-05, 1.320077e-07},{ 5.012466e-05, 2.348243e-08},{ 5.014814e-05,-8.420753e-08},
 { 5.006393e-05,-1.908373e-07},{ 4.987310e-05,-2.961861e-07},{ 4.957691e-05,-4.000376e-07},{ 4.917687e-05,-5.021804e-07},
 { 4.867469e-05,-6.024083e-07},{ 4.807229e-05,-7.005212e-07},{ 4.737176e-05,-7.963247e-07},{ 4.657544e-05,-8.896311e-07},
 { 4.568581e-05,-9.802596e-07},{ 4.470555e-05,-1.068036e-06},{ 4.363751e-05,-1.152796e-06},{ 4.248472e-05,-1.234379e-06},
 { 4.125034e-05,-1.312635e-06},{ 3.993770e-05,-1.387423e-06},{ 3.855028e-05,-1.458610e-06},{ 3.709167e-05,-1.526071e-06},
 { 3.556560e-05,-1.589690e-06},{ 3.397591e-05,-1.649361e-06},{ 3.232655e-05,-1.704987e-06},{ 3.062156e-05,-1.756481e-06},
 { 2.886508e-05,-1.803765e-06},{ 2.706132e-05,-1.846771e-06},{ 2.521454e-05,-1.885441e-06},{ 2.332910e-05,-1.919725e-06},
 { 2.140938e-05,-1.949586e-06},{ 1.945979e-05,-1.974995e-06},{ 1.748480e-05,-1.995933e-06},{ 1.548886e-05,-2.012390e-06},
 { 1.347647e-05,-2.024368e-06},{ 1.145211e-05,-2.031877e-06},{ 9.420229e-06,-2.034936e-06},{ 7.385293e-06,-2.033576e-06},
 { 5.351717e-06,-2.027834e-06},{ 3.323883e-06,-2.017760e-06},{ 1.306124e-06,-2.003409e-06},{-6.972851e-07,-1.984848e-06},
 {-2.682133e-06,-1.962151e-06},{-4.644283e-06,-1.935400e-06},{-6.579684e-06,-1.904688e-06},{-8.484372e-06,-1.870111e-06},
 {-1.035448e-05,-1.831778e-06},{-1.218626e-05,-1.789801e-06},{-1.397606e-05,-1.744300e-06},{-1.572036e-05,-1.695405e-06},
 {-1.741577e-05,-1.643247e-06},{-1.905901e-05,-1.587967e-06},{-2.064698e-05,-1.529709e-06},{-2.217669e-05,-1.468626e-06},
 {-2.364532e-05,-1.404872e-06},{-2.505019e-05,-1.338608e-06},{-2.638880e-05,-1.269997e-06},{-2.765879e-05,-1.199209e-06},
 {-2.885800e-05,-1.126414e-06},{-2.998442e-05,-1.051787e-06},{-3.103620e-05,-9.755054e-07},{-3.201171e-05,-8.977483e-07},
 {-3.290946e-05,-8.186968e-07},{-3.372815e-05,-7.385334e-07},{-3.446669e-05,-6.574414e-07},{-3.512413e-05,-5.756048e-07},
 {-3.569973e-05,-4.932077e-07},{-3.619294e-05,-4.104340e-07},{-3.660337e-05,-3.274668e-07},{-3.693084e-05,-2.444885e-07},
 {-3.717533e-05,-1.616795e-07},{-3.733701e-05,-7.921898e-08},{-3.741623e-05, 2.716490e-09},{-3.741351e-05, 8.395274e-08},
 {-3.732956e-05, 1.643185e-07},{-3.716524e-05, 2.436459e-07},{-3.692159e-05, 3.217706e-07},{-3.659982e-05, 3.985322e-07},
 {-3.620129e-05, 4.737745e-07},{-3.572752e-05, 5.473460e-07},{-3.518017e-05, 6.191001e-07},{-3.456107e-05, 6.888953e-07},
 {-3.387218e-05, 7.565953e-07},{-3.311558e-05, 8.220699e-07},{-3.229351e-05, 8.851944e-07},{-3.140832e-05, 9.458506e-07},
 {-3.046247e-05, 1.003926e-06},{-2.945854e-05, 1.059316e-06},{-2.839922e-05, 1.111922e-06},{-2.728730e-05, 1.161651e-06},
 {-2.612565e-05, 1.208418e-06},{-2.491723e-05, 1.252147e-06},{-2.366508e-05, 1.292767e-06},{-2.237232e-05, 1.330214e-06},
 {-2.104210e-05, 1.364434e-06},{-1.967767e-05, 1.395378e-06},{-1.828229e-05, 1.423006e-06},{-1.685928e-05, 1.447285e-06},
 {-1.541200e-05, 1.468190e-06},{-1.394381e-05, 1.485704e-06},{-1.245810e-05, 1.499815e-06},{-1.095829e-05, 1.510522e-06},
 {-9.447767e-06, 1.517830e-06},{-7.929937e-06, 1.521751e-06},{-6.408186e-06, 1.522305e-06},{-4.885881e-06, 1.519519e-06},
 {-3.366362e-06, 1.513427e-06},{-1.852935e-06, 1.504071e-06},{-3.488640e-07, 1.491497e-06},{ 1.142633e-06, 1.475762e-06},
 { 2.618395e-06, 1.456925e-06},{ 4.075320e-06, 1.435055e-06},{ 5.510374e-06, 1.410224e-06},{ 6.920598e-06, 1.382513e-06},
 { 8.303112e-06, 1.352007e-06},{ 9.655119e-06, 1.318797e-06},{ 1.097392e-05, 1.282977e-06},{ 1.225689e-05, 1.244650e-06},
 { 1.350154e-05, 1.203920e-06},{ 1.470546e-05, 1.160898e-06},{ 1.586636e-05, 1.115697e-06},{ 1.698206e-05, 1.068436e-06},
 { 1.805049e-05, 1.019236e-06},{ 1.906973e-05, 9.682225e-07},{ 2.003795e-05, 9.155226e-07},{ 2.095347e-05, 8.612671e-07},
 { 2.181474e-05, 8.055887e-07},{ 2.262033e-05, 7.486224e-07},{ 2.336895e-05, 6.905049e-07},{ 2.405946e-05, 6.313741e-07},
 { 2.469083e-05, 5.713691e-07},{ 2.526220e-05, 5.106301e-07},{ 2.577283e-05, 4.492972e-07},{ 2.622213e-05, 3.875111e-07},
 { 2.660964e-05, 3.254122e-07},{ 2.693505e-05, 2.631405e-07},{ 2.719819e-05, 2.008350e-07},{ 2.739903e-05, 1.386338e-07},
 { 2.753766e-05, 7.667374e-08},{ 2.761433e-05, 1.508975e-08},{ 2.762942e-05,-4.598505e-08},{ 2.758344e-05,-1.064198e-07},
 { 2.747702e-05,-1.660861e-07},{ 2.731093e-05,-2.248584e-07},{ 2.708607e-05,-2.826142e-07},{ 2.680346e-05,-3.392341e-07},
 { 2.646423e-05,-3.946024e-07},{ 2.606962e-05,-4.486071e-07},{ 2.562102e-05,-5.011400e-07},{ 2.511988e-05,-5.520972e-07},
 { 2.456778e-05,-6.013793e-07},{ 2.396640e-05,-6.488912e-07},{ 2.331751e-05,-6.945427e-07},{ 2.262297e-05,-7.382484e-07},
 { 2.188472e-05,-7.799280e-07},{ 2.110479e-05,-8.195063e-07},{ 2.028528e-05,-8.569134e-07},{ 1.942837e-05,-8.920850e-07},
 { 1.853628e-05,-9.249622e-07},{ 1.761132e-05,-9.554915e-07},{ 1.665583e-05,-9.836254e-07},{ 1.567221e-05,-1.009322e-06},
 { 1.466288e-05,-1.032545e-06},{ 1.363034e-05,-1.053265e-06},{ 1.257707e-05,-1.071456e-06},{ 1.150562e-05,-1.087100e-06},
 { 1.041852e-05,-1.100185e-06},{ 9.318333e-06,-1.110704e-06},{ 8.207629e-06,-1.118654e-06},{ 7.088974e-06,-1.124042e-06},
 { 5.964932e-06,-1.126877e-06},{ 4.838055e-06,-1.127175e-06},{ 3.710880e-06,-1.124958e-06},{ 2.585923e-06,-1.120251e-06},
 { 1.465671e-06,-1.113089e-06},{ 3.525822e-07,-1.103507e-06},{-7.509253e-07,-1.091550e-06},{-1.842475e-06,-1.077263e-06},
 {-2.919738e-06,-1.060699e-06},{-3.980437e-06,-1.041916e-06},{-5.022353e-06,-1.020975e-06},{-6.043328e-06,-9.979411e-07},
 {-7.041269e-06,-9.728848e-07},{-8.014154e-06,-9.458799e-07},{-8.960034e-06,-9.170039e-07},{-9.877038e-06,-8.863380e-07},
 {-1.076338e-05,-8.539666e-07},{-1.161734e-05,-8.199774e-07},{-1.243732e-05,-7.844608e-07},{-1.322178e-05,-7.475100e-07},
 {-1.396929e-05,-7.092205e-07},{-1.467851e-05,-6.696902e-07},{-1.534820e-05,-6.290187e-07},{-1.597722e-05,-5.873075e-07},
 {-1.656453e-05,-5.446595e-07},{-1.710919e-05,-5.011789e-07},{-1.761037e-05,-4.569709e-07},{-1.806734e-05,-4.121412e-07},
 {-1.847948e-05,-3.667964e-07},{-1.884627e-05,-3.210429e-07},{-1.916732e-05,-2.749876e-07},{-1.944230e-05,-2.287367e-07},
 {-1.967104e-05,-1.823963e-07},{-1.985344e-05,-1.360716e-07},{-1.998951e-05,-8.986686e-08},{-2.007938e-05,-4.388528e-08},
 {-2.012326e-05, 1.771394e-09},{-2.012149e-05, 4.700301e-08},{-2.007449e-05, 9.171124e-08},{-1.998278e-05, 1.357998e-07},
 {-1.984698e-05, 1.791745e-07},{-1.966780e-05, 2.217439e-07},{-1.944606e-05, 2.634188e-07},{-1.918264e-05, 3.041130e-07},
 {-1.887853e-05, 3.437431e-07},{-1.853478e-05, 3.822291e-07},{-1.815255e-05, 4.194941e-07},{-1.773306e-05, 4.554645e-07},
 {-1.727760e-05, 4.900706e-07},{-1.678752e-05, 5.232461e-07},{-1.626428e-05, 5.549286e-07},{-1.570935e-05, 5.850598e-07},
 {-1.512429e-05, 6.135852e-07},{-1.451070e-05, 6.404545e-07},{-1.387025e-05, 6.656216e-07},{-1.320463e-05, 6.890447e-07},
 {-1.251558e-05, 7.106863e-07},{-1.180490e-05, 7.305133e-07},{-1.107438e-05, 7.484970e-07},{-1.032589e-05, 7.646130e-07},
 {-9.561274e-06, 7.788417e-07},{-8.782433e-06, 7.911677e-07},{-7.991265e-06, 8.015802e-07},{-7.189685e-06, 8.100727e-07},
 {-6.379612e-06, 8.166433e-07},{-5.562969e-06, 8.212944e-07},{-4.741674e-06, 8.240330e-07},{-3.917641e-06, 8.248700e-07},
 {-3.092771e-06, 8.238208e-07},{-2.268951e-06, 8.209051e-07},{-1.448046e-06, 8.161463e-07},{-6.318993e-07, 8.095722e-07},
 { 1.776729e-07, 8.012143e-07},{ 9.788872e-07, 7.911079e-07},{ 1.769995e-06, 7.792922e-07},{ 2.549287e-06, 7.658096e-07},
 { 3.315097e-06, 7.507064e-07},{ 4.065803e-06, 7.340318e-07},{ 4.799835e-06, 7.158385e-07},{ 5.515674e-06, 6.961819e-07},
 { 6.211856e-06, 6.751206e-07},{ 6.886976e-06, 6.527157e-07},{ 7.539692e-06, 6.290308e-07},{ 8.168723e-06, 6.041321e-07},
 { 8.772855e-06, 5.780879e-07},{ 9.350943e-06, 5.509684e-07},{ 9.901911e-06, 5.228458e-07},{ 1.042476e-05, 4.937940e-07},
 { 1.091855e-05, 4.638884e-07},{ 1.138244e-05, 4.332054e-07},{ 1.181564e-05, 4.018229e-07},{ 1.221747e-05, 3.698196e-07},
 { 1.258729e-05, 3.372748e-07},{ 1.292456e-05, 3.042685e-07},{ 1.322883e-05, 2.708810e-07},{ 1.349971e-05, 2.371928e-07},
 { 1.373690e-05, 2.032843e-07},{ 1.394019e-05, 1.692359e-07},{ 1.410942e-05, 1.351272e-07},{ 1.424455e-05, 1.010377e-07},
 { 1.434559e-05, 6.704592e-08},{ 1.441264e-05, 3.322942e-08},{ 1.444586e-05,-3.352463e-10},{ 1.444553e-05,-3.357283e-08},
 { 1.441196e-05,-6.640951e-08},{ 1.434555e-05,-9.877303e-08},{ 1.424677e-05,-1.305929e-07},{ 1.411618e-05,-1.618005e-07},
 { 1.395438e-05,-1.923293e-07},{ 1.376205e-05,-2.221148e-07},{ 1.353994e-05,-2.510951e-07},{ 1.328884e-05,-2.792103e-07},
 { 1.300963e-05,-3.064034e-07},{ 1.270323e-05,-3.326199e-07},{ 1.237061e-05,-3.578081e-07},{ 1.201280e-05,-3.819191e-07},
 { 1.163088e-05,-4.049071e-07},{ 1.122597e-05,-4.267291e-07},{ 1.079924e-05,-4.473454e-07},{ 1.035190e-05,-4.667193e-07},
 { 9.885180e-06,-4.848175e-07},{ 9.400363e-06,-5.016098e-07},{ 8.898753e-06,-5.170695e-07},{ 8.381683e-06,-5.311732e-07},
 { 7.850510e-06,-5.439006e-07},{ 7.306609e-06,-5.552353e-07},{ 6.751374e-06,-5.651639e-07},{ 6.186210e-06,-5.736766e-07},
 { 5.612534e-06,-5.807670e-07},{ 5.031767e-06,-5.864319e-07},{ 4.445335e-06,-5.906717e-07},{ 3.854663e-06,-5.934900e-07},
 { 3.261173e-06,-5.948938e-07},{ 2.666279e-06,-5.948933e-07},{ 2.071386e-06,-5.935019e-07},{ 1.477884e-06,-5.907361e-07},
 { 8.871480e-07,-5.866155e-07},{ 3.005325e-07,-5.811627e-07},{-2.806302e-07,-5.744034e-07},{-8.550335e-07,-5.663658e-07},
 {-1.421399e-06,-5.570812e-07},{-1.978481e-06,-5.465833e-07},{-2.525064e-06,-5.349084e-07},{-3.059972e-06,-5.220954e-07},
 {-3.582068e-06,-5.081853e-07},{-4.090253e-06,-4.932215e-07},{-4.583474e-06,-4.772494e-07},{-5.060724e-06,-4.603163e-07},
 {-5.521040e-06,-4.424715e-07},{-5.963512e-06,-4.237659e-07},{-6.387278e-06,-4.042519e-07},{-6.791529e-06,-3.839835e-07},
 {-7.175513e-06,-3.630158e-07},{-7.538529e-06,-3.414053e-07},{-7.879934e-06,-3.192092e-07},{-8.199143e-06,-2.964857e-07},
 {-8.495629e-06,-2.732939e-07},{-8.768923e-06,-2.496931e-07},{-9.018616e-06,-2.257433e-07},{-9.244359e-06,-2.015047e-07},
 {-9.445864e-06,-1.770375e-07},{-9.622901e-06,-1.524022e-07},{-9.775304e-06,-1.276588e-07},{-9.902962e-06,-1.028671e-07},
 {-1.000583e-05,-7.808670e-08},{-1.008392e-05,-5.337628e-08},{-1.013729e-05,-2.879401e-08},{-1.016609e-05,-4.397160e-09},
 {-1.017048e-05, 1.975797e-08},{-1.015073e-05, 4.361618e-08},{-1.010711e-05, 6.712349e-08},{-1.003999e-05, 9.022726e-08},
 {-9.949759e-06, 1.128763e-07},{-9.836882e-06, 1.350210e-07},{-9.701861e-06, 1.566135e-07},{-9.545248e-06, 1.776074e-07},
 {-9.367640e-06, 1.979586e-07},{-9.169682e-06, 2.176247e-07},{-8.952057e-06, 2.365654e-07},{-8.715492e-06, 2.547425e-07},
 {-8.460749e-06, 2.721199e-07},{-8.188629e-06, 2.886640e-07},{-7.899965e-06, 3.043433e-07},{-7.595622e-06, 3.191288e-07},
 {-7.276493e-06, 3.329939e-07},{-6.943499e-06, 3.459143e-07},{-6.597585e-06, 3.578685e-07},{-6.239716e-06, 3.688374e-07},
 {-5.870879e-06, 3.788043e-07},{-5.492075e-06, 3.877554e-07},{-5.104319e-06, 3.956792e-07},{-4.708640e-06, 4.025669e-07},
 {-4.306073e-06, 4.084123e-07},{-3.897661e-06, 4.132118e-07},{-3.484449e-06, 4.169643e-07},{-3.067485e-06, 4.196712e-07},
 {-2.647814e-06, 4.213367e-07},{-2.226477e-06, 4.219671e-07},{-1.804510e-06, 4.215715e-07},{-1.382938e-06, 4.201611e-07},
 {-9.627773e-07, 4.177496e-07},{-5.450276e-07, 4.143531e-07},{-1.306745e-07, 4.099898e-07},{ 2.793154e-07, 4.046801e-07},
 { 6.839955e-07, 3.984466e-07},{ 1.082442e-06, 3.913138e-07},{ 1.473756e-06, 3.833081e-07},{ 1.857064e-06, 3.744582e-07},
 { 2.231522e-06, 3.647940e-07},{ 2.596316e-06, 3.543475e-07},{ 2.950664e-06, 3.431522e-07},{ 3.293816e-06, 3.312431e-07},
 { 3.625059e-06, 3.186566e-07},{ 3.943716e-06, 3.054305e-07},{ 4.249146e-06, 2.916035e-07},{ 4.540750e-06, 2.772159e-07},
 { 4.817966e-06, 2.623085e-07},{ 5.080274e-06, 2.469232e-07},{ 5.327197e-06, 2.311028e-07},{ 5.558300e-06, 2.148905e-07},
 { 5.773191e-06, 1.983301e-07},{ 5.971521e-06, 1.814660e-07},{ 6.152987e-06, 1.643428e-07},{ 6.317329e-06, 1.470051e-07},
 { 6.464335e-06, 1.294980e-07},{ 6.593833e-06, 1.118663e-07},{ 6.705699e-06, 9.415474e-08},{ 6.799854e-06, 7.640778e-08},
 { 6.876261e-06, 5.866958e-08},{ 6.934931e-06, 4.098385e-08},{ 6.975915e-06, 2.339372e-08},{ 6.999309e-06, 5.941669e-09},
 { 7.005250e-06,-1.133059e-08},{ 6.993920e-06,-2.838220e-08},{ 6.965537e-06,-4.517325e-08},{ 6.920364e-06,-6.166488e-08},
 { 6.858699e-06,-7.781936e-08},{ 6.780880e-06,-9.360015e-08},{ 6.687280e-06,-1.089720e-07},{ 6.578308e-06,-1.239011e-07},
 { 6.454407e-06,-1.383549e-07},{ 6.316052e-06,-1.523026e-07},{ 6.163749e-06,-1.657148e-07},{ 5.998034e-06,-1.785637e-07},
 { 5.819471e-06,-1.908233e-07},{ 5.628647e-06,-2.024694e-07},{ 5.426178e-06,-2.134793e-07},{ 5.212699e-06,-2.238323e-07},
 { 4.988866e-06,-2.335096e-07},{ 4.755357e-06,-2.424942e-07},{ 4.512863e-06,-2.507709e-07},{ 4.262092e-06,-2.583267e-07},
 { 4.003765e-06,-2.651504e-07},{ 3.738615e-06,-2.712326e-07},{ 3.467382e-06,-2.765660e-07},{ 3.190816e-06,-2.811454e-07},
 { 2.909671e-06,-2.849674e-07},{ 2.624703e-06,-2.880304e-07},{ 2.336673e-06,-2.903350e-07},{ 2.046338e-06,-2.918836e-07},
 { 1.754454e-06,-2.926805e-07},{ 1.461774e-06,-2.927319e-07},{ 1.169042e-06,-2.920456e-07},{ 8.769963e-07,-2.906314e-07},
 { 5.863649e-07,-2.885009e-07},{ 2.978639e-07,-2.856673e-07},{ 1.219662e-08,-2.821454e-07},{-2.699488e-07,-2.779516e-07},
 {-5.479004e-07,-2.731040e-07},{-8.210044e-07,-2.676220e-07},{-1.088626e-06,-2.615265e-07},{-1.350153e-06,-2.548397e-07},
 {-1.604993e-06,-2.475852e-07},{-1.852578e-06,-2.397876e-07},{-2.092365e-06,-2.314728e-07},{-2.323838e-06,-2.226678e-07},
 {-2.546506e-06,-2.134004e-07},{-2.759906e-06,-2.036994e-07},{-2.963606e-06,-1.935944e-07},{-3.157200e-06,-1.831158e-07},
 {-3.340316e-06,-1.722945e-07},{-3.512610e-06,-1.611622e-07},{-3.673773e-06,-1.497507e-07},{-3.823523e-06,-1.380926e-07},
 {-3.961616e-06,-1.262204e-07},{-4.087836e-06,-1.141673e-07},{-4.202004e-06,-1.019661e-07},{-4.303970e-06,-8.964995e-08},
 {-4.393620e-06,-7.725195e-08},{-4.470872e-06,-6.480497e-08},{-4.535677e-06,-5.234172e-08},{-4.588018e-06,-3.989459e-08},
 {-4.627913e-06,-2.749559e-08},{-4.655408e-06,-1.517628e-08},{-4.670585e-06,-2.967692e-09},{-4.673552e-06, 9.099770e-09},
 {-4.664453e-06, 2.099638e-08},{-4.643456e-06, 3.269317e-08},{-4.610763e-06, 4.416201e-08},{-4.566601e-06, 5.537563e-08},
 {-4.511225e-06, 6.630774e-08},{-4.444918e-06, 7.693306e-08},{-4.367985e-06, 8.722737e-08},{-4.280757e-06, 9.716759e-08},
 {-4.183590e-06, 1.067318e-07},{-4.076858e-06, 1.158993e-07},{-3.960959e-06, 1.246507e-07},{-3.836308e-06, 1.329678e-07},
 {-3.703340e-06, 1.408338e-07},{-3.562506e-06, 1.482333e-07},{-3.414273e-06, 1.551523e-07},{-3.259121e-06, 1.615781e-07},
 {-3.097543e-06, 1.674996e-07},{-2.930043e-06, 1.729071e-07},{-2.757136e-06, 1.777922e-07},{-2.579344e-06, 1.821481e-07},
 {-2.397196e-06, 1.859696e-07},{-2.211226e-06, 1.892528e-07},{-2.021973e-06, 1.919953e-07},{-1.829978e-06, 1.941962e-07},
 {-1.635782e-06, 1.958560e-07},{-1.439926e-06, 1.969768e-07},{-1.242949e-06, 1.975618e-07},{-1.045387e-06, 1.976158e-07},
 {-8.477714e-07, 1.971451e-07},{-6.506263e-07, 1.961570e-07},{-4.544693e-07, 1.946604e-07},{-2.598089e-07, 1.926654e-07},
 {-6.714356e-08, 1.901831e-07},{ 1.230395e-07, 1.872261e-07},{ 3.102657e-07, 1.838080e-07},{ 4.940736e-07, 1.799434e-07},
 { 6.740170e-07, 1.756481e-07},{ 8.496651e-07, 1.709388e-07},{ 1.020604e-06, 1.658331e-07},{ 1.186437e-06, 1.603496e-07},
 { 1.346786e-06, 1.545076e-07},{ 1.501294e-06, 1.483272e-07},{ 1.649621e-06, 1.418292e-07},{ 1.791451e-06, 1.350351e-07},
 { 1.926486e-06, 1.279667e-07},{ 2.054452e-06, 1.206467e-07},{ 2.175099e-06, 1.130978e-07},{ 2.288197e-06, 1.053435e-07},
 { 2.393540e-06, 9.740723e-08},{ 2.490948e-06, 8.931285e-08},{ 2.580260e-06, 8.108435e-08},{ 2.661345e-06, 7.274579e-08},
 { 2.734091e-06, 6.432127e-08},{ 2.798412e-06, 5.583487e-08},{ 2.854247e-06, 4.731054e-08},{ 2.901557e-06, 3.877207e-08},
 { 2.940329e-06, 3.024302e-08},{ 2.970572e-06, 2.174667e-08},{ 2.992319e-06, 1.330592e-08},{ 3.005625e-06, 4.943266e-09},
 { 3.010568e-06,-3.319259e-09},{ 3.007249e-06,-1.146016e-08},{ 2.995789e-06,-1.945853e-08},{ 2.976330e-06,-2.729407e-08},
 { 2.949036e-06,-3.494719e-08},{ 2.914089e-06,-4.239901e-08},{ 2.871690e-06,-4.963144e-08},{ 2.822059e-06,-5.662720e-08},
 { 2.765431e-06,-6.336987e-08},{ 2.702061e-06,-6.984391e-08},{ 2.632218e-06,-7.603472e-08},{ 2.556183e-06,-8.192866e-08},
 { 2.474254e-06,-8.751308e-08},{ 2.386741e-06,-9.277633e-08},{ 2.293965e-06,-9.770781e-08},{ 2.196257e-06,-1.022980e-07},
 { 2.093959e-06,-1.065384e-07},{ 1.987421e-06,-1.104216e-07},{ 1.876999e-06,-1.139413e-07},{ 1.763058e-06,-1.170923e-07},
 { 1.645965e-06,-1.198706e-07},{ 1.526095e-06,-1.222731e-07},{ 1.403822e-06,-1.242978e-07},{ 1.279524e-06,-1.259441e-07},
 { 1.153580e-06,-1.272122e-07},{ 1.026368e-06,-1.281033e-07},{ 8.982644e-07,-1.286200e-07},{ 7.696444e-07,-1.287656e-07},
 { 6.408788e-07,-1.285447e-07},{ 5.123341e-07,-1.279626e-07},{ 3.843716e-07,-1.270257e-07},{ 2.573459e-07,-1.257415e-07},
 { 1.316044e-07,-1.241181e-07},{ 7.486247e-09,-1.221648e-07},{-1.146786e-07,-1.198914e-07},{-2.345700e-07,-1.173089e-07},
 {-3.518789e-07,-1.144286e-07},{-4.663074e-07,-1.112628e-07},{-5.775702e-07,-1.078245e-07},{-6.853947e-07,-1.041272e-07},
 {-7.895219e-07,-1.001852e-07},{-8.897071e-07,-9.601293e-08},{-9.857200e-07,-9.162574e-08},{-1.077346e-06,-8.703920e-08},
 {-1.164385e-06,-8.226931e-08},{-1.246654e-06,-7.733243e-08},{-1.323987e-06,-7.224518e-08},{-1.396232e-06,-6.702444e-08},
 {-1.463256e-06,-6.168727e-08},{-1.524944e-06,-5.625086e-08},{-1.581194e-06,-5.073249e-08},{-1.631927e-06,-4.514947e-08},
 {-1.677076e-06,-3.951909e-08},{-1.716595e-06,-3.385856e-08},{-1.750454e-06,-2.818498e-08},{-1.778639e-06,-2.251528e-08},
 {-1.801154e-06,-1.686617e-08},{-1.818020e-06,-1.125409e-08},{-1.829275e-06,-5.695166e-09},{-1.834970e-06,-2.051715e-10},
 {-1.835175e-06, 5.200527e-09},{-1.829974e-06, 1.050700e-08},{-1.819467e-06, 1.569982e-08},{-1.803768e-06, 2.076507e-08},
 {-1.783002e-06, 2.568938e-08},{-1.757313e-06, 3.045999e-08},{-1.726853e-06, 3.506477e-08},{-1.691788e-06, 3.949221e-08},
 {-1.652296e-06, 4.373150e-08},{-1.608565e-06, 4.777253e-08},{-1.560792e-06, 5.160591e-08},{-1.509186e-06, 5.522300e-08},
 {-1.453963e-06, 5.861595e-08},{-1.395347e-06, 6.177767e-08},{-1.333570e-06, 6.470188e-08},{-1.268868e-06, 6.738307e-08},
 {-1.201485e-06, 6.981660e-08},{-1.131668e-06, 7.199860e-08},{-1.059669e-06, 7.392605e-08},{-9.857434e-07, 7.559674e-08},
 {-9.101466e-07, 7.700928e-08},{-8.331373e-07, 7.816308e-08},{-7.549743e-07, 7.905840e-08},{-6.759159e-07, 7.969624e-08},
 {-5.962196e-07, 8.007843e-08},{-5.161412e-07, 8.020755e-08},{-4.359336e-07, 8.008694e-08},{-3.558467e-07, 7.972066e-08},
 {-2.761260e-07, 7.911351e-08},{-1.970125e-07, 7.827095e-08},{-1.187416e-07, 7.719914e-08},{-4.154242e-08, 7.590485e-08},
 { 3.436243e-08, 7.439548e-08},{ 1.087579e-07, 7.267900e-08},{ 1.814369e-07, 7.076394e-08},{ 2.522009e-07, 6.865934e-08},
 { 3.208602e-07, 6.637472e-08},{ 3.872349e-07, 6.392005e-08},{ 4.511550e-07, 6.130571e-08},{ 5.124607e-07, 5.854245e-08},
 { 5.710031e-07, 5.564136e-08},{ 6.266445e-07, 5.261382e-08},{ 6.792583e-07, 4.947146e-08},{ 7.287297e-07, 4.622612e-08},
 { 7.749559e-07, 4.288982e-08},{ 8.178457e-07, 3.947472e-08},{ 8.573204e-07, 3.599303e-08},{ 8.933134e-07, 3.245706e-08},
 { 9.257705e-07, 2.887908e-08},{ 9.546496e-07, 2.527135e-08},{ 9.799209e-07, 2.164605e-08},{ 1.001567e-06, 1.801525e-08},
 { 1.019582e-06, 1.439086e-08},{ 1.033973e-06, 1.078462e-08},{ 1.044758e-06, 7.208022e-09},{ 1.051966e-06, 3.672332e-09},
 { 1.055638e-06, 1.885170e-10},{ 1.055827e-06,-3.232775e-09},{ 1.052594e-06,-6.581252e-09},{ 1.046013e-06,-9.847016e-09},
 { 1.036166e-06,-1.302058e-08},{ 1.023145e-06,-1.609290e-08},{ 1.007052e-06,-1.905539e-08},{ 9.879967e-07,-2.189995e-08},
 { 9.660967e-07,-2.461901e-08},{ 9.414777e-07,-2.720550e-08},{ 9.142722e-07,-2.965292e-08},{ 8.846193e-07,-3.195530e-08},
 { 8.526640e-07,-3.410729e-08},{ 8.185567e-07,-3.610408e-08},{ 7.824526e-07,-3.794149e-08},{ 7.445111e-07,-3.961591e-08},
 { 7.048952e-07,-4.112437e-08},{ 6.637708e-07,-4.246448e-08},{ 6.213063e-07,-4.363447e-08},{ 5.776719e-07,-4.463320e-08},
 { 5.330387e-07,-4.546010e-08},{ 4.875786e-07,-4.611522e-08},{ 4.414634e-07,-4.659921e-08},{ 3.948641e-07,-4.691329e-08},
 { 3.479508e-07,-4.705926e-08},{ 3.008916e-07,-4.703948e-08},{ 2.538521e-07,-4.685685e-08},{ 2.069953e-07,-4.651481e-08},
 { 1.604804e-07,-4.601728e-08},{ 1.144632e-07,-4.536872e-08},{ 6.909445e-08,-4.457401e-08},{ 2.452044e-08,-4.363849e-08},
 {-1.911805e-08,-4.256795e-08},{-6.168600e-08,-4.136853e-08},{-1.030545e-07,-4.004676e-08},{-1.431013e-07,-3.860950e-08},
 {-1.817108e-07,-3.706394e-08},{-2.187747e-07,-3.541752e-08},{-2.541922e-07,-3.367796e-08},{-2.878702e-07,-3.185317e-08},
 {-3.197234e-07,-2.995125e-08},{-3.496746e-07,-2.798047e-08},{-3.776551e-07,-2.594922e-08},{-4.036043e-07,-2.386596e-08},
 {-4.274703e-07,-2.173924e-08},{-4.492095e-07,-1.957760e-08},{-4.687871e-07,-1.738963e-08},{-4.861768e-07,-1.518387e-08},
 {-5.013606e-07,-1.296879e-08},{-5.143294e-07,-1.075279e-08},{-5.250822e-07,-8.544133e-09},{-5.336263e-07,-6.350933e-09},
 {-5.399773e-07,-4.181111e-09},{-5.441584e-07,-2.042386e-09},{-5.462008e-07, 5.775380e-11},{-5.461430e-07, 2.112079e-09},
 {-5.440309e-07, 4.113650e-09},{-5.399173e-07, 6.055827e-09},{-5.338614e-07, 7.932298e-09},{-5.259291e-07, 9.737099e-09},
 {-5.161920e-07, 1.146463e-08},{-5.047274e-07, 1.310968e-08},{-4.916177e-07, 1.466743e-08},{-4.769503e-07, 1.613347e-08},
 {-4.608168e-07, 1.750381e-08},{-4.433130e-07, 1.877492e-08},{-4.245381e-07, 1.994368e-08},{-4.045944e-07, 2.100744e-08},
 {-3.835870e-07, 2.196399e-08},{-3.616230e-07, 2.281160e-08},{-3.388114e-07, 2.354899e-08},{-3.152624e-07, 2.417532e-08},
 {-2.910871e-07, 2.469024e-08},{-2.663968e-07, 2.509383e-08},{-2.413030e-07, 2.538663e-08},{-2.159164e-07, 2.556962e-08},
 {-1.903468e-07, 2.564420e-08},{-1.647026e-07, 2.561221e-08},{-1.390904e-07, 2.547589e-08},{-1.136145e-07, 2.523785e-08},
 {-8.837661e-08, 2.490112e-08},{-6.347549e-08, 2.446906e-08},{-3.900643e-08, 2.394537e-08},{-1.506106e-08, 2.333410e-08},
 { 8.273033e-09, 2.263956e-08},{ 3.091260e-08, 2.186638e-08},{ 5.277898e-08, 2.101942e-08},{ 7.379839e-08, 2.010377e-08},
 { 9.390216e-08, 1.912474e-08},{ 1.130269e-07, 1.808782e-08},{ 1.311147e-07, 1.699864e-08},{ 1.481134e-07, 1.586300e-08},
 { 1.639764e-07, 1.468677e-08},{ 1.786631e-07, 1.347593e-08},{ 1.921391e-07, 1.223652e-08},{ 2.043756e-07, 1.097459e-08},
 { 2.153502e-07, 9.696247e-09},{ 2.250464e-07, 8.407546e-09},{ 2.334540e-07, 7.114492e-09},{ 2.405685e-07, 5.823005e-09},
 { 2.463915e-07, 4.538903e-09},{ 2.509304e-07, 3.267881e-09},{ 2.541982e-07, 2.015486e-09},{ 2.562137e-07, 7.870868e-10},
 { 2.570008e-07,-4.121459e-10},{ 2.565887e-07,-1.577256e-09},{ 2.550114e-07,-2.703526e-09},{ 2.523079e-07,-3.786496e-09},
 { 2.485214e-07,-4.821986e-09},{ 2.436994e-07,-5.806102e-09},{ 2.378933e-07,-6.735259e-09},{ 2.311581e-07,-7.606196e-09},
 { 2.235519e-07,-8.415981e-09},{ 2.151359e-07,-9.162025e-09},{ 2.059738e-07,-9.842094e-09},{ 1.961318e-07,-1.045431e-08},
 { 1.856774e-07,-1.099717e-08},{ 1.746803e-07,-1.146952e-08},{ 1.632108e-07,-1.187058e-08},{ 1.513402e-07,-1.219996e-08},
 { 1.391402e-07,-1.245761e-08},{ 1.266826e-07,-1.264386e-08},{ 1.140387e-07,-1.275940e-08},{ 1.012793e-07,-1.280525e-08},
 { 8.847410e-08,-1.278279e-08},{ 7.569131e-08,-1.269372e-08},{ 6.299759e-08,-1.254006e-08},{ 5.045753e-08,-1.232413e-08},
 { 3.813340e-08,-1.204855e-08},{ 2.608485e-08,-1.171618e-08},{ 1.436867e-08,-1.133017e-08},{ 3.038501e-09,-1.089385e-08},
 {-7.855350e-09,-1.041081e-08},{-1.826616e-08,-9.884796e-09},{-2.815096e-08,-9.319733e-09},{-3.747069e-08,-8.719683e-09},
 {-4.619037e-08,-8.088831e-09},{-5.427920e-08,-7.431455e-09},{-6.171066e-08,-6.751907e-09},{-6.846256e-08,-6.054590e-09},
 {-7.451715e-08,-5.343932e-09},{-7.986109e-08,-4.624370e-09},{-8.448546e-08,-3.900326e-09},{-8.838578e-08,-3.176190e-09},
 {-9.156197e-08,-2.456290e-09},{-9.401826e-08,-1.744853e-09},{-9.576311e-08,-1.045970e-09},{-9.680908e-08,-3.635695e-10},
 {-9.717265e-08, 2.985827e-10},{-9.687407e-08, 9.369029e-10},{-9.593717e-08, 1.548015e-09},{-9.438915e-08, 2.128780e-09},
 {-9.226037e-08, 2.676297e-09},{-8.958408e-08, 3.187922e-09},{-8.639615e-08, 3.661291e-09},{-8.273486e-08, 4.094326e-09},
 {-7.864054e-08, 4.485241e-09},{-7.415530e-08, 4.832559e-09},{-6.932274e-08, 5.135119e-09},{-6.418762e-08, 5.392071e-09},
 {-5.879555e-08, 5.602887e-09},{-5.319266e-08, 5.767363e-09},{-4.742530e-08, 5.885610e-09},{-4.153969e-08, 5.958055e-09},
 {-3.558163e-08, 5.985437e-09},{-2.959620e-08, 5.968793e-09},{-2.362740e-08, 5.909454e-09},{-1.771795e-08, 5.809031e-09},
 {-1.190892e-08, 5.669398e-09},{-6.239520e-09, 5.492681e-09},{-7.468393e-10, 5.281234e-09},{ 4.534395e-09, 5.037627e-09},
 { 9.572022e-09, 4.764616e-09},{ 1.433664e-08, 4.465128e-09},{ 1.880177e-08, 4.142233e-09},{ 2.294400e-08, 3.799119e-09},
 { 2.674312e-08, 3.439065e-09},{ 3.018218e-08, 3.065420e-09},{ 3.324760e-08, 2.681568e-09},{ 3.592917e-08, 2.290904e-09},
 { 3.822007e-08, 1.896808e-09},{ 4.011688e-08, 1.502616e-09},{ 4.161950e-08, 1.111595e-09},{ 4.273109e-08, 7.269139e-10},
 { 4.345801e-08, 3.516216e-10},{ 4.380963e-08,-1.137423e-11},{ 4.379826e-08,-3.593310e-10},{ 4.343892e-08,-6.896903e-10},
 { 4.274923e-08,-1.000091e-09},{ 4.174914e-08,-1.288387e-09},{ 4.046076e-08,-1.552651e-09},{ 3.890810e-08,-1.791187e-09},
 { 3.711692e-08,-2.002554e-09},{ 3.511436e-08,-2.185617e-09},{ 3.292875e-08,-2.339586e-09},{ 3.058916e-08,-2.464004e-09},
 { 2.812516e-08,-2.558707e-09},{ 2.556645e-08,-2.623840e-09},{ 2.294261e-08,-2.659871e-09},{ 2.028274e-08,-2.667575e-09},
 { 1.761516e-08,-2.648009e-09},{ 1.496715e-08,-2.602530e-09},{ 1.236462e-08,-2.532758e-09},{ 9.831864e-09,-2.440559e-09},
 { 7.391306e-09,-2.328035e-09},{ 5.063271e-09,-2.197483e-09},{ 2.865788e-09,-2.051379e-09},{ 8.144083e-10,-1.892341e-09},
 {-1.077933e-09,-1.723093e-09},{-2.801026e-09,-1.546434e-09},{-4.347459e-09,-1.365195e-09},{-5.712654e-09,-1.182201e-09},
 {-6.894856e-09,-1.000232e-09},{-7.895088e-09,-8.219709e-10},{-8.717059e-09,-6.499723e-10},{-9.367031e-09,-4.866123e-10},
 {-9.853643e-09,-3.340486e-10},{-1.018769e-08,-1.941819e-10},{-1.038187e-08,-6.861356e-11},{-1.045049e-08, 4.138212e-11},
 {-1.040911e-08, 1.348986e-10},{-1.027421e-08, 2.114117e-10},{-1.006279e-08, 2.708093e-10},{-9.791986e-09, 3.133956e-10},
 {-9.478590e-09, 3.399024e-10},{-9.138688e-09, 3.514765e-10},{-8.787211e-09, 3.496685e-10},{-8.437543e-09, 3.364000e-10},
 {-8.101143e-09, 3.139221e-10},{-7.787220e-09, 2.847562e-10},{-7.502464e-09, 2.516178e-10},{-7.250846e-09, 2.173212e-10},
 {-7.033525e-09, 1.846658e-10},{-6.848859e-09, 1.562941e-10},{-6.692565e-09, 1.345328e-10},{-6.558032e-09, 1.211998e-10},
 {-6.436833e-09, 1.173885e-10},{-6.319444e-09, 1.232147e-10},{-6.196229e-09, 1.375440e-10},{-6.058685e-09, 1.575662e-10},
 {-5.901119e-09, 1.790835e-10},{-5.722036e-09, 2.002665e-10},{-5.521769e-09, 2.209262e-10},{-5.300843e-09, 2.410450e-10},
 {-5.059798e-09, 2.605766e-10},{-4.799222e-09, 2.794782e-10},{-4.519743e-09, 2.977075e-10},{-4.222036e-09, 3.152237e-10},
 {-3.906812e-09, 3.319882e-10},{-3.574824e-09, 3.479630e-10},{-3.226861e-09, 3.631133e-10},{-2.863748e-09, 3.774054e-10},
 {-2.486342e-09, 3.908079e-10},{-2.095534e-09, 4.032922e-10},{-1.692242e-09, 4.148309e-10},{-1.277411e-09, 4.254000e-10},
 {-8.520110e-10, 4.349773e-10},{-4.170337e-10, 4.170337e-10},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00}
};

float
slope_dd_table [MINBLEP_PHASES * SLOPE_DD_PULSE_LENGTH + 1] =
{
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 4.875754e-12,
  1.319933e-11, 2.671715e-11, 4.827417e-11, 8.224112e-11, 1.350342e-10, 2.157398e-10, 3.368567e-10, 5.151708e-10,
  7.727775e-10, 1.138268e-09, 1.648097e-09, 2.348153e-09, 3.295546e-09, 4.560640e-09, 6.229351e-09, 8.405736e-09,
  1.121489e-08, 1.480621e-08, 1.935698e-08, 2.507641e-08, 3.221011e-08, 4.104497e-08, 5.191462e-08, 6.520538e-08,
  8.136281e-08, 1.008989e-07, 1.243999e-07, 1.525347e-07, 1.860645e-07, 2.258524e-07, 2.728750e-07, 3.282335e-07,
  3.931671e-07, 4.690666e-07, 5.574894e-07, 6.601755e-07, 7.790645e-07, 9.163146e-07, 1.074322e-06, 1.255743e-06,
  1.463514e-06, 1.700881e-06, 1.971418e-06, 2.279063e-06, 2.628139e-06, 3.023393e-06, 3.470022e-06, 3.973712e-06,
  4.540676e-06, 5.177691e-06, 5.892139e-06, 6.692055e-06, 7.586167e-06, 8.583953e-06, 9.695686e-06, 1.093249e-05,
  1.230640e-05, 1.383041e-05, 1.551857e-05, 1.738600e-05, 1.944901e-05, 2.172512e-05, 2.423320e-05, 2.699350e-05,
  3.002774e-05, 3.335921e-05, 3.701288e-05, 4.101543e-05, 4.539541e-05, 5.018332e-05, 5.541172e-05, 6.111533e-05,
  6.733115e-05, 7.409860e-05, 8.145960e-05, 8.945876e-05, 9.814343e-05, 1.075639e-04, 1.177736e-04, 1.288291e-04,
  1.407904e-04, 1.537208e-04, 1.676877e-04, 1.827620e-04, 1.990187e-04, 2.165372e-04, 2.354011e-04, 2.556985e-04,
  2.775226e-04, 3.009712e-04, 3.261475e-04, 3.531600e-04, 3.821228e-04, 4.131558e-04, 4.463851e-04, 4.819427e-04,
  5.199676e-04, 5.606051e-04, 6.040078e-04, 6.503353e-04, 6.997549e-04, 7.524415e-04, 8.085782e-04, 8.683562e-04,
  9.319754e-04, 9.996445e-04, 1.071581e-03, 1.148013e-03, 1.229176e-03, 1.315319e-03, 1.406697e-03, 1.503580e-03,
  1.606245e-03, 1.714982e-03, 1.830094e-03, 1.951893e-03, 2.080705e-03, 2.216867e-03, 2.360732e-03, 2.512661e-03,
  2.673034e-03, 2.842240e-03, 3.020685e-03, 3.208789e-03, 3.406985e-03, 3.615723e-03, 3.835468e-03, 4.066701e-03,
  4.309917e-03, 4.565630e-03, 4.834368e-03, 5.116679e-03, 5.413126e-03, 5.724291e-03, 6.050772e-03, 6.393187e-03,
  6.752172e-03, 7.128381e-03, 7.522489e-03, 7.935188e-03, 8.367190e-03, 8.819229e-03, 9.292057e-03, 9.786446e-03,
  1.030319e-02, 1.084310e-02, 1.140702e-02, 1.199580e-02, 1.261032e-02, 1.325148e-02, 1.392020e-02, 1.461742e-02,
  1.534411e-02, 1.610126e-02, 1.688987e-02, 1.771098e-02, 1.856564e-02, 1.945493e-02, 2.037995e-02, 2.134182e-02,
  2.234169e-02, 2.338072e-02, 2.446010e-02, 2.558105e-02, 2.674480e-02, 2.795261e-02, 2.920576e-02, 3.050554e-02,
  3.185329e-02, 3.325035e-02, 3.469808e-02, 3.619788e-02, 3.775115e-02, 3.935933e-02, 4.102386e-02, 4.274621e-02,
  4.452788e-02, 4.637038e-02, 4.827523e-02, 5.024399e-02, 5.227822e-02, 5.437950e-02, 5.654944e-02, 5.878966e-02,
  6.110178e-02, 6.348745e-02, 6.594835e-02, 6.848614e-02, 7.110253e-02, 7.379921e-02, 7.657791e-02, 7.944034e-02,
  8.238826e-02, 8.542340e-02, 8.854753e-02, 9.176241e-02, 9.506981e-02, 9.847152e-02, 1.019693e-01, 1.055650e-01,
  1.092603e-01, 1.130571e-01, 1.169571e-01, 1.209622e-01, 1.250741e-01, 1.292947e-01, 1.336256e-01, 1.380688e-01,
  1.426259e-01, 1.472988e-01, 1.520893e-01, 1.569989e-01, 1.620296e-01, 1.671830e-01, 1.724609e-01, 1.778649e-01,
  1.833968e-01, 1.734331e-01, 1.636006e-01, 1.539009e-01, 1.443356e-01, 1.349063e-01, 1.256145e-01, 1.164618e-01,
  1.074497e-01, 9.857961e-02, 8.985304e-02, 8.127138e-02, 7.283604e-02, 6.454834e-02, 5.640961e-02, 4.842112e-02,
  4.058412e-02, 3.289978e-02, 2.536928e-02, 1.799372e-02, 1.077416e-02, 3.711640e-03,-3.192877e-03,-9.938464e-03,
 -1.652424e-02,-2.294939e-02,-2.921313e-02,-3.531476e-02,-4.125359e-02,-4.702903e-02,-5.264053e-02,-5.808760e-02,
 -6.336979e-02,-6.848676e-02,-7.343817e-02,-7.822380e-02,-8.284345e-02,-8.729701e-02,-9.158444e-02,-9.570573e-02,
 -9.966099e-02,-1.034504e-01,-1.070740e-01,-1.105324e-01,-1.138257e-01,-1.169544e-01,-1.199190e-01,-1.227201e-01,
 -1.253584e-01,-1.278345e-01,-1.301493e-01,-1.323036e-01,-1.342983e-01,-1.361346e-01,-1.378134e-01,-1.393359e-01,
 -1.407034e-01,-1.419172e-01,-1.429786e-01,-1.438892e-01,-1.446504e-01,-1.452639e-01,-1.457313e-01,-1.460544e-01,
 -1.462350e-01,-1.462750e-01,-1.461763e-01,-1.459410e-01,-1.455712e-01,-1.450691e-01,-1.444368e-01,-1.436767e-01,
 -1.427911e-01,-1.417825e-01,-1.406533e-01,-1.394061e-01,-1.380435e-01,-1.365682e-01,-1.349829e-01,-1.332903e-01,
 -1.314934e-01,-1.295949e-01,-1.275978e-01,-1.255051e-01,-1.233198e-01,-1.210450e-01,-1.186838e-01,-1.162394e-01,
 -1.137148e-01,-1.111134e-01,-1.084384e-01,-1.056932e-01,-1.028809e-01,-1.000050e-01,-9.706891e-02,-9.407591e-02,
 -9.102945e-02,-8.793297e-02,-8.478992e-02,-8.160373e-02,-7.837789e-02,-7.511586e-02,-7.182113e-02,-6.849716e-02,
 -6.514744e-02,-6.177545e-02,-5.838463e-02,-5.497846e-02,-5.156039e-02,-4.813383e-02,-4.470221e-02,-4.126891e-02,
 -3.783731e-02,-3.441075e-02,-3.099255e-02,-2.758600e-02,-2.419434e-02,-2.082079e-02,-1.746852e-02,-1.414067e-02,
 -1.084033e-02,-7.570542e-03,-4.334297e-03,-1.134536e-03, 2.025853e-03, 5.144041e-03, 8.217258e-03, 1.124280e-02,
  1.421801e-02, 1.714032e-02, 2.000722e-02, 2.281627e-02, 2.556510e-02, 2.825142e-02, 3.087301e-02, 3.342774e-02,
  3.591355e-02, 3.832847e-02, 4.067061e-02, 4.293815e-02, 4.512938e-02, 4.724267e-02, 4.927648e-02, 5.122936e-02,
  5.309995e-02, 5.488698e-02, 5.658929e-02, 5.820578e-02, 5.973550e-02, 6.117754e-02, 6.253113e-02, 6.379556e-02,
  6.497026e-02, 6.605472e-02, 6.704856e-02, 6.795147e-02, 6.876325e-02, 6.948382e-02, 7.011315e-02, 7.065136e-02,
  7.109864e-02, 7.145527e-02, 7.172165e-02, 7.189826e-02, 7.198568e-02, 7.198458e-02, 7.189573e-02, 7.171998e-02,
  7.145829e-02, 7.111169e-02, 7.068131e-02, 7.016836e-02, 6.957414e-02, 6.890003e-02, 6.814750e-02, 6.731808e-02,
  6.641341e-02, 6.543516e-02, 6.438512e-02, 6.326512e-02, 6.207707e-02, 6.082296e-02, 5.950481e-02, 5.812474e-02,
  5.668491e-02, 5.518752e-02, 5.363487e-02, 5.202926e-02, 5.037308e-02, 4.866873e-02, 4.691868e-02, 4.512543e-02,
  4.329151e-02, 4.141950e-02, 3.951198e-02, 3.757160e-02, 3.560099e-02, 3.360283e-02, 3.157982e-02, 2.953465e-02,
  2.747004e-02, 2.538871e-02, 2.329339e-02, 2.118682e-02, 1.907171e-02, 1.695080e-02, 1.482679e-02, 1.270239e-02,
  1.058029e-02, 8.463155e-03, 6.353642e-03, 4.254373e-03, 2.167947e-03, 9.693343e-05,-1.956134e-03,-3.988757e-03,
 -5.998475e-03,-7.982870e-03,-9.939572e-03,-1.186625e-02,-1.376064e-02,-1.562051e-02,-1.744371e-02,-1.922811e-02,
 -2.097167e-02,-2.267242e-02,-2.432842e-02,-2.593783e-02,-2.749887e-02,-2.900982e-02,-3.046904e-02,-3.187498e-02,
 -3.322614e-02,-3.452112e-02,-3.575858e-02,-3.693729e-02,-3.805608e-02,-3.911387e-02,-4.010966e-02,-4.104254e-02,
 -4.191170e-02,-4.271638e-02,-4.345596e-02,-4.412987e-02,-4.473764e-02,-4.527888e-02,-4.575332e-02,-4.616075e-02,
 -4.650106e-02,-4.677422e-02,-4.698031e-02,-4.711947e-02,-4.719196e-02,-4.719811e-02,-4.713833e-02,-4.701313e-02,
 -4.682310e-02,-4.656891e-02,-4.625131e-02,-4.587116e-02,-4.542936e-02,-4.492691e-02,-4.436488e-02,-4.374442e-02,
 -4.306676e-02,-4.233318e-02,-4.154506e-02,-4.070381e-02,-3.981094e-02,-3.886801e-02,-3.787662e-02,-3.683848e-02,
 -3.575529e-02,-3.462886e-02,-3.346102e-02,-3.225366e-02,-3.100871e-02,-2.972813e-02,-2.841396e-02,-2.706822e-02,
 -2.569302e-02,-2.429045e-02,-2.286268e-02,-2.141185e-02,-1.994017e-02,-1.844984e-02,-1.694308e-02,-1.542213e-02,
 -1.388923e-02,-1.234664e-02,-1.079660e-02,-9.241379e-03,-7.683219e-03,-6.124365e-03,-4.567052e-03,-3.013502e-03,
 -1.465921e-03, 7.350485e-05, 1.602609e-03, 3.119250e-03, 4.621316e-03, 6.106723e-03, 7.573423e-03, 9.019401e-03,
  1.044268e-02, 1.184134e-02, 1.321348e-02, 1.455726e-02, 1.587088e-02, 1.715262e-02, 1.840077e-02, 1.961371e-02,
  2.078986e-02, 2.192770e-02, 2.302580e-02, 2.408276e-02, 2.509725e-02, 2.606803e-02, 2.699391e-02, 2.787377e-02,
  2.870657e-02, 2.949135e-02, 3.022719e-02, 3.091330e-02, 3.154891e-02, 3.213336e-02, 3.266607e-02, 3.314652e-02,
  3.357428e-02, 3.394899e-02, 3.427039e-02, 3.453827e-02, 3.475253e-02, 3.491312e-02, 3.502010e-02, 3.507357e-02,
  3.507375e-02, 3.502092e-02, 3.491542e-02, 3.475769e-02, 3.454824e-02, 3.428765e-02, 3.397658e-02, 3.361575e-02,
  3.320596e-02, 3.274809e-02, 3.224306e-02, 3.169188e-02, 3.109562e-02, 3.045540e-02, 2.977242e-02, 2.904793e-02,
  2.828322e-02, 2.747967e-02, 2.663869e-02, 2.576174e-02, 2.485033e-02, 2.390601e-02, 2.293040e-02, 2.192513e-02,
  2.089188e-02, 1.983235e-02, 1.874831e-02, 1.764151e-02, 1.651378e-02, 1.536692e-02, 1.420280e-02, 1.302328e-02,
  1.183024e-02, 1.062557e-02, 9.411184e-03, 8.188992e-03, 6.960908e-03, 5.728851e-03, 4.494734e-03, 3.260470e-03,
  2.027960e-03, 7.990964e-04,-4.242407e-04,-1.640189e-03,-2.846904e-03,-4.042565e-03,-5.225372e-03,-6.393555e-03,
 -7.545373e-03,-8.679118e-03,-9.793114e-03,-1.088573e-02,-1.195535e-02,-1.300044e-02,-1.401949e-02,-1.501101e-02,
 -1.597361e-02,-1.690591e-02,-1.780660e-02,-1.867442e-02,-1.950816e-02,-2.030669e-02,-2.106891e-02,-2.179380e-02,
 -2.248039e-02,-2.312779e-02,-2.373516e-02,-2.430173e-02,-2.482680e-02,-2.530972e-02,-2.574995e-02,-2.614696e-02,
 -2.650035e-02,-2.680974e-02,-2.707486e-02,-2.729548e-02,-2.747145e-02,-2.760270e-02,-2.768923e-02,-2.773109e-02,
 -2.772843e-02,-2.768144e-02,-2.759040e-02,-2.745565e-02,-2.727760e-02,-2.705673e-02,-2.679357e-02,-2.648873e-02,
 -2.614289e-02,-2.575677e-02,-2.533117e-02,-2.486694e-02,-2.436498e-02,-2.382628e-02,-2.325184e-02,-2.264275e-02,
 -2.200013e-02,-2.132514e-02,-2.061902e-02,-1.988303e-02,-1.911848e-02,-1.832672e-02,-1.750914e-02,-1.666715e-02,
 -1.580223e-02,-1.491585e-02,-1.400953e-02,-1.308482e-02,-1.214329e-02,-1.118651e-02,-1.021611e-02,-9.233699e-03,
 -8.240915e-03,-7.239405e-03,-6.230823e-03,-5.216828e-03,-4.199083e-03,-3.179249e-03,-2.158985e-03,-1.139945e-03,
 -1.237742e-04, 8.878924e-04, 1.893433e-03, 2.891243e-03, 3.879734e-03, 4.857341e-03, 5.822519e-03, 6.773752e-03,
  7.709551e-03, 8.628456e-03, 9.529042e-03, 1.040992e-02, 1.126973e-02, 1.210716e-02, 1.292094e-02, 1.370983e-02,
  1.447266e-02, 1.520827e-02, 1.591558e-02, 1.659355e-02, 1.724119e-02, 1.785757e-02, 1.844179e-02, 1.899304e-02,
  1.951054e-02, 1.999359e-02, 2.044152e-02, 2.085375e-02, 2.122975e-02, 2.156903e-02, 2.187120e-02, 2.213590e-02,
  2.236285e-02, 2.255183e-02, 2.270268e-02, 2.281530e-02, 2.288965e-02, 2.292578e-02, 2.292377e-02, 2.288377e-02,
  2.280601e-02, 2.269076e-02, 2.253836e-02, 2.234921e-02, 2.212377e-02, 2.186256e-02, 2.156614e-02, 2.123515e-02,
  2.087027e-02, 2.047224e-02, 2.004186e-02, 1.957995e-02, 1.908742e-02, 1.856519e-02, 1.801426e-02, 1.743565e-02,
  1.683043e-02, 1.619970e-02, 1.554463e-02, 1.486639e-02, 1.416621e-02, 1.344533e-02, 1.270503e-02, 1.194664e-02,
  1.117147e-02, 1.038090e-02, 9.576290e-03, 8.759051e-03, 7.930594e-03, 7.092346e-03, 6.245747e-03, 5.392246e-03,
  4.533296e-03, 3.670359e-03, 2.804893e-03, 1.938360e-03, 1.072216e-03, 2.079130e-04,-6.531068e-04,-1.509410e-03,
 -2.359577e-03,-3.202202e-03,-4.035899e-03,-4.859298e-03,-5.671054e-03,-6.469845e-03,-7.254374e-03,-8.023376e-03,
 -8.775612e-03,-9.509877e-03,-1.022500e-02,-1.091985e-02,-1.159333e-02,-1.224438e-02,-1.287198e-02,-1.347516e-02,
 -1.405300e-02,-1.460461e-02,-1.512916e-02,-1.562585e-02,-1.609396e-02,-1.653279e-02,-1.694170e-02,-1.732013e-02,
 -1.766753e-02,-1.798343e-02,-1.826742e-02,-1.851912e-02,-1.873823e-02,-1.892449e-02,-1.907772e-02,-1.919776e-02,
 -1.928454e-02,-1.933803e-02,-1.935826e-02,-1.934531e-02,-1.929933e-02,-1.922052e-02,-1.910912e-02,-1.896545e-02,
 -1.878987e-02,-1.858279e-02,-1.834468e-02,-1.807605e-02,-1.777748e-02,-1.744958e-02,-1.709301e-02,-1.670849e-02,
 -1.629677e-02,-1.585866e-02,-1.539500e-02,-1.490667e-02,-1.439459e-02,-1.385973e-02,-1.330308e-02,-1.272567e-02,
 -1.212856e-02,-1.151286e-02,-1.087967e-02,-1.023015e-02,-9.565465e-03,-8.886812e-03,-8.195404e-03,-7.492472e-03,
 -6.779264e-03,-6.057041e-03,-5.327076e-03,-4.590649e-03,-3.849050e-03,-3.103572e-03,-2.355510e-03,-1.606162e-03,
 -8.568202e-04,-1.087761e-04, 6.366871e-04, 1.378294e-03, 2.114780e-03, 2.844894e-03, 3.567399e-03, 4.281075e-03,
  4.984722e-03, 5.677159e-03, 6.357231e-03, 7.023806e-03, 7.675778e-03, 8.312073e-03, 8.931644e-03, 9.533478e-03,
  1.011659e-02, 1.068005e-02, 1.122294e-02, 1.174439e-02, 1.224357e-02, 1.271970e-02, 1.317203e-02, 1.359985e-02,
  1.400251e-02, 1.437940e-02, 1.472995e-02, 1.505365e-02, 1.535001e-02, 1.561863e-02, 1.585912e-02, 1.607118e-02,
  1.625451e-02, 1.640891e-02, 1.653421e-02, 1.663028e-02, 1.669705e-02, 1.673451e-02, 1.674270e-02, 1.672169e-02,
  1.667162e-02, 1.659268e-02, 1.648510e-02, 1.634917e-02, 1.618521e-02, 1.599361e-02, 1.577479e-02, 1.552923e-02,
  1.525745e-02, 1.496000e-02, 1.463748e-02, 1.429056e-02, 1.391991e-02, 1.352627e-02, 1.311038e-02, 1.267307e-02,
  1.221515e-02, 1.173751e-02, 1.124104e-02, 1.072667e-02, 1.019536e-02, 9.648106e-03, 9.085906e-03, 8.509798e-03,
  7.920838e-03, 7.320099e-03, 6.708674e-03, 6.087669e-03, 5.458204e-03, 4.821412e-03, 4.178432e-03, 3.530414e-03,
  2.878511e-03, 2.223881e-03, 1.567681e-03, 9.110689e-04, 2.551997e-04,-3.987768e-04,-1.049718e-03,-1.696488e-03,
 -2.337966e-03,-2.973039e-03,-3.600611e-03,-4.219603e-03,-4.828954e-03,-5.427621e-03,-6.014586e-03,-6.588854e-03,
 -7.149453e-03,-7.695441e-03,-8.225902e-03,-8.739952e-03,-9.236738e-03,-9.715440e-03,-1.017527e-02,-1.061548e-02,
 -1.103536e-02,-1.143423e-02,-1.181145e-02,-1.216643e-02,-1.249861e-02,-1.280748e-02,-1.309257e-02,-1.335345e-02,
 -1.358974e-02,-1.380109e-02,-1.398723e-02,-1.414788e-02,-1.428286e-02,-1.439201e-02,-1.447522e-02,-1.453241e-02,
 -1.456359e-02,-1.456876e-02,-1.454801e-02,-1.450145e-02,-1.442926e-02,-1.433163e-02,-1.420883e-02,-1.406115e-02,
 -1.388894e-02,-1.369257e-02,-1.347247e-02,-1.322911e-02,-1.296299e-02,-1.267467e-02,-1.236471e-02,-1.203374e-02,
 -1.168242e-02,-1.131143e-02,-1.092150e-02,-1.051338e-02,-1.008784e-02,-9.645712e-03,-9.187825e-03,-8.715044e-03,
 -8.228258e-03,-7.728378e-03,-7.216335e-03,-6.693079e-03,-6.159577e-03,-5.616812e-03,-5.065781e-03,-4.507491e-03,
 -3.942959e-03,-3.373214e-03,-2.799286e-03,-2.222212e-03,-1.643032e-03,-1.062786e-03,-4.825128e-04, 9.675189e-05,
  6.739770e-04, 1.248138e-03, 1.818219e-03, 2.383214e-03, 2.942131e-03, 3.493987e-03, 4.037821e-03, 4.572683e-03,
  5.097646e-03, 5.611802e-03, 6.114264e-03, 6.604169e-03, 7.080681e-03, 7.542987e-03, 7.990305e-03, 8.421879e-03,
  8.836986e-03, 9.234933e-03, 9.615060e-03, 9.976742e-03, 1.031939e-02, 1.064244e-02, 1.094538e-02, 1.122773e-02,
  1.148904e-02, 1.172892e-02, 1.194699e-02, 1.214294e-02, 1.231647e-02, 1.246735e-02, 1.259538e-02, 1.270039e-02,
  1.278227e-02, 1.284095e-02, 1.287638e-02, 1.288857e-02, 1.287758e-02, 1.284349e-02, 1.278645e-02, 1.270661e-02,
  1.260419e-02, 1.247945e-02, 1.233269e-02, 1.216422e-02, 1.197442e-02, 1.176370e-02, 1.153250e-02, 1.128130e-02,
  1.101061e-02, 1.072097e-02, 1.041298e-02, 1.008724e-02, 9.744384e-03, 9.385091e-03, 9.010055e-03, 8.620001e-03,
  8.215678e-03, 7.797859e-03, 7.367337e-03, 6.924928e-03, 6.471466e-03, 6.007804e-03, 5.534808e-03, 5.053361e-03,
  4.564359e-03, 4.068705e-03, 3.567317e-03, 3.061117e-03, 2.551034e-03, 2.038002e-03, 1.522956e-03, 1.006833e-03,
  4.905701e-04,-2.489926e-05,-5.386453e-04,-1.049744e-03,-1.557279e-03,-2.060343e-03,-2.558039e-03,-3.049482e-03,
 -3.533803e-03,-4.010145e-03,-4.477670e-03,-4.935558e-03,-5.383009e-03,-5.819244e-03,-6.243506e-03,-6.655063e-03,
 -7.053206e-03,-7.437255e-03,-7.806555e-03,-8.160482e-03,-8.498439e-03,-8.819862e-03,-9.124218e-03,-9.411005e-03,
 -9.679755e-03,-9.930036e-03,-1.016145e-02,-1.037363e-02,-1.056625e-02,-1.073901e-02,-1.089168e-02,-1.102402e-02,
 -1.113585e-02,-1.122705e-02,-1.129749e-02,-1.134712e-02,-1.137591e-02,-1.138386e-02,-1.137104e-02,-1.133751e-02,
 -1.128340e-02,-1.120888e-02,-1.111414e-02,-1.099941e-02,-1.086496e-02,-1.071109e-02,-1.053815e-02,-1.034650e-02,
 -1.013655e-02,-9.908730e-03,-9.663516e-03,-9.401404e-03,-9.122920e-03,-8.828622e-03,-8.519092e-03,-8.194940e-03,
 -7.856800e-03,-7.505331e-03,-7.141211e-03,-6.765143e-03,-6.377849e-03,-5.980068e-03,-5.572556e-03,-5.156086e-03,
 -4.731445e-03,-4.299432e-03,-3.860856e-03,-3.416539e-03,-2.967308e-03,-2.513998e-03,-2.057449e-03,-1.598504e-03,
 -1.138010e-03,-6.768105e-04,-2.157520e-04, 2.443239e-04, 7.025793e-04, 1.158182e-03, 1.610307e-03, 2.058137e-03,
  2.500867e-03, 2.937702e-03, 3.367861e-03, 3.790575e-03, 4.205094e-03, 4.610684e-03, 5.006629e-03, 5.392231e-03,
  5.766817e-03, 6.129732e-03, 6.480347e-03, 6.818056e-03, 7.142278e-03, 7.452460e-03, 7.748073e-03, 8.028621e-03,
  8.293632e-03, 8.542667e-03, 8.775317e-03, 8.991204e-03, 9.189980e-03, 9.371331e-03, 9.534977e-03, 9.680670e-03,
  9.808194e-03, 9.917369e-03, 1.000805e-02, 1.008012e-02, 1.013351e-02, 1.016817e-02, 1.018410e-02, 1.018131e-02,
  1.015987e-02, 1.011988e-02, 1.006145e-02, 9.984760e-03, 9.889995e-03, 9.777385e-03, 9.647187e-03, 9.499693e-03,
  9.335224e-03, 9.154133e-03, 8.956801e-03, 8.743638e-03, 8.515083e-03, 8.271600e-03, 8.013682e-03, 7.741844e-03,
  7.456628e-03, 7.158597e-03, 6.848337e-03, 6.526455e-03, 6.193576e-03, 5.850347e-03, 5.497427e-03, 5.135497e-03,
  4.765247e-03, 4.387385e-03, 4.002627e-03, 3.611704e-03, 3.215352e-03, 2.814318e-03, 2.409354e-03, 2.001218e-03,
  1.590671e-03, 1.178476e-03, 7.653978e-04, 3.522006e-04,-6.035386e-05,-4.715069e-04,-8.805044e-04,-1.286599e-03,
 -1.689050e-03,-2.087125e-03,-2.480104e-03,-2.867276e-03,-3.247944e-03,-3.621424e-03,-3.987049e-03,-4.344167e-03,
 -4.692143e-03,-5.030361e-03,-5.358226e-03,-5.675163e-03,-5.980619e-03,-6.274062e-03,-6.554986e-03,-6.822908e-03,
 -7.077373e-03,-7.317948e-03,-7.544230e-03,-7.755842e-03,-7.952436e-03,-8.133694e-03,-8.299323e-03,-8.449065e-03,
 -8.582687e-03,-8.699992e-03,-8.800808e-03,-8.884997e-03,-8.952454e-03,-9.003101e-03,-9.036893e-03,-9.053819e-03,
 -9.053894e-03,-9.037170e-03,-9.003724e-03,-8.953669e-03,-8.887146e-03,-8.804324e-03,-8.705406e-03,-8.590622e-03,
 -8.460229e-03,-8.314517e-03,-8.153798e-03,-7.978415e-03,-7.788734e-03,-7.585150e-03,-7.368081e-03,-7.137967e-03,
 -6.895273e-03,-6.640486e-03,-6.374113e-03,-6.096682e-03,-5.808740e-03,-5.510852e-03,-5.203597e-03,-4.887575e-03,
 -4.563396e-03,-4.231686e-03,-3.893082e-03,-3.548232e-03,-3.197795e-03,-2.842436e-03,-2.482831e-03,-2.119658e-03,
 -1.753603e-03,-1.385353e-03,-1.015599e-03,-6.450304e-04,-2.743390e-04, 9.578681e-05, 4.646612e-04, 8.316027e-04,
  1.195935e-03, 1.556990e-03, 1.914105e-03, 2.266628e-03, 2.613918e-03, 2.955344e-03, 3.290290e-03, 3.618151e-03,
  3.938338e-03, 4.250279e-03, 4.553417e-03, 4.847215e-03, 5.131154e-03, 5.404733e-03, 5.667475e-03, 5.918922e-03,
  6.158640e-03, 6.386216e-03, 6.601263e-03, 6.803417e-03, 6.992339e-03, 7.167717e-03, 7.329263e-03, 7.476717e-03,
  7.609846e-03, 7.728443e-03, 7.832331e-03, 7.921358e-03, 7.995403e-03, 8.054370e-03, 8.098194e-03, 8.126839e-03,
  8.140293e-03, 8.138578e-03, 8.121740e-03, 8.089855e-03, 8.043027e-03, 7.981385e-03, 7.905089e-03, 7.814323e-03,
  7.709299e-03, 7.590254e-03, 7.457451e-03, 7.311178e-03, 7.151747e-03, 6.979493e-03, 6.794777e-03, 6.597978e-03,
  6.389499e-03, 6.169762e-03, 5.939212e-03, 5.698309e-03, 5.447534e-03, 5.187383e-03, 4.918370e-03, 4.641021e-03,
  4.355880e-03, 4.063502e-03, 3.764453e-03, 3.459312e-03, 3.148665e-03, 2.833110e-03, 2.513249e-03, 2.189693e-03,
  1.863058e-03, 1.533962e-03, 1.203027e-03, 8.708764e-04, 5.381354e-04, 2.054268e-04,-1.266274e-04,-4.574088e-04,
 -7.863029e-04,-1.112700e-03,-1.435998e-03,-1.755601e-03,-2.070923e-03,-2.381386e-03,-2.686425e-03,-2.985484e-03,
 -3.278022e-03,-3.563511e-03,-3.841437e-03,-4.111304e-03,-4.372629e-03,-4.624949e-03,-4.867818e-03,-5.100810e-03,
 -5.323517e-03,-5.535553e-03,-5.736553e-03,-5.926172e-03,-6.104090e-03,-6.270007e-03,-6.423648e-03,-6.564761e-03,
 -6.693120e-03,-6.808521e-03,-6.910787e-03,-6.999764e-03,-7.075325e-03,-7.137369e-03,-7.185817e-03,-7.220621e-03,
 -7.241755e-03,-7.249219e-03,-7.243040e-03,-7.223269e-03,-7.189985e-03,-7.143288e-03,-7.083307e-03,-7.010193e-03,
 -6.924121e-03,-6.825292e-03,-6.713928e-03,-6.590275e-03,-6.454602e-03,-6.307198e-03,-6.148375e-03,-5.978464e-03,
 -5.797816e-03,-5.606803e-03,-5.405814e-03,-5.195254e-03,-4.975549e-03,-4.747136e-03,-4.510471e-03,-4.266021e-03,
 -4.014270e-03,-3.755711e-03,-3.490850e-03,-3.220203e-03,-2.944294e-03,-2.663659e-03,-2.378837e-03,-2.090377e-03,
 -1.798830e-03,-1.504754e-03,-1.208709e-03,-9.112555e-04,-6.129580e-04,-3.143790e-04,-1.608051e-05, 2.813778e-04,
  5.774395e-04, 8.715521e-04, 1.163169e-03, 1.451749e-03, 1.736758e-03, 2.017672e-03, 2.293975e-03, 2.565160e-03,
  2.830734e-03, 3.090212e-03, 3.343126e-03, 3.589019e-03, 3.827450e-03, 4.057992e-03, 4.280235e-03, 4.493786e-03,
  4.698269e-03, 4.893325e-03, 5.078617e-03, 5.253824e-03, 5.418647e-03, 5.572806e-03, 5.716043e-03, 5.848121e-03,
  5.968825e-03, 6.077962e-03, 6.175359e-03, 6.260870e-03, 6.334368e-03, 6.395751e-03, 6.444939e-03, 6.481877e-03,
  6.506531e-03, 6.518891e-03, 6.518971e-03, 6.506808e-03, 6.482460e-03, 6.446011e-03, 6.397565e-03, 6.337249e-03,
  6.265212e-03, 6.181626e-03, 6.086681e-03, 5.980592e-03, 5.863592e-03, 5.735933e-03, 5.597889e-03, 5.449750e-03,
  5.291826e-03, 5.124445e-03, 4.947950e-03, 4.762701e-03, 4.569074e-03, 4.367460e-03, 4.158262e-03, 3.941897e-03,
  3.718796e-03, 3.489399e-03, 3.254159e-03, 3.013536e-03, 2.768000e-03, 2.518030e-03, 2.264111e-03, 2.006734e-03,
  1.746394e-03, 1.483592e-03, 1.218832e-03, 9.526187e-04, 6.854592e-04, 4.178609e-04, 1.503300e-04,-1.166284e-04,
 -3.825121e-04,-6.468224e-04,-9.090648e-04,-1.168751e-03,-1.425397e-03,-1.678528e-03,-1.927677e-03,-2.172385e-03,
 -2.412203e-03,-2.646694e-03,-2.875429e-03,-3.097995e-03,-3.313990e-03,-3.523025e-03,-3.724726e-03,-3.918735e-03,
 -4.104709e-03,-4.282320e-03,-4.451257e-03,-4.611229e-03,-4.761959e-03,-4.903191e-03,-5.034687e-03,-5.156228e-03,
 -5.267614e-03,-5.368665e-03,-5.459222e-03,-5.539146e-03,-5.608318e-03,-5.666639e-03,-5.714033e-03,-5.750443e-03,
 -5.775834e-03,-5.790191e-03,-5.793521e-03,-5.785851e-03,-5.767230e-03,-5.737725e-03,-5.697427e-03,-5.646444e-03,
 -5.584905e-03,-5.512960e-03,-5.430775e-03,-5.338539e-03,-5.236457e-03,-5.124752e-03,-5.003664e-03,-4.873452e-03,
 -4.734391e-03,-4.586771e-03,-4.430897e-03,-4.267091e-03,-4.095687e-03,-3.917032e-03,-3.731488e-03,-3.539427e-03,
 -3.341233e-03,-3.137300e-03,-2.928033e-03,-2.713844e-03,-2.495154e-03,-2.272392e-03,-2.045992e-03,-1.816394e-03,
 -1.584044e-03,-1.349390e-03,-1.112884e-03,-8.749811e-04,-6.361355e-04,-3.968031e-04,-1.574394e-04, 8.150180e-05,
  3.195687e-04, 5.563126e-04, 7.912885e-04, 1.024056e-03, 1.254181e-03, 1.481236e-03, 1.704798e-03, 1.924454e-03,
  2.139800e-03, 2.350441e-03, 2.555992e-03, 2.756078e-03, 2.950337e-03, 3.138418e-03, 3.319983e-03, 3.494709e-03,
  3.662284e-03, 3.822412e-03, 3.974814e-03, 4.119224e-03, 4.255391e-03, 4.383085e-03, 4.502087e-03, 4.612201e-03,
  4.713243e-03, 4.805050e-03, 4.887478e-03, 4.960398e-03, 5.023701e-03, 5.077298e-03, 5.121117e-03, 5.155104e-03,
  5.179227e-03, 5.193470e-03, 5.197837e-03, 5.192350e-03, 5.177050e-03, 5.151998e-03, 5.117271e-03, 5.072965e-03,
  5.019195e-03, 4.956092e-03, 4.883806e-03, 4.802502e-03, 4.712364e-03, 4.613589e-03, 4.506394e-03, 4.391008e-03,
  4.267676e-03, 4.136658e-03, 3.998226e-03, 3.852668e-03, 3.700282e-03, 3.541379e-03, 3.376282e-03, 3.205325e-03,
  3.028850e-03, 2.847212e-03, 2.660771e-03, 2.469897e-03, 2.274967e-03, 2.076365e-03, 1.874480e-03, 1.669707e-03,
  1.462443e-03, 1.253092e-03, 1.042058e-03, 8.297482e-04, 6.165699e-04, 4.029319e-04, 1.892421e-04,-2.409266e-05,
 -2.366676e-04,-4.480805e-04,-6.579328e-04,-8.658300e-04,-1.071382e-03,-1.274207e-03,-1.473925e-03,-1.670167e-03,
 -1.862570e-03,-2.050780e-03,-2.234453e-03,-2.413252e-03,-2.586854e-03,-2.754943e-03,-2.917217e-03,-3.073386e-03,
 -3.223173e-03,-3.366311e-03,-3.502550e-03,-3.631651e-03,-3.753393e-03,-3.867566e-03,-3.973977e-03,-4.072449e-03,
 -4.162819e-03,-4.244940e-03,-4.318683e-03,-4.383935e-03,-4.440597e-03,-4.488589e-03,-4.527849e-03,-4.558328e-03,
 -4.579998e-03,-4.592844e-03,-4.596872e-03,-4.592101e-03,-4.578569e-03,-4.556330e-03,-4.525454e-03,-4.486028e-03,
 -4.438155e-03,-4.381953e-03,-4.317557e-03,-4.245115e-03,-4.164792e-03,-4.076765e-03,-3.981229e-03,-3.878390e-03,
 -3.768466e-03,-3.651692e-03,-3.528311e-03,-3.398581e-03,-3.262769e-03,-3.121155e-03,-2.974027e-03,-2.821684e-03,
 -2.664434e-03,-2.502593e-03,-2.336484e-03,-2.166439e-03,-1.992794e-03,-1.815893e-03,-1.636084e-03,-1.453720e-03,
 -1.269157e-03,-1.082754e-03,-8.948748e-04,-7.058813e-04,-5.161385e-04,-3.260111e-04,-1.358634e-04, 5.394129e-05,
  2.430417e-04, 4.310790e-04, 6.176975e-04, 8.025453e-04, 9.852752e-04, 1.165545e-03, 1.343018e-03, 1.517365e-03,
  1.688263e-03, 1.855397e-03, 2.018459e-03, 2.177151e-03, 2.331185e-03, 2.480281e-03, 2.624170e-03, 2.762596e-03,
  2.895310e-03, 3.022078e-03, 3.142678e-03, 3.256899e-03, 3.364544e-03, 3.465428e-03, 3.559381e-03, 3.646247e-03,
  3.725881e-03, 3.798157e-03, 3.862959e-03, 3.920190e-03, 3.969763e-03, 4.011610e-03, 4.045676e-03, 4.071922e-03,
  4.090323e-03, 4.100870e-03, 4.103569e-03, 4.098440e-03, 4.085519e-03, 4.064857e-03, 4.036519e-03, 4.000585e-03,
  3.957147e-03, 3.906315e-03, 3.848210e-03, 3.782967e-03, 3.710736e-03, 3.631676e-03, 3.545963e-03, 3.453782e-03,
  3.355331e-03, 3.250819e-03, 3.140467e-03, 3.024506e-03, 2.903175e-03, 2.776725e-03, 2.645416e-03, 2.509514e-03,
  2.369295e-03, 2.225041e-03, 2.077044e-03, 1.925597e-03, 1.771004e-03, 1.613570e-03, 1.453606e-03, 1.291427e-03,
  1.127351e-03, 9.616985e-04, 7.947920e-04, 6.269552e-04, 4.585129e-04, 2.897895e-04, 1.211091e-04,-4.720523e-05,
 -2.148324e-04,-3.814537e-04,-5.467533e-04,-7.104190e-04,-8.721428e-04,-1.031621e-03,-1.188557e-03,-1.342657e-03,
 -1.493636e-03,-1.641216e-03,-1.785124e-03,-1.925098e-03,-2.060883e-03,-2.192233e-03,-2.318911e-03,-2.440689e-03,
 -2.557352e-03,-2.668693e-03,-2.774517e-03,-2.874639e-03,-2.968887e-03,-3.057101e-03,-3.139131e-03,-3.214841e-03,
 -3.284108e-03,-3.346821e-03,-3.402883e-03,-3.452207e-03,-3.494723e-03,-3.530372e-03,-3.559110e-03,-3.580904e-03,
 -3.595738e-03,-3.603605e-03,-3.604516e-03,-3.598491e-03,-3.585567e-03,-3.565791e-03,-3.539226e-03,-3.505945e-03,
 -3.466035e-03,-3.419596e-03,-3.366739e-03,-3.307588e-03,-3.242278e-03,-3.170955e-03,-3.093777e-03,-3.010912e-03,
 -2.922539e-03,-2.828847e-03,-2.730033e-03,-2.626306e-03,-2.517880e-03,-2.404981e-03,-2.287841e-03,-2.166699e-03,
 -2.041801e-03,-1.913401e-03,-1.781758e-03,-1.647134e-03,-1.509800e-03,-1.370027e-03,-1.228094e-03,-1.084280e-03,
 -9.388683e-04,-7.921431e-04,-6.443911e-04,-4.958997e-04,-3.469567e-04,-1.978498e-04,-4.886610e-05, 9.970862e-05,
  2.475903e-04, 3.944973e-04, 5.401506e-04, 6.842747e-04, 8.265981e-04, 9.668534e-04, 1.104778e-03, 1.240116e-03,
  1.372615e-03, 1.502032e-03, 1.628127e-03, 1.750670e-03, 1.869438e-03, 1.984217e-03, 2.094798e-03, 2.200985e-03,
  2.302588e-03, 2.399429e-03, 2.491337e-03, 2.578154e-03, 2.659730e-03, 2.735928e-03, 2.806618e-03, 2.871685e-03,
  2.931024e-03, 2.984539e-03, 3.032150e-03, 3.073785e-03, 3.109385e-03, 3.138903e-03, 3.162303e-03, 3.179563e-03,
  3.190670e-03, 3.195626e-03, 3.194441e-03, 3.187141e-03, 3.173760e-03, 3.154347e-03, 3.128959e-03, 3.097667e-03,
  3.060552e-03, 3.017706e-03, 2.969231e-03, 2.915242e-03, 2.855861e-03, 2.791222e-03, 2.721468e-03, 2.646751e-03,
  2.567233e-03, 2.483084e-03, 2.394482e-03, 2.301615e-03, 2.204674e-03, 2.103863e-03, 1.999389e-03, 1.891465e-03,
  1.780313e-03, 1.666157e-03, 1.549228e-03, 1.429761e-03, 1.307995e-03, 1.184173e-03, 1.058541e-03, 9.313474e-04,
  8.028419e-04, 6.732772e-04, 5.429066e-04, 4.119840e-04, 2.807636e-04, 1.494991e-04, 1.844352e-05,-1.121515e-04,
 -2.420360e-04,-3.709624e-04,-4.986858e-04,-6.249646e-04,-7.495606e-04,-8.722399e-04,-9.927732e-04,-1.110936e-03,
 -1.226509e-03,-1.339279e-03,-1.449039e-03,-1.555589e-03,-1.658734e-03,-1.758288e-03,-1.854073e-03,-1.945918e-03,
 -2.033659e-03,-2.117143e-03,-2.196224e-03,-2.270767e-03,-2.340643e-03,-2.405735e-03,-2.465935e-03,-2.521146e-03,
 -2.571277e-03,-2.616253e-03,-2.656004e-03,-2.690474e-03,-2.719614e-03,-2.743389e-03,-2.761772e-03,-2.774748e-03,
 -2.782312e-03,-2.784468e-03,-2.781232e-03,-2.772631e-03,-2.758700e-03,-2.739487e-03,-2.715048e-03,-2.685449e-03,
 -2.650766e-03,-2.611085e-03,-2.566501e-03,-2.517118e-03,-2.463049e-03,-2.404416e-03,-2.341349e-03,-2.273985e-03,
 -2.202472e-03,-2.126961e-03,-2.047614e-03,-1.964599e-03,-1.878088e-03,-1.788262e-03,-1.695306e-03,-1.599412e-03,
 -1.500776e-03,-1.399598e-03,-1.296083e-03,-1.190440e-03,-1.082881e-03,-9.736191e-04,-8.628734e-04,-7.508627e-04,
 -6.378081e-04,-5.239318e-04,-4.094568e-04,-2.946064e-04,-1.796038e-04,-6.467179e-05, 4.996794e-05, 1.640950e-04,
  2.774910e-04, 3.899394e-04, 5.012266e-04, 6.111421e-04, 7.194784e-04, 8.260324e-04, 9.306047e-04, 1.033001e-03,
  1.133031e-03, 1.230511e-03, 1.325261e-03, 1.417110e-03, 1.505890e-03, 1.591442e-03, 1.673612e-03, 1.752254e-03,
  1.827229e-03, 1.898407e-03, 1.965664e-03, 2.028885e-03, 2.087963e-03, 2.142799e-03, 2.193304e-03, 2.239395e-03,
  2.281002e-03, 2.318059e-03, 2.350514e-03, 2.378320e-03, 2.401441e-03, 2.419851e-03, 2.433532e-03, 2.442475e-03,
  2.446680e-03, 2.446159e-03, 2.440929e-03, 2.431019e-03, 2.416465e-03, 2.397315e-03, 2.373621e-03, 2.345447e-03,
  2.312866e-03, 2.275955e-03, 2.234805e-03, 2.189510e-03, 2.140173e-03, 2.086906e-03, 2.029827e-03, 1.969061e-03,
  1.904739e-03, 1.837000e-03, 1.765987e-03, 1.691851e-03, 1.614747e-03, 1.534835e-03, 1.452282e-03, 1.367256e-03,
  1.279933e-03, 1.190489e-03, 1.099106e-03, 1.005968e-03, 9.112629e-04, 8.151793e-04, 7.179086e-04, 6.196437e-04,
  5.205786e-04, 4.209081e-04, 3.208275e-04, 2.205322e-04, 1.202170e-04, 2.007629e-05,-7.969678e-05,-1.789105e-04,
 -2.773749e-04,-3.749024e-04,-4.713077e-04,-5.664086e-04,-6.600260e-04,-7.519844e-04,-8.421122e-04,-9.302420e-04,
 -1.016211e-03,-1.099861e-03,-1.181039e-03,-1.259598e-03,-1.335396e-03,-1.408296e-03,-1.478169e-03,-1.544892e-03,
 -1.608347e-03,-1.668425e-03,-1.725022e-03,-1.778042e-03,-1.827397e-03,-1.873005e-03,-1.914793e-03,-1.952696e-03,
 -1.986654e-03,-2.016617e-03,-2.042544e-03,-2.064400e-03,-2.082159e-03,-2.095802e-03,-2.105319e-03,-2.110709e-03,
 -2.111976e-03,-2.109136e-03,-2.102209e-03,-2.091226e-03,-2.076224e-03,-2.057248e-03,-2.034350e-03,-2.007590e-03,
 -1.977036e-03,-1.942762e-03,-1.904850e-03,-1.863387e-03,-1.818468e-03,-1.770193e-03,-1.718671e-03,-1.664013e-03,
 -1.606338e-03,-1.545771e-03,-1.482440e-03,-1.416479e-03,-1.348026e-03,-1.277226e-03,-1.204223e-03,-1.129169e-03,
 -1.052218e-03,-9.735258e-04,-8.932531e-04,-8.115616e-04,-7.286157e-04,-6.445813e-04,-5.596260e-04,-4.739182e-04,
 -3.876274e-04,-3.009234e-04,-2.139762e-04,-1.269556e-04,-4.003068e-05, 4.663009e-05, 1.328596e-04, 2.184921e-04,
  3.033637e-04, 3.873129e-04, 4.701803e-04, 5.518094e-04, 6.320467e-04, 7.107419e-04, 7.877487e-04, 8.629242e-04,
  9.361299e-04, 1.007232e-03, 1.076100e-03, 1.142610e-03, 1.206642e-03, 1.268082e-03, 1.326821e-03, 1.382755e-03,
  1.435789e-03, 1.485830e-03, 1.532794e-03, 1.576601e-03, 1.617180e-03, 1.654465e-03, 1.688397e-03, 1.718923e-03,
  1.745999e-03, 1.769585e-03, 1.789651e-03, 1.806171e-03, 1.819128e-03, 1.828512e-03, 1.834318e-03, 1.836551e-03,
  1.835220e-03, 1.830343e-03, 1.821944e-03, 1.810053e-03, 1.794708e-03, 1.775954e-03, 1.753840e-03, 1.728423e-03,
  1.699767e-03, 1.667940e-03, 1.633017e-03, 1.595080e-03, 1.554213e-03, 1.510510e-03, 1.464066e-03, 1.414983e-03,
  1.363367e-03, 1.309330e-03, 1.252985e-03, 1.194454e-03, 1.133857e-03, 1.071323e-03, 1.006979e-03, 9.409599e-04,
  8.733999e-04, 8.044370e-04, 7.342110e-04, 6.628640e-04, 5.905393e-04, 5.173816e-04, 4.435366e-04, 3.691510e-04,
  2.943715e-04, 2.193454e-04, 1.442195e-04, 6.914038e-05,-5.746067e-06,-8.029500e-05,-1.543628e-04,-2.278074e-04,
 -3.004886e-04,-3.722682e-04,-4.430102e-04,-5.125816e-04,-5.808517e-04,-6.476932e-04,-7.129822e-04,-7.765982e-04,
 -8.384243e-04,-8.983479e-04,-9.562604e-04,-1.012058e-03,-1.065640e-03,-1.116912e-03,-1.165785e-03,-1.212172e-03,
 -1.255996e-03,-1.297180e-03,-1.335656e-03,-1.371361e-03,-1.404238e-03,-1.434233e-03,-1.461301e-03,-1.485402e-03,
 -1.506501e-03,-1.524570e-03,-1.539587e-03,-1.551537e-03,-1.560407e-03,-1.566195e-03,-1.568903e-03,-1.568538e-03,
 -1.565114e-03,-1.558651e-03,-1.549175e-03,-1.536717e-03,-1.521315e-03,-1.503010e-03,-1.481851e-03,-1.457892e-03,
 -1.431191e-03,-1.401812e-03,-1.369824e-03,-1.335300e-03,-1.298320e-03,-1.258965e-03,-1.217322e-03,-1.173483e-03,
 -1.127542e-03,-1.079599e-03,-1.029755e-03,-9.781150e-04,-9.247886e-04,-8.698866e-04,-8.135229e-04,-7.558139e-04,
 -6.968777e-04,-6.368348e-04,-5.758071e-04,-5.139177e-04,-4.512913e-04,-3.880530e-04,-3.243291e-04,-2.602458e-04,
 -1.959297e-04,-1.315074e-04,-6.710486e-05,-2.847772e-06, 6.113918e-05, 1.247323e-04, 1.878094e-04, 2.502494e-04,
  3.119334e-04, 3.727444e-04, 4.325675e-04, 4.912902e-04, 5.488029e-04, 6.049985e-04, 6.597733e-04, 7.130264e-04,
  7.646607e-04, 8.145825e-04, 8.627018e-04, 9.089328e-04, 9.531934e-04, 9.954059e-04, 1.035497e-03, 1.073398e-03,
  1.109043e-03, 1.142375e-03, 1.173337e-03, 1.201880e-03, 1.227959e-03, 1.251534e-03, 1.272569e-03, 1.291035e-03,
  1.306908e-03, 1.320167e-03, 1.330798e-03, 1.338793e-03, 1.344147e-03, 1.346861e-03, 1.346943e-03, 1.344403e-03,
  1.339258e-03, 1.331530e-03, 1.321245e-03, 1.308435e-03, 1.293136e-03, 1.275390e-03, 1.255240e-03, 1.232739e-03,
  1.207939e-03, 1.180901e-03, 1.151686e-03, 1.120361e-03, 1.086998e-03, 1.051670e-03, 1.014455e-03, 9.754340e-04,
  9.346921e-04, 8.923161e-04, 8.483962e-04, 8.030252e-04, 7.562983e-04, 7.083127e-04, 6.591680e-04, 6.089654e-04,
  5.578077e-04, 5.057993e-04, 4.530455e-04, 3.996530e-04, 3.457288e-04, 2.913808e-04, 2.367170e-04, 1.818459e-04,
  1.268755e-04, 7.191370e-05, 1.706795e-05,-3.755509e-05,-9.184968e-05,-1.457112e-04,-1.990362e-04,-2.517231e-04,
 -3.036716e-04,-3.547837e-04,-4.049631e-04,-4.541161e-04,-5.021512e-04,-5.489796e-04,-5.945153e-04,-6.386751e-04,
 -6.813790e-04,-7.225502e-04,-7.621152e-04,-8.000039e-04,-8.361500e-04,-8.704909e-04,-9.029675e-04,-9.335251e-04,
 -9.621126e-04,-9.886832e-04,-1.013194e-03,-1.035607e-03,-1.055888e-03,-1.074007e-03,-1.089939e-03,-1.103662e-03,
 -1.115160e-03,-1.124421e-03,-1.131436e-03,-1.136204e-03,-1.138724e-03,-1.139002e-03,-1.137049e-03,-1.132878e-03,
 -1.126508e-03,-1.117962e-03,-1.107266e-03,-1.094452e-03,-1.079554e-03,-1.062611e-03,-1.043667e-03,-1.022767e-03,
 -9.999613e-04,-9.753043e-04,-9.488524e-04,-9.206661e-04,-8.908084e-04,-8.593460e-04,-8.263478e-04,-7.918857e-04,
 -7.560342e-04,-7.188701e-04,-6.804723e-04,-6.409219e-04,-6.003018e-04,-5.586967e-04,-5.161928e-04,-4.728775e-04,
 -4.288397e-04,-3.841691e-04,-3.389562e-04,-2.932923e-04,-2.472689e-04,-2.009780e-04,-1.545117e-04,-1.079618e-04,
 -6.142011e-05,-1.497778e-05, 3.127458e-05, 7.724716e-05, 1.228511e-04, 1.679988e-04, 2.126038e-04, 2.565811e-04,
  2.998476e-04, 3.423218e-04, 3.839240e-04, 4.245768e-04, 4.642051e-04, 5.027358e-04, 5.400987e-04, 5.762261e-04,
  6.110528e-04, 6.445169e-04, 6.765590e-04, 7.071233e-04, 7.361566e-04, 7.636095e-04, 7.894355e-04, 8.135917e-04,
  8.360388e-04, 8.567408e-04, 8.756655e-04, 8.927842e-04, 9.080721e-04, 9.215079e-04, 9.330740e-04, 9.427568e-04,
  9.505463e-04, 9.564363e-04, 9.604243e-04, 9.625118e-04, 9.627037e-04, 9.610087e-04, 9.574393e-04, 9.520116e-04,
  9.447451e-04, 9.356630e-04, 9.247918e-04, 9.121616e-04, 8.978056e-04, 8.817604e-04, 8.640656e-04, 8.447640e-04,
  8.239012e-04, 8.015258e-04, 7.776891e-04, 7.524448e-04, 7.258495e-04, 6.979620e-04, 6.688431e-04, 6.385563e-04,
  6.071664e-04, 5.747407e-04, 5.413479e-04, 5.070581e-04, 4.719432e-04, 4.360761e-04, 3.995309e-04, 3.623828e-04,
  3.247076e-04, 2.865820e-04, 2.480830e-04, 2.092880e-04, 1.702748e-04, 1.311210e-04, 9.190422e-05, 5.270182e-05,
  1.359075e-05,-2.535263e-05,-6.405263e-05,-1.024344e-04,-1.404242e-04,-1.779491e-04,-2.149380e-04,-2.513206e-04,
 -2.870285e-04,-3.219948e-04,-3.561547e-04,-3.894449e-04,-4.218042e-04,-4.531739e-04,-4.834970e-04,-5.127193e-04,
 -5.407888e-04,-5.676561e-04,-5.932743e-04,-6.175993e-04,-6.405898e-04,-6.622073e-04,-6.824160e-04,-7.011834e-04,
 -7.184798e-04,-7.342786e-04,-7.485561e-04,-7.612920e-04,-7.724689e-04,-7.820728e-04,-7.900927e-04,-7.965207e-04,
 -8.013523e-04,-8.045860e-04,-8.062236e-04,-8.062698e-04,-8.047326e-04,-8.016231e-04,-7.969554e-04,-7.907465e-04,
 -7.830164e-04,-7.737882e-04,-7.630875e-04,-7.509430e-04,-7.373858e-04,-7.224499e-04,-7.061716e-04,-6.885898e-04,
 -6.697459e-04,-6.496834e-04,-6.284479e-04,-6.060872e-04,-5.826513e-04,-5.581916e-04,-5.327617e-04,-5.064166e-04,
 -4.792128e-04,-4.512083e-04,-4.224625e-04,-3.930357e-04,-3.629894e-04,-3.323860e-04,-3.012886e-04,-2.697612e-04,
 -2.378679e-04,-2.056735e-04,-1.732430e-04,-1.406416e-04,-1.079344e-04,-7.518639e-05,-4.246230e-05,-9.826536e-06,
  2.265704e-05, 5.492518e-05, 8.691538e-05, 1.185660e-04, 1.498165e-04, 1.806072e-04, 2.108798e-04, 2.405775e-04,
  2.696444e-04, 2.980267e-04, 3.256720e-04, 3.525295e-04, 3.785504e-04, 4.036877e-04, 4.278965e-04, 4.511338e-04,
  4.733589e-04, 4.945333e-04, 5.146207e-04, 5.335871e-04, 5.514009e-04, 5.680332e-04, 5.834573e-04, 5.976490e-04,
  6.105869e-04, 6.222520e-04, 6.326280e-04, 6.417012e-04, 6.494606e-04, 6.558977e-04, 6.610069e-04, 6.647850e-04,
  6.672317e-04, 6.683492e-04, 6.681423e-04, 6.666183e-04, 6.637874e-04, 6.596620e-04, 6.542572e-04, 6.475903e-04,
  6.396814e-04, 6.305526e-04, 6.202284e-04, 6.087357e-04, 5.961033e-04, 5.823623e-04, 5.675458e-04, 5.516887e-04,
  5.348281e-04, 5.170025e-04, 4.982524e-04, 4.786198e-04, 4.581482e-04, 4.368826e-04, 4.148694e-04, 3.921560e-04,
  3.687911e-04, 3.448244e-04, 3.203066e-04, 2.952892e-04, 2.698243e-04, 2.439646e-04, 2.177636e-04, 1.912748e-04,
  1.645522e-04, 1.376500e-04, 1.106224e-04, 8.352356e-05, 5.640747e-05, 2.932793e-05, 2.338329e-06,-2.450838e-05,
 -5.115981e-05,-7.756426e-05,-1.036708e-04,-1.294293e-04,-1.547907e-04,-1.797069e-04,-2.041309e-04,-2.280171e-04,
 -2.513210e-04,-2.739997e-04,-2.960117e-04,-3.173169e-04,-3.378769e-04,-3.576552e-04,-3.766167e-04,-3.947284e-04,
 -4.119590e-04,-4.282791e-04,-4.436613e-04,-4.580803e-04,-4.715129e-04,-4.839376e-04,-4.953354e-04,-5.056894e-04,
 -5.149847e-04,-5.232087e-04,-5.303509e-04,-5.364031e-04,-5.413593e-04,-5.452157e-04,-5.479706e-04,-5.496247e-04,
 -5.501806e-04,-5.496434e-04,-5.480202e-04,-5.453200e-04,-5.415543e-04,-5.367363e-04,-5.308814e-04,-5.240069e-04,
 -5.161322e-04,-5.072783e-04,-4.974683e-04,-4.867268e-04,-4.750805e-04,-4.625573e-04,-4.491871e-04,-4.350010e-04,
 -4.200317e-04,-4.043134e-04,-3.878813e-04,-3.707721e-04,-3.530235e-04,-3.346743e-04,-3.157643e-04,-2.963341e-04,
 -2.764254e-04,-2.560802e-04,-2.353415e-04,-2.142526e-04,-1.928574e-04,-1.712001e-04,-1.493252e-04,-1.272775e-04,
 -1.051016e-04,-8.284249e-05,-6.054476e-05,-3.825299e-05,-1.601147e-05, 6.135867e-06, 2.814550e-05, 4.997445e-05,
  7.158029e-05, 9.292133e-05, 1.139566e-04, 1.346460e-04, 1.549502e-04, 1.748311e-04, 1.942515e-04, 2.131753e-04,
  2.315677e-04, 2.493951e-04, 2.666251e-04, 2.832269e-04, 2.991709e-04, 3.144291e-04, 3.289750e-04, 3.427837e-04,
  3.558318e-04, 3.680977e-04, 3.795613e-04, 3.902043e-04, 4.000103e-04, 4.089644e-04, 4.170535e-04, 4.242665e-04,
  4.305940e-04, 4.360284e-04, 4.405639e-04, 4.441965e-04, 4.469242e-04, 4.487466e-04, 4.496653e-04, 4.496835e-04,
  4.488064e-04, 4.470407e-04, 4.443951e-04, 4.408798e-04, 4.365067e-04, 4.312894e-04, 4.252433e-04, 4.183849e-04,
  4.107327e-04, 4.023064e-04, 3.931273e-04, 3.832178e-04, 3.726020e-04, 3.613051e-04, 3.493534e-04, 3.367746e-04,
  3.235972e-04, 3.098511e-04, 2.955669e-04, 2.807762e-04, 2.655114e-04, 2.498055e-04, 2.336926e-04, 2.172071e-04,
  2.003840e-04, 1.832589e-04, 1.658675e-04, 1.482463e-04, 1.304316e-04, 1.124602e-04, 9.436870e-05, 7.619406e-05,
  5.797299e-05, 3.974213e-05, 2.153795e-05, 3.396622e-06,-1.464598e-05,-3.255440e-05,-5.029364e-05,-6.782927e-05,
 -8.512742e-05,-1.021549e-04,-1.188793e-04,-1.352690e-04,-1.512931e-04,-1.669217e-04,-1.821260e-04,-1.968779e-04,
 -2.111507e-04,-2.249186e-04,-2.381569e-04,-2.508424e-04,-2.629529e-04,-2.744674e-04,-2.853665e-04,-2.956319e-04,
 -3.052468e-04,-3.141958e-04,-3.224648e-04,-3.300413e-04,-3.369141e-04,-3.430736e-04,-3.485116e-04,-3.532215e-04,
 -3.571981e-04,-3.604377e-04,-3.629381e-04,-3.646987e-04,-3.657202e-04,-3.660049e-04,-3.655566e-04,-3.643804e-04,
 -3.624829e-04,-3.598722e-04,-3.565577e-04,-3.525500e-04,-3.478614e-04,-3.425051e-04,-3.364959e-04,-3.298494e-04,
 -3.225829e-04,-3.147145e-04,-3.062634e-04,-2.972501e-04,-2.876959e-04,-2.776230e-04,-2.670547e-04,-2.560151e-04,
 -2.445290e-04,-2.326222e-04,-2.203209e-04,-2.076520e-04,-1.946432e-04,-1.813225e-04,-1.677184e-04,-1.538598e-04,
 -1.397761e-04,-1.254967e-04,-1.110514e-04,-9.647027e-05,-8.178318e-05,-6.702025e-05,-5.221149e-05,-3.738688e-05,
 -2.257622e-05,-7.809115e-06, 6.885088e-06, 2.147736e-05, 3.593906e-05, 5.024195e-05, 6.435830e-05, 7.826091e-05,
  9.192318e-05, 1.053191e-04, 1.184235e-04, 1.312117e-04, 1.436599e-04, 1.557453e-04, 1.674458e-04, 1.787401e-04,
  1.896081e-04, 2.000304e-04, 2.099888e-04, 2.194662e-04, 2.284462e-04, 2.369140e-04, 2.448556e-04, 2.522581e-04,
  2.591099e-04, 2.654007e-04, 2.711210e-04, 2.762629e-04, 2.808194e-04, 2.847850e-04, 2.881552e-04, 2.909268e-04,
  2.930978e-04, 2.946675e-04, 2.956364e-04, 2.960061e-04, 2.957794e-04, 2.949604e-04, 2.935543e-04, 2.915674e-04,
  2.890073e-04, 2.858825e-04, 2.822028e-04, 2.779787e-04, 2.732222e-04, 2.679460e-04, 2.621637e-04, 2.558902e-04,
  2.491409e-04, 2.419323e-04, 2.342817e-04, 2.262071e-04, 2.177272e-04, 2.088617e-04, 1.996306e-04, 1.900548e-04,
  1.801555e-04, 1.699546e-04, 1.594745e-04, 1.487379e-04, 1.377680e-04, 1.265883e-04, 1.152225e-04, 1.036946e-04,
  9.202877e-05, 8.024933e-05, 6.838067e-05, 5.644720e-05, 4.447332e-05, 3.248338e-05, 2.050160e-05, 8.552036e-06,
 -3.341456e-06,-1.515528e-05,-2.686615e-05,-3.845112e-05,-4.988765e-05,-6.115360e-05,-7.222735e-05,-8.308778e-05,
 -9.371432e-05,-1.040870e-04,-1.141865e-04,-1.239942e-04,-1.334920e-04,-1.426628e-04,-1.514901e-04,-1.599582e-04,
 -1.680522e-04,-1.757582e-04,-1.830630e-04,-1.899543e-04,-1.964209e-04,-2.024522e-04,-2.080388e-04,-2.131722e-04,
 -2.178448e-04,-2.220501e-04,-2.257824e-04,-2.290371e-04,-2.318106e-04,-2.341003e-04,-2.359045e-04,-2.372226e-04,
 -2.380549e-04,-2.384028e-04,-2.382685e-04,-2.376553e-04,-2.365674e-04,-2.350099e-04,-2.329888e-04,-2.305111e-04,
 -2.275846e-04,-2.242179e-04,-2.204207e-04,-2.162032e-04,-2.115765e-04,-2.065525e-04,-2.011438e-04,-1.953636e-04,
 -1.892261e-04,-1.827456e-04,-1.759376e-04,-1.688176e-04,-1.614021e-04,-1.537078e-04,-1.457520e-04,-1.375524e-04,
 -1.291271e-04,-1.204943e-04,-1.116730e-04,-1.026820e-04,-9.354062e-05,-8.426816e-05,-7.488419e-05,-6.540837e-05,
 -5.586038e-05,-4.625998e-05,-3.662687e-05,-2.698071e-05,-1.734107e-05,-7.727368e-06, 1.841130e-06, 1.134538e-05,
  2.076659e-05, 3.008623e-05, 3.928613e-05, 4.834844e-05, 5.725571e-05, 6.599092e-05, 7.453749e-05, 8.287934e-05,
  9.100089e-05, 9.888711e-05, 1.065235e-04, 1.138963e-04, 1.209922e-04, 1.277986e-04, 1.343035e-04, 1.404957e-04,
  1.463647e-04, 1.519006e-04, 1.570943e-04, 1.619375e-04, 1.664226e-04, 1.705428e-04, 1.742920e-04, 1.776651e-04,
  1.806575e-04, 1.832657e-04, 1.854867e-04, 1.873185e-04, 1.887599e-04, 1.898104e-04, 1.904705e-04, 1.907411e-04,
  1.906243e-04, 1.901227e-04, 1.892398e-04, 1.879798e-04, 1.863476e-04, 1.843490e-04, 1.819902e-04, 1.792783e-04,
  1.762211e-04, 1.728269e-04, 1.691049e-04, 1.650645e-04, 1.607160e-04, 1.560701e-04, 1.511383e-04, 1.459322e-04,
  1.404642e-04, 1.347469e-04, 1.287937e-04, 1.226180e-04, 1.162338e-04, 1.096553e-04, 1.028972e-04, 9.597419e-05,
  8.890142e-05, 8.169417e-05, 7.436791e-05, 6.693825e-05, 5.942089e-05, 5.183166e-05, 4.418637e-05, 3.650090e-05,
  2.879108e-05, 2.107268e-05, 1.336142e-05, 5.672890e-06,-1.977480e-06,-9.574417e-06,-1.710286e-05,-2.454799e-05,
 -3.189523e-05,-3.913032e-05,-4.623931e-05,-5.320859e-05,-6.002491e-05,-6.667545e-05,-7.314778e-05,-7.942992e-05,
 -8.551034e-05,-9.137802e-05,-9.702243e-05,-1.024335e-04,-1.076019e-04,-1.125186e-04,-1.171752e-04,-1.215640e-04,
 -1.256779e-04,-1.295102e-04,-1.330550e-04,-1.363070e-04,-1.392614e-04,-1.419142e-04,-1.442620e-04,-1.463019e-04,
 -1.480319e-04,-1.494504e-04,-1.505566e-04,-1.513502e-04,-1.518317e-04,-1.520021e-04,-1.518632e-04,-1.514171e-04,
 -1.506668e-04,-1.496158e-04,-1.482683e-04,-1.466288e-04,-1.447026e-04,-1.424955e-04,-1.400138e-04,-1.372643e-04,
 -1.342545e-04,-1.309920e-04,-1.274852e-04,-1.237429e-04,-1.197740e-04,-1.155883e-04,-1.111956e-04,-1.066063e-04,
 -1.018309e-04,-9.688032e-05,-9.176585e-05,-8.649894e-05,-8.109130e-05,-7.555486e-05,-6.990171e-05,-6.414412e-05,
 -5.829450e-05,-5.236534e-05,-4.636923e-05,-4.031881e-05,-3.422674e-05,-2.810570e-05,-2.196834e-05,-1.582724e-05,
 -9.694936e-06,-3.583843e-06, 2.493740e-06, 8.525664e-06, 1.449995e-05, 2.040482e-05, 2.622871e-05, 3.196031e-05,
  3.758854e-05, 4.310264e-05, 4.849213e-05, 5.374686e-05, 5.885703e-05, 6.381319e-05, 6.860625e-05, 7.322755e-05,
  7.766880e-05, 8.192216e-05, 8.598020e-05, 8.983597e-05, 9.348293e-05, 9.691506e-05, 1.001268e-04, 1.031130e-04,
  1.058692e-04, 1.083912e-04, 1.106755e-04, 1.127190e-04, 1.145191e-04, 1.160738e-04, 1.173815e-04, 1.184413e-04,
  1.192526e-04, 1.198155e-04, 1.201303e-04, 1.201983e-04, 1.200208e-04, 1.195999e-04, 1.189380e-04, 1.180381e-04,
  1.169038e-04, 1.155387e-04, 1.139473e-04, 1.121343e-04, 1.101050e-04, 1.078648e-04, 1.054198e-04, 1.027764e-04,
  9.994127e-05, 9.692147e-05, 9.372443e-05, 9.035786e-05, 8.682978e-05, 8.314847e-05, 7.932247e-05, 7.536057e-05,
  7.127178e-05, 6.706530e-05, 6.275051e-05, 5.833695e-05, 5.383430e-05, 4.925236e-05, 4.460102e-05, 3.989025e-05,
  3.513007e-05, 3.033054e-05, 2.550173e-05, 2.065371e-05, 1.579650e-05, 1.094010e-05, 6.094426e-06, 1.269300e-06,
 -3.525552e-06,-8.280538e-06,-1.298621e-05,-1.763328e-05,-2.221266e-05,-2.671543e-05,-3.113292e-05,-3.545667e-05,
 -3.967848e-05,-4.379041e-05,-4.778480e-05,-5.165429e-05,-5.539180e-05,-5.899060e-05,-6.244427e-05,-6.574673e-05,
 -6.889226e-05,-7.187549e-05,-7.469144e-05,-7.733547e-05,-7.980337e-05,-8.209127e-05,-8.419572e-05,-8.611368e-05,
 -8.784250e-05,-8.937992e-05,-9.072412e-05,-9.187367e-05,-9.282754e-05,-9.358513e-05,-9.414622e-05,-9.451102e-05,
 -9.468013e-05,-9.465455e-05,-9.443565e-05,-9.402523e-05,-9.342543e-05,-9.263879e-05,-9.166820e-05,-9.051692e-05,
 -8.918854e-05,-8.768701e-05,-8.601661e-05,-8.418190e-05,-8.218779e-05,-8.003947e-05,-7.774239e-05,-7.530229e-05,
 -7.272516e-05,-7.001724e-05,-6.718497e-05,-6.423501e-05,-6.117424e-05,-5.800969e-05,-5.474858e-05,-5.139824e-05,
 -4.796618e-05,-4.446000e-05,-4.088740e-05,-3.725617e-05,-3.357417e-05,-2.984929e-05,-2.608949e-05,-2.230271e-05,
 -1.849691e-05,-1.468003e-05,-1.085999e-05,-7.044638e-06,-3.241777e-06, 5.408758e-07, 4.295698e-06, 8.015176e-06,
  1.169192e-05, 1.531868e-05, 1.888836e-05, 2.239404e-05, 2.582894e-05, 2.918653e-05, 3.246044e-05, 3.564454e-05,
  3.873291e-05, 4.171988e-05, 4.460003e-05, 4.736818e-05, 5.001943e-05, 5.254916e-05, 5.495301e-05, 5.722694e-05,
  5.936718e-05, 6.137027e-05, 6.323305e-05, 6.495269e-05, 6.652665e-05, 6.795273e-05, 6.922902e-05, 7.035397e-05,
  7.132632e-05, 7.214514e-05, 7.280984e-05, 7.332014e-05, 7.367607e-05, 7.387798e-05, 7.392656e-05, 7.382278e-05,
  7.356793e-05, 7.316361e-05, 7.261169e-05, 7.191437e-05, 7.107409e-05, 7.009361e-05, 6.897594e-05, 6.772434e-05,
  6.634234e-05, 6.483370e-05, 6.320244e-05, 6.145278e-05, 5.958916e-05, 5.761623e-05, 5.553883e-05, 5.336197e-05,
  5.109085e-05, 4.873082e-05, 4.628736e-05, 4.376611e-05, 4.117282e-05, 3.851333e-05, 3.579360e-05, 3.301967e-05,
  3.019763e-05, 2.733364e-05, 2.443392e-05, 2.150468e-05, 1.855218e-05, 1.558267e-05, 1.260240e-05, 9.617576e-06,
  6.634399e-06, 3.659005e-06, 6.974735e-07,-2.244187e-06,-5.160051e-06,-8.044288e-06,-1.089118e-05,-1.369511e-05,
 -1.645061e-05,-1.915235e-05,-2.179512e-05,-2.437391e-05,-2.688384e-05,-2.932024e-05,-3.167860e-05,-3.395462e-05,
 -3.614419e-05,-3.824341e-05,-4.024860e-05,-4.215630e-05,-4.396326e-05,-4.566649e-05,-4.726321e-05,-4.875090e-05,
 -5.012726e-05,-5.139027e-05,-5.253812e-05,-5.356928e-05,-5.448247e-05,-5.527664e-05,-5.595102e-05,-5.650509e-05,
 -5.693856e-05,-5.725142e-05,-5.744389e-05,-5.751645e-05,-5.746981e-05,-5.730495e-05,-5.702306e-05,-5.662556e-05,
 -5.611413e-05,-5.549065e-05,-5.475722e-05,-5.391617e-05,-5.297000e-05,-5.192145e-05,-5.077344e-05,-4.952906e-05,
 -4.819158e-05,-4.676446e-05,-4.525131e-05,-4.365588e-05,-4.198208e-05,-4.023395e-05,-3.841564e-05,-3.653144e-05,
 -3.458572e-05,-3.258298e-05,-3.052777e-05,-2.842474e-05,-2.627859e-05,-2.409408e-05,-2.187603e-05,-1.962926e-05,
 -1.735866e-05,-1.506910e-05,-1.276546e-05,-1.045262e-05,-8.135450e-06,-5.818777e-06,-3.507402e-06,-1.206079e-06,
  1.080495e-06, 3.347685e-06, 5.590934e-06, 7.805764e-06, 9.987792e-06, 1.213273e-05, 1.423641e-05, 1.629476e-05,
  1.830386e-05, 2.025989e-05, 2.215919e-05, 2.399823e-05, 2.577365e-05, 2.748223e-05, 2.912091e-05, 3.068682e-05,
  3.217724e-05, 3.358964e-05, 3.492165e-05, 3.617112e-05, 3.733606e-05, 3.841467e-05, 3.940536e-05, 4.030672e-05,
  4.111754e-05, 4.183682e-05, 4.246373e-05, 4.299766e-05, 4.343820e-05, 4.378513e-05, 4.403842e-05, 4.419824e-05,
  4.426496e-05, 4.423913e-05, 4.412151e-05, 4.391301e-05, 4.361475e-05, 4.322803e-05, 4.275431e-05, 4.219523e-05,
  4.155258e-05, 4.082834e-05, 4.002462e-05, 3.914369e-05, 3.818796e-05, 3.715998e-05, 3.606244e-05, 3.489814e-05,
  3.367001e-05, 3.238109e-05, 3.103451e-05, 2.963353e-05, 2.818146e-05, 2.668171e-05, 2.513777e-05, 2.355319e-05,
  2.193158e-05, 2.027660e-05, 1.859195e-05, 1.688136e-05, 1.514859e-05, 1.339744e-05, 1.163168e-05, 9.855110e-06,
  8.071521e-06, 6.284684e-06, 4.498351e-06, 2.716245e-06, 9.420526e-07,-8.205833e-07,-2.568072e-06,-4.296881e-06,
 -6.003543e-06,-7.684663e-06,-9.336926e-06,-1.095710e-05,-1.254205e-05,-1.408872e-05,-1.559419e-05,-1.705561e-05,
 -1.847027e-05,-1.983558e-05,-2.114905e-05,-2.240833e-05,-2.361121e-05,-2.475560e-05,-2.583956e-05,-2.686128e-05,
 -2.781909e-05,-2.871150e-05,-2.953712e-05,-3.029474e-05,-3.098330e-05,-3.160188e-05,-3.214974e-05,-3.262625e-05,
 -3.303098e-05,-3.336363e-05,-3.362404e-05,-3.381224e-05,-3.392838e-05,-3.397277e-05,-3.394587e-05,-3.384828e-05,
 -3.368076e-05,-3.344418e-05,-3.313959e-05,-3.276813e-05,-3.233110e-05,-3.182993e-05,-3.126616e-05,-3.064145e-05,
 -2.995758e-05,-2.921644e-05,-2.842004e-05,-2.757045e-05,-2.666989e-05,-2.572063e-05,-2.472504e-05,-2.368556e-05,
 -2.260472e-05,-2.148510e-05,-2.032936e-05,-1.914021e-05,-1.792038e-05,-1.667269e-05,-1.539998e-05,-1.410510e-05,
 -1.279094e-05,-1.146043e-05,-1.011648e-05,-8.762011e-06,-7.399961e-06,-6.033248e-06,-4.664779e-06,-3.297446e-06,
 -1.934112e-06,-5.776122e-07, 7.692540e-07, 2.103730e-06, 3.423107e-06, 4.724728e-06, 6.005994e-06, 7.264368e-06,
  8.497382e-06, 9.702641e-06, 1.087783e-05, 1.202070e-05, 1.312910e-05, 1.420098e-05, 1.523437e-05, 1.622738e-05,
  1.717824e-05, 1.808529e-05, 1.894695e-05, 1.976178e-05, 2.052841e-05, 2.124562e-05, 2.191227e-05, 2.252738e-05,
  2.309004e-05, 2.359948e-05, 2.405505e-05, 2.445621e-05, 2.480255e-05, 2.509377e-05, 2.532969e-05, 2.551025e-05,
  2.563551e-05, 2.570564e-05, 2.572092e-05, 2.568178e-05, 2.558870e-05, 2.544233e-05, 2.524340e-05, 2.499273e-05,
  2.469128e-05, 2.434007e-05, 2.394026e-05, 2.349307e-05, 2.299983e-05, 2.246194e-05, 2.188089e-05, 2.125826e-05,
  2.059571e-05, 1.989494e-05, 1.915774e-05, 1.838598e-05, 1.758155e-05, 1.674641e-05, 1.588259e-05, 1.499214e-05,
  1.407716e-05, 1.313979e-05, 1.218218e-05, 1.120653e-05, 1.021504e-05, 9.209961e-06, 8.193515e-06, 7.167951e-06,
  6.135517e-06, 5.098456e-06, 4.059004e-06, 3.019385e-06, 1.981805e-06, 9.484493e-07,-7.852493e-08,-1.096990e-06,
 -2.104852e-06,-3.100059e-06,-4.080601e-06,-5.044512e-06,-5.989883e-06,-6.914854e-06,-7.817626e-06,-8.696461e-06,
 -9.549686e-06,-1.037570e-05,-1.117295e-05,-1.194000e-05,-1.267545e-05,-1.337799e-05,-1.404640e-05,-1.467954e-05,
 -1.527634e-05,-1.583583e-05,-1.635713e-05,-1.683942e-05,-1.728202e-05,-1.768429e-05,-1.804571e-05,-1.836585e-05,
 -1.864435e-05,-1.888097e-05,-1.907554e-05,-1.922799e-05,-1.933834e-05,-1.940671e-05,-1.943328e-05,-1.941835e-05,
 -1.936229e-05,-1.926555e-05,-1.912867e-05,-1.895228e-05,-1.873707e-05,-1.848383e-05,-1.819341e-05,-1.786672e-05,
 -1.750478e-05,-1.710864e-05,-1.667942e-05,-1.621833e-05,-1.572660e-05,-1.520555e-05,-1.465651e-05,-1.408091e-05,
 -1.348019e-05,-1.285585e-05,-1.220940e-05,-1.154243e-05,-1.085652e-05,-1.015330e-05,-9.434418e-06,-8.701544e-06,
 -7.956362e-06,-7.200570e-06,-6.435873e-06,-5.663985e-06,-4.886618e-06,-4.105482e-06,-3.322285e-06,-2.538720e-06,
 -1.756471e-06,-9.772037e-07,-2.025645e-07, 5.658242e-07, 1.326366e-06, 2.077496e-06, 2.817680e-06, 3.545421e-06,
  4.259262e-06, 4.957786e-06, 5.639622e-06, 6.303446e-06, 6.947982e-06, 7.572009e-06, 8.174357e-06, 8.753914e-06,
  9.309627e-06, 9.840500e-06, 1.034560e-05, 1.082406e-05, 1.127508e-05, 1.169791e-05, 1.209189e-05, 1.245641e-05,
  1.279093e-05, 1.309499e-05, 1.336819e-05, 1.361020e-05, 1.382077e-05, 1.399971e-05, 1.414690e-05, 1.426230e-05,
  1.434592e-05, 1.439785e-05, 1.441826e-05, 1.440737e-05, 1.436546e-05, 1.429289e-05, 1.419009e-05, 1.405752e-05,
  1.389573e-05, 1.370532e-05, 1.348694e-05, 1.324131e-05, 1.296919e-05, 1.267139e-05, 1.234878e-05, 1.200227e-05,
  1.163281e-05, 1.124141e-05, 1.082908e-05, 1.039691e-05, 9.946006e-06, 9.477499e-06, 8.992559e-06, 8.492376e-06,
  7.978165e-06, 7.451163e-06, 6.912621e-06, 6.363807e-06, 5.805998e-06, 5.240483e-06, 4.668556e-06, 4.091511e-06,
  3.510647e-06, 2.927256e-06, 2.342628e-06, 1.758041e-06, 1.174767e-06, 5.940602e-07, 1.716030e-08,-5.547119e-07,
 -1.120357e-06,-1.678600e-06,-2.228290e-06,-2.768306e-06,-3.297559e-06,-3.814990e-06,-4.319576e-06,-4.810331e-06,
 -5.286307e-06,-5.746597e-06,-6.190335e-06,-6.616699e-06,-7.024912e-06,-7.414244e-06,-7.784011e-06,-8.133578e-06,
 -8.462361e-06,-8.769825e-06,-9.055485e-06,-9.318912e-06,-9.559724e-06,-9.777596e-06,-9.972254e-06,-1.014348e-05,
 -1.029110e-05,-1.041500e-05,-1.051513e-05,-1.059147e-05,-1.064407e-05,-1.067303e-05,-1.067848e-05,-1.066062e-05,
 -1.061971e-05,-1.055603e-05,-1.046993e-05,-1.036180e-05,-1.023206e-05,-1.008120e-05,-9.909735e-06,-9.718221e-06,
 -9.507259e-06,-9.277486e-06,-9.029574e-06,-8.764230e-06,-8.482191e-06,-8.184226e-06,-7.871133e-06,-7.543735e-06,
 -7.202880e-06,-6.849437e-06,-6.484297e-06,-6.108368e-06,-5.722574e-06,-5.327852e-06,-4.925152e-06,-4.515431e-06,
 -4.099655e-06,-3.678795e-06,-3.253824e-06,-2.825714e-06,-2.395438e-06,-1.963964e-06,-1.532254e-06,-1.101263e-06,
 -6.719344e-07,-2.452011e-07, 1.780188e-07, 5.968229e-07, 1.010326e-06, 1.417664e-06, 1.817993e-06, 2.210491e-06,
  2.594362e-06, 2.968837e-06, 3.333173e-06, 3.686657e-06, 4.028606e-06, 4.358368e-06, 4.675326e-06, 4.978894e-06,
  5.268524e-06, 5.543700e-06, 5.803948e-06, 6.048826e-06, 6.277934e-06, 6.490908e-06, 6.687424e-06, 6.867200e-06,
  7.029989e-06, 7.175588e-06, 7.303832e-06, 7.414597e-06, 7.507799e-06, 7.583394e-06, 7.641377e-06, 7.681782e-06,
  7.704683e-06, 7.710192e-06, 7.698459e-06, 7.669670e-06, 7.624049e-06, 7.561855e-06, 7.483380e-06, 7.388953e-06,
  7.278934e-06, 7.153712e-06, 7.013712e-06, 6.859383e-06, 6.691205e-06, 6.509685e-06, 6.315351e-06, 6.108761e-06,
  5.890491e-06, 5.661139e-06, 5.421324e-06, 5.171679e-06, 4.912859e-06, 4.645528e-06, 4.370366e-06, 4.088064e-06,
  3.799322e-06, 3.504849e-06, 3.205359e-06, 2.901573e-06, 2.594213e-06, 2.284003e-06, 1.971667e-06, 1.657927e-06,
  1.343501e-06, 1.029103e-06, 7.154389e-07, 4.032081e-07, 9.309907e-08,-2.142103e-07,-5.180550e-07,-8.177837e-07,
 -1.112761e-06,-1.402367e-06,-1.686000e-06,-1.963079e-06,-2.233042e-06,-2.495347e-06,-2.749476e-06,-2.994935e-06,
 -3.231252e-06,-3.457982e-06,-3.674704e-06,-3.881027e-06,-4.076583e-06,-4.261034e-06,-4.434071e-06,-4.595413e-06,
 -4.744808e-06,-4.882034e-06,-5.006897e-06,-5.119236e-06,-5.218918e-06,-5.305839e-06,-5.379928e-06,-5.441141e-06,
 -5.489465e-06,-5.524918e-06,-5.547543e-06,-5.557417e-06,-5.554641e-06,-5.539346e-06,-5.511689e-06,-5.471857e-06,
 -5.420058e-06,-5.356530e-06,-5.281533e-06,-5.195350e-06,-5.098290e-06,-4.990681e-06,-4.872873e-06,-4.745237e-06,
 -4.608161e-06,-4.462053e-06,-4.307335e-06,-4.144449e-06,-3.973846e-06,-3.795996e-06,-3.611376e-06,-3.420478e-06,
 -3.223802e-06,-3.021856e-06,-2.815155e-06,-2.604222e-06,-2.389583e-06,-2.171768e-06,-1.951308e-06,-1.728737e-06,
 -1.504587e-06,-1.279389e-06,-1.053673e-06,-8.279614e-07,-6.027746e-07,-3.786254e-07,-1.560196e-07, 6.454575e-08,
  2.825830e-07, 4.976150e-07, 7.091765e-07, 9.168147e-07, 1.120090e-06, 1.318578e-06, 1.511869e-06, 1.699569e-06,
  1.881301e-06, 2.056707e-06, 2.225445e-06, 2.387194e-06, 2.541650e-06, 2.688530e-06, 2.827573e-06, 2.958537e-06,
  3.081201e-06, 3.195367e-06, 3.300857e-06, 3.397517e-06, 3.485213e-06, 3.563834e-06, 3.633293e-06, 3.693522e-06,
  3.744477e-06, 3.786138e-06, 3.818504e-06, 3.841595e-06, 3.855457e-06, 3.860153e-06, 3.855768e-06, 3.842408e-06,
  3.820199e-06, 3.789285e-06, 3.749831e-06, 3.702019e-06, 3.646049e-06, 3.582139e-06, 3.510522e-06, 3.431448e-06,
  3.345182e-06, 3.252002e-06, 3.152201e-06, 3.046083e-06, 2.933966e-06, 2.816176e-06, 2.693052e-06, 2.564941e-06,
  2.432197e-06, 2.295182e-06, 2.154266e-06, 2.009823e-06, 1.862232e-06, 1.711874e-06, 1.559135e-06, 1.404401e-06,
  1.248060e-06, 1.090499e-06, 9.321034e-07, 7.732583e-07, 6.143445e-07, 4.557394e-07, 2.978158e-07, 1.409410e-07,
 -1.452397e-08,-1.682253e-07,-3.198168e-07,-4.689613e-07,-6.153307e-07,-7.586070e-07,-8.984829e-07,-1.034662e-06,
 -1.166862e-06,-1.294809e-06,-1.418246e-06,-1.536928e-06,-1.650623e-06,-1.759115e-06,-1.862202e-06,-1.959698e-06,
 -2.051430e-06,-2.137244e-06,-2.216999e-06,-2.290571e-06,-2.357854e-06,-2.418755e-06,-2.473199e-06,-2.521129e-06,
 -2.562501e-06,-2.597290e-06,-2.625485e-06,-2.647093e-06,-2.662137e-06,-2.670653e-06,-2.672695e-06,-2.668330e-06,
 -2.657643e-06,-2.640730e-06,-2.617702e-06,-2.588686e-06,-2.553818e-06,-2.513251e-06,-2.467147e-06,-2.415681e-06,
 -2.359039e-06,-2.297419e-06,-2.231026e-06,-2.160076e-06,-2.084796e-06,-2.005416e-06,-1.922179e-06,-1.835331e-06,
 -1.745124e-06,-1.651819e-06,-1.555679e-06,-1.456971e-06,-1.355966e-06,-1.252937e-06,-1.148160e-06,-1.041913e-06,
 -9.344711e-07,-8.261128e-07,-7.171141e-07,-6.077499e-07,-4.982929e-07,-3.890129e-07,-2.801764e-07,-1.720457e-07,
 -6.487851e-08, 4.107275e-08, 1.455615e-07, 2.483476e-07, 3.491977e-07, 4.478860e-07, 5.441946e-07, 6.379138e-07,
  7.288431e-07, 8.167907e-07, 9.015747e-07, 9.830231e-07, 1.060974e-06, 1.135277e-06, 1.205790e-06, 1.272385e-06,
  1.334944e-06, 1.393360e-06, 1.447538e-06, 1.497394e-06, 1.542858e-06, 1.583869e-06, 1.620379e-06, 1.652353e-06,
  1.679767e-06, 1.702607e-06, 1.720873e-06, 1.734576e-06, 1.743738e-06, 1.748392e-06, 1.748583e-06, 1.744365e-06,
  1.735804e-06, 1.722976e-06, 1.705966e-06, 1.684870e-06, 1.659792e-06, 1.630845e-06, 1.598152e-06, 1.561842e-06,
  1.522053e-06, 1.478930e-06, 1.432623e-06, 1.383292e-06, 1.331100e-06, 1.276215e-06, 1.218812e-06, 1.159070e-06,
  1.097170e-06, 1.033297e-06, 9.676408e-07, 9.003913e-07, 8.317410e-07, 7.618836e-07, 6.910136e-07, 6.193259e-07,
  5.470147e-07, 4.742740e-07, 4.012961e-07, 3.282718e-07, 2.553898e-07, 1.828358e-07, 1.107926e-07, 3.943944e-08,
 -3.104846e-08,-1.005003e-07,-1.687501e-07,-2.356369e-07,-3.010055e-07,-3.647064e-07,-4.265964e-07,-4.865387e-07,
 -5.444034e-07,-6.000675e-07,-6.534155e-07,-7.043393e-07,-7.527384e-07,-7.985203e-07,-8.416006e-07,-8.819028e-07,
 -9.193590e-07,-9.539094e-07,-9.855027e-07,-1.014096e-06,-1.039655e-06,-1.062154e-06,-1.081575e-06,-1.097909e-06,
 -1.111156e-06,-1.121322e-06,-1.128423e-06,-1.132482e-06,-1.133532e-06,-1.131609e-06,-1.126761e-06,-1.119041e-06,
 -1.108510e-06,-1.095234e-06,-1.079287e-06,-1.060749e-06,-1.039705e-06,-1.016247e-06,-9.904721e-07,-9.624807e-07,
 -9.323793e-07,-9.002785e-07,-8.662926e-07,-8.305395e-07,-7.931404e-07,-7.542194e-07,-7.139028e-07,-6.723193e-07,
 -6.295991e-07,-5.858739e-07,-5.412763e-07,-4.959395e-07,-4.499969e-07,-4.035817e-07,-3.568267e-07,-3.098638e-07,
 -2.628237e-07,-2.158354e-07,-1.690262e-07,-1.225210e-07,-7.644235e-08,-3.090970e-08, 1.396045e-08, 5.805511e-08,
  1.012650e-07, 1.434847e-07, 1.846131e-07, 2.245535e-07, 2.632137e-07, 3.005065e-07, 3.363497e-07, 3.706662e-07,
  4.033843e-07, 4.344378e-07, 4.637659e-07, 4.913137e-07, 5.170319e-07, 5.408771e-07, 5.628118e-07, 5.828044e-07,
  6.008291e-07, 6.168661e-07, 6.309015e-07, 6.429271e-07, 6.529409e-07, 6.609461e-07, 6.669519e-07, 6.709729e-07,
  6.730293e-07, 6.731462e-07, 6.713544e-07, 6.676892e-07, 6.621911e-07, 6.549051e-07, 6.458805e-07, 6.351712e-07,
  6.228349e-07, 6.089333e-07, 5.935314e-07, 5.766979e-07, 5.585044e-07, 5.390254e-07, 5.183381e-07, 4.965220e-07,
  4.736586e-07, 4.498313e-07, 4.251252e-07, 3.996263e-07, 3.734220e-07, 3.466002e-07, 3.192494e-07, 2.914581e-07,
  2.633151e-07, 2.349085e-07, 2.063261e-07, 1.776547e-07, 1.489801e-07, 1.203868e-07, 9.195757e-08, 6.377370e-08,
  3.591429e-08, 8.456276e-09,-1.852580e-08,-4.496000e-08,-7.077713e-08,-9.591095e-08,-1.202983e-07,-1.438794e-07,
 -1.665975e-07,-1.883998e-07,-2.092369e-07,-2.290629e-07,-2.478361e-07,-2.655184e-07,-2.820758e-07,-2.974780e-07,
 -3.116991e-07,-3.247168e-07,-3.365133e-07,-3.470745e-07,-3.563904e-07,-3.644551e-07,-3.712666e-07,-3.768267e-07,
 -3.811412e-07,-3.842195e-07,-3.860748e-07,-3.867239e-07,-3.861870e-07,-3.844877e-07,-3.816527e-07,-3.777121e-07,
 -3.726986e-07,-3.666481e-07,-3.595988e-07,-3.515916e-07,-3.426697e-07,-3.328783e-07,-3.222649e-07,-3.108785e-07,
 -2.987698e-07,-2.859910e-07,-2.725954e-07,-2.586373e-07,-2.441722e-07,-2.292558e-07,-2.139445e-07,-1.982950e-07,
 -1.823641e-07,-1.662082e-07,-1.498839e-07,-1.334469e-07,-1.169526e-07,-1.004553e-07,-8.400851e-08,-6.766457e-08,
 -5.147448e-08,-3.548784e-08,-1.975266e-08,-4.315211e-09, 1.078006e-08, 2.549065e-08, 3.977615e-08, 5.359833e-08,
  6.692120e-08, 7.971116e-08, 9.193698e-08, 1.035700e-07, 1.145840e-07, 1.249554e-07, 1.346633e-07, 1.436894e-07,
  1.520181e-07, 1.596366e-07, 1.665344e-07, 1.727042e-07, 1.781409e-07, 1.828423e-07, 1.868088e-07, 1.900431e-07,
  1.925506e-07, 1.943391e-07, 1.954187e-07, 1.958018e-07, 1.955031e-07, 1.945393e-07, 1.929290e-07, 1.906931e-07,
  1.878538e-07, 1.844355e-07, 1.804637e-07, 1.759658e-07, 1.709701e-07, 1.655064e-07, 1.596055e-07, 1.532992e-07,
  1.466200e-07, 1.396011e-07, 1.322763e-07, 1.246798e-07, 1.168460e-07, 1.088096e-07, 1.006052e-07, 9.226731e-08,
  8.383017e-08, 7.532770e-08, 6.679332e-08, 5.825983e-08, 4.975935e-08, 4.132315e-08, 3.298156e-08, 2.476392e-08,
  1.669842e-08, 8.812052e-09, 1.130530e-09,-6.321812e-09,-1.352207e-08,-2.044884e-08,-2.708225e-08,-3.340404e-08,
 -3.939758e-08,-4.504794e-08,-5.034187e-08,-5.526785e-08,-5.981609e-08,-6.397853e-08,-6.774889e-08,-7.112259e-08,
 -7.409675e-08,-7.667022e-08,-7.884350e-08,-8.061872e-08,-8.199960e-08,-8.299141e-08,-8.360088e-08,-8.383621e-08,
 -8.370695e-08,-8.322394e-08,-8.239927e-08,-8.124617e-08,-7.977894e-08,-7.801290e-08,-7.596424e-08,-7.364997e-08,
 -7.108784e-08,-6.829623e-08,-6.529406e-08,-6.210070e-08,-5.873585e-08,-5.521950e-08,-5.157179e-08,-4.781290e-08,
 -4.396304e-08,-4.004225e-08,-3.607040e-08,-3.206706e-08,-2.805143e-08,-2.404224e-08,-2.005768e-08,-1.611538e-08,
 -1.223223e-08,-8.424436e-09,-4.707360e-09,-1.095515e-09, 2.397485e-09, 5.758977e-09, 8.977324e-09, 1.204188e-08,
  1.494310e-08, 1.767248e-08, 2.022264e-08, 2.258733e-08, 2.476139e-08, 2.674081e-08, 2.852266e-08, 3.010516e-08,
  3.148756e-08, 3.267023e-08, 3.365457e-08, 3.444298e-08, 3.503881e-08, 3.544639e-08, 3.567091e-08, 3.571839e-08,
  3.559565e-08, 3.531024e-08, 3.487038e-08, 3.428491e-08, 3.356318e-08, 3.271506e-08, 3.175083e-08, 3.068111e-08,
  2.951678e-08, 2.826896e-08, 2.694887e-08, 2.556784e-08, 2.413719e-08, 2.266816e-08, 2.117186e-08, 1.965921e-08,
  1.814090e-08, 1.662724e-08, 1.512822e-08, 1.365339e-08, 1.221183e-08, 1.081207e-08, 9.462127e-09, 8.169394e-09,
  6.940638e-09, 5.781956e-09, 4.698791e-09, 3.695860e-09, 2.777185e-09, 1.946049e-09, 1.205024e-09, 5.559713e-10,
  1.421085e-14, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00
};

