#!/usr/bin/perl -w
# 
# Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
# This program is free software. You can redistribute it and/or modify it
# under the terms of the GNU General Public License, either version 2 of
# the License, or (at your option) any later version. See COPYING.
#

$DEBUG = 0;

$PROGRAM = "ldscript_patcher.pl";
$NM = "nm";
$NM_ARGS = "-o ";
##$OBJ_PREFIX = "bios_elf1-";

#$script_name = $ARGV[0];
$in_script = shift(@ARGV);
$out_script = shift(@ARGV);
@obj_files = @ARGV;

%sym_table = ();

foreach $obj_file (@obj_files) {
	open(SYM_LISTING, "${NM} ${NM_ARGS} ${obj_file} |") 
		|| die "$PROGRAM: unable to use process inputfile \"$obj_file\" ($!)";

	#Read symbol table
	while (defined($line = <SYM_LISTING>)) {
		# Look for entries
		if ($line =~ /(\S*):(\S*)\s*(\w)\s*(\S*)\s*.*/) {
			$module = $1;
			$address = $2;
			$type= $3;
			$symbol = $4;
			if ($DEBUG) {
				print "module: $module address: $address symbol: $symbol type: $type\n";
			}
			# add just global symbol
			if ($type eq "T" or $type eq "C") { 
				$sym_table{$symbol} = $module;
			}
		}
	}
	close(SYM_LISTING) 
		|| die "$PROGRAM: unable to close object file \"$in_script\" ($!)";
}

open(IN, $in_script) 
	|| die "$PROGRAM: unable to open input file \"$in_script\" ($!)";

open(OUT, ">$out_script") 
	|| die "$PROGRAM: unable to open output file \"$out_script\" ($!)";

while (defined($line = <IN>)) {
	if ($line =~ /\bCREATE_SEGOFF_SYMBOLS\b/) {
		foreach $sym_entry (sort keys (%sym_table)) {
			# FIXME JOSEF: segment = SEG(OBJECT_FILE)
			print OUT "SEG_$sym_entry = ($sym_entry >> 4) - 0x800;\n";
			print OUT "OFF_$sym_entry = ($sym_entry & 0x000f) | 0x8000;\n";
		}
	} else {
		print OUT "$line";
	}
}

close(IN) 
	|| die "$PROGRAM: unable to close input file \"$in_script\" ($!)";
close(OUT) 
	|| die "$PROGRAM: unable to close output file \"$in_script\" ($!)";

