//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: BoundaryConditionExpressionDirichlet.hpp,v 1.2 2007/02/08 23:19:38 delpinux Exp $

#ifndef BOUNDARY_CONDITION_EXPRESSION_DIRICHLET_HPP
#define BOUNDARY_CONDITION_EXPRESSION_DIRICHLET_HPP

#include <BoundaryConditionExpression.hpp>

/**
 * @file   BoundaryConditionExpressionDirichlet.hpp
 * @author Stephane Del Pino
 * @date   Mon Aug  7 12:18:17 2006
 * 
 * @brief This class defines the class of dirichlet BoundaryCondition
 * expressions
 */
class BoundaryConditionExpressionDirichlet
  : public BoundaryConditionExpression
{
private:
  ReferenceCounting<FunctionExpression>
  __g;				/**< @f$ g @f$ */

  /** 
   * Writes the expression to a stream
   * 
   * @param os given stream
   * 
   * @return os
   */
  std::ostream& put(std::ostream& os) const;

public:
  /** 
   * Executes the expression
   * 
   */
  void execute();

  /** 
   * Constructor
   * 
   * @param unknownName unknown variable
   * @param g @f$ g @f$
   * @param boundary boundary expression
   */
  BoundaryConditionExpressionDirichlet(const std::string& unknownName,
				       ReferenceCounting<FunctionExpression> g,
				       ReferenceCounting<BoundaryExpression> boundary);

  /** 
   * Copy constructor
   * 
   * @param d dirichlet expression
   */
  BoundaryConditionExpressionDirichlet(const BoundaryConditionExpressionDirichlet& d);

  /** 
   * Destructor
   * 
   */
  ~BoundaryConditionExpressionDirichlet();
};

#endif // BOUNDARY_CONDITION_EXPRESSION_DIRICHLET_HPP
