#ifndef __GM_EDITOR_H__
#define __GM_EDITOR_H__

#include <glib-object.h>
#include <glib.h>

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_EDITOR					(gm_editor_get_type())
#define GM_EDITOR(obj)					(G_TYPE_CHECK_INSTANCE_CAST((obj), GM_TYPE_EDITOR, GmEditor))
#define GM_EDITOR_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), GM_TYPE_EDITOR, GmEditor const))
#define GM_EDITOR_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), GM_TYPE_EDITOR, GmEditorClass))
#define GM_IS_EDITOR(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), GM_TYPE_EDITOR))
#define GM_IS_EDITOR_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), GM_TYPE_EDITOR))
#define GM_EDITOR_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), GM_TYPE_EDITOR, GmEditorClass))

/* Private structure type */
typedef struct _GmEditorPrivate GmEditorPrivate;

/*
 * Main object structure
 */
typedef struct _GmEditor GmEditor;
 
struct _GmEditor {
	GObject object;
	
	/*< private > */
	GmEditorPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmEditorClass 	GmEditorClass;

struct _GmEditorClass {
	GObjectClass parent_class;

	/* Signals */
	void (* save) (GmEditor *editor);
	void (* saved) (GmEditor *editor);
	void (* close) (GmEditor *editor);
};

typedef enum _GmEditType GmEditType;
enum _GmEditType {
	E_LEGACY,
	E_MCP
};

GType gm_editor_get_type(void) G_GNUC_CONST;
GmEditor *gm_editor_new(gchar *name, gchar *uploadcmd, GList *text);
GmEditor *gm_editor_new_mcp(gchar *name, gchar *reference, gchar *type,
		GList *text);

void gm_editor_set_lines_from_string(GmEditor *editor, gchar const *text);
void gm_editor_set_lines_from_file(GmEditor *editor, gchar const *filename);
gchar *gm_editor_write_lines(GmEditor *editor);

void gm_editor_save(GmEditor *editor);
void gm_editor_saved(GmEditor *editor);
void gm_editor_close(GmEditor *editor);

gboolean gm_editor_is_code(GmEditor *editor);
gchar *gm_editor_name(GmEditor *editor);
gchar *gm_editor_upload_cmd(GmEditor *editor);
gchar *gm_editor_mcp_type(GmEditor *editor);
GList *gm_editor_lines(GmEditor *editor);
GmEditType gm_editor_type(GmEditor *editor);

G_END_DECLS
#endif /* __GM_EDITOR_H__ */
