% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmTMB.R
\name{glmmTMBControl}
\alias{glmmTMBControl}
\title{Control parameters for glmmTMB optimization}
\usage{
glmmTMBControl(
  optCtrl = NULL,
  optArgs = list(),
  optimizer = nlminb,
  profile = FALSE,
  collect = FALSE,
  parallel = NULL,
  eigval_check = TRUE
)
}
\arguments{
\item{optCtrl}{Passed as argument \code{control} to optimizer. Default value (if default \code{nlminb} optimizer is used): \code{list(iter.max=300, eval.max=400)}}

\item{optArgs}{additional arguments to be passed to optimizer function (e.g.: \code{list(method="BFGS")} when \code{optimizer=optim})}

\item{optimizer}{Function to use in model fitting. See \code{Details} for required properties of this function.}

\item{profile}{Logical; Experimental option to improve speed and
robustness when a model has many fixed effects}

\item{collect}{Logical; Experimental option to improve speed by
recognizing duplicated observations.}

\item{parallel}{Numeric; Setting number of OpenMP threads to evaluate
the negative log-likelihood in parallel}

\item{eigval_check}{Check eigenvalues of variance-covariance matrix? (This test may be very slow for models with large numbers of fixed-effect parameters.)}
}
\description{
Control parameters for glmmTMB optimization
}
\details{
The general non-linear optimizer \code{nlminb} is used by
\code{\link{glmmTMB}} for parameter estimation. It may sometimes be
necessary to tweak some tolerances in order to make a model
converge. For instance, the warning \sQuote{iteration limit reached
without convergence} may be fixed by increasing the number of
iterations using something like

\code{glmmTMBControl(optCtrl=list(iter.max=1e3,eval.max=1e3))}.

The argument \code{profile} allows \code{glmmTMB} to use some special
properties of the optimization problem in order to speed up estimation
in cases with many fixed effects. Enable this option using

\code{glmmTMBControl(profile=TRUE)}.

Control parameters may depend on the model specification, because each
control component is evaluated inside \code{TMBStruc}, the output
of \code{mkTMBStruc}.  To specify that \code{profile} should be
enabled for more than 5 fixed effects one can use

\code{glmmTMBControl(profile=quote(length(parameters$beta)>=5))}.

The \code{optimizer} argument can be any optimization (minimizing) function, provided that:
\itemize{
\item the first three arguments, in order, are the starting values, objective function, and gradient function;
\item it also takes a \code{control} argument;
\item it returns a list with elements (at least) \code{par}, \code{objective}, \code{convergence} (0 if convergence is successful) and \code{message}
(the code internally handles output from \code{optim()}, by renaming the \code{value} component to \code{objective})

}
}
\examples{
## fit with default (nlminb) and alternative (optim/BFGS) optimizer
m1 <- glmmTMB(count~ mined, family=poisson, data=Salamanders)
m1B <- update(m1, control=glmmTMBControl(optimizer=optim,
               optArgs=list(method="BFGS")))
## estimates are *nearly* identical:
all.equal(fixef(m1), fixef(m1B))
}
