% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data_frame.R
\name{graph_from_edgelist}
\alias{from_edgelist}
\alias{graph.edgelist}
\alias{graph_from_edgelist}
\title{Create a graph from an edge list matrix}
\usage{
graph_from_edgelist(el, directed = TRUE)

from_edgelist(...)
}
\arguments{
\item{el}{The edge list, a two column matrix, character or numeric.}

\item{directed}{Whether to create a directed graph.}

\item{...}{Passed to \code{graph_from_edgelist}.}
}
\value{
An igraph graph.
}
\description{
\code{graph_from_edgelist} creates a graph from an edge list. Its argument
is a two-column matrix, each row defines one edge. If it is
a numeric matrix then its elements are interpreted as vertex ids. If
it is a character matrix then it is interpreted as symbolic vertex
names and a vertex id will be assigned to each name, and also a
\code{name} vertex attribute will be added.
}
\examples{
el <- matrix( c("foo", "bar", "bar", "foobar"), nc = 2, byrow = TRUE)
graph_from_edgelist(el)

# Create a ring by hand
graph_from_edgelist(cbind(1:10, c(2:10, 1)))
}
\seealso{
Other determimistic constructors: \code{\link{atlas}},
  \code{\link{graph.atlas}},
  \code{\link{graph_from_atlas}};
  \code{\link{chordal_ring}},
  \code{\link{graph.extended.chordal.ring}},
  \code{\link{make_chordal_ring}};
  \code{\link{directed_graph}}, \code{\link{graph}},
  \code{\link{graph.famous}},
  \code{\link{make_directed_graph}},
  \code{\link{make_graph}},
  \code{\link{make_undirected_graph}},
  \code{\link{undirected_graph}};
  \code{\link{empty_graph}}, \code{\link{graph.empty}},
  \code{\link{make_empty_graph}};
  \code{\link{from_literal}}, \code{\link{graph.formula}},
  \code{\link{graph_from_literal}};
  \code{\link{full_citation_graph}},
  \code{\link{graph.full.citation}},
  \code{\link{make_full_citation_graph}};
  \code{\link{full_graph}}, \code{\link{graph.full}},
  \code{\link{make_full_graph}};
  \code{\link{graph.lattice}}, \code{\link{lattice}},
  \code{\link{make_lattice}}; \code{\link{graph.ring}},
  \code{\link{make_ring}}, \code{\link{ring}};
  \code{\link{graph.star}}, \code{\link{make_star}},
  \code{\link{star}}; \code{\link{graph.tree}},
  \code{\link{make_tree}}, \code{\link{tree}}
}
\concept{
Edge list
}

