% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_replace_na.R
\name{stri_replace_na}
\alias{stri_replace_na}
\title{Replace Missing Values in a Character Vector}
\usage{
stri_replace_na(str, replacement = "NA")
}
\arguments{
\item{str}{character vector or an object coercible to}

\item{replacement}{single string}
}
\value{
Returns a character vector.
}
\description{
This function offers a convenient way to replace each \code{NA}
in a character vector with a given string.
}
\details{
This function is roughly equivalent to
\code{str2 <- stri_enc_toutf8(str);
str2[is.na(str2)] <- stri_enc_toutf8(replacement);
str2}.
It may be used e.g. wherever ``plain \R'' \code{NA} handling is
desired, see Examples.
}
\examples{
x <- c('test', NA)
stri_paste(x, 1:2)                           # "test1" NA
paste(x, 1:2)                                # "test 1" "NA 2"
stri_paste(stri_replace_na(x), 1:2, sep=' ') # "test 1" "NA 2"

}
\seealso{
Other search_replace: \code{\link{stri_replace_all}},
  \code{\link{stri_trim_both}},
  \code{\link{stringi-search}}
}

