-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
procedure Add_Generic_Formal_Parameter_Local
  (Comp_Unit             : in     ContextManager.UnitDescriptors;
   Declaration           : in     Location;
   The_Generic_Unit      : in     RawDict.Generic_Unit_Info_Ref;
   Type_Mark             : in     RawDict.Type_Info_Ref;
   The_Object            : in     RawDict.Constant_Info_Ref;
   The_Generic_Parameter :    out RawDict.Generic_Parameter_Info_Ref) is
   Previous : RawDict.Generic_Parameter_Info_Ref;
begin
   RawDict.Create_Generic_Parameter
     (Owning_Generic        => The_Generic_Unit,
      Type_Mark             => Type_Mark,
      Object                => The_Object,
      Comp_Unit             => Comp_Unit,
      Loc                   => Declaration.Start_Position,
      The_Generic_Parameter => The_Generic_Parameter);

   if The_Object /= RawDict.Null_Constant_Info_Ref then
      -- Set a back pointer from the constant so that we know that we created it to implement a generic object
      -- parameter and know which generic parameter the constant belongs to
      RawDict.Set_Constant_Associated_Generic_Parameter
        (The_Constant          => The_Object,
         The_Generic_Parameter => The_Generic_Parameter);
   end if;

   Previous := RawDict.Get_Generic_Unit_Last_Generic_Parameter (The_Generic_Unit => The_Generic_Unit);
   if Previous = RawDict.Null_Generic_Parameter_Info_Ref then
      RawDict.Set_Generic_Unit_First_Generic_Parameter
        (The_Generic_Unit      => The_Generic_Unit,
         The_Generic_Parameter => The_Generic_Parameter);
   else
      RawDict.Set_Next_Generic_Parameter (The_Generic_Parameter => Previous,
                                          Next                  => The_Generic_Parameter);
   end if;
   RawDict.Set_Generic_Unit_Last_Generic_Parameter
     (The_Generic_Unit      => The_Generic_Unit,
      The_Generic_Parameter => The_Generic_Parameter);
end Add_Generic_Formal_Parameter_Local;
