/* Copyright (c) 2003, Roger Dingledine
 * Copyright (c) 2004-2006, Roger Dingledine, Nick Mathewson.
 * Copyright (c) 2007-2011, The Tor Project, Inc. */
/* See LICENSE for licensing information */

/* Helper file: included only in tortls.c */

#ifndef _TORTLS_STATES_H
#define _TORTLS_STATES_H

/* The main body of this file was mechanically generated with this
   perl script:

   my %keys = ();
   for $fn (@ARGV) {
       open(F, $fn);
       while (<F>) {
           next unless /^#define ((?:SSL|DTLS)\w*_ST_\w*)/;
           $keys{$1} = 1;
       }
       close(F);
   }
   for $k (sort keys %keys) {
       print "#ifdef $k\n  S($k),\n#endif\n"
   }
*/

/** Mapping from allowed value of SSL.state to the name of C macro for that
 * state.  Used for debugging an openssl connection. */
static const struct { int state; const char *name; } state_map[] = {
#define S(state) { state, #state }
#ifdef DTLS1_ST_CR_HELLO_VERIFY_REQUEST_A
  S(DTLS1_ST_CR_HELLO_VERIFY_REQUEST_A),
#endif
#ifdef DTLS1_ST_CR_HELLO_VERIFY_REQUEST_B
  S(DTLS1_ST_CR_HELLO_VERIFY_REQUEST_B),
#endif
#ifdef DTLS1_ST_SW_HELLO_VERIFY_REQUEST_A
  S(DTLS1_ST_SW_HELLO_VERIFY_REQUEST_A),
#endif
#ifdef DTLS1_ST_SW_HELLO_VERIFY_REQUEST_B
  S(DTLS1_ST_SW_HELLO_VERIFY_REQUEST_B),
#endif
#ifdef SSL23_ST_CR_SRVR_HELLO_A
  S(SSL23_ST_CR_SRVR_HELLO_A),
#endif
#ifdef SSL23_ST_CR_SRVR_HELLO_B
  S(SSL23_ST_CR_SRVR_HELLO_B),
#endif
#ifdef SSL23_ST_CW_CLNT_HELLO_A
  S(SSL23_ST_CW_CLNT_HELLO_A),
#endif
#ifdef SSL23_ST_CW_CLNT_HELLO_B
  S(SSL23_ST_CW_CLNT_HELLO_B),
#endif
#ifdef SSL23_ST_SR_CLNT_HELLO_A
  S(SSL23_ST_SR_CLNT_HELLO_A),
#endif
#ifdef SSL23_ST_SR_CLNT_HELLO_B
  S(SSL23_ST_SR_CLNT_HELLO_B),
#endif
#ifdef SSL2_ST_CLIENT_START_ENCRYPTION
  S(SSL2_ST_CLIENT_START_ENCRYPTION),
#endif
#ifdef SSL2_ST_GET_CLIENT_FINISHED_A
  S(SSL2_ST_GET_CLIENT_FINISHED_A),
#endif
#ifdef SSL2_ST_GET_CLIENT_FINISHED_B
  S(SSL2_ST_GET_CLIENT_FINISHED_B),
#endif
#ifdef SSL2_ST_GET_CLIENT_HELLO_A
  S(SSL2_ST_GET_CLIENT_HELLO_A),
#endif
#ifdef SSL2_ST_GET_CLIENT_HELLO_B
  S(SSL2_ST_GET_CLIENT_HELLO_B),
#endif
#ifdef SSL2_ST_GET_CLIENT_HELLO_C
  S(SSL2_ST_GET_CLIENT_HELLO_C),
#endif
#ifdef SSL2_ST_GET_CLIENT_MASTER_KEY_A
  S(SSL2_ST_GET_CLIENT_MASTER_KEY_A),
#endif
#ifdef SSL2_ST_GET_CLIENT_MASTER_KEY_B
  S(SSL2_ST_GET_CLIENT_MASTER_KEY_B),
#endif
#ifdef SSL2_ST_GET_SERVER_FINISHED_A
  S(SSL2_ST_GET_SERVER_FINISHED_A),
#endif
#ifdef SSL2_ST_GET_SERVER_FINISHED_B
  S(SSL2_ST_GET_SERVER_FINISHED_B),
#endif
#ifdef SSL2_ST_GET_SERVER_HELLO_A
  S(SSL2_ST_GET_SERVER_HELLO_A),
#endif
#ifdef SSL2_ST_GET_SERVER_HELLO_B
  S(SSL2_ST_GET_SERVER_HELLO_B),
#endif
#ifdef SSL2_ST_GET_SERVER_VERIFY_A
  S(SSL2_ST_GET_SERVER_VERIFY_A),
#endif
#ifdef SSL2_ST_GET_SERVER_VERIFY_B
  S(SSL2_ST_GET_SERVER_VERIFY_B),
#endif
#ifdef SSL2_ST_SEND_CLIENT_CERTIFICATE_A
  S(SSL2_ST_SEND_CLIENT_CERTIFICATE_A),
#endif
#ifdef SSL2_ST_SEND_CLIENT_CERTIFICATE_B
  S(SSL2_ST_SEND_CLIENT_CERTIFICATE_B),
#endif
#ifdef SSL2_ST_SEND_CLIENT_CERTIFICATE_C
  S(SSL2_ST_SEND_CLIENT_CERTIFICATE_C),
#endif
#ifdef SSL2_ST_SEND_CLIENT_CERTIFICATE_D
  S(SSL2_ST_SEND_CLIENT_CERTIFICATE_D),
#endif
#ifdef SSL2_ST_SEND_CLIENT_FINISHED_A
  S(SSL2_ST_SEND_CLIENT_FINISHED_A),
#endif
#ifdef SSL2_ST_SEND_CLIENT_FINISHED_B
  S(SSL2_ST_SEND_CLIENT_FINISHED_B),
#endif
#ifdef SSL2_ST_SEND_CLIENT_HELLO_A
  S(SSL2_ST_SEND_CLIENT_HELLO_A),
#endif
#ifdef SSL2_ST_SEND_CLIENT_HELLO_B
  S(SSL2_ST_SEND_CLIENT_HELLO_B),
#endif
#ifdef SSL2_ST_SEND_CLIENT_MASTER_KEY_A
  S(SSL2_ST_SEND_CLIENT_MASTER_KEY_A),
#endif
#ifdef SSL2_ST_SEND_CLIENT_MASTER_KEY_B
  S(SSL2_ST_SEND_CLIENT_MASTER_KEY_B),
#endif
#ifdef SSL2_ST_SEND_REQUEST_CERTIFICATE_A
  S(SSL2_ST_SEND_REQUEST_CERTIFICATE_A),
#endif
#ifdef SSL2_ST_SEND_REQUEST_CERTIFICATE_B
  S(SSL2_ST_SEND_REQUEST_CERTIFICATE_B),
#endif
#ifdef SSL2_ST_SEND_REQUEST_CERTIFICATE_C
  S(SSL2_ST_SEND_REQUEST_CERTIFICATE_C),
#endif
#ifdef SSL2_ST_SEND_REQUEST_CERTIFICATE_D
  S(SSL2_ST_SEND_REQUEST_CERTIFICATE_D),
#endif
#ifdef SSL2_ST_SEND_SERVER_FINISHED_A
  S(SSL2_ST_SEND_SERVER_FINISHED_A),
#endif
#ifdef SSL2_ST_SEND_SERVER_FINISHED_B
  S(SSL2_ST_SEND_SERVER_FINISHED_B),
#endif
#ifdef SSL2_ST_SEND_SERVER_HELLO_A
  S(SSL2_ST_SEND_SERVER_HELLO_A),
#endif
#ifdef SSL2_ST_SEND_SERVER_HELLO_B
  S(SSL2_ST_SEND_SERVER_HELLO_B),
#endif
#ifdef SSL2_ST_SEND_SERVER_VERIFY_A
  S(SSL2_ST_SEND_SERVER_VERIFY_A),
#endif
#ifdef SSL2_ST_SEND_SERVER_VERIFY_B
  S(SSL2_ST_SEND_SERVER_VERIFY_B),
#endif
#ifdef SSL2_ST_SEND_SERVER_VERIFY_C
  S(SSL2_ST_SEND_SERVER_VERIFY_C),
#endif
#ifdef SSL2_ST_SERVER_START_ENCRYPTION
  S(SSL2_ST_SERVER_START_ENCRYPTION),
#endif
#ifdef SSL2_ST_X509_GET_CLIENT_CERTIFICATE
  S(SSL2_ST_X509_GET_CLIENT_CERTIFICATE),
#endif
#ifdef SSL2_ST_X509_GET_SERVER_CERTIFICATE
  S(SSL2_ST_X509_GET_SERVER_CERTIFICATE),
#endif
#ifdef SSL3_ST_CR_CERT_A
  S(SSL3_ST_CR_CERT_A),
#endif
#ifdef SSL3_ST_CR_CERT_B
  S(SSL3_ST_CR_CERT_B),
#endif
#ifdef SSL3_ST_CR_CERT_REQ_A
  S(SSL3_ST_CR_CERT_REQ_A),
#endif
#ifdef SSL3_ST_CR_CERT_REQ_B
  S(SSL3_ST_CR_CERT_REQ_B),
#endif
#ifdef SSL3_ST_CR_CERT_STATUS_A
  S(SSL3_ST_CR_CERT_STATUS_A),
#endif
#ifdef SSL3_ST_CR_CERT_STATUS_B
  S(SSL3_ST_CR_CERT_STATUS_B),
#endif
#ifdef SSL3_ST_CR_CHANGE_A
  S(SSL3_ST_CR_CHANGE_A),
#endif
#ifdef SSL3_ST_CR_CHANGE_B
  S(SSL3_ST_CR_CHANGE_B),
#endif
#ifdef SSL3_ST_CR_FINISHED_A
  S(SSL3_ST_CR_FINISHED_A),
#endif
#ifdef SSL3_ST_CR_FINISHED_B
  S(SSL3_ST_CR_FINISHED_B),
#endif
#ifdef SSL3_ST_CR_KEY_EXCH_A
  S(SSL3_ST_CR_KEY_EXCH_A),
#endif
#ifdef SSL3_ST_CR_KEY_EXCH_B
  S(SSL3_ST_CR_KEY_EXCH_B),
#endif
#ifdef SSL3_ST_CR_SESSION_TICKET_A
  S(SSL3_ST_CR_SESSION_TICKET_A),
#endif
#ifdef SSL3_ST_CR_SESSION_TICKET_B
  S(SSL3_ST_CR_SESSION_TICKET_B),
#endif
#ifdef SSL3_ST_CR_SRVR_DONE_A
  S(SSL3_ST_CR_SRVR_DONE_A),
#endif
#ifdef SSL3_ST_CR_SRVR_DONE_B
  S(SSL3_ST_CR_SRVR_DONE_B),
#endif
#ifdef SSL3_ST_CR_SRVR_HELLO_A
  S(SSL3_ST_CR_SRVR_HELLO_A),
#endif
#ifdef SSL3_ST_CR_SRVR_HELLO_B
  S(SSL3_ST_CR_SRVR_HELLO_B),
#endif
#ifdef SSL3_ST_CW_CERT_A
  S(SSL3_ST_CW_CERT_A),
#endif
#ifdef SSL3_ST_CW_CERT_B
  S(SSL3_ST_CW_CERT_B),
#endif
#ifdef SSL3_ST_CW_CERT_C
  S(SSL3_ST_CW_CERT_C),
#endif
#ifdef SSL3_ST_CW_CERT_D
  S(SSL3_ST_CW_CERT_D),
#endif
#ifdef SSL3_ST_CW_CERT_VRFY_A
  S(SSL3_ST_CW_CERT_VRFY_A),
#endif
#ifdef SSL3_ST_CW_CERT_VRFY_B
  S(SSL3_ST_CW_CERT_VRFY_B),
#endif
#ifdef SSL3_ST_CW_CHANGE_A
  S(SSL3_ST_CW_CHANGE_A),
#endif
#ifdef SSL3_ST_CW_CHANGE_B
  S(SSL3_ST_CW_CHANGE_B),
#endif
#ifdef SSL3_ST_CW_CLNT_HELLO_A
  S(SSL3_ST_CW_CLNT_HELLO_A),
#endif
#ifdef SSL3_ST_CW_CLNT_HELLO_B
  S(SSL3_ST_CW_CLNT_HELLO_B),
#endif
#ifdef SSL3_ST_CW_FINISHED_A
  S(SSL3_ST_CW_FINISHED_A),
#endif
#ifdef SSL3_ST_CW_FINISHED_B
  S(SSL3_ST_CW_FINISHED_B),
#endif
#ifdef SSL3_ST_CW_FLUSH
  S(SSL3_ST_CW_FLUSH),
#endif
#ifdef SSL3_ST_CW_KEY_EXCH_A
  S(SSL3_ST_CW_KEY_EXCH_A),
#endif
#ifdef SSL3_ST_CW_KEY_EXCH_B
  S(SSL3_ST_CW_KEY_EXCH_B),
#endif
#ifdef SSL3_ST_SR_CERT_A
  S(SSL3_ST_SR_CERT_A),
#endif
#ifdef SSL3_ST_SR_CERT_B
  S(SSL3_ST_SR_CERT_B),
#endif
#ifdef SSL3_ST_SR_CERT_VRFY_A
  S(SSL3_ST_SR_CERT_VRFY_A),
#endif
#ifdef SSL3_ST_SR_CERT_VRFY_B
  S(SSL3_ST_SR_CERT_VRFY_B),
#endif
#ifdef SSL3_ST_SR_CHANGE_A
  S(SSL3_ST_SR_CHANGE_A),
#endif
#ifdef SSL3_ST_SR_CHANGE_B
  S(SSL3_ST_SR_CHANGE_B),
#endif
#ifdef SSL3_ST_SR_CLNT_HELLO_A
  S(SSL3_ST_SR_CLNT_HELLO_A),
#endif
#ifdef SSL3_ST_SR_CLNT_HELLO_B
  S(SSL3_ST_SR_CLNT_HELLO_B),
#endif
#ifdef SSL3_ST_SR_CLNT_HELLO_C
  S(SSL3_ST_SR_CLNT_HELLO_C),
#endif
#ifdef SSL3_ST_SR_FINISHED_A
  S(SSL3_ST_SR_FINISHED_A),
#endif
#ifdef SSL3_ST_SR_FINISHED_B
  S(SSL3_ST_SR_FINISHED_B),
#endif
#ifdef SSL3_ST_SR_KEY_EXCH_A
  S(SSL3_ST_SR_KEY_EXCH_A),
#endif
#ifdef SSL3_ST_SR_KEY_EXCH_B
  S(SSL3_ST_SR_KEY_EXCH_B),
#endif
#ifdef SSL3_ST_SW_CERT_A
  S(SSL3_ST_SW_CERT_A),
#endif
#ifdef SSL3_ST_SW_CERT_B
  S(SSL3_ST_SW_CERT_B),
#endif
#ifdef SSL3_ST_SW_CERT_REQ_A
  S(SSL3_ST_SW_CERT_REQ_A),
#endif
#ifdef SSL3_ST_SW_CERT_REQ_B
  S(SSL3_ST_SW_CERT_REQ_B),
#endif
#ifdef SSL3_ST_SW_CERT_STATUS_A
  S(SSL3_ST_SW_CERT_STATUS_A),
#endif
#ifdef SSL3_ST_SW_CERT_STATUS_B
  S(SSL3_ST_SW_CERT_STATUS_B),
#endif
#ifdef SSL3_ST_SW_CHANGE_A
  S(SSL3_ST_SW_CHANGE_A),
#endif
#ifdef SSL3_ST_SW_CHANGE_B
  S(SSL3_ST_SW_CHANGE_B),
#endif
#ifdef SSL3_ST_SW_FINISHED_A
  S(SSL3_ST_SW_FINISHED_A),
#endif
#ifdef SSL3_ST_SW_FINISHED_B
  S(SSL3_ST_SW_FINISHED_B),
#endif
#ifdef SSL3_ST_SW_FLUSH
  S(SSL3_ST_SW_FLUSH),
#endif
#ifdef SSL3_ST_SW_HELLO_REQ_A
  S(SSL3_ST_SW_HELLO_REQ_A),
#endif
#ifdef SSL3_ST_SW_HELLO_REQ_B
  S(SSL3_ST_SW_HELLO_REQ_B),
#endif
#ifdef SSL3_ST_SW_HELLO_REQ_C
  S(SSL3_ST_SW_HELLO_REQ_C),
#endif
#ifdef SSL3_ST_SW_KEY_EXCH_A
  S(SSL3_ST_SW_KEY_EXCH_A),
#endif
#ifdef SSL3_ST_SW_KEY_EXCH_B
  S(SSL3_ST_SW_KEY_EXCH_B),
#endif
#ifdef SSL3_ST_SW_SESSION_TICKET_A
  S(SSL3_ST_SW_SESSION_TICKET_A),
#endif
#ifdef SSL3_ST_SW_SESSION_TICKET_B
  S(SSL3_ST_SW_SESSION_TICKET_B),
#endif
#ifdef SSL3_ST_SW_SRVR_DONE_A
  S(SSL3_ST_SW_SRVR_DONE_A),
#endif
#ifdef SSL3_ST_SW_SRVR_DONE_B
  S(SSL3_ST_SW_SRVR_DONE_B),
#endif
#ifdef SSL3_ST_SW_SRVR_HELLO_A
  S(SSL3_ST_SW_SRVR_HELLO_A),
#endif
#ifdef SSL3_ST_SW_SRVR_HELLO_B
  S(SSL3_ST_SW_SRVR_HELLO_B),
#endif
#ifdef SSL_ST_ACCEPT
  S(SSL_ST_ACCEPT),
#endif
#ifdef SSL_ST_BEFORE
  S(SSL_ST_BEFORE),
#endif
#ifdef SSL_ST_CONNECT
  S(SSL_ST_CONNECT),
#endif
#ifdef SSL_ST_INIT
  S(SSL_ST_INIT),
#endif
#ifdef SSL_ST_MASK
  S(SSL_ST_MASK),
#endif
#ifdef SSL_ST_OK
  S(SSL_ST_OK),
#endif
#ifdef SSL_ST_READ_BODY
  S(SSL_ST_READ_BODY),
#endif
#ifdef SSL_ST_READ_DONE
  S(SSL_ST_READ_DONE),
#endif
#ifdef SSL_ST_READ_HEADER
  S(SSL_ST_READ_HEADER),
#endif
#ifdef SSL_ST_RENEGOTIATE
  S(SSL_ST_RENEGOTIATE),
#endif
  { 0, NULL }
};

#endif

