/* kvhash.h - key/value hash
 *
 * Copyright (c) 2010 Colin Watson <cjwatson@debian.org>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdlib.h>
#include <stdbool.h>

#include "gl_list.h"

struct kvelem {
    char *key;
    void *value;
};

void kvhash_dispose (void *data);
void kvhash_dispose_plain (void *data);
gl_list_t kvhash_initialize (gl_listelement_dispose_fn dispose_fn);
bool kvhash_exists (gl_list_t list, const char *key);
void *kvhash_lookup (gl_list_t list, const char *key);
void *kvhash_insert (gl_list_t list, const char *key, const void *value);
void *kvhash_delete (gl_list_t list, const char *key);
