/* -*- c-file-style: "GNU" -*- */
/*
 * Copyright (C) CNRS, INRIA, Universite Bordeaux 1, Telecom SudParis
 * See COPYING in top-level directory.
 */

#ifndef __MPI_EV_CODES_H__
#define __MPI_EV_CODES_H__

#include "ev_codes.h"

#ifndef MPI_EVENT_ID
  #define MPI_EVENT_ID 0x04
#endif

#define EZTRACE_MPI_EVENTS_ID SYSTEM_MODULE_ID(MPI_EVENT_ID)
#define EZTRACE_MPI_PREFIX    GENERATE_SYSTEM_MODULE_PREFIX(EZTRACE_MPI_EVENTS_ID)

#define EZTRACE_MPI_INIT           (EZTRACE_MPI_PREFIX | 0x0010)
#define EZTRACE_MPI_INIT_Info      (EZTRACE_MPI_PREFIX | 0x0011)

#define EZTRACE_MPI_NEW_COMM       (EZTRACE_MPI_PREFIX | 0x0012)
#define EZTRACE_MPI_NEW_COMM_Info  (EZTRACE_MPI_PREFIX | 0x0013)
#define EZTRACE_MPI_DELETE_COMM    (EZTRACE_MPI_PREFIX | 0x0014)

#define EZTRACE_MPI_START_SEND     (EZTRACE_MPI_PREFIX | 0x0001)
#define EZTRACE_MPI_STOP_SEND      (EZTRACE_MPI_PREFIX | 0x0002)
#define EZTRACE_MPI_START_BSEND    (EZTRACE_MPI_PREFIX | 0x0003)
#define EZTRACE_MPI_STOP_BSEND     (EZTRACE_MPI_PREFIX | 0x0004)
#define EZTRACE_MPI_START_SSEND    (EZTRACE_MPI_PREFIX | 0x0005)
#define EZTRACE_MPI_STOP_SSEND     (EZTRACE_MPI_PREFIX | 0x0006)
#define EZTRACE_MPI_START_RSEND    (EZTRACE_MPI_PREFIX | 0x0007)
#define EZTRACE_MPI_STOP_RSEND     (EZTRACE_MPI_PREFIX | 0x0008)

#define EZTRACE_MPI_START_SENDRECV         (EZTRACE_MPI_PREFIX | 0x000a)
#define EZTRACE_MPI_STOP_SENDRECV          (EZTRACE_MPI_PREFIX | 0x000b)
#define EZTRACE_MPI_START_SENDRECV_REPLACE (EZTRACE_MPI_PREFIX | 0x000c)
#define EZTRACE_MPI_STOP_SENDRECV_REPLACE  (EZTRACE_MPI_PREFIX | 0x000d)

#define EZTRACE_MPI_ISEND    (EZTRACE_MPI_PREFIX | 0x0101)
#define EZTRACE_MPI_IBSEND   (EZTRACE_MPI_PREFIX | 0x0103)
#define EZTRACE_MPI_ISSEND   (EZTRACE_MPI_PREFIX | 0x0105)
#define EZTRACE_MPI_IRSEND   (EZTRACE_MPI_PREFIX | 0x0107)
#define EZTRACE_MPI_START_PUT   (EZTRACE_MPI_PREFIX | 0x0201)
#define EZTRACE_MPI_STOP_PUT    (EZTRACE_MPI_PREFIX | 0x0202)
#define EZTRACE_MPI_START_GET   (EZTRACE_MPI_PREFIX | 0x0203)
#define EZTRACE_MPI_STOP_GET    (EZTRACE_MPI_PREFIX | 0x0204)

#define EZTRACE_MPI_START_RECV     (EZTRACE_MPI_PREFIX | 0x1003)
#define EZTRACE_MPI_STOP_RECV      (EZTRACE_MPI_PREFIX | 0x1004)
#define EZTRACE_MPI_IRECV          (EZTRACE_MPI_PREFIX | 0x1005)

#define EZTRACE_MPI_START_WAIT     (EZTRACE_MPI_PREFIX | 0x2001)
#define EZTRACE_MPI_STOP_WAIT      (EZTRACE_MPI_PREFIX | 0x2002)
#define EZTRACE_MPI_TEST_SUCCESS   (EZTRACE_MPI_PREFIX | 0x2003)
#define EZTRACE_MPI_START_PROBE    (EZTRACE_MPI_PREFIX | 0x2004)
#define EZTRACE_MPI_STOP_PROBE     (EZTRACE_MPI_PREFIX | 0x2005)
#define EZTRACE_MPI_IPROBE_SUCCESS (EZTRACE_MPI_PREFIX | 0x2006)
#define EZTRACE_MPI_IPROBE_FAILED  (EZTRACE_MPI_PREFIX | 0x2007)
#define EZTRACE_MPI_START_WAITANY     (EZTRACE_MPI_PREFIX | 0x2008)
#define EZTRACE_MPI_STOP_WAITANY      (EZTRACE_MPI_PREFIX | 0x2009)
#define EZTRACE_MPI_START_WAITALL     (EZTRACE_MPI_PREFIX | 0x200a)
#define EZTRACE_MPI_STOP_WAITALL      (EZTRACE_MPI_PREFIX | 0x200b)
#define EZTRACE_MPI_STOP_WAIT_FAILED  (EZTRACE_MPI_PREFIX | 0x200c)

#define EZTRACE_MPI_BCast_info           (EZTRACE_MPI_PREFIX | 0x3101)

#define EZTRACE_MPI_START_BCast          (EZTRACE_MPI_PREFIX | 0x3001)
#define EZTRACE_MPI_START_Gather         (EZTRACE_MPI_PREFIX | 0x3002)
#define EZTRACE_MPI_START_Gatherv        (EZTRACE_MPI_PREFIX | 0x3003)
#define EZTRACE_MPI_START_Scatter        (EZTRACE_MPI_PREFIX | 0x3004)
#define EZTRACE_MPI_START_Scatterv       (EZTRACE_MPI_PREFIX | 0x3005)
#define EZTRACE_MPI_START_Allgather      (EZTRACE_MPI_PREFIX | 0x3006)
#define EZTRACE_MPI_START_Allgatherv     (EZTRACE_MPI_PREFIX | 0x3007)
#define EZTRACE_MPI_START_Alltoall       (EZTRACE_MPI_PREFIX | 0x3008)
#define EZTRACE_MPI_START_Alltoallv      (EZTRACE_MPI_PREFIX | 0x3009)
#define EZTRACE_MPI_START_Reduce         (EZTRACE_MPI_PREFIX | 0x300a)
#define EZTRACE_MPI_START_Allreduce      (EZTRACE_MPI_PREFIX | 0x300b)
#define EZTRACE_MPI_START_Reduce_scatter (EZTRACE_MPI_PREFIX | 0x300c)
#define EZTRACE_MPI_START_Scan           (EZTRACE_MPI_PREFIX | 0x300d)
#define EZTRACE_MPI_START_BARRIER        (EZTRACE_MPI_PREFIX | 0x300e)

#define EZTRACE_MPI_STOP_BCast           (EZTRACE_MPI_PREFIX | 0x3011)
#define EZTRACE_MPI_STOP_Gather          (EZTRACE_MPI_PREFIX | 0x3012)
#define EZTRACE_MPI_STOP_Gatherv         (EZTRACE_MPI_PREFIX | 0x3013)
#define EZTRACE_MPI_STOP_Scatter         (EZTRACE_MPI_PREFIX | 0x3014)
#define EZTRACE_MPI_STOP_Scatterv        (EZTRACE_MPI_PREFIX | 0x3015)
#define EZTRACE_MPI_STOP_Allgather       (EZTRACE_MPI_PREFIX | 0x3016)
#define EZTRACE_MPI_STOP_Allgatherv      (EZTRACE_MPI_PREFIX | 0x3017)
#define EZTRACE_MPI_STOP_Alltoall        (EZTRACE_MPI_PREFIX | 0x3018)
#define EZTRACE_MPI_STOP_Alltoallv       (EZTRACE_MPI_PREFIX | 0x3019)
#define EZTRACE_MPI_STOP_Reduce          (EZTRACE_MPI_PREFIX | 0x301a)
#define EZTRACE_MPI_STOP_Allreduce       (EZTRACE_MPI_PREFIX | 0x301b)
#define EZTRACE_MPI_STOP_Reduce_scatter  (EZTRACE_MPI_PREFIX | 0x301c)
#define EZTRACE_MPI_STOP_Scan            (EZTRACE_MPI_PREFIX | 0x301d)
#define EZTRACE_MPI_STOP_BARRIER         (EZTRACE_MPI_PREFIX | 0x301e)

#define EZTRACE_MPI_IBCAST               (EZTRACE_MPI_PREFIX | 0x3021)
#define EZTRACE_MPI_IGATHER              (EZTRACE_MPI_PREFIX | 0x3022)
#define EZTRACE_MPI_IGATHERV             (EZTRACE_MPI_PREFIX | 0x3023)
#define EZTRACE_MPI_ISCATTER             (EZTRACE_MPI_PREFIX | 0x3024)
#define EZTRACE_MPI_ISCATTERV            (EZTRACE_MPI_PREFIX | 0x3025)
#define EZTRACE_MPI_IALLGATHER           (EZTRACE_MPI_PREFIX | 0x3026)
#define EZTRACE_MPI_IALLGATHERV          (EZTRACE_MPI_PREFIX | 0x3027)
#define EZTRACE_MPI_IALLTOALL            (EZTRACE_MPI_PREFIX | 0x3028)
#define EZTRACE_MPI_IALLTOALLV           (EZTRACE_MPI_PREFIX | 0x3029)
#define EZTRACE_MPI_IREDUCE              (EZTRACE_MPI_PREFIX | 0x302a)
#define EZTRACE_MPI_IALLREDUCE           (EZTRACE_MPI_PREFIX | 0x302b)
#define EZTRACE_MPI_IREDUCE_SCATTER      (EZTRACE_MPI_PREFIX | 0x302c)
#define EZTRACE_MPI_ISCAN                (EZTRACE_MPI_PREFIX | 0x302d)
#define EZTRACE_MPI_IBARRIER             (EZTRACE_MPI_PREFIX | 0x302e)

#define EZTRACE_MPI_SPAWN                (EZTRACE_MPI_PREFIX | 0x4001)
#define EZTRACE_MPI_SPAWNED              (EZTRACE_MPI_PREFIX | 0x4002)

#define EZTRACE_MPI_SEND_INIT            (EZTRACE_MPI_PREFIX | 0x5001)
#define EZTRACE_MPI_BSEND_INIT           (EZTRACE_MPI_PREFIX | 0x5002)
#define EZTRACE_MPI_RSEND_INIT           (EZTRACE_MPI_PREFIX | 0x5003)
#define EZTRACE_MPI_SSEND_INIT           (EZTRACE_MPI_PREFIX | 0x5004)
#define EZTRACE_MPI_RECV_INIT            (EZTRACE_MPI_PREFIX | 0x5010)
#define EZTRACE_MPI_START                (EZTRACE_MPI_PREFIX | 0x5100)

#define EZTRACE_MPI_CANCEL               (EZTRACE_MPI_PREFIX | 0x6001)

#define EZTRACE_MPI_Info                 (EZTRACE_MPI_PREFIX | 0x9999)

#endif	/* __MPI_EV_CODES_H__ */
