// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file deadlinepayload.cpp
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifdef _WIN32
// Remove linker warning LNK4221 on Visual Studio
namespace {
char dummy;
}  // namespace
#endif  // _WIN32

#include "deadlinepayload.h"
#include <fastcdr/Cdr.h>

#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

#include <utility>

HelloMsg::HelloMsg()
{
    // m_deadlinekey com.eprosima.idl.parser.typecode.PrimitiveTypeCode@130f889
    m_deadlinekey = 0;
    // m_payload com.eprosima.idl.parser.typecode.StringTypeCode@101df177
    m_payload ="";

}

HelloMsg::~HelloMsg()
{


}

HelloMsg::HelloMsg(
        const HelloMsg& x)
{
    m_deadlinekey = x.m_deadlinekey;
    m_payload = x.m_payload;
}

HelloMsg::HelloMsg(
        HelloMsg&& x)
{
    m_deadlinekey = x.m_deadlinekey;
    m_payload = std::move(x.m_payload);
}

HelloMsg& HelloMsg::operator =(
        const HelloMsg& x)
{

    m_deadlinekey = x.m_deadlinekey;
    m_payload = x.m_payload;

    return *this;
}

HelloMsg& HelloMsg::operator =(
        HelloMsg&& x)
{

    m_deadlinekey = x.m_deadlinekey;
    m_payload = std::move(x.m_payload);

    return *this;
}

bool HelloMsg::operator ==(
        const HelloMsg& x) const
{

    return (m_deadlinekey == x.m_deadlinekey && m_payload == x.m_payload);
}

bool HelloMsg::operator !=(
        const HelloMsg& x) const
{
    return !(*this == x);
}

size_t HelloMsg::getMaxCdrSerializedSize(
        size_t current_alignment)
{
    size_t initial_alignment = current_alignment;


    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 256 + 1;


    return current_alignment - initial_alignment;
}

size_t HelloMsg::getCdrSerializedSize(
        const HelloMsg& data,
        size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;


    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + data.payload().size() + 1;


    return current_alignment - initial_alignment;
}

void HelloMsg::serialize(
        eprosima::fastcdr::Cdr& scdr) const
{

    scdr << m_deadlinekey;
    scdr << m_payload;

}

void HelloMsg::deserialize(
        eprosima::fastcdr::Cdr& dcdr)
{

    dcdr >> m_deadlinekey;
    dcdr >> m_payload;
}

/*!
 * @brief This function sets a value in member deadlinekey
 * @param _deadlinekey New value for member deadlinekey
 */
void HelloMsg::deadlinekey(
        uint16_t _deadlinekey)
{
    m_deadlinekey = _deadlinekey;
}

/*!
 * @brief This function returns the value of member deadlinekey
 * @return Value of member deadlinekey
 */
uint16_t HelloMsg::deadlinekey() const
{
    return m_deadlinekey;
}

/*!
 * @brief This function returns a reference to member deadlinekey
 * @return Reference to member deadlinekey
 */
uint16_t& HelloMsg::deadlinekey()
{
    return m_deadlinekey;
}

/*!
 * @brief This function copies the value in member payload
 * @param _payload New value to be copied in member payload
 */
void HelloMsg::payload(
        const std::string& _payload)
{
    m_payload = _payload;
}

/*!
 * @brief This function moves the value in member payload
 * @param _payload New value to be moved in member payload
 */
void HelloMsg::payload(
        std::string&& _payload)
{
    m_payload = std::move(_payload);
}

/*!
 * @brief This function returns a constant reference to member payload
 * @return Constant reference to member payload
 */
const std::string& HelloMsg::payload() const
{
    return m_payload;
}

/*!
 * @brief This function returns a reference to member payload
 * @return Reference to member payload
 */
std::string& HelloMsg::payload()
{
    return m_payload;
}

size_t HelloMsg::getKeyMaxCdrSerializedSize(
        size_t current_alignment)
{
    size_t current_align = current_alignment;


     current_align += 2 + eprosima::fastcdr::Cdr::alignment(current_align, 2);

     


    return current_align;
}

bool HelloMsg::isKeyDefined()
{
    return true;
}

void HelloMsg::serializeKey(
        eprosima::fastcdr::Cdr& scdr) const
{
    (void) scdr;
     scdr << m_deadlinekey;
       
}
