/* test-ai.c generated by valac 0.26.0.19-b2255, the Vala compiler
 * generated from test-ai.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Michael Catanzaro
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of Four-in-a-row.
 *
 * Four-in-a-row is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Four-in-a-row is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Four-in-a-row.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_DECISION_TREE (decision_tree_get_type ())
#define DECISION_TREE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DECISION_TREE, DecisionTree))
#define DECISION_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DECISION_TREE, DecisionTreeClass))
#define IS_DECISION_TREE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DECISION_TREE))
#define IS_DECISION_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DECISION_TREE))
#define DECISION_TREE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DECISION_TREE, DecisionTreeClass))

typedef struct _DecisionTree DecisionTree;
typedef struct _DecisionTreeClass DecisionTreeClass;
#define _decision_tree_unref0(var) ((var == NULL) ? NULL : (var = (decision_tree_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);



#define NUMBER_GAMES 5
#define MAXIMUM_GAMES 100
#define THRESHOLD_DENOMINATOR 4
void test_horizontal_win (void);
gint playgame (const gchar* moves_until_now);
void test_vertical_win (void);
void test_forward_diagonal_win (void);
void test_backward_diagonal_win (void);
void test_avoid_vertical_loss (void);
void test_avoid_forward_diagonal_loss (void);
void test_avoid_backward_diagonal_loss (void);
void test_avoid_horizontal_loss (void);
void test_draw (void);
void test_random (void);
gint test_ai_vs_ai (const gchar* easier, const gchar* harder);
gpointer decision_tree_ref (gpointer instance);
void decision_tree_unref (gpointer instance);
GParamSpec* param_spec_decision_tree (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_decision_tree (GValue* value, gpointer v_object);
void value_take_decision_tree (GValue* value, gpointer v_object);
gpointer value_get_decision_tree (const GValue* value);
GType decision_tree_get_type (void) G_GNUC_CONST;
DecisionTree* decision_tree_new (void);
DecisionTree* decision_tree_construct (GType object_type);
gint decision_tree_playandcheck (DecisionTree* self, const gchar* vstr);
void repeat_contests (const gchar* easier, const gchar* harder, gint* games_contested, gint* easy_wins);
void test_easy_vs_medium (void);
void test_easy_vs_hard (void);
void test_medium_vs_hard (void);
gint _vala_main (gchar** args, int args_length1);
static void _test_horizontal_win_gcallback (void);
static void _test_vertical_win_gcallback (void);
static void _test_forward_diagonal_win_gcallback (void);
static void _test_backward_diagonal_win_gcallback (void);
static void _test_avoid_horizontal_loss_gcallback (void);
static void _test_avoid_vertical_loss_gcallback (void);
static void _test_avoid_forward_diagonal_loss_gcallback (void);
static void _test_avoid_backward_diagonal_loss_gcallback (void);
static void _test_easy_vs_medium_gcallback (void);
static void _test_easy_vs_hard_gcallback (void);
static void _test_medium_vs_hard_gcallback (void);
static void _test_draw_gcallback (void);
static void _test_random_gcallback (void);


void test_horizontal_win (void) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 31 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp0_ = playgame ("a1727370");
#line 31 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp0_ == 4, "playgame (\"a1727370\") == 4");
#line 32 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp1_ = playgame ("a7315651311324420");
#line 32 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp1_ == 6, "playgame (\"a7315651311324420\") == 6");
#line 33 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp2_ = playgame ("a232225657223561611133440");
#line 33 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp2_ == 4, "playgame (\"a232225657223561611133440\") == 4");
#line 34 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp3_ = playgame ("a242215322574255543341746677453337710");
#line 34 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp3_ == 1, "playgame (\"a242215322574255543341746677453337710\") == 1");
#line 114 "test-ai.c"
}


void test_vertical_win (void) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 40 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp0_ = playgame ("a1213140");
#line 40 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp0_ == 1, "playgame (\"a1213140\") == 1");
#line 41 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp1_ = playgame ("a14456535526613130");
#line 41 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp1_ == 1, "playgame (\"a14456535526613130\") == 1");
#line 42 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp2_ = playgame ("a432334277752576710");
#line 42 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp2_ == 7, "playgame (\"a432334277752576710\") == 7");
#line 43 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp3_ = playgame ("a547477454544323321712116260");
#line 43 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp3_ == 2, "playgame (\"a547477454544323321712116260\") == 2");
#line 139 "test-ai.c"
}


void test_forward_diagonal_win (void) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 49 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp0_ = playgame ("a54221164712446211622157570");
#line 49 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp0_ == 7, "playgame (\"a54221164712446211622157570\") == 7");
#line 50 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp1_ = playgame ("a4256424426621271412117175776343330");
#line 50 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp1_ == 3, "playgame (\"a4256424426621271412117175776343330\") == 3");
#line 51 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp2_ = playgame ("a132565522322662666775443351131113540");
#line 51 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp2_ == 4, "playgame (\"a132565522322662666775443351131113540\") == 4");
#line 52 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp3_ = playgame ("a4571311334541225544112245262577767733360");
#line 52 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp3_ == 6, "playgame (\"a4571311334541225544112245262577767733360\") == 6");
#line 164 "test-ai.c"
}


void test_backward_diagonal_win (void) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 58 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp0_ = playgame ("5422327343142110");
#line 58 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp0_ == 1, "playgame (\"5422327343142110\") == 1");
#line 59 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp1_ = playgame ("a1415113315143220");
#line 59 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp1_ == 2, "playgame (\"a1415113315143220\") == 2");
#line 60 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp2_ = playgame ("a547323452213345110");
#line 60 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp2_ == 1, "playgame (\"a547323452213345110\") == 1");
#line 61 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp3_ = playgame ("a4256424426621271412117175776343330");
#line 61 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp3_ == 3, "playgame (\"a4256424426621271412117175776343330\") == 3");
#line 189 "test-ai.c"
}


void test_avoid_vertical_loss (void) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 68 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp0_ = playgame ("a42563117273430");
#line 68 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp0_ == 3, "playgame (\"a42563117273430\") == 3");
#line 69 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp1_ = playgame ("a3642571541322340");
#line 69 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp1_ == 4, "playgame (\"a3642571541322340\") == 4");
#line 70 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp2_ = playgame ("a144566264475171137750");
#line 70 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp2_ == 5, "playgame (\"a144566264475171137750\") == 5");
#line 71 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp3_ = playgame ("a54747745454432332171210");
#line 71 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp3_ == 1, "playgame (\"a54747745454432332171210\") == 1");
#line 214 "test-ai.c"
}


void test_avoid_forward_diagonal_loss (void) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 77 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp0_ = playgame ("a34256477331566570");
#line 77 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp0_ == 7, "playgame (\"a34256477331566570\") == 7");
#line 78 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp1_ = playgame ("a1445662644751711370");
#line 78 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp1_ == 7, "playgame (\"a1445662644751711370\") == 7");
#line 79 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp2_ = playgame ("a43442235372115113340");
#line 79 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp2_ == 4, "playgame (\"a43442235372115113340\") == 4");
#line 80 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp3_ = playgame ("a4143525567766443543125411170");
#line 80 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp3_ == 7, "playgame (\"a4143525567766443543125411170\") == 7");
#line 239 "test-ai.c"
}


void test_avoid_backward_diagonal_loss (void) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 86 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp0_ = playgame ("a47465234222530");
#line 86 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp0_ == 3, "playgame (\"a47465234222530\") == 3");
#line 87 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp1_ = playgame ("a4344223537211510");
#line 87 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp1_ == 1, "playgame (\"a4344223537211510\") == 1");
#line 88 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp2_ = playgame ("a4141311525513520");
#line 88 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp2_ == 2, "playgame (\"a4141311525513520\") == 2");
#line 89 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp3_ = playgame ("a1445662644751711377553330");
#line 89 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp3_ == 3, "playgame (\"a1445662644751711377553330\") == 3");
#line 264 "test-ai.c"
}


void test_avoid_horizontal_loss (void) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 96 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp0_ = playgame ("a445360");
#line 96 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp0_ == 7, "playgame (\"a445360\") == 7");
#line 97 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp1_ = playgame ("a745534131117114777720");
#line 97 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp1_ == 2, "playgame (\"a745534131117114777720\") == 2");
#line 98 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp2_ = playgame ("a243466431217112323350");
#line 98 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp2_ == 5, "playgame (\"a243466431217112323350\") == 5");
#line 99 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp3_ = playgame ("a24147356465355111336631615240");
#line 99 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp3_ == 4, "playgame (\"a24147356465355111336631615240\") == 4");
#line 289 "test-ai.c"
}


void test_draw (void) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 105 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp0_ = playgame ("a1311313113652226667224247766737374455445550");
#line 105 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp0_ == 0, "playgame (\"a1311313113652226667224247766737374455445550\") == 0");
#line 106 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp1_ = playgame ("a6121151135432322433425566474425617635677770");
#line 106 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp1_ == 0, "playgame (\"a6121151135432322433425566474425617635677770\") == 0");
#line 107 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp2_ = playgame ("a4226111412113275256335534443264375577676670");
#line 107 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp2_ == 0, "playgame (\"a4226111412113275256335534443264375577676670\") == 0");
#line 108 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp3_ = playgame ("a4212116575717754775221133434432366655342660");
#line 108 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp3_ == 0, "playgame (\"a4212116575717754775221133434432366655342660\") == 0");
#line 314 "test-ai.c"
}


void test_random (void) {
	gint x = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_ = 0;
	gint _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
	gint _tmp14_ = 0;
#line 114 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp0_ = playgame ("a443256214350");
#line 114 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	x = _tmp0_;
#line 115 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp2_ = x;
#line 115 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	if (_tmp2_ >= 1) {
#line 340 "test-ai.c"
		gint _tmp3_ = 0;
#line 115 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp3_ = x;
#line 115 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp1_ = _tmp3_ <= 7;
#line 346 "test-ai.c"
	} else {
#line 115 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp1_ = FALSE;
#line 350 "test-ai.c"
	}
#line 115 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp1_, "x >= 1 && x <= 7");
#line 117 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp4_ = playgame ("a241473564653551113366316150");
#line 117 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	x = _tmp4_;
#line 118 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp6_ = x;
#line 118 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	if (_tmp6_ >= 1) {
#line 362 "test-ai.c"
		gint _tmp7_ = 0;
#line 118 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp7_ = x;
#line 118 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp5_ = _tmp7_ <= 7;
#line 368 "test-ai.c"
	} else {
#line 118 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp5_ = FALSE;
#line 372 "test-ai.c"
	}
#line 118 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp5_, "x >= 1 && x <= 7");
#line 120 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp8_ = playgame ("a24357315461711177416622623350");
#line 120 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	x = _tmp8_;
#line 121 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp10_ = x;
#line 121 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	if (_tmp10_ >= 1) {
#line 384 "test-ai.c"
		gint _tmp11_ = 0;
#line 121 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp11_ = x;
#line 121 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp9_ = _tmp11_ <= 7;
#line 390 "test-ai.c"
	} else {
#line 121 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp9_ = FALSE;
#line 394 "test-ai.c"
	}
#line 121 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp9_, "x >= 1 && x <= 7");
#line 123 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp12_ = playgame ("a1445662644751711377553333665775446110");
#line 123 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	x = _tmp12_;
#line 124 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp14_ = x;
#line 124 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	if (_tmp14_ >= 1) {
#line 406 "test-ai.c"
		gint _tmp15_ = 0;
#line 124 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp15_ = x;
#line 124 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp13_ = _tmp15_ <= 7;
#line 412 "test-ai.c"
	} else {
#line 124 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp13_ = FALSE;
#line 416 "test-ai.c"
	}
#line 124 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (_tmp13_, "x >= 1 && x <= 7");
#line 420 "test-ai.c"
}


gint test_ai_vs_ai (const gchar* easier, const gchar* harder) {
	gint result = 0;
	gint easier_wins = 0;
	gint draw = 0;
	gint harder_wins = 0;
#line 128 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_return_val_if_fail (easier != NULL, 0);
#line 128 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_return_val_if_fail (harder != NULL, 0);
#line 130 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	easier_wins = 0;
#line 131 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	draw = 0;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	harder_wins = 0;
#line 439 "test-ai.c"
	{
		gint i = 0;
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		i = 0;
#line 444 "test-ai.c"
		{
			gboolean _tmp0_ = FALSE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
			_tmp0_ = TRUE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
			while (TRUE) {
#line 451 "test-ai.c"
				gint _tmp2_ = 0;
				GString* e = NULL;
				GString* _tmp3_ = NULL;
				GString* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				GString* m = NULL;
				GString* _tmp6_ = NULL;
				GString* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				if (!_tmp0_) {
#line 463 "test-ai.c"
					gint _tmp1_ = 0;
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp1_ = i;
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					i = _tmp1_ + 1;
#line 469 "test-ai.c"
				}
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				_tmp0_ = FALSE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				_tmp2_ = i;
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				if (!(_tmp2_ < NUMBER_GAMES)) {
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					break;
#line 479 "test-ai.c"
				}
#line 136 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				_tmp3_ = g_string_new ("");
#line 136 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				e = _tmp3_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				_tmp4_ = e;
#line 137 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				_tmp5_ = easier;
#line 137 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				g_string_append (_tmp4_, _tmp5_);
#line 139 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				_tmp6_ = g_string_new ("");
#line 139 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				m = _tmp6_;
#line 140 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				_tmp7_ = m;
#line 140 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				_tmp8_ = harder;
#line 140 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				g_string_append (_tmp7_, _tmp8_);
#line 142 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				while (TRUE) {
#line 503 "test-ai.c"
					gint move = 0;
					DecisionTree* t = NULL;
					DecisionTree* _tmp9_ = NULL;
					DecisionTree* _tmp10_ = NULL;
					GString* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					gint _tmp16_ = 0;
					GString* _tmp18_ = NULL;
					GString* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					gint _tmp22_ = 0;
					gint _tmp23_ = 0;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					GString* _tmp26_ = NULL;
					GString* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
					gchar* _tmp32_ = NULL;
					gchar* _tmp33_ = NULL;
					DecisionTree* d = NULL;
					DecisionTree* _tmp34_ = NULL;
					DecisionTree* _tmp35_ = NULL;
					GString* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gint _tmp38_ = 0;
					gint _tmp39_ = 0;
					gint _tmp41_ = 0;
					GString* _tmp43_ = NULL;
					GString* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					gint _tmp46_ = 0;
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_ = NULL;
					GString* _tmp51_ = NULL;
					GString* _tmp52_ = NULL;
					const gchar* _tmp53_ = NULL;
					gint _tmp54_ = 0;
					gint _tmp55_ = 0;
					gint _tmp56_ = 0;
					gchar* _tmp57_ = NULL;
					gchar* _tmp58_ = NULL;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp9_ = decision_tree_new ();
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					t = _tmp9_;
#line 146 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp10_ = t;
#line 146 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp11_ = e;
#line 146 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp12_ = _tmp11_->str;
#line 146 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp13_ = decision_tree_playandcheck (_tmp10_, _tmp12_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					move = _tmp13_;
#line 147 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp14_ = move;
#line 147 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					if (_tmp14_ == 0) {
#line 571 "test-ai.c"
						gint _tmp15_ = 0;
#line 149 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						_tmp15_ = draw;
#line 149 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						draw = _tmp15_ + 1;
#line 150 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						_decision_tree_unref0 (t);
#line 150 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						break;
#line 581 "test-ai.c"
					}
#line 153 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp16_ = move;
#line 153 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					if (_tmp16_ == 1000) {
#line 587 "test-ai.c"
						gint _tmp17_ = 0;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						_tmp17_ = easier_wins;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						easier_wins = _tmp17_ + 1;
#line 156 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						_decision_tree_unref0 (t);
#line 156 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						break;
#line 597 "test-ai.c"
					}
#line 159 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp18_ = e;
#line 159 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp19_ = e;
#line 159 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp20_ = _tmp19_->str;
#line 159 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp21_ = strlen (_tmp20_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp22_ = _tmp21_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp23_ = move;
#line 159 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp24_ = g_strdup_printf ("%i", _tmp23_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp25_ = _tmp24_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					g_string_insert (_tmp18_, (gssize) (_tmp22_ - 1), _tmp25_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_g_free0 (_tmp25_);
#line 160 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp26_ = m;
#line 160 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp27_ = m;
#line 160 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp28_ = _tmp27_->str;
#line 160 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp29_ = strlen (_tmp28_);
#line 160 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp30_ = _tmp29_;
#line 160 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp31_ = move;
#line 160 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp32_ = g_strdup_printf ("%i", _tmp31_);
#line 160 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp33_ = _tmp32_;
#line 160 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					g_string_insert (_tmp26_, (gssize) (_tmp30_ - 1), _tmp33_);
#line 160 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_g_free0 (_tmp33_);
#line 162 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp34_ = decision_tree_new ();
#line 162 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					d = _tmp34_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp35_ = d;
#line 163 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp36_ = m;
#line 163 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp37_ = _tmp36_->str;
#line 163 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp38_ = decision_tree_playandcheck (_tmp35_, _tmp37_);
#line 163 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					move = _tmp38_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp39_ = move;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					if (_tmp39_ == 0) {
#line 657 "test-ai.c"
						gint _tmp40_ = 0;
#line 167 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						_tmp40_ = draw;
#line 167 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						draw = _tmp40_ + 1;
#line 168 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						_decision_tree_unref0 (d);
#line 168 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						_decision_tree_unref0 (t);
#line 168 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						break;
#line 669 "test-ai.c"
					}
#line 171 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp41_ = move;
#line 171 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					if (_tmp41_ == 1000) {
#line 675 "test-ai.c"
						gint _tmp42_ = 0;
#line 173 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						_tmp42_ = harder_wins;
#line 173 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						harder_wins = _tmp42_ + 1;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						_decision_tree_unref0 (d);
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						_decision_tree_unref0 (t);
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
						break;
#line 687 "test-ai.c"
					}
#line 176 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp43_ = e;
#line 176 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp44_ = e;
#line 176 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp45_ = _tmp44_->str;
#line 176 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp46_ = strlen (_tmp45_);
#line 176 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp47_ = _tmp46_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp48_ = move;
#line 176 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp49_ = g_strdup_printf ("%i", _tmp48_);
#line 176 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp50_ = _tmp49_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					g_string_insert (_tmp43_, (gssize) (_tmp47_ - 1), _tmp50_);
#line 176 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_g_free0 (_tmp50_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp51_ = m;
#line 177 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp52_ = m;
#line 177 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp53_ = _tmp52_->str;
#line 177 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp54_ = strlen (_tmp53_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp55_ = _tmp54_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp56_ = move;
#line 177 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp57_ = g_strdup_printf ("%i", _tmp56_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_tmp58_ = _tmp57_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					g_string_insert (_tmp51_, (gssize) (_tmp55_ - 1), _tmp58_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_g_free0 (_tmp58_);
#line 142 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_decision_tree_unref0 (d);
#line 142 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
					_decision_tree_unref0 (t);
#line 733 "test-ai.c"
				}
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				_g_string_free0 (m);
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
				_g_string_free0 (e);
#line 739 "test-ai.c"
			}
		}
	}
#line 180 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	result = easier_wins;
#line 180 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	return result;
#line 747 "test-ai.c"
}


void repeat_contests (const gchar* easier, const gchar* harder, gint* games_contested, gint* easy_wins) {
	gint _vala_games_contested = 0;
	gint _vala_easy_wins = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 185 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_return_if_fail (easier != NULL);
#line 185 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_return_if_fail (harder != NULL);
#line 187 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp0_ = easier;
#line 187 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp1_ = harder;
#line 187 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp2_ = test_ai_vs_ai (_tmp0_, _tmp1_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_easy_wins = _tmp2_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_games_contested = NUMBER_GAMES;
#line 190 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	while (TRUE) {
#line 773 "test-ai.c"
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
		gint _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 190 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp4_ = _vala_games_contested;
#line 190 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		if (_tmp4_ <= MAXIMUM_GAMES) {
#line 785 "test-ai.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
#line 190 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
			_tmp5_ = _vala_easy_wins;
#line 190 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
			_tmp6_ = _vala_games_contested;
#line 190 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
			_tmp3_ = _tmp5_ > (_tmp6_ / THRESHOLD_DENOMINATOR);
#line 794 "test-ai.c"
		} else {
#line 190 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
			_tmp3_ = FALSE;
#line 798 "test-ai.c"
		}
#line 190 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		if (!_tmp3_) {
#line 190 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
			break;
#line 804 "test-ai.c"
		}
#line 192 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp7_ = _vala_easy_wins;
#line 192 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp8_ = easier;
#line 192 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp9_ = harder;
#line 192 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp10_ = test_ai_vs_ai (_tmp8_, _tmp9_);
#line 192 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_vala_easy_wins = _tmp7_ + _tmp10_;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_tmp11_ = _vala_games_contested;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		_vala_games_contested = _tmp11_ + NUMBER_GAMES;
#line 820 "test-ai.c"
	}
#line 185 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	if (games_contested) {
#line 185 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		*games_contested = _vala_games_contested;
#line 826 "test-ai.c"
	}
#line 185 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	if (easy_wins) {
#line 185 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
		*easy_wins = _vala_easy_wins;
#line 832 "test-ai.c"
	}
}


void test_easy_vs_medium (void) {
	gint easy_wins = 0;
	gint games_contested = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 201 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	repeat_contests ("a0", "b0", &_tmp0_, &_tmp1_);
#line 201 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	games_contested = _tmp0_;
#line 201 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	easy_wins = _tmp1_;
#line 203 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (easy_wins <= (games_contested / THRESHOLD_DENOMINATOR), "easy_wins <= games_contested/THRESHOLD_DENOMINATOR");
#line 850 "test-ai.c"
}


void test_easy_vs_hard (void) {
	gint easy_wins = 0;
	gint games_contested = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 210 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	repeat_contests ("a0", "c0", &_tmp0_, &_tmp1_);
#line 210 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	games_contested = _tmp0_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	easy_wins = _tmp1_;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (easy_wins <= (games_contested / THRESHOLD_DENOMINATOR), "easy_wins <= games_contested/THRESHOLD_DENOMINATOR");
#line 867 "test-ai.c"
}


void test_medium_vs_hard (void) {
	gint medium_wins = 0;
	gint games_contested = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 219 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	repeat_contests ("b0", "c0", &_tmp0_, &_tmp1_);
#line 219 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	games_contested = _tmp0_;
#line 219 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	medium_wins = _tmp1_;
#line 221 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_vala_assert (medium_wins <= (games_contested / THRESHOLD_DENOMINATOR), "medium_wins <= games_contested/THRESHOLD_DENOMINATOR");
#line 884 "test-ai.c"
}


static void _test_horizontal_win_gcallback (void) {
#line 227 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	test_horizontal_win ();
#line 891 "test-ai.c"
}


static void _test_vertical_win_gcallback (void) {
#line 228 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	test_vertical_win ();
#line 898 "test-ai.c"
}


static void _test_forward_diagonal_win_gcallback (void) {
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	test_forward_diagonal_win ();
#line 905 "test-ai.c"
}


static void _test_backward_diagonal_win_gcallback (void) {
#line 230 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	test_backward_diagonal_win ();
#line 912 "test-ai.c"
}


static void _test_avoid_horizontal_loss_gcallback (void) {
#line 231 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	test_avoid_horizontal_loss ();
#line 919 "test-ai.c"
}


static void _test_avoid_vertical_loss_gcallback (void) {
#line 232 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	test_avoid_vertical_loss ();
#line 926 "test-ai.c"
}


static void _test_avoid_forward_diagonal_loss_gcallback (void) {
#line 233 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	test_avoid_forward_diagonal_loss ();
#line 933 "test-ai.c"
}


static void _test_avoid_backward_diagonal_loss_gcallback (void) {
#line 234 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	test_avoid_backward_diagonal_loss ();
#line 940 "test-ai.c"
}


static void _test_easy_vs_medium_gcallback (void) {
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	test_easy_vs_medium ();
#line 947 "test-ai.c"
}


static void _test_easy_vs_hard_gcallback (void) {
#line 236 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	test_easy_vs_hard ();
#line 954 "test-ai.c"
}


static void _test_medium_vs_hard_gcallback (void) {
#line 237 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	test_medium_vs_hard ();
#line 961 "test-ai.c"
}


static void _test_draw_gcallback (void) {
#line 238 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	test_draw ();
#line 968 "test-ai.c"
}


static void _test_random_gcallback (void) {
#line 239 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	test_random ();
#line 975 "test-ai.c"
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 226 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_test_init (&args_length1, &args, NULL);
#line 227 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_test_add_func ("/AI/Take Win/Horizontal Win", _test_horizontal_win_gcallback);
#line 228 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_test_add_func ("/AI/Take Win/Vertical Win", _test_vertical_win_gcallback);
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_test_add_func ("/AI/Take Win/Forward Diagonal Win", _test_forward_diagonal_win_gcallback);
#line 230 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_test_add_func ("/AI/Take Win/Backward Diagonal Win", _test_backward_diagonal_win_gcallback);
#line 231 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_test_add_func ("/AI/Avoid Loss/Horizontal Loss", _test_avoid_horizontal_loss_gcallback);
#line 232 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_test_add_func ("/AI/Avoid Loss/Vertical Loss", _test_avoid_vertical_loss_gcallback);
#line 233 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_test_add_func ("/AI/Avoid Loss/Forward Diagonal Loss", _test_avoid_forward_diagonal_loss_gcallback);
#line 234 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_test_add_func ("/AI/Avoid Loss/Backward Diagonal Loss", _test_avoid_backward_diagonal_loss_gcallback);
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_test_add_func ("/AI/AI vs AI/Easy vs Medium", _test_easy_vs_medium_gcallback);
#line 236 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_test_add_func ("/AI/AI vs AI/Easy vs Hard", _test_easy_vs_hard_gcallback);
#line 237 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_test_add_func ("/AI/AI vs AI/Medium vs Hard", _test_medium_vs_hard_gcallback);
#line 238 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_test_add_func ("/AI/Draw", _test_draw_gcallback);
#line 239 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	g_test_add_func ("/AI/Random", _test_random_gcallback);
#line 240 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	_tmp0_ = g_test_run ();
#line 240 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	result = _tmp0_;
#line 240 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	return result;
#line 1016 "test-ai.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 224 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/test-ai.vala"
	return _vala_main (argv, argc);
#line 1026 "test-ai.c"
}



