{
    package GCLang::ZH;

    use utf8;
###################################################
#
#  Copyright 2005-2010 Christian Jodar
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################
    
    use strict;
    use base 'Exporter';

    our @EXPORT = qw(%lang);

    our %lang = (

        'LangName' => '中文(繁體)',
        
        'Separator' => ': ',
        
        'Warning' => '<b>警告</b>:
        
透過插件從網站上下載的資訊<b>僅限於個人使用</b>。

沒有<b>獲取額外授權</b>的任何二次轉發行為都是非法的。

若想確認哪個網站擁有這些資訊，你可以使用<b>項目細節下的按鈕</b>。',
        
        'AllItemsFiltered' => '沒有項目匹配過濾器要求',
        
#Installation
        'InstallDirInfo' => '安裝到',
        'InstallMandatory' => '必要元件',
        'InstallOptional' => '選擇元件',
        'InstallErrorMissing' => '錯誤：以下Perl組件必須被安裝：',
        'InstallPrompt' => '安裝的基礎資料夾 [/usr/local]: ',
        'InstallEnd' => '安裝完畢',
        'InstallNoError' => '沒有錯誤',
        'InstallLaunch' => '想使用這個應用程式，請點擊一下',
        'InstallDirectory' => '基礎資料夾',
        'InstallTitle' => 'GCstar 安裝程式',
        'InstallDependencies' => '相依元件',
        'InstallPath' => '路徑',
        'InstallOptions' => '選項',
        'InstallSelectDirectory' => '選擇安裝用的基礎資料夾',
        'InstallWithClean' => '移除安裝資料夾中的檔案',
        'InstallWithMenu' => '將GCstar加入應用程式選單',
        'InstallNoPermission' => '錯誤：你沒有寫入指定資料夾的權限',
        'InstallMissingMandatory' => '必要相依元件不存在。在獲取這些元件前，你不能夠安裝GCstar。',
        'InstallMissingOptional' => '部份選擇相依元件不存在。詳細列表顯示於下。 GCstar或許可以安裝，但部份功能將會失效。',
        'InstallMissingNone' => '沒有任何相依問題，你可以繼續並安裝GCstar',
        'InstallOK' => '完成',
        'InstallMissing' => '不存在',
        'InstallMissingFor' => '不存在',
        'InstallCleanDirectory' => '移除資料夾中的GCstar檔案：',
        'InstallCopyDirectory' => '將檔案拷貝到資料夾：',
        'InstallCopyDesktop' => '複製桌面文件：',

#Update
        'UpdateUseProxy' => '使用代理（如果沒有使用代理直接按下ENTER）：',
        'UpdateNoPermission' => '這個資料夾沒有寫入權限：',
        'UpdateNone' => '沒有發現更新',
        'UpdateFileNotFound' => '檔案不存在',

#Splash
        'SplashInit' => '初始化',
        'SplashLoad' => '載入收藏集',
        'SplashDisplay' => '正在顯示收藏集',
        'SplashSort' => '排序收藏集',
        'SplashDone' => '準備完成',

#Import from GCfilms
        'GCfilmsImportQuestion' => '你似乎先前用過GCfilms，你想要匯入GCfilms資料到GCstar中嗎（這不會損傷你的GCfilms資料）？',
        'GCfilmsImportOptions' => '設定',
        'GCfilmsImportData' => '電影列表',

#Menus
        'MenuFile' => '檔案（_F）',
            'MenuNewList' => '新收藏集(_N)',
            'MenuStats' => 'Statistics',
            'MenuHistory' => '最近使用的收藏集(_R)',
            'MenuLend' => '顯示被借走的東西(_B)',
            'MenuImport' => '匯入(_I)',	
            'MenuExport' => '匯出(_E)',
            'MenuAddItem' => '_Add {1}', # Accepts model codes
    
        'MenuEdit'  => '編輯(_E)',
            'MenuDuplicate' => '複製項目(_p)',
            'MenuDuplicatePlural' => '複製項目(_p)',
            'MenuEditSelectAllItems' => 'Select _All {X}', # Accepts model codes
            'MenuEditDeleteCurrent' => '移除項目(_R)',
            'MenuEditDeleteCurrentPlural' => '移除項目(_R)',
            'MenuEditFields' => '變更收藏集欄位(_C)',
            'MenuEditLockItems' => '鎖定收藏集(_L)',
    
        'MenuDisplay' => '過濾器(_i)',
            'MenuSavedSearches' => '儲存搜尋',
                'MenuSavedSearchesSave' => '儲存當前搜尋',
                'MenuSavedSearchesEdit' => '變更已經儲存的搜尋',
            'MenuAdvancedSearch' => '進階搜尋(_d)',
            'MenuViewAllItems' => '顯示全部項目(_A)',
            'MenuNoFilter' => '全部(_A)',
    
        'MenuConfiguration' => '設定(_S)',
            'MenuDisplayOptions' => '顯示資訊(_D)',
            'MenuBorrowers' => '出借對象(_B)',
            'MenuToolbarConfiguration' => '工具列控制（_T）',
            'MenuGenresConversion' => '類型轉換(_C)',
        
        'MenuBookmarks' => '我的收藏集(_C)',
            'MenuBookmarksAdd' => '加入當前收藏集(_A)',
            'MenuBookmarksEdit' => '編輯被書籤的收藏集（_E）',

        'MenuHelp' => '幫助(_H)',
            'MenuHelpContent' => '內容(_C)',
            'MenuAllPlugins' => '檢視插件(_P)',
            'MenuBugReport' => '回報問題',
            'MenuAbout' => '關於GCstar(_A)',
    
        'MenuNewWindow' => '在新視窗中顯示項目(_N)',
        'MenuNewWindowPlural' => '在新視窗中顯示項目(_N)',
        
        'ContextExpandAll' => '展開全部',
        'ContextCollapseAll' => '收合全部',
        'ContextChooseImage' => '選擇圖片(_I)',
        'ContextOpenWith' => '以指定程式開啟(_h)...',
        'ContextImageEditor' => 'Image Editor',
        'ContextImgFront' => '封面',
        'ContextImgBack' => '封底',
        'ContextChooseFile' => '請選擇要使用的檔案',
        'ContextChooseFolder' => '選擇一個資料夾',

        'DialogEnterNumber' => '請輸入數值',

        'RemoveConfirm' => '你確定要移除這個項目？',
        'RemoveConfirmPlural' => '你確定要移除這個項目？',
        'DefaultNewItem' => '新項目',
        'NewItemTooltip' => '加入一個新項目',
        'NoItemFound' => '沒有發現，想要搜尋其他站點嗎？',
        'OpenList' => '請選擇收藏集',
        'SaveList' => '請選擇要將這個收藏集保存在哪裡？',
        'SaveListTooltip' => '保存當前的收藏集',
        'SaveUnsavedChanges' => '你收藏集中的變更還未儲存，現在儲存嗎？',
        'SaveDontSave' => '不儲存',
        'PreferencesTooltip' => '設定偏好',
        'ViewTooltip' => '改變收藏集顯示',
        'PlayTooltip' => '針對項目啟動檔案關聯（通常是播放的意思）',
        'PlayFileNotFound' => '在指定位置上沒有發現目標檔案：',
        'PlayRetry' => '重試',

        'StatusSave' => '儲存中...',
        'StatusLoad' => '載入中...',
        'StatusSearch' => '搜尋正在進行...',
        'StatusGetInfo' => '取得資訊...',
        'StatusGetImage' => '取得圖片...',
                
        'SaveError' => '不能儲存項目列表，請檢查檔案存取權限與剩餘磁碟空間。',
        'OpenError' => '不能開啟項目列表，請檢查檔案存取權限。',
        'OpenFormatError' => '不能開啟項目列表，因為檔案格式不正確。',
        'OpenVersionWarning' => '本收藏集由更新版本的GCstar建立。如果你儲存，你可能會失去某些訊息。',
        'OpenVersionQuestion' => '你依然想繼續嗎？',
        'ImageError' => '選擇儲存圖片的資料夾不正確，請選擇另一個。',
        'OptionsCreationError'=> '不能建立設定檔。',
        'OptionsOpenError'=> '不能打開設定檔：',
        'OptionsSaveError'=> '不能儲存設定檔：',
        'ErrorModelNotFound' => '未發現模組：',
        'ErrorModelUserDir' => '使用者定義模組在：',
        
        'RandomTooltip' => 'What to see this evening ?',
        'RandomError'=> '沒有項目可供選擇',
        'RandomEnd'=> '沒有更多項目',
        'RandomNextTip'=> '下一個建議',
        'RandomOkTip'=> '接受這個項目',
        
        'AboutTitle' => '關於GCstar',
        'AboutDesc' => '個人收藏品管理器',
        'AboutVersion' => '版本',
        'AboutTeam' => '團隊',
        'AboutWho' => 'Christian Jodar (Tian): Project manager, Programmer
Nyall Dawson (Zombiepig): Programmer
TPF: Programmer
Adolfo González: Programmer
',
        'AboutLicense' => '以GNU GPL授權發佈
Logos Copyright le Spektre
http://le-spektre.org',
        'AboutTranslation' => '中文翻譯由林雪凡製作
http://wfst.blogspot.com',
        'AboutDesign' => 'Łukasz Kowalczk (Qoolman): Skin Designer
Logo和網路設計： le Spektre',

        'UnsavedCollection' => '未儲存的收藏集',
        'ModelsSelect' => '選擇一個收藏集類型',
        'ModelsPersonal' => '個人模組',
        'ModelsDefault' => '預設模組',
        'ModelsList' => '收藏集定義',
        'ModelSettings' => '收藏集設定',
        'ModelNewType' => '新的收藏集類型',
        'ModelName' => '收藏集類型的名字：',
		'ModelFields' => '欄位',
		'ModelOptions'	=> '選項',
		'ModelFilters'	=> '過濾器',
        'ModelNewField' => '新欄位',
        'ModelFieldInformation' => '資訊',
        'ModelFieldName' => '欄位名稱：',
        'ModelFieldType' => '類型：',
        'ModelFieldGroup' => '組別：',
        'ModelFieldValues' => '值',
        'ModelFieldInit' => '預設：',
        'ModelFieldMin' => '最小：',
        'ModelFieldMax' => '最大：',
        'ModelFieldList' => '列表：',
        'ModelFieldListLegend' => '<i>用半形逗號分隔</i>',
        'ModelFieldDisplayAs' => '顯示成：',
        'ModelFieldDisplayAsText' => '文字',
        'ModelFieldDisplayAsGraphical' => '評分條',
        'ModelFieldTypeShortText' => '短文字',
        'ModelFieldTypeLongText' => '長文字',
        'ModelFieldTypeYesNo' => '布林值',
        'ModelFieldTypeNumber' => '數字',
        'ModelFieldTypeDate' => '日期',
        'ModelFieldTypeOptions' => '預定義選擇列表',
        'ModelFieldTypeImage' => '圖片',
        'ModelFieldTypeSingleList' => '簡表',
        'ModelFieldTypeFile' => '檔案',
        'ModelFieldTypeFormatted' => '依賴其他欄位',
        'ModelFieldParameters' => '變數',
        'ModelFieldHasHistory' => '使用歷史資訊',
        'ModelFieldFlat' => '單行顯示',
        'ModelFieldStep' => '累進增加：',
        'ModelFieldFileFormat' => '檔案格式：',
        'ModelFieldFileFile' => '一般檔案',
        'ModelFieldFileImage' => '圖片',
        'ModelFieldFileVideo' => '影片',
        'ModelFieldFileAudio' => '音訊',
        'ModelFieldFileProgram' => '程式',
        'ModelFieldFileUrl' => '統一資源定義符(URL)',
        'ModelFieldFileEbook' => 'Ebook',
        'ModelOptionsFields' => '使用欄位',
        'ModelOptionsFieldsAuto' => '自動',
        'ModelOptionsFieldsNone' => '無',
        'ModelOptionsFieldsTitle' => '作為標題',
        'ModelOptionsFieldsId' => '作為ID',
        'ModelOptionsFieldsCover' => '作為封面',
        'ModelOptionsFieldsPlay' => '連給播放按鈕',
        'ModelCollectionSettings' => '收藏集設定',
        'ModelCollectionSettingsLending' => '可被借出',
        'ModelCollectionSettingsTagging' => '可加標籤',
        'ModelFilterActivated' => '收錄進搜尋盒內',
        'ModelFilterComparison' => '比較',
        'ModelFilterContain' => '含有',
        'ModelFilterDoesNotContain' => '未含有',
        'ModelFilterRegexp' => '正則表示式',
        'ModelFilterRange' => '範圍',
        'ModelFilterNumeric' => '以數字比較',
        'ModelFilterQuick' => '建立一個快速過濾器',
        'ModelTooltipName' => '建立名字以供其他收藏集使用。如果空白，相關設定會直接儲存在收藏集裡面。',
        'ModelTooltipLabel' => '用來顯示的欄位名稱',
        'ModelTooltipGroup' => '供欄位的分組使用，不設定會將欄位歸入預設分組',
        'ModelTooltipHistory' => '過去的輸入值將會被建成列表供選擇',
        'ModelTooltipFormat' => '格式將會決定播放按鈕關聯到什麼程式',
        'ModelTooltipLending' => '這會在收藏集裡加入一些欄位來管理借出資訊',
        'ModelTooltipTagging' => '這會加入一些欄位來管理標籤',
        'ModelTooltipNumeric' => '這個值將會被當作數字來比較',
        'ModelTooltipQuick' => 'This will add a submenu in the Filters one',
        
        'ResultsTitle' => '選擇一個項目',
        'ResultsNextTip' => '搜尋下一個網站',
        'ResultsPreview' => '預覽',
        'ResultsInfo' => '藉由按住Ctrl或shift鍵，你可以加入多個項目到收藏集中',
        
        'OptionsTitle' => '偏好設定',
		'OptionsExpertMode' => '專家模式',
        'OptionsPrograms' => '對不同類型的檔案用不同的程式開啟，若留白則使用系統預設值',
        'OptionsBrowser' => '網頁瀏覽器',
        'OptionsPlayer' => '影片播放器',
        'OptionsAudio' => '音訊播放器',
        'OptionsImageEditor' => '影像編輯器',
        'OptionsCdDevice' => 'CD裝置',
        'OptionsImages' => '圖片資料夾',
        'OptionsUseRelativePaths' => '對圖片使用相對路徑',
        'OptionsLayout' => '視窗佈局方式',
        'OptionsStatus' => '顯示狀態條',
        'OptionsUseStars' => '使用星號來顯示評分',
        'OptionsWarning' => '警告：改變這個標籤頁後必須要重啟程式才會生效。',
        'OptionsRemoveConfirm' => '在項目刪除前要求確認',
        'OptionsAutoSave' => '自動儲存收藏集',
        'OptionsAutoLoad' => '在啟動時載入先前的收藏集',
        'OptionsSplash' => '顯示啟動畫面',
        'OptionsTearoffMenus' => '允許撕開選單',
        'OptionsSpellCheck' => '在長文字欄位使用語法檢查',
        'OptionsProgramTitle' => '選擇使用的程式',
		'OptionsPlugins' => '從哪些網站取得項目資料',
		'OptionsAskPlugins' => '詢問 (全部網站)',
		'OptionsPluginsMulti' => '多數網站',
		'OptionsPluginsMultiAsk' => '詢問 (多數網站)',
        'OptionsPluginsMultiPerField' => 'Many sites (per field)',
        'OptionsPluginsMultiPerFieldWindowTitle' => 'Many sites per field order selection',
        'OptionsPluginsMultiPerFieldDesc' => 'For each field we will fill the field with the first non empty information beginning from left',
        'OptionsPluginsMultiPerFieldFirst' => 'First',
        'OptionsPluginsMultiPerFieldLast' => 'Last',
        'OptionsPluginsMultiPerFieldRemove' => 'Remove',
        'OptionsPluginsMultiPerFieldClearSelected' => 'Empty selected field list',
		'OptionsPluginsList' => '設定列表',
        'OptionsAskImport' => '選擇欄位來匯入',
		'OptionsProxy' => '使用代理',
		'OptionsCookieJar' => '使用cookie jar檔案',
        'OptionsLang' => '語言',
        'OptionsMain' => '主要',
        'OptionsPaths' => '路徑',
        'OptionsInternet' => '網際網路',
        'OptionsConveniences' => '其他特徵',
        'OptionsDisplay' => '顯示',
        'OptionsToolbar' => '工具列',
        'OptionsToolbars' => {0 => '無', 1 => '小', 2 => '大', 3 => '系統設定'},
        'OptionsToolbarPosition' => '位置',
        'OptionsToolbarPositions' => {0 => '上', 1 => '下', 2 => '左', 3 => '右'},
        'OptionsExpandersMode' => '過長的文字',
        'OptionsExpandersModes' => {'asis' => '不管它', 'cut' => '切斷', 'wrap' => '自動換行'},
        'OptionsDateFormat' => '日期格式',
        'OptionsDateFormatTooltip' => '使用strftime(3)格式，預設值為%d/%m/%Y',
        'OptionsView' => '項目列表',
        'OptionsViews' => {0 => '文字', 1 => '圖片', 2 => '細節'},
        'OptionsColumns' => '欄',
        'OptionsMailer' => '寄件程式',
        'OptionsSMTP' => '伺服器',
        'OptionsFrom' => '你的e-mail',
        'OptionsTransform' => 'Place articles at the end of titles',
        'OptionsArticles' => 'Articles (用逗點分開)',
        'OptionsSearchStop' => '允許搜尋被放棄',
        'OptionsBigPics' => '在可以的狀況下使用大圖片',
        'OptionsAlwaysOriginal' => 'Use main title as the original title if none present',
        'OptionsRestoreAccelerators' => 'Restore accelerators',
        'OptionsHistory' => '歷史大小',
        'OptionsClearHistory' => '清除歷史',
		'OptionsStyle' => '面板',
        'OptionsDontAsk' => '別再詢問',
        'OptionsPathProgramsGroup' => 'Applications',
        'OptionsProgramsSystem' => '使用系統定義的程式',
        'OptionsProgramsUser' => '複寫預設的程式',
        'OptionsProgramsSet' => '設定程式',
        'OptionsPathImagesGroup' => '圖片',
        'OptionsInternetDataGroup' => '資料匯入',
        'OptionsInternetSettingsGroup' => '設定',
        'OptionsDisplayInformationGroup' => '訊息顯示方式',
        'OptionsDisplayArticlesGroup' => 'Articles',
        'OptionsImagesDisplayGroup' => '顯示',
        'OptionsImagesStyleGroup' => '風格',
        'OptionsDetailedPreferencesGroup' => '偏好設定',
        'OptionsFeaturesConveniencesGroup' => 'Conveniences',
        'OptionsPicturesFormat' => '圖片前綴：',
        'OptionsPicturesFormatInternal' => 'gcstar__',
        'OptionsPicturesFormatTitle' => '關聯項目的標題或名字',
        'OptionsPicturesWorkingDir' => '%WORKING_DIR% 或 . 被用來代指收藏集資料夾（在路徑的開始處）',
        'OptionsPicturesFileBase' => '%FILE_BASE% 被用來代指沒有後綴的收藏集檔名（.gcs）',
        'OptionsPicturesWorkingDirError' => '%WORKING_DIR% 只能被用在圖片路徑的開頭',
        'OptionsConfigureMailers' => '設定郵件程式',

        'ImagesOptionsButton' => '設定',
        'ImagesOptionsTitle' => '設定圖片列表',
        'ImagesOptionsSelectColor' => '選擇一個顏色',
        'ImagesOptionsUseOverlays' => '使用圖像層疊',
        'ImagesOptionsBg' => '背景',
        'ImagesOptionsBgPicture' => '使用背景圖片',
        'ImagesOptionsFg'=> '選擇',
        'ImagesOptionsBgTooltip' => '改變背景色',
        'ImagesOptionsFgTooltip'=> '改變選擇顏色',
        'ImagesOptionsResizeImgList' => '自動改變欄的數字',
        'ImagesOptionsSizeLabel' => '尺寸',
        'ImagesOptionsSizeList' => {0 => '極小', 1 => '小', 2 => '中', 3 => '大', 4 => '極大'},
        'ImagesOptionsSizeTooltip' => '選擇圖片尺寸',
		        
        'DetailedOptionsTitle' => '設定細節列表',
        'DetailedOptionsImageSize' => '圖片尺寸',
        'DetailedOptionsGroupItems' => '項目分組依據',
        'DetailedOptionsSecondarySort' => 'Sort field for children',
		'DetailedOptionsFields' => 'Select fields to display',
        'DetailedOptionsGroupedFirst' => 'Keep together orphaned items',
        'DetailedOptionsAddCount' => 'Add number of elements on categories',

        'ExtractButton' => '訊息',
        'ExtractTitle' => '檔案訊息',
        'ExtractImport' => '使用值',

        'FieldsListOpen' => '從檔案載入欄位列表',
        'FieldsListSave' => '儲存欄位列表到檔案',
        'FieldsListError' => '這個欄位列表不能被用在這個類型的收藏集上',
        'FieldsListIgnore' => '--- 忽略',

        'ExportTitle' => '匯出項目列表',
        'ExportFilter' => '僅匯出顯示的項目',
        'ExportFieldsTitle' => '欄位被匯出',
        'ExportFieldsTip' => '選擇你想匯出的欄位',
        'ExportWithPictures' => '複製子目錄中的圖片',
        'ExportSortBy' => '排序依據',
        'ExportOrder' => 'Order',

        'ImportListTitle' => '匯入另一個項目列表',
        'ImportExportData' => '資料',
        'ImportExportFile' => '檔案',
        'ImportExportFieldsUnused' => '未使用欄位',
        'ImportExportFieldsUsed' => '使用欄位',
        'ImportExportFieldsFill' => '添加全部',
        'ImportExportFieldsClear' => '移除全部',
        'ImportExportFieldsEmpty' => '你至少必須選擇一個欄位',
        'ImportExportFileEmpty' => '你必須指定一個檔案名稱',
        'ImportFieldsTitle' => '要導入的欄位',
        'ImportFieldsTip' => '選擇你想匯入的欄位',
        'ImportNewList' => '建立一個新的收藏集',
        'ImportCurrentList' => '加入當前的收藏集',
        'ImportDropError' => 'There was an error opening at least one file. Previous list will be reloaded.',
        'ImportGenerateId' => '對每個項目產生ID',

        'FileChooserOpenFile' => '請選擇要使用的檔案',
        'FileChooserDirectory' => '資料夾',
        'FileChooserOpenDirectory' => '選擇一個資料夾',
        'FileChooserOverwrite' => '這個檔案已經存在，你要複寫它嗎？',
        'FileAllFiles' => 'All Files',
        'FileVideoFiles' => 'Video Files',
        'FileEbookFiles' => 'Ebook Files',
        'FileAudioFiles' => 'Audio Files',
        'FileGCstarFiles' => 'GCstar Collections',

        #Some default panels
        'PanelCompact' => '緊密',
        'PanelReadOnly' => '唯讀',
        'PanelForm' => '分頁',

        'PanelSearchButton' => '獲取資訊',
        'PanelSearchTip' => '搜尋網路上關於這個名字的資訊',
        'PanelSearchContextChooseOne' => 'Choose a site ...',
        'PanelSearchContextMultiSite' => 'Use "Many sites"',
        'PanelSearchContextMultiSitePerField' => 'Use "Many sites per field"',
        'PanelSearchContextOptions' => 'Change options ...',
        'PanelImageTipOpen' => '點擊圖片以選擇另一個。',
        'PanelImageTipView' => '點擊圖片瀏覽真實尺寸。',
        'PanelImageTipMenu' => ' 更多選擇請按右鍵',
        'PanelImageTitle' => '選擇一張圖片',
        'PanelImageNoImage' => '沒有圖片',
        'PanelSelectFileTitle' => '選擇一個檔案',
        'PanelLaunch' => 'Launch',        
        'PanelRestoreDefault' => '復原到預設值',
        'PanelRefresh' => 'Update',
        'PanelRefreshTip' => 'Update information from web',

        'PanelFrom' =>'From',
        'PanelTo' =>'To',

        'PanelWeb' => '瀏覽資訊',
        'PanelWebTip' => '瀏覽網路上關於這個項目的資訊',
        'PanelRemoveTip' => '移除當前項目',

        'PanelDateSelect' => '選擇',
        'PanelNobody' => '沒有人',
        'PanelUnknown' => '未知',
        'PanelAdded' => '加入日期',
        'PanelRating' => '評價',
        'PanelPressRating' => 'Press Rating',
        'PanelLocation' => '位置',

        'PanelLending' => '出借狀況',
        'PanelBorrower' => '借出對象',
        'PanelLendDate' => '出借日期',
        'PanelHistory' => '出借記錄',
        'PanelReturned' => '物品歸還',
        'PanelReturnDate' => '歸還日期',
        'PanelLendedYes' => '出借中',
        'PanelLendedNo' => '可用',

        'PanelTags' => '標籤',
        'PanelFavourite' => '最愛',
        'TagsAssigned' => '標籤', 

        'PanelUser' => '使用者欄位',

        'CheckUndef' => '未定義',
        'CheckYes' => '是',
        'CheckNo' => '不是',

        'ToolbarRandom' => 'Tonight',
        'ToolbarAll' => '瀏覽全部',
        'ToolbarAllTooltip' => '瀏覽全部項目',
        'ToolbarGroupBy' => '分組依據',
        'ToolbarGroupByTooltip' => '選擇一個欄位給項目列表分組',
        'ToolbarQuickSearch' => '快速搜尋',
        'ToolbarQuickSearchLabel' => '搜尋',
        'ToolbarQuickSearchTooltip' => '選擇這個欄位來搜尋，輸入要搜尋的字串後按ENTER。',
        'ToolbarSeparator' => '分隔',
        
        'PluginsTitle' => '搜尋一個項目',
        'PluginsQuery' => '查詢',
        'PluginsFrame' => '搜尋站點',
        'PluginsLogo' => 'Logo',
        'PluginsName' => '名字',
        'PluginsSearchFields' => '搜尋欄位',
        'PluginsAuthor' => '作者',
        'PluginsLang' => '語言',
        'PluginsUseSite' => '使用被選擇的站點供未來搜尋',
        'PluginsPreferredTooltip' => 'Site recommended by GCstar',
        'PluginDisabled' => 'Disabled',

        'BorrowersTitle' => '出借對象設定',
        'BorrowersList' => '出借對象',
        'BorrowersName' => '名字',
        'BorrowersEmail' => 'E-mail',
        'BorrowersAdd' => '加入',
        'BorrowersRemove' => '移除',
        'BorrowersEdit' => '編輯',
        'BorrowersTemplate' => '郵件模板',
        'BorrowersSubject' => '郵件主題',
        'BorrowersNotice1' => '%1 將會被取代為出借對象的名字',
        'BorrowersNotice2' => '%2 將會被取代為物品名稱',
        'BorrowersNotice3' => '%3 將會被取代為出借日期',

        'BorrowersImportTitle' => '匯入出借對象的資訊',
        'BorrowersImportType' => '檔案格式：',
        'BorrowersImportFile' => '檔案：',

        'BorrowedTitle' => '被借走的東西',
        'BorrowedDate' => '從',
        'BorrowedDisplayInPanel' => '在主視窗顯示物品',

        'MailTitle' => '發一封e-mail',
        'MailFrom' => '寄件人：',
        'MailTo' => '收件人：',
        'MailSubject' => '主旨：',
        'MailSmtpError' => '連線到SMTP伺服器時出現問題',
        'MailSendmailError' => '寄送信件時出現問題',

        'SearchTooltip' => '搜尋所有項目',
        'SearchTitle' => '項目搜尋',
        'SearchNoField' => 'No field have been selected for the search box.
Add some of them in the Filters tab of the collection settings.',

        'QueryReplaceField' => '欄位取代',
        'QueryReplaceOld' => '當前值',
        'QueryReplaceNew' => '新值',
        'QueryReplaceLaunch' => '取代',
        
        'ImportWindowTitle' => '選擇要匯入的欄位',
        'ImportViewPicture' => '瀏覽圖片',
        'ImportSelectAll' => '全選',
        'ImportSelectNone' => '全部不選',

        'MultiSiteTitle' => '用來搜尋的網站',
        'MultiSiteUnused' => '未使用的插件',
        'MultiSiteUsed' => '被使用的插件',
        'MultiSiteLang' => 'Fill list with English plugins',
        'MultiSiteEmptyError' => '你的站點列表為空',
        'MultiSiteClear' => '清除列表',
        
        'DisplayOptionsTitle' => 'Items to display',
        'DisplayOptionsAll' => '全選',
        'DisplayOptionsSearch' => '選擇鈕',

        'GenresTitle' => 'Genre Conversion',
        'GenresCategoryName' => 'Genre to use',
        'GenresCategoryMembers' => 'Genre to replace',
        'GenresLoad' => '讀取一個列表',
        'GenresExport' => '將列表存到檔案',
        'GenresModify' => '編輯轉換',

        'PropertiesName' => '收藏集名稱',
        'PropertiesLang' => '語言編碼',
        'PropertiesOwner' => '擁有者',
        'PropertiesEmail' => 'Email',
        'PropertiesDescription' => '描述',
        'PropertiesFile' => '檔案訊息',
        'PropertiesFilePath' => '完整路徑',
        'PropertiesItemsNumber' => '項目數目',
        'PropertiesFileSize' => '大小',
        'PropertiesFileSizeSymbols' => ['位元組', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
        'PropertiesCollection' => '收藏集屬性',
        'PropertiesDefaultPicture' => '預設圖片',

        'MailProgramsTitle' => '寄件軟體',
        'MailProgramsName' => '名字',
        'MailProgramsCommand' => '指令行',
        'MailProgramsRestore' => '回復預設值',
        'MailProgramsAdd' => '加入一個程式',
        'MailProgramsInstructions' => '在指令行中，你可以用下面的變數來替換：
 %f 可被替換為使用者的電子郵件地址。
 %t 可被替換為接收地址。
 %s 可被替換為郵件主題。
 %b 可被替換為郵件訊息。',

        'BookmarksBookmarks' => '書籤',
        'BookmarksFolder' => '資料夾',
        'BookmarksLabel' => '書籤名',
        'BookmarksPath' => '路徑',
        'BookmarksNewFolder' => '新資料夾',

        'AdvancedSearchType' => '搜尋類型',
        'AdvancedSearchTypeAnd' => '項目匹配所有條件',
        'AdvancedSearchTypeOr' => '項目匹配至少一個條件',
        'AdvancedSearchCriteria' => '條件',
        'AdvancedSearchAnyField' => '所有欄位',
        'AdvancedSearchSaveTitle' => '儲存搜尋',
        'AdvancedSearchSaveName' => '名稱',
        'AdvancedSearchSaveOverwrite' => '一個使用相同名字的搜尋已經存在，請使用另一個名字。',
        'AdvancedSearchUseCase' => '大小寫敏感',
        'AdvancedSearchIgnoreDiacritics' => '忽略重音等發音記號',

        'BugReportSubject' => 'GCstar產生錯誤回報',
        'BugReportVersion' => '版本',
        'BugReportPlatform' => '作業系統',
        'BugReportMessage' => '錯誤訊息',
        'BugReportInformation' => '附加資訊',

#Statistics
        'StatsFieldToUse' => 'Field to use',
        'StatsSortByNumber' => 'Sort by number of {lowercaseX}',
        'StatsGenerate' => 'Generate',
        'StatsKindOfGraph' => 'Kind of graphic',
        'StatsBars' => 'Bars',
        'StatsPie' => 'Pie',
        'Stats3DPie' => '3D Pie',
        'StatsArea' => 'Areas',
        'StatsHistory' => 'History',
        'StatsWidth' => 'Width',
        'StatsHeight' => 'Height',
        'StatsFontSize' => 'Font size',
        'StatsDisplayNumber' => 'Show numbers',
        'StatsSave' => 'Save statistics image to a file',
        'StatsAccumulate' => 'Accumulate values',
        'StatsShowAllDates' => 'Show all dates',    );
}
1;
