------------------------------------------------------------------------------
--                                                                          --
--                     Copyright (C) 2012-2015, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNATCOLL.Projects;         use GNATCOLL.Projects;
with GNATCOLL.VFS;              use GNATCOLL.VFS;
with GNAT.Directory_Operations; use GNAT.Directory_Operations;
with GNAT.IO;                   use GNAT.IO;
with GNAT.Strings;              use GNAT.Strings;

procedure Test_Projects is
   procedure Display_Error (Msg : String);

   procedure Display_Error (Msg : String) is
   begin
      Put_Line ("Error while loading project: " & Msg);
   end Display_Error;

   Tree     : Project_Tree;

begin
   --  Error when loading projects that use the same external variable
   --  multiple times and we do not pass an explicit environment.

   Tree.Load
      (Create ("root.gpr"), Errors => Display_Error'Unrestricted_Access);
   Tree.Unload;
end Test_Projects;
