/* user-dict.c generated by valac 0.14.2, the Vala compiler
 * generated from user-dict.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011-2012 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gstdio.h>


#define SKK_TYPE_DICT (skk_dict_get_type ())
#define SKK_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_DICT, SkkDict))
#define SKK_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_DICT, SkkDictClass))
#define SKK_IS_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_DICT))
#define SKK_IS_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_DICT))
#define SKK_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_DICT, SkkDictClass))

typedef struct _SkkDict SkkDict;
typedef struct _SkkDictClass SkkDictClass;
typedef struct _SkkDictPrivate SkkDictPrivate;

#define SKK_TYPE_CANDIDATE (skk_candidate_get_type ())
#define SKK_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_CANDIDATE, SkkCandidate))
#define SKK_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_CANDIDATE, SkkCandidateClass))
#define SKK_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_CANDIDATE))
#define SKK_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_CANDIDATE))
#define SKK_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_CANDIDATE, SkkCandidateClass))

typedef struct _SkkCandidate SkkCandidate;
typedef struct _SkkCandidateClass SkkCandidateClass;

#define SKK_TYPE_USER_DICT (skk_user_dict_get_type ())
#define SKK_USER_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_USER_DICT, SkkUserDict))
#define SKK_USER_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_USER_DICT, SkkUserDictClass))
#define SKK_IS_USER_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_USER_DICT))
#define SKK_IS_USER_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_USER_DICT))
#define SKK_USER_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_USER_DICT, SkkUserDictClass))

typedef struct _SkkUserDict SkkUserDict;
typedef struct _SkkUserDictClass SkkUserDictClass;
typedef struct _SkkUserDictPrivate SkkUserDictPrivate;

#define SKK_TYPE_ENCODING_CONVERTER (skk_encoding_converter_get_type ())
#define SKK_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter))
#define SKK_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))
#define SKK_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))

typedef struct _SkkEncodingConverter SkkEncodingConverter;
typedef struct _SkkEncodingConverterClass SkkEncodingConverterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _SkkDict {
	GObject parent_instance;
	SkkDictPrivate * priv;
};

struct _SkkDictClass {
	GObjectClass parent_class;
	void (*reload) (SkkDict* self, GError** error);
	SkkCandidate** (*lookup) (SkkDict* self, const gchar* midasi, gboolean okuri, int* result_length1);
	gchar** (*complete) (SkkDict* self, const gchar* midasi, int* result_length1);
	gboolean (*select_candidate) (SkkDict* self, SkkCandidate* candidate);
	gboolean (*purge_candidate) (SkkDict* self, SkkCandidate* candidate);
	void (*save) (SkkDict* self, GError** error);
	gboolean (*get_read_only) (SkkDict* self);
};

struct _SkkUserDict {
	SkkDict parent_instance;
	SkkUserDictPrivate * priv;
};

struct _SkkUserDictClass {
	SkkDictClass parent_class;
};

struct _SkkUserDictPrivate {
	GFile* file;
	gchar* etag;
	SkkEncodingConverter* converter;
	GeeMap* okuri_ari_entries;
	GeeMap* okuri_nasi_entries;
	gchar* midasi_history[128];
};

typedef enum  {
	SKK_SKK_DICT_ERROR_NOT_READABLE,
	SKK_SKK_DICT_ERROR_MALFORMED_INPUT
} SkkSkkDictError;
#define SKK_SKK_DICT_ERROR skk_skk_dict_error_quark ()

static gpointer skk_user_dict_parent_class = NULL;

GType skk_dict_get_type (void) G_GNUC_CONST;
GType skk_candidate_get_type (void) G_GNUC_CONST;
GType skk_user_dict_get_type (void) G_GNUC_CONST;
GType skk_encoding_converter_get_type (void) G_GNUC_CONST;
#define SKK_USER_DICT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_USER_DICT, SkkUserDictPrivate))
enum  {
	SKK_USER_DICT_DUMMY_PROPERTY,
	SKK_USER_DICT_READ_ONLY
};
GQuark skk_skk_dict_error_quark (void);
static void skk_user_dict_load (SkkUserDict* self, GError** error);
static guint8* _vala_array_dup2 (guint8* self, int length);
gchar* skk_encoding_converter_extract_coding_system (const gchar* line);
SkkEncodingConverter* skk_encoding_converter_new_from_coding_system (const gchar* coding, GError** error);
SkkEncodingConverter* skk_encoding_converter_construct_from_coding_system (GType object_type, const gchar* coding, GError** error);
gchar* skk_encoding_converter_decode (SkkEncodingConverter* self, const gchar* external_str, GError** error);
SkkCandidate** skk_dict_split_candidates (SkkDict* self, const gchar* midasi, gboolean okuri, const gchar* line, int* result_length1);
static void skk_user_dict_real_reload (SkkDict* base, GError** error);
static gint skk_user_dict_compare_entry_asc (GeeMapEntry* a, GeeMapEntry* b);
static gint skk_user_dict_compare_entry_dsc (GeeMapEntry* a, GeeMapEntry* b);
static void skk_user_dict_write_entries (SkkUserDict* self, GString* builder, GeeList* entries);
gchar* skk_dict_join_candidates (SkkDict* self, SkkCandidate** candidates, int candidates_length1);
static void skk_user_dict_real_save (SkkDict* base, GError** error);
gchar* skk_encoding_converter_get_coding_system (SkkEncodingConverter* self);
gchar* skk_encoding_converter_encode (SkkEncodingConverter* self, const gchar* internal_str, GError** error);
static GeeMap* skk_user_dict_get_entries (SkkUserDict* self, gboolean okuri);
static SkkCandidate** skk_user_dict_real_lookup (SkkDict* base, const gchar* midasi, gboolean okuri, int* result_length1);
static gchar** skk_user_dict_real_complete (SkkDict* base, const gchar* midasi, int* result_length1);
static gboolean skk_user_dict_real_select_candidate (SkkDict* base, SkkCandidate* candidate);
const gchar* skk_candidate_get_midasi (SkkCandidate* self);
gboolean skk_candidate_get_okuri (SkkCandidate* self);
const gchar* skk_candidate_get_text (SkkCandidate* self);
static gboolean skk_user_dict_real_purge_candidate (SkkDict* base, SkkCandidate* candidate);
SkkUserDict* skk_user_dict_new (const gchar* path, const gchar* encoding, GError** error);
SkkUserDict* skk_user_dict_construct (GType object_type, const gchar* path, const gchar* encoding, GError** error);
SkkDict* skk_dict_construct (GType object_type);
SkkEncodingConverter* skk_encoding_converter_new (const gchar* encoding, GError** error);
SkkEncodingConverter* skk_encoding_converter_construct (GType object_type, const gchar* encoding, GError** error);
void skk_dict_reload (SkkDict* self, GError** error);
static void skk_user_dict_finalize (GObject* obj);
gboolean skk_dict_get_read_only (SkkDict* self);
static void _vala_skk_user_dict_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static guint8* _vala_array_dup2 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void skk_user_dict_load (SkkUserDict* self, GError** error) {
	guint8* contents = NULL;
	gint contents_length1 = 0;
	gint _contents_size_ = 0;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	GDestroyNotify _tmp7_;
	GMemoryInputStream* _tmp8_;
	GMemoryInputStream* memory;
	GMemoryInputStream* _tmp9_;
	GDataInputStream* _tmp10_;
	GDataInputStream* data;
	gchar* line;
	gsize length = 0UL;
	GDataInputStream* _tmp11_;
	gsize _tmp12_ = 0UL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* coding;
	const gchar* _tmp18_;
	GeeMap* entries;
	GeeMap* _tmp42_;
	gboolean okuri;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFile* _tmp0_;
		guint8* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gchar* _tmp3_ = NULL;
		_tmp0_ = self->priv->file;
		g_file_load_contents (_tmp0_, NULL, &_tmp1_, &_tmp2_, &_tmp3_, &_inner_error_);
		contents = (g_free (contents), NULL);
		contents = _tmp1_;
		contents_length1 = _tmp2_;
		_contents_size_ = contents_length1;
		_g_free0 (self->priv->etag);
		self->priv->etag = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_NOT_READABLE, "can't load contents");
		_inner_error_ = _tmp4_;
		_g_error_free0 (e);
		goto __finally12;
	}
	__finally12:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			contents = (g_free (contents), NULL);
			return;
		} else {
			contents = (g_free (contents), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = contents;
	_tmp5__length1 = contents_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = g_free;
	_tmp8_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp6_, _tmp6__length1, _tmp7_);
	memory = _tmp8_;
	_tmp9_ = memory;
	_tmp10_ = g_data_input_stream_new ((GInputStream*) _tmp9_);
	data = _tmp10_;
	line = NULL;
	_tmp11_ = data;
	_tmp13_ = g_data_input_stream_read_line (_tmp11_, &_tmp12_, NULL, &_inner_error_);
	length = _tmp12_;
	_tmp14_ = _tmp13_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		} else {
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (line);
	line = _tmp14_;
	_tmp15_ = line;
	if (_tmp15_ == NULL) {
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	_tmp16_ = line;
	_tmp17_ = skk_encoding_converter_extract_coding_system (_tmp16_);
	coding = _tmp17_;
	_tmp18_ = coding;
	if (_tmp18_ != NULL) {
		GDataInputStream* _tmp27_;
		gsize _tmp28_ = 0UL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		{
			const gchar* _tmp19_;
			SkkEncodingConverter* _tmp20_;
			SkkEncodingConverter* _converter;
			SkkEncodingConverter* _tmp21_;
			_tmp19_ = coding;
			_tmp20_ = skk_encoding_converter_new_from_coding_system (_tmp19_, &_inner_error_);
			_converter = _tmp20_;
			if (_inner_error_ != NULL) {
				goto __catch13_g_error;
			}
			_tmp21_ = _converter;
			if (_tmp21_ != NULL) {
				SkkEncodingConverter* _tmp22_;
				SkkEncodingConverter* _tmp23_;
				_tmp22_ = _converter;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				_g_object_unref0 (self->priv->converter);
				self->priv->converter = _tmp23_;
			}
			_g_object_unref0 (_converter);
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp24_;
			GError* _tmp25_;
			const gchar* _tmp26_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = coding;
			_tmp25_ = e;
			_tmp26_ = _tmp25_->message;
			g_warning ("user-dict.vala:51: can't create converter from coding system %s: %s", _tmp24_, _tmp26_);
			_g_error_free0 (e);
		}
		__finally13:
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (coding);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_free0 (coding);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp27_ = data;
		_tmp29_ = g_data_input_stream_read_line (_tmp27_, &_tmp28_, NULL, &_inner_error_);
		length = _tmp28_;
		_tmp30_ = _tmp29_;
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (coding);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_free0 (coding);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_free0 (line);
		line = _tmp30_;
		_tmp31_ = line;
		if (_tmp31_ == NULL) {
			_g_free0 (coding);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
	}
	entries = NULL;
	while (TRUE) {
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gboolean _tmp34_ = FALSE;
		GDataInputStream* _tmp37_;
		gsize _tmp38_ = 0UL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_;
		const gchar* _tmp41_;
		_tmp32_ = line;
		if (!(_tmp32_ != NULL)) {
			break;
		}
		_tmp33_ = line;
		_tmp34_ = g_str_has_prefix (_tmp33_, ";; okuri-ari entries.");
		if (_tmp34_) {
			GeeMap* _tmp35_;
			GeeMap* _tmp36_;
			_tmp35_ = self->priv->okuri_ari_entries;
			_tmp36_ = _g_object_ref0 (_tmp35_);
			_g_object_unref0 (entries);
			entries = _tmp36_;
			break;
		}
		_tmp37_ = data;
		_tmp39_ = g_data_input_stream_read_line (_tmp37_, &_tmp38_, NULL, &_inner_error_);
		length = _tmp38_;
		_tmp40_ = _tmp39_;
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_free0 (line);
		line = _tmp40_;
		_tmp41_ = line;
		if (_tmp41_ == NULL) {
			break;
		}
	}
	_tmp42_ = entries;
	if (_tmp42_ == NULL) {
		GError* _tmp43_;
		_tmp43_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "no okuri-ari boundary");
		_inner_error_ = _tmp43_;
		if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (entries);
			_g_free0 (coding);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		} else {
			_g_object_unref0 (entries);
			_g_free0 (coding);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	okuri = TRUE;
	while (TRUE) {
		const gchar* _tmp44_;
		GDataInputStream* _tmp45_;
		gsize _tmp46_ = 0UL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_;
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		gboolean _tmp51_ = FALSE;
		const gchar* _tmp62_;
		gint _tmp63_ = 0;
		gint index;
		gint _tmp64_;
		const gchar* _tmp67_;
		gint _tmp68_;
		gchar* _tmp69_ = NULL;
		gchar* midasi;
		const gchar* _tmp70_;
		gint _tmp71_;
		const gchar* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gchar* _tmp75_ = NULL;
		gchar* candidates_str;
		gboolean _tmp76_ = FALSE;
		const gchar* _tmp77_;
		gboolean _tmp78_ = FALSE;
		gboolean _tmp81_;
		const gchar* _tmp84_;
		gboolean _tmp85_;
		const gchar* _tmp86_;
		gint _tmp87_ = 0;
		SkkCandidate** _tmp88_ = NULL;
		SkkCandidate** candidates;
		gint candidates_length1;
		gint _candidates_size_;
		GeeArrayList* _tmp89_;
		GeeArrayList* list;
		SkkCandidate** _tmp90_;
		gint _tmp90__length1;
		GeeMap* _tmp94_;
		const gchar* _tmp95_;
		GeeArrayList* _tmp96_;
		_tmp44_ = line;
		if (!(_tmp44_ != NULL)) {
			break;
		}
		_tmp45_ = data;
		_tmp47_ = g_data_input_stream_read_line (_tmp45_, &_tmp46_, NULL, &_inner_error_);
		length = _tmp46_;
		_tmp48_ = _tmp47_;
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_free0 (line);
		line = _tmp48_;
		_tmp49_ = line;
		if (_tmp49_ == NULL) {
			break;
		}
		_tmp50_ = line;
		_tmp51_ = g_str_has_prefix (_tmp50_, ";; okuri-nasi entries.");
		if (_tmp51_) {
			GeeMap* _tmp52_;
			GeeMap* _tmp53_;
			_tmp52_ = self->priv->okuri_nasi_entries;
			_tmp53_ = _g_object_ref0 (_tmp52_);
			_g_object_unref0 (entries);
			entries = _tmp53_;
			okuri = FALSE;
			continue;
		}
		{
			SkkEncodingConverter* _tmp54_;
			const gchar* _tmp55_;
			gchar* _tmp56_ = NULL;
			gchar* _tmp57_;
			_tmp54_ = self->priv->converter;
			_tmp55_ = line;
			_tmp56_ = skk_encoding_converter_decode (_tmp54_, _tmp55_, &_inner_error_);
			_tmp57_ = _tmp56_;
			if (_inner_error_ != NULL) {
				goto __catch14_g_error;
			}
			_g_free0 (line);
			line = _tmp57_;
		}
		goto __finally14;
		__catch14_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp58_;
			GError* _tmp59_;
			const gchar* _tmp60_;
			GError* _tmp61_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp58_ = line;
			_tmp59_ = e;
			_tmp60_ = _tmp59_->message;
			_tmp61_ = g_error_new (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "can't decode line %s: %s", _tmp58_, _tmp60_);
			_inner_error_ = _tmp61_;
			_g_error_free0 (e);
			goto __finally14;
		}
		__finally14:
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp62_ = line;
		_tmp63_ = string_index_of (_tmp62_, " ", 0);
		index = _tmp63_;
		_tmp64_ = index;
		if (_tmp64_ < 1) {
			const gchar* _tmp65_;
			GError* _tmp66_;
			_tmp65_ = line;
			_tmp66_ = g_error_new (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "can't extract midasi from line %s", _tmp65_);
			_inner_error_ = _tmp66_;
			if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp67_ = line;
		_tmp68_ = index;
		_tmp69_ = string_slice (_tmp67_, (glong) 0, (glong) _tmp68_);
		midasi = _tmp69_;
		_tmp70_ = line;
		_tmp71_ = index;
		_tmp72_ = line;
		_tmp73_ = strlen (_tmp72_);
		_tmp74_ = _tmp73_;
		_tmp75_ = string_slice (_tmp70_, (glong) (_tmp71_ + 1), (glong) _tmp74_);
		candidates_str = _tmp75_;
		_tmp77_ = candidates_str;
		_tmp78_ = g_str_has_prefix (_tmp77_, "/");
		if (!_tmp78_) {
			_tmp76_ = TRUE;
		} else {
			const gchar* _tmp79_;
			gboolean _tmp80_ = FALSE;
			_tmp79_ = candidates_str;
			_tmp80_ = g_str_has_suffix (_tmp79_, "/");
			_tmp76_ = !_tmp80_;
		}
		_tmp81_ = _tmp76_;
		if (_tmp81_) {
			const gchar* _tmp82_;
			GError* _tmp83_;
			_tmp82_ = candidates_str;
			_tmp83_ = g_error_new (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "can't parse candidates list %s", _tmp82_);
			_inner_error_ = _tmp83_;
			if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (candidates_str);
				_g_free0 (midasi);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_free0 (candidates_str);
				_g_free0 (midasi);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp84_ = midasi;
		_tmp85_ = okuri;
		_tmp86_ = candidates_str;
		_tmp88_ = skk_dict_split_candidates ((SkkDict*) self, _tmp84_, _tmp85_, _tmp86_, &_tmp87_);
		candidates = _tmp88_;
		candidates_length1 = _tmp87_;
		_candidates_size_ = candidates_length1;
		_tmp89_ = gee_array_list_new (SKK_TYPE_CANDIDATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		list = _tmp89_;
		_tmp90_ = candidates;
		_tmp90__length1 = candidates_length1;
		{
			SkkCandidate** c_collection = NULL;
			gint c_collection_length1 = 0;
			gint _c_collection_size_ = 0;
			gint c_it = 0;
			c_collection = _tmp90_;
			c_collection_length1 = _tmp90__length1;
			for (c_it = 0; c_it < _tmp90__length1; c_it = c_it + 1) {
				SkkCandidate* _tmp91_;
				SkkCandidate* c = NULL;
				_tmp91_ = _g_object_ref0 (c_collection[c_it]);
				c = _tmp91_;
				{
					GeeArrayList* _tmp92_;
					SkkCandidate* _tmp93_;
					_tmp92_ = list;
					_tmp93_ = c;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp92_, _tmp93_);
					_g_object_unref0 (c);
				}
			}
		}
		_tmp94_ = entries;
		_tmp95_ = midasi;
		_tmp96_ = list;
		gee_map_set (_tmp94_, _tmp95_, (GeeList*) _tmp96_);
		_g_object_unref0 (list);
		candidates = (_vala_array_free (candidates, candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_free0 (candidates_str);
		_g_free0 (midasi);
	}
	_g_object_unref0 (entries);
	_g_free0 (coding);
	_g_free0 (line);
	_g_object_unref0 (data);
	_g_object_unref0 (memory);
	contents = (g_free (contents), NULL);
}


/**
         * {@inheritDoc}
         */
static void skk_user_dict_real_reload (SkkDict* base, GError** error) {
	SkkUserDict * self;
	gchar* _tmp0_;
	gchar* attributes;
	GFile* _tmp1_;
	GFileInfo* _tmp2_ = NULL;
	GFileInfo* info;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (SkkUserDict*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_query_info (_tmp1_, attributes, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attributes);
		return;
	}
	_tmp3_ = g_file_info_get_etag (info);
	_tmp4_ = self->priv->etag;
	if (g_strcmp0 (_tmp3_, _tmp4_) != 0) {
		GeeMap* _tmp5_;
		GeeMap* _tmp6_;
		_tmp5_ = self->priv->okuri_ari_entries;
		gee_map_clear (_tmp5_);
		_tmp6_ = self->priv->okuri_nasi_entries;
		gee_map_clear (_tmp6_);
		{
			skk_user_dict_load (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
					goto __catch15_skk_skk_dict_error;
				}
				if (_inner_error_->domain == G_IO_ERROR) {
					goto __catch15_g_io_error;
				}
				_g_object_unref0 (info);
				_g_free0 (attributes);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally15;
		__catch15_skk_skk_dict_error:
		{
			GError* e = NULL;
			GFile* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp7_ = self->priv->file;
			_tmp8_ = g_file_get_path (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("user-dict.vala:138: error parsing user dictionary %s: %s", _tmp9_, _tmp11_);
			_g_free0 (_tmp9_);
			_g_error_free0 (e);
		}
		goto __finally15;
		__catch15_g_io_error:
		{
			GError* e = NULL;
			GFile* _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			GError* _tmp15_;
			const gchar* _tmp16_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = self->priv->file;
			_tmp13_ = g_file_get_path (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			g_warning ("user-dict.vala:141: error reading user dictionary %s: %s", _tmp14_, _tmp16_);
			_g_free0 (_tmp14_);
			_g_error_free0 (e);
		}
		__finally15:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
	}
	_g_object_unref0 (info);
	_g_free0 (attributes);
}


static gint skk_user_dict_compare_entry_asc (GeeMapEntry* a, GeeMapEntry* b) {
	gint result = 0;
	GCompareFunc _tmp0_;
	GeeMapEntry* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_;
	GeeMapEntry* _tmp4_;
	gconstpointer _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = a;
	_tmp2_ = gee_map_entry_get_key (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	_tmp5_ = gee_map_entry_get_key (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp0_ ((const gchar*) _tmp3_, (const gchar*) _tmp6_);
	result = _tmp7_;
	return result;
}


static gint skk_user_dict_compare_entry_dsc (GeeMapEntry* a, GeeMapEntry* b) {
	gint result = 0;
	GCompareFunc _tmp0_;
	GeeMapEntry* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_;
	GeeMapEntry* _tmp4_;
	gconstpointer _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = b;
	_tmp2_ = gee_map_entry_get_key (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = a;
	_tmp5_ = gee_map_entry_get_key (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp0_ ((const gchar*) _tmp3_, (const gchar*) _tmp6_);
	result = _tmp7_;
	return result;
}


static void skk_user_dict_write_entries (SkkUserDict* self, GString* builder, GeeList* entries) {
	GeeList* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
	GeeIterator* iter;
	GeeIterator* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (entries != NULL);
	_tmp0_ = entries;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	iter = _tmp1_;
	_tmp2_ = iter;
	_tmp3_ = gee_iterator_first (_tmp2_);
	if (_tmp3_) {
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				GeeIterator* _tmp8_;
				gpointer _tmp9_ = NULL;
				GeeMapEntry* entry;
				GeeMapEntry* _tmp10_;
				gconstpointer _tmp11_;
				const gchar* _tmp12_;
				GeeMapEntry* _tmp13_;
				gconstpointer _tmp14_;
				GeeList* _tmp15_;
				gint _tmp16_ = 0;
				gpointer* _tmp17_ = NULL;
				SkkCandidate** _tmp18_;
				gint _tmp18__length1;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				gchar* line;
				GString* _tmp23_;
				const gchar* _tmp24_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					GeeIterator* _tmp6_;
					gboolean _tmp7_ = FALSE;
					_tmp6_ = iter;
					_tmp7_ = gee_iterator_next (_tmp6_);
					if (!_tmp7_) {
						break;
					}
				}
				_tmp4_ = FALSE;
				_tmp8_ = iter;
				_tmp9_ = gee_iterator_get (_tmp8_);
				entry = (GeeMapEntry*) _tmp9_;
				_tmp10_ = entry;
				_tmp11_ = gee_map_entry_get_key (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = entry;
				_tmp14_ = gee_map_entry_get_value (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp17_ = gee_collection_to_array ((GeeCollection*) ((GeeList*) _tmp15_), &_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp18__length1 = _tmp16_;
				_tmp19_ = skk_dict_join_candidates ((SkkDict*) self, _tmp18_, _tmp16_);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strdup_printf ("%s %s\n", (const gchar*) _tmp12_, _tmp20_);
				_tmp22_ = _tmp21_;
				_g_free0 (_tmp20_);
				_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_object_unref), NULL);
				line = _tmp22_;
				_tmp23_ = builder;
				_tmp24_ = line;
				g_string_append (_tmp23_, _tmp24_);
				_g_free0 (line);
				_g_object_unref0 (entry);
			}
		}
	}
	_g_object_unref0 (iter);
}


/**
         * {@inheritDoc}
         */
static void skk_user_dict_real_save (SkkDict* base, GError** error) {
	SkkUserDict * self;
	GString* _tmp0_;
	GString* builder;
	SkkEncodingConverter* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* coding;
	const gchar* _tmp3_;
	GString* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* entries;
	GeeArrayList* _tmp10_;
	GeeMap* _tmp11_;
	GeeSet* _tmp12_;
	GeeSet* _tmp13_;
	GeeSet* _tmp14_;
	GeeArrayList* _tmp15_;
	GString* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GString* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeMap* _tmp21_;
	GeeSet* _tmp22_;
	GeeSet* _tmp23_;
	GeeSet* _tmp24_;
	GeeArrayList* _tmp25_;
	GString* _tmp26_;
	GeeArrayList* _tmp27_;
	GeeArrayList* _tmp28_;
	SkkEncodingConverter* _tmp29_;
	GString* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* contents;
	GFile* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_ = NULL;
	GError * _inner_error_ = NULL;
	self = (SkkUserDict*) base;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->priv->converter;
	_tmp2_ = skk_encoding_converter_get_coding_system (_tmp1_);
	coding = _tmp2_;
	_tmp3_ = coding;
	if (_tmp3_ != NULL) {
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp4_ = builder;
		_tmp5_ = coding;
		_tmp6_ = g_strdup_printf (";;; -*- coding: %s -*-\n", _tmp5_);
		_tmp7_ = _tmp6_;
		g_string_append (_tmp4_, _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = builder;
	g_string_append (_tmp8_, ";; okuri-ari entries.\n");
	_tmp9_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	entries = _tmp9_;
	_tmp10_ = entries;
	_tmp11_ = self->priv->okuri_ari_entries;
	_tmp12_ = gee_map_get_entries (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp10_, (GeeCollection*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = entries;
	gee_list_sort ((GeeList*) _tmp15_, (GCompareFunc) skk_user_dict_compare_entry_dsc);
	_tmp16_ = builder;
	_tmp17_ = entries;
	skk_user_dict_write_entries (self, _tmp16_, (GeeList*) _tmp17_);
	_tmp18_ = entries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp18_);
	_tmp19_ = builder;
	g_string_append (_tmp19_, ";; okuri-nasi entries.\n");
	_tmp20_ = entries;
	_tmp21_ = self->priv->okuri_nasi_entries;
	_tmp22_ = gee_map_get_entries (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_;
	gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp20_, (GeeCollection*) _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = entries;
	gee_list_sort ((GeeList*) _tmp25_, (GCompareFunc) skk_user_dict_compare_entry_asc);
	_tmp26_ = builder;
	_tmp27_ = entries;
	skk_user_dict_write_entries (self, _tmp26_, (GeeList*) _tmp27_);
	_tmp28_ = entries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp28_);
	_tmp29_ = self->priv->converter;
	_tmp30_ = builder;
	_tmp31_ = _tmp30_->str;
	_tmp32_ = skk_encoding_converter_encode (_tmp29_, _tmp31_, &_inner_error_);
	contents = _tmp32_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (entries);
		_g_free0 (coding);
		_g_string_free0 (builder);
		return;
	}
	_tmp33_ = self->priv->file;
	_tmp34_ = contents;
	_tmp35_ = contents;
	_tmp36_ = strlen (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = self->priv->etag;
	g_file_replace_contents (_tmp33_, _tmp34_, (gsize) _tmp37_, _tmp38_, FALSE, G_FILE_CREATE_PRIVATE, &_tmp39_, NULL, &_inner_error_);
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp39_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (contents);
		_g_object_unref0 (entries);
		_g_free0 (coding);
		_g_string_free0 (builder);
		return;
	}
	_g_free0 (contents);
	_g_object_unref0 (entries);
	_g_free0 (coding);
	_g_string_free0 (builder);
}


static GeeMap* skk_user_dict_get_entries (SkkUserDict* self, gboolean okuri) {
	GeeMap* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = okuri;
	if (_tmp0_) {
		GeeMap* _tmp1_;
		GeeMap* _tmp2_;
		_tmp1_ = self->priv->okuri_ari_entries;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		GeeMap* _tmp3_;
		GeeMap* _tmp4_;
		_tmp3_ = self->priv->okuri_nasi_entries;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		return result;
	}
}


/**
         * {@inheritDoc}
         */
static SkkCandidate** skk_user_dict_real_lookup (SkkDict* base, const gchar* midasi, gboolean okuri, int* result_length1) {
	SkkUserDict * self;
	SkkCandidate** result = NULL;
	gboolean _tmp0_;
	GeeMap* _tmp1_ = NULL;
	GeeMap* entries;
	GeeMap* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	self = (SkkUserDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = okuri;
	_tmp1_ = skk_user_dict_get_entries (self, _tmp0_);
	entries = _tmp1_;
	_tmp2_ = entries;
	_tmp3_ = midasi;
	_tmp4_ = gee_map_has_key (_tmp2_, _tmp3_);
	if (_tmp4_) {
		GeeMap* _tmp5_;
		const gchar* _tmp6_;
		gpointer _tmp7_ = NULL;
		GeeList* _tmp8_;
		gint _tmp9_ = 0;
		gpointer* _tmp10_ = NULL;
		SkkCandidate** _tmp11_;
		gint _tmp11__length1;
		SkkCandidate** _tmp12_;
		gint _tmp12__length1;
		_tmp5_ = entries;
		_tmp6_ = midasi;
		_tmp7_ = gee_map_get (_tmp5_, _tmp6_);
		_tmp8_ = (GeeList*) _tmp7_;
		_tmp10_ = gee_collection_to_array ((GeeCollection*) _tmp8_, &_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_tmp12_ = _tmp11_;
		_tmp12__length1 = _tmp11__length1;
		if (result_length1) {
			*result_length1 = _tmp12__length1;
		}
		result = _tmp12_;
		_g_object_unref0 (entries);
		return result;
	} else {
		SkkCandidate** _tmp13_ = NULL;
		SkkCandidate** _tmp14_;
		gint _tmp14__length1;
		_tmp13_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp14_ = _tmp13_;
		_tmp14__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp14__length1;
		}
		result = _tmp14_;
		_g_object_unref0 (entries);
		return result;
	}
	_g_object_unref0 (entries);
}


/**
         * {@inheritDoc}
         */
static gchar** skk_user_dict_real_complete (SkkDict* base, const gchar* midasi, int* result_length1) {
	SkkUserDict * self;
	gchar** result = NULL;
	GeeArrayList* _tmp0_;
	GeeList* completion;
	GeeArrayList* _tmp1_;
	GeeList* keys;
	GeeList* _tmp2_;
	GeeMap* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	GeeIterator* _tmp9_ = NULL;
	GeeIterator* iter;
	GeeIterator* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeList* _tmp36_;
	gint _tmp37_ = 0;
	gpointer* _tmp38_ = NULL;
	gchar** _tmp39_;
	gint _tmp39__length1;
	self = (SkkUserDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	completion = (GeeList*) _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	keys = (GeeList*) _tmp1_;
	_tmp2_ = keys;
	_tmp3_ = self->priv->okuri_nasi_entries;
	_tmp4_ = gee_map_get_keys (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	gee_collection_add_all ((GeeCollection*) _tmp2_, (GeeCollection*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = keys;
	gee_list_sort (_tmp7_, NULL);
	_tmp8_ = keys;
	_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
	iter = _tmp9_;
	_tmp10_ = iter;
	_tmp11_ = gee_iterator_first (_tmp10_);
	if (_tmp11_) {
		{
			gboolean _tmp12_;
			_tmp12_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_;
				GeeIterator* _tmp16_;
				gpointer _tmp17_ = NULL;
				gchar* key;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gboolean _tmp20_ = FALSE;
				_tmp13_ = _tmp12_;
				if (!_tmp13_) {
					GeeIterator* _tmp14_;
					gboolean _tmp15_ = FALSE;
					_tmp14_ = iter;
					_tmp15_ = gee_iterator_next (_tmp14_);
					if (!_tmp15_) {
						break;
					}
				}
				_tmp12_ = FALSE;
				_tmp16_ = iter;
				_tmp17_ = gee_iterator_get (_tmp16_);
				key = (gchar*) _tmp17_;
				_tmp18_ = key;
				_tmp19_ = midasi;
				_tmp20_ = g_str_has_prefix (_tmp18_, _tmp19_);
				if (_tmp20_) {
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					_tmp21_ = key;
					_tmp22_ = midasi;
					if (g_strcmp0 (_tmp21_, _tmp22_) != 0) {
						GeeList* _tmp23_;
						const gchar* _tmp24_;
						_tmp23_ = completion;
						_tmp24_ = key;
						gee_collection_add ((GeeCollection*) _tmp23_, _tmp24_);
					}
					_g_free0 (key);
					break;
				}
				_g_free0 (key);
			}
		}
		while (TRUE) {
			GeeIterator* _tmp25_;
			gboolean _tmp26_ = FALSE;
			GeeIterator* _tmp27_;
			gpointer _tmp28_ = NULL;
			gchar* key;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gboolean _tmp31_ = FALSE;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			_tmp25_ = iter;
			_tmp26_ = gee_iterator_next (_tmp25_);
			if (!_tmp26_) {
				break;
			}
			_tmp27_ = iter;
			_tmp28_ = gee_iterator_get (_tmp27_);
			key = (gchar*) _tmp28_;
			_tmp29_ = key;
			_tmp30_ = midasi;
			_tmp31_ = g_str_has_prefix (_tmp29_, _tmp30_);
			if (!_tmp31_) {
				_g_free0 (key);
				break;
			}
			_tmp32_ = key;
			_tmp33_ = midasi;
			if (g_strcmp0 (_tmp32_, _tmp33_) != 0) {
				GeeList* _tmp34_;
				const gchar* _tmp35_;
				_tmp34_ = completion;
				_tmp35_ = key;
				gee_collection_add ((GeeCollection*) _tmp34_, _tmp35_);
			}
			_g_free0 (key);
		}
	}
	_tmp36_ = completion;
	_tmp38_ = gee_collection_to_array ((GeeCollection*) _tmp36_, &_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp39__length1 = _tmp37_;
	if (result_length1) {
		*result_length1 = _tmp39__length1;
	}
	result = _tmp39_;
	_g_object_unref0 (iter);
	_g_object_unref0 (keys);
	_g_object_unref0 (completion);
	return result;
}


/**
         * {@inheritDoc}
         */
static gboolean skk_user_dict_real_select_candidate (SkkDict* base, SkkCandidate* candidate) {
	SkkUserDict * self;
	gboolean result = FALSE;
	gint index = 0;
	gboolean _tmp24_ = FALSE;
	gint _tmp25_;
	gboolean _tmp28_;
	SkkCandidate* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	SkkCandidate* _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	GeeMap* _tmp47_ = NULL;
	GeeMap* entries;
	GeeMap* _tmp48_;
	SkkCandidate* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	gboolean _tmp52_ = FALSE;
	GeeMap* _tmp59_;
	SkkCandidate* _tmp60_;
	const gchar* _tmp61_;
	const gchar* _tmp62_;
	gpointer _tmp63_ = NULL;
	GeeList* candidates;
	GeeList* _tmp93_;
	SkkCandidate* _tmp94_;
	self = (SkkUserDict*) base;
	g_return_val_if_fail (candidate != NULL, FALSE);
	{
		gboolean _tmp0_;
		index = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_;
			gboolean _tmp3_ = FALSE;
			gint _tmp4_;
			gboolean _tmp7_;
			gint _tmp8_;
			const gchar* _tmp9_;
			SkkCandidate* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				gint _tmp2_;
				_tmp2_ = index;
				index = _tmp2_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp4_ = index;
			if (_tmp4_ < 128) {
				gint _tmp5_;
				const gchar* _tmp6_;
				_tmp5_ = index;
				_tmp6_ = self->priv->midasi_history[_tmp5_];
				_tmp3_ = _tmp6_ != NULL;
			} else {
				_tmp3_ = FALSE;
			}
			_tmp7_ = _tmp3_;
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = index;
			_tmp9_ = self->priv->midasi_history[_tmp8_];
			_tmp10_ = candidate;
			_tmp11_ = skk_candidate_get_midasi (_tmp10_);
			_tmp12_ = _tmp11_;
			if (g_strcmp0 (_tmp9_, _tmp12_) == 0) {
				gint _tmp13_;
				_tmp13_ = index;
				if (_tmp13_ > 0) {
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* first;
					gint _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					gint _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp14_ = self->priv->midasi_history[0];
					_tmp15_ = g_strdup (_tmp14_);
					first = _tmp15_;
					_tmp16_ = index;
					_tmp17_ = self->priv->midasi_history[_tmp16_];
					_tmp18_ = g_strdup (_tmp17_);
					_g_free0 (self->priv->midasi_history[0]);
					self->priv->midasi_history[0] = _tmp18_;
					_tmp19_ = self->priv->midasi_history[0];
					_tmp20_ = index;
					_tmp21_ = first;
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (self->priv->midasi_history[_tmp20_]);
					self->priv->midasi_history[_tmp20_] = _tmp22_;
					_tmp23_ = self->priv->midasi_history[_tmp20_];
					_g_free0 (first);
					break;
				}
			}
		}
	}
	_tmp25_ = index;
	if (_tmp25_ == 128) {
		_tmp24_ = TRUE;
	} else {
		gint _tmp26_;
		const gchar* _tmp27_;
		_tmp26_ = index;
		_tmp27_ = self->priv->midasi_history[_tmp26_];
		_tmp24_ = _tmp27_ == NULL;
	}
	_tmp28_ = _tmp24_;
	if (_tmp28_) {
		{
			gint j;
			j = 1;
			{
				gboolean _tmp29_;
				_tmp29_ = TRUE;
				while (TRUE) {
					gboolean _tmp30_;
					gint _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					gint _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					_tmp30_ = _tmp29_;
					if (!_tmp30_) {
						gint _tmp31_;
						_tmp31_ = j;
						j = _tmp31_ + 1;
					}
					_tmp29_ = FALSE;
					_tmp32_ = j;
					_tmp33_ = index;
					if (!(_tmp32_ < (_tmp33_ - 1))) {
						break;
					}
					_tmp34_ = j;
					_tmp35_ = j;
					_tmp36_ = self->priv->midasi_history[_tmp35_ - 1];
					_tmp37_ = g_strdup (_tmp36_);
					_g_free0 (self->priv->midasi_history[_tmp34_]);
					self->priv->midasi_history[_tmp34_] = _tmp37_;
					_tmp38_ = self->priv->midasi_history[_tmp34_];
				}
			}
		}
	}
	_tmp39_ = candidate;
	_tmp40_ = skk_candidate_get_midasi (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strdup (_tmp41_);
	_g_free0 (self->priv->midasi_history[0]);
	self->priv->midasi_history[0] = _tmp42_;
	_tmp43_ = self->priv->midasi_history[0];
	_tmp44_ = candidate;
	_tmp45_ = skk_candidate_get_okuri (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = skk_user_dict_get_entries (self, _tmp46_);
	entries = _tmp47_;
	_tmp48_ = entries;
	_tmp49_ = candidate;
	_tmp50_ = skk_candidate_get_midasi (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = gee_map_has_key (_tmp48_, _tmp51_);
	if (!_tmp52_) {
		GeeMap* _tmp53_;
		SkkCandidate* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		GeeArrayList* _tmp57_;
		GeeArrayList* _tmp58_;
		_tmp53_ = entries;
		_tmp54_ = candidate;
		_tmp55_ = skk_candidate_get_midasi (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = gee_array_list_new (SKK_TYPE_CANDIDATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		_tmp58_ = _tmp57_;
		gee_map_set (_tmp53_, _tmp56_, (GeeList*) _tmp58_);
		_g_object_unref0 (_tmp58_);
	}
	index = 0;
	_tmp59_ = entries;
	_tmp60_ = candidate;
	_tmp61_ = skk_candidate_get_midasi (_tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = gee_map_get (_tmp59_, _tmp62_);
	candidates = (GeeList*) _tmp63_;
	{
		GeeList* _tmp64_;
		GeeList* _tmp65_;
		GeeList* _c_list;
		GeeList* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		gint _c_size;
		gint _c_index;
		_tmp64_ = candidates;
		_tmp65_ = _g_object_ref0 (_tmp64_);
		_c_list = _tmp65_;
		_tmp66_ = _c_list;
		_tmp67_ = gee_collection_get_size ((GeeCollection*) _tmp66_);
		_tmp68_ = _tmp67_;
		_c_size = _tmp68_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			GeeList* _tmp72_;
			gint _tmp73_;
			gpointer _tmp74_ = NULL;
			SkkCandidate* c;
			SkkCandidate* _tmp75_;
			const gchar* _tmp76_;
			const gchar* _tmp77_;
			SkkCandidate* _tmp78_;
			const gchar* _tmp79_;
			const gchar* _tmp80_;
			gint _tmp92_;
			_tmp69_ = _c_index;
			_c_index = _tmp69_ + 1;
			_tmp70_ = _c_index;
			_tmp71_ = _c_size;
			if (!(_tmp70_ < _tmp71_)) {
				break;
			}
			_tmp72_ = _c_list;
			_tmp73_ = _c_index;
			_tmp74_ = gee_list_get (_tmp72_, _tmp73_);
			c = (SkkCandidate*) _tmp74_;
			_tmp75_ = c;
			_tmp76_ = skk_candidate_get_text (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = candidate;
			_tmp79_ = skk_candidate_get_text (_tmp78_);
			_tmp80_ = _tmp79_;
			if (g_strcmp0 (_tmp77_, _tmp80_) == 0) {
				gint _tmp81_;
				_tmp81_ = index;
				if (_tmp81_ > 0) {
					GeeList* _tmp82_;
					gpointer _tmp83_ = NULL;
					SkkCandidate* first;
					GeeList* _tmp84_;
					GeeList* _tmp85_;
					gint _tmp86_;
					gpointer _tmp87_ = NULL;
					SkkCandidate* _tmp88_;
					GeeList* _tmp89_;
					gint _tmp90_;
					SkkCandidate* _tmp91_;
					_tmp82_ = candidates;
					_tmp83_ = gee_list_get (_tmp82_, 0);
					first = (SkkCandidate*) _tmp83_;
					_tmp84_ = candidates;
					_tmp85_ = candidates;
					_tmp86_ = index;
					_tmp87_ = gee_list_get (_tmp85_, _tmp86_);
					_tmp88_ = (SkkCandidate*) _tmp87_;
					gee_list_set (_tmp84_, 0, _tmp88_);
					_g_object_unref0 (_tmp88_);
					_tmp89_ = candidates;
					_tmp90_ = index;
					_tmp91_ = first;
					gee_list_set (_tmp89_, _tmp90_, _tmp91_);
					result = TRUE;
					_g_object_unref0 (first);
					_g_object_unref0 (c);
					_g_object_unref0 (_c_list);
					_g_object_unref0 (candidates);
					_g_object_unref0 (entries);
					return result;
				}
				result = FALSE;
				_g_object_unref0 (c);
				_g_object_unref0 (_c_list);
				_g_object_unref0 (candidates);
				_g_object_unref0 (entries);
				return result;
			}
			_tmp92_ = index;
			index = _tmp92_ + 1;
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_list);
	}
	_tmp93_ = candidates;
	_tmp94_ = candidate;
	gee_list_insert (_tmp93_, 0, _tmp94_);
	result = TRUE;
	_g_object_unref0 (candidates);
	_g_object_unref0 (entries);
	return result;
}


/**
         * {@inheritDoc}
         */
static gboolean skk_user_dict_real_purge_candidate (SkkDict* base, SkkCandidate* candidate) {
	SkkUserDict * self;
	gboolean result = FALSE;
	gboolean modified;
	SkkCandidate* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeMap* _tmp3_ = NULL;
	GeeMap* entries;
	GeeMap* _tmp4_;
	SkkCandidate* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	self = (SkkUserDict*) base;
	g_return_val_if_fail (candidate != NULL, FALSE);
	modified = FALSE;
	_tmp0_ = candidate;
	_tmp1_ = skk_candidate_get_okuri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = skk_user_dict_get_entries (self, _tmp2_);
	entries = _tmp3_;
	_tmp4_ = entries;
	_tmp5_ = candidate;
	_tmp6_ = skk_candidate_get_midasi (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_map_has_key (_tmp4_, _tmp7_);
	if (_tmp8_) {
		GeeMap* _tmp9_;
		SkkCandidate* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gpointer _tmp13_ = NULL;
		GeeList* candidates;
		GeeList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp9_ = entries;
		_tmp10_ = candidate;
		_tmp11_ = skk_candidate_get_midasi (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_map_get (_tmp9_, _tmp12_);
		candidates = (GeeList*) _tmp13_;
		_tmp14_ = candidates;
		_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_ > 0) {
			GeeList* _tmp17_;
			GeeIterator* _tmp18_ = NULL;
			GeeIterator* iter;
			GeeIterator* _tmp19_;
			GeeList* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			_tmp17_ = candidates;
			_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
			iter = _tmp18_;
			_tmp19_ = iter;
			gee_iterator_first (_tmp19_);
			{
				gboolean _tmp20_;
				_tmp20_ = TRUE;
				while (TRUE) {
					gboolean _tmp21_;
					GeeIterator* _tmp24_;
					gpointer _tmp25_ = NULL;
					SkkCandidate* c;
					SkkCandidate* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					SkkCandidate* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					_tmp21_ = _tmp20_;
					if (!_tmp21_) {
						GeeIterator* _tmp22_;
						gboolean _tmp23_ = FALSE;
						_tmp22_ = iter;
						_tmp23_ = gee_iterator_next (_tmp22_);
						if (!_tmp23_) {
							break;
						}
					}
					_tmp20_ = FALSE;
					_tmp24_ = iter;
					_tmp25_ = gee_iterator_get (_tmp24_);
					c = (SkkCandidate*) _tmp25_;
					_tmp26_ = c;
					_tmp27_ = skk_candidate_get_text (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = candidate;
					_tmp30_ = skk_candidate_get_text (_tmp29_);
					_tmp31_ = _tmp30_;
					if (g_strcmp0 (_tmp28_, _tmp31_) == 0) {
						GeeIterator* _tmp32_;
						_tmp32_ = iter;
						gee_iterator_remove (_tmp32_);
						modified = TRUE;
					}
					_g_object_unref0 (c);
				}
			}
			_tmp33_ = candidates;
			_tmp34_ = gee_collection_get_size ((GeeCollection*) _tmp33_);
			_tmp35_ = _tmp34_;
			if (_tmp35_ == 0) {
				GeeMap* _tmp36_;
				SkkCandidate* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				_tmp36_ = entries;
				_tmp37_ = candidate;
				_tmp38_ = skk_candidate_get_midasi (_tmp37_);
				_tmp39_ = _tmp38_;
				gee_map_unset (_tmp36_, _tmp39_, NULL);
			}
			_g_object_unref0 (iter);
		}
		_g_object_unref0 (candidates);
	}
	result = modified;
	_g_object_unref0 (entries);
	return result;
}


/**
         * Create a new UserDict.
         *
         * @param path a path to the file
         * @param encoding encoding of the file (default UTF-8)
         *
         * @return a new UserDict
         * @throws GLib.Error if opening the file is failed
         */
SkkUserDict* skk_user_dict_construct (GType object_type, const gchar* path, const gchar* encoding, GError** error) {
	SkkUserDict * self = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	SkkEncodingConverter* _tmp4_;
	SkkEncodingConverter* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (encoding != NULL, NULL);
	self = (SkkUserDict*) skk_dict_construct (object_type);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp2_;
	_tmp3_ = encoding;
	_tmp4_ = skk_encoding_converter_new (_tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (self->priv->converter);
	self->priv->converter = _tmp5_;
	_tmp6_ = path;
	_tmp7_ = g_file_test (_tmp6_, G_FILE_TEST_EXISTS);
	if (_tmp7_) {
		skk_dict_reload ((SkkDict*) self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		}
	}
	return self;
}


SkkUserDict* skk_user_dict_new (const gchar* path, const gchar* encoding, GError** error) {
	return skk_user_dict_construct (SKK_TYPE_USER_DICT, path, encoding, error);
}


static gboolean skk_user_dict_real_get_read_only (SkkDict* base) {
	gboolean result;
	SkkUserDict* self;
	self = (SkkUserDict*) base;
	result = FALSE;
	return result;
}


static void skk_user_dict_class_init (SkkUserDictClass * klass) {
	skk_user_dict_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkUserDictPrivate));
	SKK_DICT_CLASS (klass)->reload = skk_user_dict_real_reload;
	SKK_DICT_CLASS (klass)->save = skk_user_dict_real_save;
	SKK_DICT_CLASS (klass)->lookup = skk_user_dict_real_lookup;
	SKK_DICT_CLASS (klass)->complete = skk_user_dict_real_complete;
	SKK_DICT_CLASS (klass)->select_candidate = skk_user_dict_real_select_candidate;
	SKK_DICT_CLASS (klass)->purge_candidate = skk_user_dict_real_purge_candidate;
	SKK_DICT_CLASS (klass)->get_read_only = skk_user_dict_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_user_dict_get_property;
	G_OBJECT_CLASS (klass)->finalize = skk_user_dict_finalize;
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_USER_DICT_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void skk_user_dict_instance_init (SkkUserDict * self) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = SKK_USER_DICT_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->okuri_ari_entries = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->okuri_nasi_entries = (GeeMap*) _tmp1_;
}


static void skk_user_dict_finalize (GObject* obj) {
	SkkUserDict * self;
	GeeMap* _tmp0_;
	GeeMapIterator* _tmp1_ = NULL;
	GeeMapIterator* okuri_ari_iter;
	GeeMapIterator* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeMap* _tmp11_;
	GeeMap* _tmp12_;
	GeeMapIterator* _tmp13_ = NULL;
	GeeMapIterator* okuri_nasi_iter;
	GeeMapIterator* _tmp14_;
	gboolean _tmp15_ = FALSE;
	GeeMap* _tmp23_;
	self = SKK_USER_DICT (obj);
	_tmp0_ = self->priv->okuri_ari_entries;
	_tmp1_ = gee_map_map_iterator (_tmp0_);
	okuri_ari_iter = _tmp1_;
	_tmp2_ = okuri_ari_iter;
	_tmp3_ = gee_map_iterator_first (_tmp2_);
	if (_tmp3_) {
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				GeeMapIterator* _tmp8_;
				gpointer _tmp9_ = NULL;
				GeeList* _tmp10_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					GeeMapIterator* _tmp6_;
					gboolean _tmp7_ = FALSE;
					_tmp6_ = okuri_ari_iter;
					_tmp7_ = gee_map_iterator_next (_tmp6_);
					if (!_tmp7_) {
						break;
					}
				}
				_tmp4_ = FALSE;
				_tmp8_ = okuri_ari_iter;
				_tmp9_ = gee_map_iterator_get_value (_tmp8_);
				_tmp10_ = (GeeList*) _tmp9_;
				gee_collection_clear ((GeeCollection*) _tmp10_);
				_g_object_unref0 (_tmp10_);
			}
		}
	}
	_tmp11_ = self->priv->okuri_ari_entries;
	gee_map_clear (_tmp11_);
	_tmp12_ = self->priv->okuri_nasi_entries;
	_tmp13_ = gee_map_map_iterator (_tmp12_);
	okuri_nasi_iter = _tmp13_;
	_tmp14_ = okuri_nasi_iter;
	_tmp15_ = gee_map_iterator_first (_tmp14_);
	if (_tmp15_) {
		{
			gboolean _tmp16_;
			_tmp16_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_;
				GeeMapIterator* _tmp20_;
				gpointer _tmp21_ = NULL;
				GeeList* _tmp22_;
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					GeeMapIterator* _tmp18_;
					gboolean _tmp19_ = FALSE;
					_tmp18_ = okuri_nasi_iter;
					_tmp19_ = gee_map_iterator_next (_tmp18_);
					if (!_tmp19_) {
						break;
					}
				}
				_tmp16_ = FALSE;
				_tmp20_ = okuri_nasi_iter;
				_tmp21_ = gee_map_iterator_get_value (_tmp20_);
				_tmp22_ = (GeeList*) _tmp21_;
				gee_collection_clear ((GeeCollection*) _tmp22_);
				_g_object_unref0 (_tmp22_);
			}
		}
	}
	_tmp23_ = self->priv->okuri_nasi_entries;
	gee_map_clear (_tmp23_);
	_g_object_unref0 (okuri_nasi_iter);
	_g_object_unref0 (okuri_ari_iter);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->converter);
	_g_object_unref0 (self->priv->okuri_ari_entries);
	_g_object_unref0 (self->priv->okuri_nasi_entries);
	_vala_array_destroy (self->priv->midasi_history, 128, (GDestroyNotify) g_free);
	G_OBJECT_CLASS (skk_user_dict_parent_class)->finalize (obj);
}


/**
     * File based implementation of Dict with write access.
     */
GType skk_user_dict_get_type (void) {
	static volatile gsize skk_user_dict_type_id__volatile = 0;
	if (g_once_init_enter (&skk_user_dict_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkUserDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_user_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkUserDict), 0, (GInstanceInitFunc) skk_user_dict_instance_init, NULL };
		GType skk_user_dict_type_id;
		skk_user_dict_type_id = g_type_register_static (SKK_TYPE_DICT, "SkkUserDict", &g_define_type_info, 0);
		g_once_init_leave (&skk_user_dict_type_id__volatile, skk_user_dict_type_id);
	}
	return skk_user_dict_type_id__volatile;
}


static void _vala_skk_user_dict_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SkkUserDict * self;
	self = SKK_USER_DICT (object);
	switch (property_id) {
		case SKK_USER_DICT_READ_ONLY:
		g_value_set_boolean (value, skk_dict_get_read_only ((SkkDict*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



