// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_SelectDeduct_HeaderFile
#define _IFSelect_SelectDeduct_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IFSelect_SelectDeduct.hxx>

#include <Handle_IFSelect_Selection.hxx>
#include <Handle_IFSelect_SelectPointed.hxx>
#include <IFSelect_Selection.hxx>
#include <Standard_Boolean.hxx>
class IFSelect_Selection;
class IFSelect_SelectPointed;
class Interface_InterfaceError;
class Interface_EntityIterator;
class Interface_Graph;
class IFSelect_SelectionIterator;


//! A SelectDeduct determines a list of Entities from an Input
//! Selection, by a computation : Output list is not obliged to be
//! a sub-list of Input list
//! (for more specific, see SelectExtract for filtered sub-lists,
//! and SelectExplore for recurcive exploration)
//!
//! A SelectDeduct may use an alternate input for one shot
//! This allows to use an already existing definition, by
//! overloading the input selection by an alternate list,
//! already defined, for one use :
//! If this alternate list is set, InputResult queries it instead
//! of calling the input selection, then clears it immediately
class IFSelect_SelectDeduct : public IFSelect_Selection
{

public:

  
  //! Defines or Changes the Input Selection
  Standard_EXPORT   void SetInput (const Handle(IFSelect_Selection)& sel) ;
  
  //! Returns the Input Selection
  Standard_EXPORT   Handle(IFSelect_Selection) Input()  const;
  
  //! Returns True if the Input Selection is defined, False else
  Standard_EXPORT   Standard_Boolean HasInput()  const;
  
  //! Tells if an Alternate List has been set, i.e. : the Alternate
  //! Definition is present and set
  Standard_EXPORT   Standard_Boolean HasAlternate()  const;
  
  //! Returns the Alternate Definition
  //! It is returned modifiable, hence an already defined
  //! SelectPointed can be used
  //! But if it was not yet defined, it is created the first time
  //!
  //! It is exploited by InputResult
  Standard_EXPORT   Handle(IFSelect_SelectPointed)& Alternate() ;
  
  //! Returns the Result determined by Input Selection, as Unique
  //! if Input Selection is not defined, returns an empty list.
  //!
  //! If Alternate is set, InputResult takes its definition instead
  //! of calling the Input Selection, then clears it
  Standard_EXPORT   Interface_EntityIterator InputResult (const Interface_Graph& G)  const;
  
  //! Puts in an Iterator the Selections from which "me" depends
  //! This list contains one Selection : the InputSelection
  Standard_EXPORT   void FillIterator (IFSelect_SelectionIterator& iter)  const;




  DEFINE_STANDARD_RTTI(IFSelect_SelectDeduct)

protected:




private: 


  Handle(IFSelect_Selection) thesel;
  Handle(IFSelect_SelectPointed) thealt;


};







#endif // _IFSelect_SelectDeduct_HeaderFile
