//                                               -*- C++ -*-
/**
 *  @file  CorrelationMatrix.hxx
 *  @brief The class CorrelationMatrix implements correlation matrices
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: CorrelationMatrix.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_CORRELATIONMATRIX_HXX
#define OPENTURNS_CORRELATIONMATRIX_HXX

#include "OTprivate.hxx"
#include "CovarianceMatrix.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class CorrelationMatrix
 */

class CorrelationMatrix
  : public CovarianceMatrix
{
  CLASSNAME;

public:
  typedef Collection<NumericalScalar>       NumericalScalarCollection;


  /** Default constructor */
  CorrelationMatrix();

  /** Constructor with size */
  CorrelationMatrix(UnsignedLong const dim);

  /** Constructor from external collection */
  CorrelationMatrix(const UnsignedLong dim,
                    const NumericalScalarCollection & elementsValues);

  /** Constructor with implementation */
  CorrelationMatrix(const Implementation & i);

  /** String converter */
  virtual String __repr__() const;

  /** CorrelationMatrix transpose */
  CorrelationMatrix transpose () const ;

  /** CorrelationMatrix multiplication (must have consistent dimensions) */
  CorrelationMatrix operator * (const IdentityMatrix & m) const;
  using CovarianceMatrix::operator *;

protected:


private:

}; /* class CorrelationMatrix */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_COVARIANCEMATRIX_HXX */
