//                                               -*- C++ -*-
/**
 *  @file  RootStrategy.hxx
 *  @brief
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: RootStrategy.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_ROOTSTRATEGY_HXX
#define OPENTURNS_ROOTSTRATEGY_HXX

#include "RootStrategyImplementation.hxx"
#include "Pointer.hxx"
#include "TypedInterfaceObject.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class RootStrategy
 */

class RootStrategy
  : public TypedInterfaceObject<RootStrategyImplementation>
{
  CLASSNAME;

public:
  typedef Pointer<RootStrategyImplementation>     Implementation;
  typedef Collection<NumericalScalar> NumericalScalarCollection;

  /** Constructor with parameters */
  RootStrategy(const RootStrategyImplementation & implementation);

  /** Constructor with parameters */
  RootStrategy(Implementation & p_implementation);

  /** Default Constructor: choose the SafeAndSlow strategy with its default solver */
  explicit RootStrategy();


  /** Solve gives all the roots found applying the root strategy */
  NumericalScalarCollection solve(const NumericalMathFunction & function,
                                  const NumericalScalar value);

  /** Solver accessor */
  void setSolver(const Solver & solver);
  Solver getSolver() const;

  /** Maximum distance accessor */
  void setMaximumDistance(const NumericalScalar maximumDistance);
  NumericalScalar getMaximumDistance() const;

  /** Step size accessor */
  void setStepSize(const NumericalScalar stepSize);
  NumericalScalar getStepSize() const;

  /** Value of the performance function at the origin accessor */
  void setOriginValue(const NumericalScalar originValue);
  NumericalScalar getOriginValue() const;

  /** String converter */
  String __repr__() const;

} ; /* class RootStrategy */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_ROOTSTRATEGY_HXX */
