//                                               -*- C++ -*-
/**
 *  @file  t_Cache_std.cxx
 *  @brief The test file of class Cache for standard methods
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_Cache_std.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "Cache.hxx"
#include "NumericalPoint.hxx"

using namespace OT;
using namespace OT::Test;

typedef PersistentCollection<NumericalScalar> KeyType;
typedef PersistentCollection<NumericalScalar> ValueType;
typedef Cache<KeyType,ValueType>              TestCache;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    // Create a Cache object
    TestCache myCache(3);
    myCache.setName("aCache");
    myCache.enable();

    fullprint << "myCache = " << myCache << std::endl;

    // Create a point and add it to the cache
    KeyType k(3);
    k[0] = 1.;
    k[1] = 2.;
    k[2] = 3.;
    ValueType v(2);
    v[0] = 10.;
    v[1] = 20.;
    myCache.add( k, v );

    fullprint << "myCache = " << myCache << std::endl;

    // Create a fake point
    KeyType ko(3);
    ko[0] = -1.;
    ko[1] = -2.;
    ko[2] = -3.;

    // Create a valid point
    KeyType ok(k);

    // Check which point is in the cache and retrieve corresponding values
    fullprint << "Is ko in myCache ? " << myCache.hasKey( ko ) << std::endl;
    fullprint << "Cache value for ko = " << myCache.find( ko ) << std::endl;

    fullprint << "Is ok in myCache ? " << myCache.hasKey( ok ) << std::endl;
    fullprint << "Cache value for ok = " << myCache.find( ok ) << std::endl;

    fullprint << "myCache = " << myCache << std::endl;

    // Add some more points in the cache
    KeyType p1  = 2. * k;
    ValueType pv1 = 2. * v;
    myCache.add( p1, pv1 );
    fullprint << "myCache = " << myCache << std::endl;

    KeyType p2  = 3. * k;
    ValueType pv2 = 3. * v;
    myCache.add( p2, pv2 );
    fullprint << "myCache = " << myCache << std::endl;

    KeyType p3  = 4. * k;
    ValueType pv3 = 4. * v;
    myCache.add( p3, pv3 );
    fullprint << "myCache = " << myCache << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
