//                                               -*- C++ -*-
/**
 *  @file  t_SpatialFunction_std.cxx
 *  @brief The test file of class SpatialFunction for standard methods
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (mar. 24 mai 2011) $
 *  Id:      $Id: t_SpatialFunction_std.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "SpatialFunction.hxx"
#include "NumericalMathFunction.hxx"
#include "TimeSeries.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    /* Create an intance */
    NumericalMathFunction myFunc("x", "x^2");
    SpatialFunction mySpatialFunc(myFunc);

    fullprint << "mySpatialFunc=" << mySpatialFunc << std::endl;
    /* Get the input and output description */
    fullprint << "mySpatialFunc input description=" << mySpatialFunc.getInputDescription() << std::endl;
    fullprint << "mySpatialFunc output description=" << mySpatialFunc.getOutputDescription() << std::endl;
    /* Get the input and output dimension, based on description */
    fullprint << "mySpatialFunc input dimension=" << mySpatialFunc.getInputDimension() << std::endl;
    fullprint << "mySpatialFunc output dimension=" << mySpatialFunc.getOutputDimension() << std::endl;
    /* Create a TimeSeries */
    RegularGrid tg(0.0, 0.2, 6);
    NumericalSample data(tg.getN(), myFunc.getInputDimension());
    for (UnsignedLong i = 0; i < data.getSize(); ++i)
      for (UnsignedLong j = 0; j < data.getDimension(); ++j)
        data(i, j) = i * data.getDimension() + j;
    TimeSeries ts(tg, data);
    fullprint << "input time series=" << ts << std::endl;
    fullprint << "output time series=" << mySpatialFunc(ts) << std::endl;
    /* Get the number of calls */
    fullprint << "called " << mySpatialFunc.getCallsNumber() << " times" << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
