/*
**  Flags.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
#import <Foundation/Foundation.h>

#define ANSWERED    1
#define DRAFT       2
#define FLAGGED     4
#define RECENT      8
#define SEEN        16
#define DELETED     32
#define TRANSFERRED 64

@interface Flags : NSObject <NSCoding, NSCopying>
{
  int flags;
}

- (id) init;
- (id) initWithFlags: (int) theFlags;
- (id) initWithString: (NSString *) theString;

- (void) dealloc;

//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder;
- (id) initWithCoder: (NSCoder *) theCoder;

//
// NSCopying protocol
//
- (id) copyWithZone: (NSZone *) zone;


//
// access/mutation methods
//
- (void) add: (int) aFlag;
- (void) addFlagsFromString: (NSString *) theString;

- (BOOL) contain: (int) theFlag;
- (void) remove: (int) theFlag;
- (void) removeAll;

- (NSString *) string;

- (char *) statusString;
- (char *) xstatusString;

@end
