#ifndef INCLUDE_ENTITY_HANDLER_H
#define INCLUDE_ENTITY_HANDLER_H

#include "EntityGroup.h"

typedef std::list<EntityGroup*> GroupList;

#include <glade/glade.h>

class EntityHandler {

 public:
  EntityHandler();
  ~EntityHandler();

  void addGroup(EntityGroup *);
  void removeGroup(EntityGroup *);
  void moveGroup(Entity *, char *);

  void addEntity(char * group, Entity *);
  void removeEntity(Entity *);
  void removeEntityGroup(EntityGroup *);

  EntityGroup * findGroup(char *, bool);

  void findExecute(EntityType type, char * field, char * value, void * data, bool multiple);

  void load();
  void load(FILE *);
  void importEntities(char *);

  void save();
  void exportEntities(char *);

  void importSelected();
  void exportSelected();

  void edit();

  void populate_tree_model(GtkTreeStore *);
  void row_selected(GtkTreeSelection *, gpointer);

  void apply();
  void close();

  void entitySelected(gpointer);

  Entity * findByID(int);

  void update();
  void selectEntity(Entity *);
  void deleteSelected();
  void deleteEntity(Entity *);
  EntityGroup * getSelectedGroup();
  Entity * getSelectedEntity();
  GList * getSelectedEntities();
  int getSelectedID();

  void selectByID(GtkTreeIter *, gpointer);

  void newAlias();
  void newTrigger();

  GtkWidget * getGroupOptionMenu(Entity *);
  GList * getGroupOptionMenuList();
  
  EntityGroup * getEntityGroupForEntity(Entity *);
  
 private:

  std::list<EntityGroup*> groups;

  GladeXML * xml;

  GtkTreeStore * tree_model;
  GtkTreeSelection * selection;

  GtkWidget * entity_widget;
};

#endif // INCLUDE_ENTITY_HANDLER_H

