#ifndef INCLUDE_FONT_PREFERENCE_H
#define INCLUDE_FONT_PREFERENCE_H

#include "papaya/Preference.h"
#include "PreferenceHandler.h"
#include "FontChooser.h"

class FontPreference : public Preference {
 public:
  FontPreference();
  ~FontPreference();

  GtkWidget * getWidget();
  void destroyWidget();

  Category * getCategories();

  void applyPreferences(Prefs *);
  void loadPreferences(Prefs *);

 private:
  FontChooser * bold_chooser;
  FontChooser * italic_chooser;
  FontChooser * input_chooser;
  FontChooser * output_chooser;
  FontChooser * prompt_chooser;

};

const Category font_categories[] = {
  CategoryFonts,
  CategoryLast
};


#endif // INCLUDE_FONT_PREFERENCE_H
