/*=========================================================================

   Program: ParaView
   Module:    pqApplyPropertiesManager.h

   Copyright (c) 2005-2008 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.2. 

   See License_v1.2.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/
#ifndef __pqApplyPropertiesManager_h
#define __pqApplyPropertiesManager_h

#include "pqComponentsExport.h"

#include <QObject>

class PQCOMPONENTS_EXPORT pqApplyPropertiesManager : public QObject
{
  Q_OBJECT

public:
  pqApplyPropertiesManager(QObject *parent = 0);
  ~pqApplyPropertiesManager();

public slots:
  void applyProperties();

signals:
  /// This signal is emitted before applying any proxy property
  /// changes.
  void preApply();

  /// This signal is emitted to notify observers that they should
  /// apply any changed proxy propterites.
  void apply();

  /// This signal is emitted after applying any proxy property
  /// changes.
  void postApply();

  /// This signal is emitted when the state of the apply button
  /// should change.
  void applyStateChanged(bool enabled);

  /// This signal is emitted when the state of the reset button
  /// should be changed.
  void resetStateChanged(bool enabled);

  /// This signal is emitted when the state of the delete button
  /// should change.
  void deleteStateChanged(bool enabled);
};

#endif
