/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkOpenGLLightingPainter.h,v $

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkOpenGLLightingPainter - painter that manages lighting.
// .SECTION Description
// This painter manages lighting.
// Ligting is disabled when rendering points/lines and no normals are present
// or rendering Polygons/TStrips and representation is points and no normals 
// are present.

#ifndef __vtkOpenGLLightingPainter_h
#define __vtkOpenGLLightingPainter_h

#include "vtkLightingPainter.h"

class vtkWindow;

class VTK_RENDERING_EXPORT vtkOpenGLLightingPainter : public vtkLightingPainter
{
public:
  static vtkOpenGLLightingPainter* New();
  vtkTypeRevisionMacro(vtkOpenGLLightingPainter, vtkLightingPainter);
  void PrintSelf(ostream& os ,vtkIndent indent);
    
protected:
  vtkOpenGLLightingPainter();
  ~vtkOpenGLLightingPainter();

  // Description:
  // Setups lighting state before calling render on delegate 
  // painter.
  virtual void RenderInternal(vtkRenderer* renderer, vtkActor* actor, 
    unsigned long typeflags);

private:
  vtkOpenGLLightingPainter(const vtkOpenGLLightingPainter&); // Not implemented.
  void operator=(const vtkOpenGLLightingPainter&); // Not implemented.
};

#endif

