/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <NamespaceAttributes.h>
#include <DataNode.h>

// Type map format string
const char *NamespaceAttributes::TypeMapFormatString = "ii*ii";

// ****************************************************************************
// Method: NamespaceAttributes::NamespaceAttributes
//
// Purpose: 
//   Constructor for the NamespaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

NamespaceAttributes::NamespaceAttributes() : 
    AttributeSubject(NamespaceAttributes::TypeMapFormatString)
{
    type = -1;
    min = -1;
    max = -1;
}

// ****************************************************************************
// Method: NamespaceAttributes::NamespaceAttributes
//
// Purpose: 
//   Copy constructor for the NamespaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

NamespaceAttributes::NamespaceAttributes(const NamespaceAttributes &obj) : 
    AttributeSubject(NamespaceAttributes::TypeMapFormatString)
{
    type = obj.type;
    subsets = obj.subsets;
    min = obj.min;
    max = obj.max;

    SelectAll();
}

// ****************************************************************************
// Method: NamespaceAttributes::~NamespaceAttributes
//
// Purpose: 
//   Destructor for the NamespaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

NamespaceAttributes::~NamespaceAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: NamespaceAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the NamespaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

NamespaceAttributes& 
NamespaceAttributes::operator = (const NamespaceAttributes &obj)
{
    if (this == &obj) return *this;
    type = obj.type;
    subsets = obj.subsets;
    min = obj.min;
    max = obj.max;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: NamespaceAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the NamespaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
NamespaceAttributes::operator == (const NamespaceAttributes &obj) const
{
    // Create the return value
    return ((type == obj.type) &&
            (subsets == obj.subsets) &&
            (min == obj.min) &&
            (max == obj.max));
}

// ****************************************************************************
// Method: NamespaceAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the NamespaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
NamespaceAttributes::operator != (const NamespaceAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: NamespaceAttributes::TypeName
//
// Purpose: 
//   Type name method for the NamespaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
NamespaceAttributes::TypeName() const
{
    return "NamespaceAttributes";
}

// ****************************************************************************
// Method: NamespaceAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the NamespaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
NamespaceAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const NamespaceAttributes *tmp = (const NamespaceAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: NamespaceAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the NamespaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
NamespaceAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new NamespaceAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: NamespaceAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the NamespaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
NamespaceAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new NamespaceAttributes(*this);
    else
        retval = new NamespaceAttributes;

    return retval;
}

// ****************************************************************************
// Method: NamespaceAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
NamespaceAttributes::SelectAll()
{
    Select(ID_type,    (void *)&type);
    Select(ID_subsets, (void *)&subsets);
    Select(ID_min,     (void *)&min);
    Select(ID_max,     (void *)&max);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: NamespaceAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
NamespaceAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    NamespaceAttributes defaultObject;
    bool addToParent = false;
    // Create a node for NamespaceAttributes.
    DataNode *node = new DataNode("NamespaceAttributes");

    if(completeSave || !FieldsEqual(ID_type, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("type", type));
    }

    if(completeSave || !FieldsEqual(ID_subsets, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("subsets", subsets));
    }

    if(completeSave || !FieldsEqual(ID_min, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("min", min));
    }

    if(completeSave || !FieldsEqual(ID_max, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("max", max));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: NamespaceAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
NamespaceAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("NamespaceAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("type")) != 0)
        SetType(node->AsInt());
    if((node = searchNode->GetNode("subsets")) != 0)
        SetSubsets(node->AsIntVector());
    if((node = searchNode->GetNode("min")) != 0)
        SetMin(node->AsInt());
    if((node = searchNode->GetNode("max")) != 0)
        SetMax(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
NamespaceAttributes::SetType(int type_)
{
    type = type_;
    Select(ID_type, (void *)&type);
}

void
NamespaceAttributes::SetSubsets(const intVector &subsets_)
{
    subsets = subsets_;
    Select(ID_subsets, (void *)&subsets);
}

void
NamespaceAttributes::SetMin(int min_)
{
    min = min_;
    Select(ID_min, (void *)&min);
}

void
NamespaceAttributes::SetMax(int max_)
{
    max = max_;
    Select(ID_max, (void *)&max);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
NamespaceAttributes::GetType() const
{
    return type;
}

const intVector &
NamespaceAttributes::GetSubsets() const
{
    return subsets;
}

intVector &
NamespaceAttributes::GetSubsets()
{
    return subsets;
}

int
NamespaceAttributes::GetMin() const
{
    return min;
}

int
NamespaceAttributes::GetMax() const
{
    return max;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
NamespaceAttributes::SelectSubsets()
{
    Select(ID_subsets, (void *)&subsets);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: NamespaceAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
NamespaceAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_type:    return "type";
    case ID_subsets: return "subsets";
    case ID_min:     return "min";
    case ID_max:     return "max";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: NamespaceAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
NamespaceAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_type:    return FieldType_int;
    case ID_subsets: return FieldType_intVector;
    case ID_min:     return FieldType_int;
    case ID_max:     return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: NamespaceAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
NamespaceAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_type:    return "int";
    case ID_subsets: return "intVector";
    case ID_min:     return "int";
    case ID_max:     return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: NamespaceAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
NamespaceAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const NamespaceAttributes &obj = *((const NamespaceAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_type:
        {  // new scope
        retval = (type == obj.type);
        }
        break;
    case ID_subsets:
        {  // new scope
        retval = (subsets == obj.subsets);
        }
        break;
    case ID_min:
        {  // new scope
        retval = (min == obj.min);
        }
        break;
    case ID_max:
        {  // new scope
        retval = (max == obj.max);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

