/* pdf.c generated by valac 0.16.0, the Vala compiler
 * generated from pdf.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <poppler.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define PDFPC_METADATA_TYPE_BASE (pdfpc_metadata_base_get_type ())
#define PDFPC_METADATA_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_METADATA_TYPE_BASE, pdfpcMetadataBase))
#define PDFPC_METADATA_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_METADATA_TYPE_BASE, pdfpcMetadataBaseClass))
#define PDFPC_METADATA_IS_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_METADATA_TYPE_BASE))
#define PDFPC_METADATA_IS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_METADATA_TYPE_BASE))
#define PDFPC_METADATA_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_METADATA_TYPE_BASE, pdfpcMetadataBaseClass))

typedef struct _pdfpcMetadataBase pdfpcMetadataBase;
typedef struct _pdfpcMetadataBaseClass pdfpcMetadataBaseClass;
typedef struct _pdfpcMetadataBasePrivate pdfpcMetadataBasePrivate;

#define PDFPC_METADATA_TYPE_PDF (pdfpc_metadata_pdf_get_type ())
#define PDFPC_METADATA_PDF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdf))
#define PDFPC_METADATA_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdfClass))
#define PDFPC_METADATA_IS_PDF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_METADATA_TYPE_PDF))
#define PDFPC_METADATA_IS_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_METADATA_TYPE_PDF))
#define PDFPC_METADATA_PDF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdfClass))

typedef struct _pdfpcMetadataPdf pdfpcMetadataPdf;
typedef struct _pdfpcMetadataPdfClass pdfpcMetadataPdfClass;
typedef struct _pdfpcMetadataPdfPrivate pdfpcMetadataPdfPrivate;

#define PDFPC_TYPE_SLIDES_NOTES (pdfpc_slides_notes_get_type ())
#define PDFPC_SLIDES_NOTES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_TYPE_SLIDES_NOTES, pdfpcslides_notes))
#define PDFPC_SLIDES_NOTES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_TYPE_SLIDES_NOTES, pdfpcslides_notesClass))
#define PDFPC_IS_SLIDES_NOTES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_TYPE_SLIDES_NOTES))
#define PDFPC_IS_SLIDES_NOTES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_TYPE_SLIDES_NOTES))
#define PDFPC_SLIDES_NOTES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_TYPE_SLIDES_NOTES, pdfpcslides_notesClass))

typedef struct _pdfpcslides_notes pdfpcslides_notes;
typedef struct _pdfpcslides_notesClass pdfpcslides_notesClass;

#define PDFPC_METADATA_PDF_TYPE_PARSE_STATE (pdfpc_metadata_pdf_parse_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _pdfpcMetadataBase {
	GObject parent_instance;
	pdfpcMetadataBasePrivate * priv;
	gchar* fname;
	gchar* url;
};

struct _pdfpcMetadataBaseClass {
	GObjectClass parent_class;
	guint (*get_slide_count) (pdfpcMetadataBase* self);
};

struct _pdfpcMetadataPdf {
	pdfpcMetadataBase parent_instance;
	pdfpcMetadataPdfPrivate * priv;
	gchar* pdf_fname;
	gchar* pdf_url;
	gchar* pdfpc_url;
	PopplerDocument* document;
	gdouble page_width;
	gdouble page_height;
	guint page_count;
	pdfpcslides_notes* notes;
	gboolean skips_by_user;
	guint duration;
};

struct _pdfpcMetadataPdfClass {
	pdfpcMetadataBaseClass parent_class;
};

struct _pdfpcMetadataPdfPrivate {
	gint* user_view_indexes;
	gint user_view_indexes_length1;
	gint _user_view_indexes_size_;
	gint end_user_slide;
};

typedef enum  {
	PDFPC_METADATA_PDF_PARSE_STATE_FILE,
	PDFPC_METADATA_PDF_PARSE_STATE_SKIP,
	PDFPC_METADATA_PDF_PARSE_STATE_DURATION,
	PDFPC_METADATA_PDF_PARSE_STATE_END_USER_SLIDE,
	PDFPC_METADATA_PDF_PARSE_STATE_NOTES,
	PDFPC_METADATA_PDF_PARSE_STATE_NOTHING
} pdfpcMetadataPdfParseState;


static gpointer pdfpc_metadata_pdf_parent_class = NULL;
extern GMutex* pdfpc_mutex_locks_poppler;

GType pdfpc_metadata_base_get_type (void) G_GNUC_CONST;
GType pdfpc_metadata_pdf_get_type (void) G_GNUC_CONST;
GType pdfpc_slides_notes_get_type (void) G_GNUC_CONST;
#define PDFPC_METADATA_PDF_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdfPrivate))
enum  {
	PDFPC_METADATA_PDF_DUMMY_PROPERTY
};
static GType pdfpc_metadata_pdf_parse_state_get_type (void) G_GNUC_UNUSED;
static void pdfpc_metadata_pdf_parse_pdfpc_file (pdfpcMetadataPdf* self, gchar** skip_line);
void pdfpc_slides_notes_parse_lines (pdfpcslides_notes* self, gchar** lines, int lines_length1);
static void pdfpc_metadata_pdf_parse_skip_line (pdfpcMetadataPdf* self, const gchar* line);
static void _vala_array_add2 (gint** array, int* length, int* size, gint value);
static void _vala_array_add3 (gint** array, int* length, int* size, gint value);
static void pdfpc_metadata_pdf_fill_path_info (pdfpcMetadataPdf* self, const gchar* fname);
void pdfpc_metadata_pdf_save_to_disk (pdfpcMetadataPdf* self);
gchar* pdfpc_metadata_pdf_format_duration (pdfpcMetadataPdf* self);
gchar* pdfpc_metadata_pdf_format_skips (pdfpcMetadataPdf* self);
gchar* pdfpc_metadata_pdf_format_end_user_slide (pdfpcMetadataPdf* self);
gchar* pdfpc_metadata_pdf_format_notes (pdfpcMetadataPdf* self);
gboolean pdfpc_slides_notes_has_notes (pdfpcslides_notes* self);
gchar* pdfpc_slides_notes_format_to_save (pdfpcslides_notes* self);
pdfpcMetadataPdf* pdfpc_metadata_pdf_new (const gchar* fname);
pdfpcMetadataPdf* pdfpc_metadata_pdf_construct (GType object_type, const gchar* fname);
pdfpcMetadataBase* pdfpc_metadata_base_construct (GType object_type, const gchar* fname);
pdfpcslides_notes* pdfpc_slides_notes_new (void);
pdfpcslides_notes* pdfpc_slides_notes_construct (GType object_type);
PopplerDocument* pdfpc_metadata_pdf_open_pdf_document (pdfpcMetadataPdf* self, const gchar* url);
static void _vala_array_add4 (gint** array, int* length, int* size, gint value);
static guint pdfpc_metadata_pdf_real_get_slide_count (pdfpcMetadataBase* base);
gint pdfpc_metadata_pdf_get_user_slide_count (pdfpcMetadataPdf* self);
gint pdfpc_metadata_pdf_get_end_user_slide (pdfpcMetadataPdf* self);
void pdfpc_metadata_pdf_set_end_user_slide (pdfpcMetadataPdf* self, gint slide);
gint pdfpc_metadata_pdf_toggle_skip (pdfpcMetadataPdf* self, gint slide_number, gint user_slide_number);
gint pdfpc_metadata_pdf_user_slide_to_real_slide (pdfpcMetadataPdf* self, gint number);
static gint* _vala_array_dup3 (gint* self, int length);
static gint* _vala_array_dup4 (gint* self, int length);
gint pdfpc_metadata_pdf_real_slide_to_user_slide (pdfpcMetadataPdf* self, gint number);
gdouble pdfpc_metadata_pdf_get_page_width (pdfpcMetadataPdf* self);
gdouble pdfpc_metadata_pdf_get_page_height (pdfpcMetadataPdf* self);
PopplerDocument* pdfpc_metadata_pdf_get_document (pdfpcMetadataPdf* self);
pdfpcslides_notes* pdfpc_metadata_pdf_get_notes (pdfpcMetadataPdf* self);
guint pdfpc_metadata_pdf_get_duration (pdfpcMetadataPdf* self);
void pdfpc_metadata_pdf_set_duration (pdfpcMetadataPdf* self, guint d);
static void pdfpc_metadata_pdf_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
         * The parsing states for the pdfpc file
         */
static GType pdfpc_metadata_pdf_parse_state_get_type (void) {
	static volatile gsize pdfpc_metadata_pdf_parse_state_type_id__volatile = 0;
	if (g_once_init_enter (&pdfpc_metadata_pdf_parse_state_type_id__volatile)) {
		static const GEnumValue values[] = {{PDFPC_METADATA_PDF_PARSE_STATE_FILE, "PDFPC_METADATA_PDF_PARSE_STATE_FILE", "file"}, {PDFPC_METADATA_PDF_PARSE_STATE_SKIP, "PDFPC_METADATA_PDF_PARSE_STATE_SKIP", "skip"}, {PDFPC_METADATA_PDF_PARSE_STATE_DURATION, "PDFPC_METADATA_PDF_PARSE_STATE_DURATION", "duration"}, {PDFPC_METADATA_PDF_PARSE_STATE_END_USER_SLIDE, "PDFPC_METADATA_PDF_PARSE_STATE_END_USER_SLIDE", "end-user-slide"}, {PDFPC_METADATA_PDF_PARSE_STATE_NOTES, "PDFPC_METADATA_PDF_PARSE_STATE_NOTES", "notes"}, {PDFPC_METADATA_PDF_PARSE_STATE_NOTHING, "PDFPC_METADATA_PDF_PARSE_STATE_NOTHING", "nothing"}, {0, NULL, NULL}};
		GType pdfpc_metadata_pdf_parse_state_type_id;
		pdfpc_metadata_pdf_parse_state_type_id = g_enum_register_static ("pdfpcMetadataPdfParseState", values);
		g_once_init_leave (&pdfpc_metadata_pdf_parse_state_type_id__volatile, pdfpc_metadata_pdf_parse_state_type_id);
	}
	return pdfpc_metadata_pdf_parse_state_type_id__volatile;
}


/**
         * Parse the given pdfpc file
         */
static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void pdfpc_metadata_pdf_parse_pdfpc_file (pdfpcMetadataPdf* self, gchar** skip_line) {
	gchar* _vala_skip_line = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_g_free0 (_vala_skip_line);
	_vala_skip_line = NULL;
	{
		const gchar* _tmp0_;
		GFile* _tmp1_ = NULL;
		GFile* file;
		guint8* raw_datau8 = NULL;
		gint raw_datau8_length1 = 0;
		gint _raw_datau8_size_ = 0;
		GFile* _tmp2_;
		guint8* _tmp3_ = NULL;
		gsize _tmp4_;
		guint8* _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gchar** _tmp7_ = NULL;
		gchar** lines;
		gint lines_length1;
		gint _lines_size_;
		pdfpcMetadataPdfParseState state;
		_tmp0_ = self->pdfpc_url;
		_tmp1_ = g_file_new_for_uri (_tmp0_);
		file = _tmp1_;
		_tmp2_ = file;
		g_file_load_contents (_tmp2_, NULL, &_tmp3_, &_tmp4_, NULL, &_inner_error_);
		raw_datau8 = (g_free (raw_datau8), NULL);
		raw_datau8 = _tmp3_;
		raw_datau8_length1 = _tmp4_;
		_raw_datau8_size_ = raw_datau8_length1;
		if (_inner_error_ != NULL) {
			raw_datau8 = (g_free (raw_datau8), NULL);
			_g_object_unref0 (file);
			goto __catch13_g_error;
		}
		_tmp5_ = raw_datau8;
		_tmp5__length1 = raw_datau8_length1;
		_tmp7_ = _tmp6_ = g_strsplit ((const gchar*) _tmp5_, "\n", 0);
		lines = _tmp7_;
		lines_length1 = _vala_array_length (_tmp6_);
		_lines_size_ = lines_length1;
		state = PDFPC_METADATA_PDF_PARSE_STATE_NOTHING;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					gboolean _tmp9_;
					gint _tmp11_;
					gchar** _tmp12_;
					gint _tmp12__length1;
					gchar** _tmp13_;
					gint _tmp13__length1;
					gint _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_ = NULL;
					gchar* l;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					_tmp9_ = _tmp8_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp11_ = i;
					_tmp12_ = lines;
					_tmp12__length1 = lines_length1;
					if (!(_tmp11_ < _tmp12__length1)) {
						break;
					}
					_tmp13_ = lines;
					_tmp13__length1 = lines_length1;
					_tmp14_ = i;
					_tmp15_ = _tmp13_[_tmp14_];
					_tmp16_ = string_strip (_tmp15_);
					l = _tmp16_;
					_tmp17_ = l;
					if (g_strcmp0 (_tmp17_, "") == 0) {
						_g_free0 (l);
						continue;
					}
					_tmp18_ = l;
					if (g_strcmp0 (_tmp18_, "[file]") == 0) {
						state = PDFPC_METADATA_PDF_PARSE_STATE_FILE;
					} else {
						const gchar* _tmp19_;
						_tmp19_ = l;
						if (g_strcmp0 (_tmp19_, "[skip]") == 0) {
							state = PDFPC_METADATA_PDF_PARSE_STATE_SKIP;
						} else {
							const gchar* _tmp20_;
							_tmp20_ = l;
							if (g_strcmp0 (_tmp20_, "[duration]") == 0) {
								state = PDFPC_METADATA_PDF_PARSE_STATE_DURATION;
							} else {
								const gchar* _tmp21_;
								_tmp21_ = l;
								if (g_strcmp0 (_tmp21_, "[end_user_slide]") == 0) {
									state = PDFPC_METADATA_PDF_PARSE_STATE_END_USER_SLIDE;
								} else {
									const gchar* _tmp22_;
									_tmp22_ = l;
									if (g_strcmp0 (_tmp22_, "[notes]") == 0) {
										pdfpcslides_notes* _tmp23_;
										gchar** _tmp24_;
										gint _tmp24__length1;
										gint _tmp25_;
										gchar** _tmp26_;
										gint _tmp26__length1;
										_tmp23_ = self->notes;
										_tmp24_ = lines;
										_tmp24__length1 = lines_length1;
										_tmp25_ = i;
										_tmp26_ = lines;
										_tmp26__length1 = lines_length1;
										pdfpc_slides_notes_parse_lines (_tmp23_, _tmp24_ + (_tmp25_ + 1), _tmp26__length1 - (_tmp25_ + 1));
										_g_free0 (l);
										break;
									} else {
										pdfpcMetadataPdfParseState _tmp27_;
										_tmp27_ = state;
										switch (_tmp27_) {
											case PDFPC_METADATA_PDF_PARSE_STATE_FILE:
											{
												const gchar* _tmp28_;
												gchar* _tmp29_;
												GFile* _tmp30_;
												GFile* _tmp31_ = NULL;
												GFile* _tmp32_;
												const gchar* _tmp33_;
												GFile* _tmp34_ = NULL;
												GFile* _tmp35_;
												GFile* pdffile;
												GFile* _tmp36_;
												gchar* _tmp37_ = NULL;
												_tmp28_ = l;
												_tmp29_ = g_strdup (_tmp28_);
												_g_free0 (self->pdf_fname);
												self->pdf_fname = _tmp29_;
												_tmp30_ = file;
												_tmp31_ = g_file_get_parent (_tmp30_);
												_tmp32_ = _tmp31_;
												_tmp33_ = self->pdf_fname;
												_tmp34_ = g_file_get_child (_tmp32_, _tmp33_);
												_tmp35_ = _tmp34_;
												_g_object_unref0 (_tmp32_);
												pdffile = _tmp35_;
												_tmp36_ = pdffile;
												_tmp37_ = g_file_get_uri (_tmp36_);
												_g_free0 (self->pdf_url);
												self->pdf_url = _tmp37_;
												state = PDFPC_METADATA_PDF_PARSE_STATE_NOTHING;
												_g_object_unref0 (pdffile);
												break;
											}
											case PDFPC_METADATA_PDF_PARSE_STATE_SKIP:
											{
												const gchar* _tmp38_;
												gchar* _tmp39_;
												_tmp38_ = l;
												_tmp39_ = g_strdup (_tmp38_);
												_g_free0 (_vala_skip_line);
												_vala_skip_line = _tmp39_;
												self->skips_by_user = TRUE;
												state = PDFPC_METADATA_PDF_PARSE_STATE_NOTHING;
												break;
											}
											case PDFPC_METADATA_PDF_PARSE_STATE_DURATION:
											{
												const gchar* _tmp40_;
												gint _tmp41_ = 0;
												_tmp40_ = l;
												_tmp41_ = atoi (_tmp40_);
												self->duration = (guint) _tmp41_;
												break;
											}
											case PDFPC_METADATA_PDF_PARSE_STATE_END_USER_SLIDE:
											{
												const gchar* _tmp42_;
												gint _tmp43_ = 0;
												_tmp42_ = l;
												_tmp43_ = atoi (_tmp42_);
												self->priv->end_user_slide = _tmp43_;
												break;
											}
											default:
											break;
										}
									}
								}
							}
						}
					}
					_g_free0 (l);
				}
			}
		}
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		raw_datau8 = (g_free (raw_datau8), NULL);
		_g_object_unref0 (file);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp44_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp44_ = e->message;
		g_error ("pdf.vala:145: %s", _tmp44_);
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (skip_line) {
		*skip_line = _vala_skip_line;
	} else {
		_g_free0 (_vala_skip_line);
	}
}


/**
         * Parse the line for the skip slides
         */
static void _vala_array_add2 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add3 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void pdfpc_metadata_pdf_parse_skip_line (pdfpcMetadataPdf* self, const gchar* line) {
	gint s;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** fields;
	gint fields_length1;
	gint _fields_size_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	s = 0;
	_tmp0_ = line;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ",", 0);
	fields = _tmp2_;
	fields_length1 = _vala_array_length (_tmp1_);
	_fields_size_ = fields_length1;
	{
		gint f;
		f = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				const gchar* _tmp10_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_ = 0;
				gint current_skip;
				gint _tmp20_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = f;
					f = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = f;
				_tmp7_ = fields;
				_tmp7__length1 = fields_length1;
				if (!(_tmp6_ < (_tmp7__length1 - 1))) {
					break;
				}
				_tmp8_ = fields;
				_tmp8__length1 = fields_length1;
				_tmp9_ = f;
				_tmp10_ = _tmp8_[_tmp9_];
				if (g_strcmp0 (_tmp10_, "") == 0) {
					continue;
				}
				_tmp11_ = fields;
				_tmp11__length1 = fields_length1;
				_tmp12_ = f;
				_tmp13_ = _tmp11_[_tmp12_];
				_tmp14_ = atoi (_tmp13_);
				current_skip = _tmp14_ - 1;
				while (TRUE) {
					gint _tmp15_;
					gint _tmp16_;
					gint* _tmp17_;
					gint _tmp17__length1;
					gint _tmp18_;
					gint _tmp19_;
					_tmp15_ = s;
					_tmp16_ = current_skip;
					if (!(_tmp15_ < _tmp16_)) {
						break;
					}
					_tmp17_ = self->priv->user_view_indexes;
					_tmp17__length1 = self->priv->user_view_indexes_length1;
					_tmp18_ = s;
					_vala_array_add2 (&self->priv->user_view_indexes, &self->priv->user_view_indexes_length1, &self->priv->_user_view_indexes_size_, _tmp18_);
					_tmp19_ = s;
					s = _tmp19_ + 1;
				}
				_tmp20_ = s;
				s = _tmp20_ + 1;
			}
		}
	}
	while (TRUE) {
		gint _tmp21_;
		guint _tmp22_;
		gint* _tmp23_;
		gint _tmp23__length1;
		gint _tmp24_;
		gint _tmp25_;
		_tmp21_ = s;
		_tmp22_ = self->page_count;
		if (!(((guint) _tmp21_) < _tmp22_)) {
			break;
		}
		_tmp23_ = self->priv->user_view_indexes;
		_tmp23__length1 = self->priv->user_view_indexes_length1;
		_tmp24_ = s;
		_vala_array_add3 (&self->priv->user_view_indexes, &self->priv->user_view_indexes_length1, &self->priv->_user_view_indexes_size_, _tmp24_);
		_tmp25_ = s;
		s = _tmp25_ + 1;
	}
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
}


/**
         * Fill the path information starting from the user provided filename
         */
static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void pdfpc_metadata_pdf_fill_path_info (pdfpcMetadataPdf* self, const gchar* fname) {
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint l;
	const gchar* _tmp3_;
	GFile* _tmp4_ = NULL;
	GFile* file;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fname != NULL);
	_tmp0_ = fname;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	l = _tmp2_;
	_tmp3_ = fname;
	_tmp4_ = g_file_new_for_commandline_arg (_tmp3_);
	file = _tmp4_;
	_tmp6_ = fname;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ < 6) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		_tmp9_ = fname;
		_tmp10_ = l;
		_tmp11_ = l;
		_tmp12_ = string_slice (_tmp9_, (glong) (_tmp10_ - 6), (glong) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp5_ = g_strcmp0 (_tmp13_, ".pdfpc") != 0;
		_g_free0 (_tmp13_);
	}
	_tmp14_ = _tmp5_;
	if (_tmp14_) {
		GFile* _tmp15_;
		gchar* _tmp16_ = NULL;
		GFile* _tmp17_;
		gchar* _tmp18_ = NULL;
		GFile* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* pdf_basefname;
		const gchar* _tmp21_;
		gint _tmp22_ = 0;
		gint extension_index;
		const gchar* _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* pdfpc_basefname;
		GFile* _tmp29_;
		GFile* _tmp30_ = NULL;
		GFile* _tmp31_;
		const gchar* _tmp32_;
		GFile* _tmp33_ = NULL;
		GFile* _tmp34_;
		GFile* pdfpc_file;
		GFile* _tmp35_;
		gchar* _tmp36_ = NULL;
		_tmp15_ = file;
		_tmp16_ = g_file_get_basename (_tmp15_);
		_g_free0 (self->pdf_fname);
		self->pdf_fname = _tmp16_;
		_tmp17_ = file;
		_tmp18_ = g_file_get_uri (_tmp17_);
		_g_free0 (self->pdf_url);
		self->pdf_url = _tmp18_;
		_tmp19_ = file;
		_tmp20_ = g_file_get_basename (_tmp19_);
		pdf_basefname = _tmp20_;
		_tmp21_ = pdf_basefname;
		_tmp22_ = string_last_index_of (_tmp21_, ".", 0);
		extension_index = _tmp22_;
		_tmp23_ = pdf_basefname;
		_tmp24_ = extension_index;
		_tmp25_ = string_slice (_tmp23_, (glong) 0, (glong) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat (_tmp26_, ".pdfpc", NULL);
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp26_);
		pdfpc_basefname = _tmp28_;
		_tmp29_ = file;
		_tmp30_ = g_file_get_parent (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = pdfpc_basefname;
		_tmp33_ = g_file_get_child (_tmp31_, _tmp32_);
		_tmp34_ = _tmp33_;
		_g_object_unref0 (_tmp31_);
		pdfpc_file = _tmp34_;
		_tmp35_ = pdfpc_file;
		_tmp36_ = g_file_get_uri (_tmp35_);
		_g_free0 (self->pdfpc_url);
		self->pdfpc_url = _tmp36_;
		_g_object_unref0 (pdfpc_file);
		_g_free0 (pdfpc_basefname);
		_g_free0 (pdf_basefname);
	} else {
		GFile* _tmp37_;
		gchar* _tmp38_ = NULL;
		_tmp37_ = file;
		_tmp38_ = g_file_get_uri (_tmp37_);
		_g_free0 (self->pdfpc_url);
		self->pdfpc_url = _tmp38_;
	}
	_g_object_unref0 (file);
}


/**
         * Save the metadata to disk, if needed (i.e. if the user did something
         * with the notes or the skips)
         */
void pdfpc_metadata_pdf_save_to_disk (pdfpcMetadataPdf* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* contents;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = pdfpc_metadata_pdf_format_duration (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = pdfpc_metadata_pdf_format_skips (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = pdfpc_metadata_pdf_format_end_user_slide (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = pdfpc_metadata_pdf_format_notes (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	contents = _tmp13_;
	{
		const gchar* _tmp14_;
		_tmp14_ = contents;
		if (g_strcmp0 (_tmp14_, "") != 0) {
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			const gchar* _tmp22_;
			GFile* _tmp23_ = NULL;
			GFile* pdfpc_file;
			GFile* _tmp24_;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			_tmp15_ = self->pdf_fname;
			_tmp16_ = g_strconcat ("[file]\n", _tmp15_, NULL);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strconcat (_tmp17_, "\n", NULL);
			_tmp19_ = _tmp18_;
			_tmp20_ = contents;
			_tmp21_ = g_strconcat (_tmp19_, _tmp20_, NULL);
			_g_free0 (contents);
			contents = _tmp21_;
			_g_free0 (_tmp19_);
			_g_free0 (_tmp17_);
			_tmp22_ = self->pdfpc_url;
			_tmp23_ = g_file_new_for_uri (_tmp22_);
			pdfpc_file = _tmp23_;
			_tmp24_ = pdfpc_file;
			_tmp25_ = g_file_get_path (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = contents;
			_tmp28_ = contents;
			_tmp29_ = strlen (_tmp28_);
			_tmp30_ = _tmp29_;
			g_file_set_contents (_tmp26_, _tmp27_, (gssize) (_tmp30_ - 1), &_inner_error_);
			_g_free0 (_tmp26_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (pdfpc_file);
				goto __catch14_g_error;
			}
			_g_object_unref0 (pdfpc_file);
		} else {
			const gchar* _tmp31_;
			GFile* _tmp32_ = NULL;
			GFile* file;
			GFile* _tmp33_;
			gboolean _tmp34_ = FALSE;
			_tmp31_ = self->pdfpc_url;
			_tmp32_ = g_file_new_for_uri (_tmp31_);
			file = _tmp32_;
			_tmp33_ = file;
			_tmp34_ = g_file_query_exists (_tmp33_, NULL);
			if (_tmp34_) {
				GFile* _tmp35_;
				_tmp35_ = file;
				g_file_delete (_tmp35_, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (file);
					goto __catch14_g_error;
				}
			}
			_g_object_unref0 (file);
		}
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp36_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp36_ = e->message;
		g_error ("pdf.vala:212: %s", _tmp36_);
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (contents);
}


/**
         * Format the skip information for saving to disk
         */
gchar* pdfpc_metadata_pdf_format_skips (pdfpcMetadataPdf* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* contents;
	gboolean _tmp1_ = FALSE;
	gint* _tmp2_;
	gint _tmp2__length1;
	guint _tmp3_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	contents = _tmp0_;
	_tmp2_ = self->priv->user_view_indexes;
	_tmp2__length1 = self->priv->user_view_indexes_length1;
	_tmp3_ = self->page_count;
	if (((guint) _tmp2__length1) < _tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = self->skips_by_user;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gint user_slide;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp6_ = contents;
		_tmp7_ = g_strconcat (_tmp6_, "[skip]\n", NULL);
		_g_free0 (contents);
		contents = _tmp7_;
		user_slide = 0;
		{
			gint slide;
			slide = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					gboolean _tmp9_;
					gint _tmp11_;
					guint _tmp12_;
					gint _tmp13_;
					gint* _tmp14_;
					gint _tmp14__length1;
					gint _tmp15_;
					gint _tmp16_;
					_tmp9_ = _tmp8_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = slide;
						slide = _tmp10_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp11_ = slide;
					_tmp12_ = self->page_count;
					if (!(((guint) _tmp11_) < _tmp12_)) {
						break;
					}
					_tmp13_ = slide;
					_tmp14_ = self->priv->user_view_indexes;
					_tmp14__length1 = self->priv->user_view_indexes_length1;
					_tmp15_ = user_slide;
					_tmp16_ = _tmp14_[_tmp15_];
					if (_tmp13_ != _tmp16_) {
						const gchar* _tmp17_;
						gint _tmp18_;
						gchar* _tmp19_ = NULL;
						gchar* _tmp20_;
						gchar* _tmp21_;
						_tmp17_ = contents;
						_tmp18_ = slide;
						_tmp19_ = g_strdup_printf ("%d,", _tmp18_ + 1);
						_tmp20_ = _tmp19_;
						_tmp21_ = g_strconcat (_tmp17_, _tmp20_, NULL);
						_g_free0 (contents);
						contents = _tmp21_;
						_g_free0 (_tmp20_);
					} else {
						gint _tmp22_;
						_tmp22_ = user_slide;
						user_slide = _tmp22_ + 1;
					}
				}
			}
		}
		_tmp23_ = contents;
		_tmp24_ = g_strconcat (_tmp23_, "\n", NULL);
		_g_free0 (contents);
		contents = _tmp24_;
	}
	result = contents;
	return result;
}


gchar* pdfpc_metadata_pdf_format_end_user_slide (pdfpcMetadataPdf* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* contents;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	contents = _tmp0_;
	_tmp1_ = self->priv->end_user_slide;
	if (_tmp1_ >= 0) {
		const gchar* _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = contents;
		_tmp3_ = self->priv->end_user_slide;
		_tmp4_ = g_strdup_printf ("[end_user_slide]\n%d\n", _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp2_, _tmp5_, NULL);
		_g_free0 (contents);
		contents = _tmp6_;
		_g_free0 (_tmp5_);
	}
	result = contents;
	return result;
}


/**
         * Format the notes for saving to disk
         */
gchar* pdfpc_metadata_pdf_format_notes (pdfpcMetadataPdf* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* contents;
	pdfpcslides_notes* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	contents = _tmp0_;
	_tmp1_ = self->notes;
	_tmp2_ = pdfpc_slides_notes_has_notes (_tmp1_);
	if (_tmp2_) {
		const gchar* _tmp3_;
		pdfpcslides_notes* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp3_ = contents;
		_tmp4_ = self->notes;
		_tmp5_ = pdfpc_slides_notes_format_to_save (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat ("[notes]\n", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp3_, _tmp8_, NULL);
		_g_free0 (contents);
		contents = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
	}
	result = contents;
	return result;
}


gchar* pdfpc_metadata_pdf_format_duration (pdfpcMetadataPdf* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* contents;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	contents = _tmp0_;
	_tmp1_ = self->duration;
	if (_tmp1_ > ((guint) 0)) {
		const gchar* _tmp2_;
		guint _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = contents;
		_tmp3_ = self->duration;
		_tmp4_ = g_strdup_printf ("[duration]\n%u\n", _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp2_, _tmp5_, NULL);
		_g_free0 (contents);
		contents = _tmp6_;
		_g_free0 (_tmp5_);
	}
	result = contents;
	return result;
}


/**
         * Base constructor taking the file url to the pdf file
         */
static void _vala_array_add4 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


pdfpcMetadataPdf* pdfpc_metadata_pdf_construct (GType object_type, const gchar* fname) {
	pdfpcMetadataPdf * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	pdfpcslides_notes* _tmp2_;
	gchar* skip_line;
	const gchar* _tmp3_;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	const gchar* _tmp9_;
	PopplerDocument* _tmp10_ = NULL;
	GMutex* _tmp11_;
	PopplerDocument* _tmp12_;
	gint _tmp13_ = 0;
	PopplerDocument* _tmp14_;
	PopplerPage* _tmp15_ = NULL;
	PopplerPage* _tmp16_;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	gboolean _tmp19_;
	GMutex* _tmp40_;
	g_return_val_if_fail (fname != NULL, NULL);
	_tmp0_ = fname;
	self = (pdfpcMetadataPdf*) pdfpc_metadata_base_construct (object_type, _tmp0_);
	_tmp1_ = fname;
	pdfpc_metadata_pdf_fill_path_info (self, _tmp1_);
	_tmp2_ = pdfpc_slides_notes_new ();
	_g_object_unref0 (self->notes);
	self->notes = _tmp2_;
	self->skips_by_user = FALSE;
	skip_line = NULL;
	_tmp3_ = self->pdfpc_url;
	_tmp4_ = g_file_new_for_uri (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_query_exists (_tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		pdfpc_metadata_pdf_parse_pdfpc_file (self, &_tmp8_);
		_g_free0 (skip_line);
		skip_line = _tmp8_;
	}
	_tmp9_ = self->pdf_url;
	_tmp10_ = pdfpc_metadata_pdf_open_pdf_document (self, _tmp9_);
	_g_object_unref0 (self->document);
	self->document = _tmp10_;
	_tmp11_ = pdfpc_mutex_locks_poppler;
	g_mutex_lock (_tmp11_);
	_tmp12_ = self->document;
	_tmp13_ = poppler_document_get_n_pages (_tmp12_);
	self->page_count = (guint) _tmp13_;
	_tmp14_ = self->document;
	_tmp15_ = poppler_document_get_page (_tmp14_, 0);
	_tmp16_ = _tmp15_;
	poppler_page_get_size (_tmp16_, &_tmp17_, &_tmp18_);
	self->page_width = _tmp17_;
	self->page_height = _tmp18_;
	_g_object_unref0 (_tmp16_);
	_tmp19_ = self->skips_by_user;
	if (!_tmp19_) {
		gchar* previous_label;
		gint user_pages;
		previous_label = NULL;
		user_pages = 0;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp20_;
				_tmp20_ = TRUE;
				while (TRUE) {
					gboolean _tmp21_;
					gint _tmp23_;
					guint _tmp24_;
					PopplerDocument* _tmp25_;
					gint _tmp26_;
					PopplerPage* _tmp27_ = NULL;
					PopplerPage* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* this_label;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					_tmp21_ = _tmp20_;
					if (!_tmp21_) {
						gint _tmp22_;
						_tmp22_ = i;
						i = _tmp22_ + 1;
					}
					_tmp20_ = FALSE;
					_tmp23_ = i;
					_tmp24_ = self->page_count;
					if (!(((guint) _tmp23_) < _tmp24_)) {
						break;
					}
					_tmp25_ = self->document;
					_tmp26_ = i;
					_tmp27_ = poppler_document_get_page (_tmp25_, _tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = poppler_page_get_label (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = _tmp30_;
					_g_object_unref0 (_tmp28_);
					this_label = _tmp31_;
					_tmp32_ = this_label;
					_tmp33_ = previous_label;
					if (g_strcmp0 (_tmp32_, _tmp33_) != 0) {
						gint* _tmp34_;
						gint _tmp34__length1;
						gint _tmp35_;
						const gchar* _tmp36_;
						gchar* _tmp37_;
						gint _tmp38_;
						_tmp34_ = self->priv->user_view_indexes;
						_tmp34__length1 = self->priv->user_view_indexes_length1;
						_tmp35_ = i;
						_vala_array_add4 (&self->priv->user_view_indexes, &self->priv->user_view_indexes_length1, &self->priv->_user_view_indexes_size_, _tmp35_);
						_tmp36_ = this_label;
						_tmp37_ = g_strdup (_tmp36_);
						_g_free0 (previous_label);
						previous_label = _tmp37_;
						_tmp38_ = user_pages;
						user_pages = _tmp38_ + 1;
					}
					_g_free0 (this_label);
				}
			}
		}
		_g_free0 (previous_label);
	} else {
		const gchar* _tmp39_;
		_tmp39_ = skip_line;
		pdfpc_metadata_pdf_parse_skip_line (self, _tmp39_);
	}
	_tmp40_ = pdfpc_mutex_locks_poppler;
	g_mutex_unlock (_tmp40_);
	_g_free0 (skip_line);
	return self;
}


pdfpcMetadataPdf* pdfpc_metadata_pdf_new (const gchar* fname) {
	return pdfpc_metadata_pdf_construct (PDFPC_METADATA_TYPE_PDF, fname);
}


/**
         * Return the number of pages in the pdf document
         */
static guint pdfpc_metadata_pdf_real_get_slide_count (pdfpcMetadataBase* base) {
	pdfpcMetadataPdf * self;
	guint result = 0U;
	guint _tmp0_;
	self = (pdfpcMetadataPdf*) base;
	_tmp0_ = self->page_count;
	result = _tmp0_;
	return result;
}


/**
         * Return the number of user slides
         */
gint pdfpc_metadata_pdf_get_user_slide_count (pdfpcMetadataPdf* self) {
	gint result = 0;
	gint* _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->user_view_indexes;
	_tmp0__length1 = self->priv->user_view_indexes_length1;
	result = _tmp0__length1;
	return result;
}


/**
         * Return the last slide defined by the user. It may be different as
         * get_user_slide_count()!
         */
gint pdfpc_metadata_pdf_get_end_user_slide (pdfpcMetadataPdf* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->end_user_slide;
	if (_tmp0_ >= 0) {
		gint _tmp1_;
		_tmp1_ = self->priv->end_user_slide;
		result = _tmp1_;
		return result;
	} else {
		gint _tmp2_ = 0;
		_tmp2_ = pdfpc_metadata_pdf_get_user_slide_count (self);
		result = _tmp2_;
		return result;
	}
}


/**
         * Set the last slide defined by the user
         */
void pdfpc_metadata_pdf_set_end_user_slide (pdfpcMetadataPdf* self, gint slide) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = slide;
	self->priv->end_user_slide = _tmp0_;
}


/**
         * Toggle the skip flag for one slide
         *
         * We require to be provided also with the user_slide_number, as this
         * info should be available and so we do not need to perform a search.
         *
         * Returns the offset to move the current user_slide_number
         */
static gint* _vala_array_dup3 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


static gint* _vala_array_dup4 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


gint pdfpc_metadata_pdf_toggle_skip (pdfpcMetadataPdf* self, gint slide_number, gint user_slide_number) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
	gint converted_user_slide;
	gint offset = 0;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint l;
	gint _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = slide_number;
	if (_tmp0_ == 0) {
		result = 0;
		return result;
	}
	self->skips_by_user = TRUE;
	_tmp1_ = user_slide_number;
	_tmp2_ = pdfpc_metadata_pdf_user_slide_to_real_slide (self, _tmp1_);
	converted_user_slide = _tmp2_;
	_tmp3_ = self->priv->user_view_indexes;
	_tmp3__length1 = self->priv->user_view_indexes_length1;
	l = _tmp3__length1;
	_tmp4_ = converted_user_slide;
	_tmp5_ = slide_number;
	if (_tmp4_ == _tmp5_) {
		gint _tmp6_;
		gint* _tmp7_ = NULL;
		gint* new_indexes;
		gint new_indexes_length1;
		gint _new_indexes_size_;
		gint* _tmp31_;
		gint _tmp31__length1;
		gint* _tmp32_;
		gint _tmp32__length1;
		gboolean _tmp33_ = FALSE;
		gint _tmp34_;
		gboolean _tmp37_;
		_tmp6_ = l;
		_tmp7_ = g_new0 (gint, _tmp6_ - 1);
		new_indexes = _tmp7_;
		new_indexes_length1 = _tmp6_ - 1;
		_new_indexes_size_ = new_indexes_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					gboolean _tmp9_;
					gint _tmp11_;
					gint _tmp12_;
					gint* _tmp13_;
					gint _tmp13__length1;
					gint _tmp14_;
					gint* _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp9_ = _tmp8_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp11_ = i;
					_tmp12_ = user_slide_number;
					if (!(_tmp11_ < _tmp12_)) {
						break;
					}
					_tmp13_ = new_indexes;
					_tmp13__length1 = new_indexes_length1;
					_tmp14_ = i;
					_tmp15_ = self->priv->user_view_indexes;
					_tmp15__length1 = self->priv->user_view_indexes_length1;
					_tmp16_ = i;
					_tmp17_ = _tmp15_[_tmp16_];
					_tmp13_[_tmp14_] = _tmp17_;
					_tmp18_ = _tmp13_[_tmp14_];
				}
			}
		}
		{
			gint _tmp19_;
			gint i;
			_tmp19_ = user_slide_number;
			i = _tmp19_ + 1;
			{
				gboolean _tmp20_;
				_tmp20_ = TRUE;
				while (TRUE) {
					gboolean _tmp21_;
					gint _tmp23_;
					gint _tmp24_;
					gint* _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					gint* _tmp27_;
					gint _tmp27__length1;
					gint _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					_tmp21_ = _tmp20_;
					if (!_tmp21_) {
						gint _tmp22_;
						_tmp22_ = i;
						i = _tmp22_ + 1;
					}
					_tmp20_ = FALSE;
					_tmp23_ = i;
					_tmp24_ = l;
					if (!(_tmp23_ < _tmp24_)) {
						break;
					}
					_tmp25_ = new_indexes;
					_tmp25__length1 = new_indexes_length1;
					_tmp26_ = i;
					_tmp27_ = self->priv->user_view_indexes;
					_tmp27__length1 = self->priv->user_view_indexes_length1;
					_tmp28_ = i;
					_tmp29_ = _tmp27_[_tmp28_];
					_tmp25_[_tmp26_ - 1] = _tmp29_;
					_tmp30_ = _tmp25_[_tmp26_ - 1];
				}
			}
		}
		_tmp31_ = new_indexes;
		_tmp31__length1 = new_indexes_length1;
		_tmp32_ = (_tmp31_ != NULL) ? _vala_array_dup3 (_tmp31_, _tmp31__length1) : ((gpointer) _tmp31_);
		_tmp32__length1 = _tmp31__length1;
		self->priv->user_view_indexes = (g_free (self->priv->user_view_indexes), NULL);
		self->priv->user_view_indexes = _tmp32_;
		self->priv->user_view_indexes_length1 = _tmp32__length1;
		self->priv->_user_view_indexes_size_ = self->priv->user_view_indexes_length1;
		_tmp34_ = self->priv->end_user_slide;
		if (_tmp34_ >= 0) {
			gint _tmp35_;
			gint _tmp36_;
			_tmp35_ = user_slide_number;
			_tmp36_ = self->priv->end_user_slide;
			_tmp33_ = _tmp35_ < _tmp36_;
		} else {
			_tmp33_ = FALSE;
		}
		_tmp37_ = _tmp33_;
		if (_tmp37_) {
			gint _tmp38_;
			_tmp38_ = self->priv->end_user_slide;
			self->priv->end_user_slide = _tmp38_ - 1;
		}
		offset = -1;
		new_indexes = (g_free (new_indexes), NULL);
	} else {
		gint _tmp39_;
		gint* _tmp40_ = NULL;
		gint* new_indexes;
		gint new_indexes_length1;
		gint _new_indexes_size_;
		gint* _tmp52_;
		gint _tmp52__length1;
		gint _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint* _tmp68_;
		gint _tmp68__length1;
		gint* _tmp69_;
		gint _tmp69__length1;
		gboolean _tmp70_ = FALSE;
		gint _tmp71_;
		gboolean _tmp74_;
		_tmp39_ = l;
		_tmp40_ = g_new0 (gint, _tmp39_ + 1);
		new_indexes = _tmp40_;
		new_indexes_length1 = _tmp39_ + 1;
		_new_indexes_size_ = new_indexes_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp41_;
				_tmp41_ = TRUE;
				while (TRUE) {
					gboolean _tmp42_;
					gint _tmp44_;
					gint _tmp45_;
					gint* _tmp46_;
					gint _tmp46__length1;
					gint _tmp47_;
					gint* _tmp48_;
					gint _tmp48__length1;
					gint _tmp49_;
					gint _tmp50_;
					gint _tmp51_;
					_tmp42_ = _tmp41_;
					if (!_tmp42_) {
						gint _tmp43_;
						_tmp43_ = i;
						i = _tmp43_ + 1;
					}
					_tmp41_ = FALSE;
					_tmp44_ = i;
					_tmp45_ = user_slide_number;
					if (!(_tmp44_ <= _tmp45_)) {
						break;
					}
					_tmp46_ = new_indexes;
					_tmp46__length1 = new_indexes_length1;
					_tmp47_ = i;
					_tmp48_ = self->priv->user_view_indexes;
					_tmp48__length1 = self->priv->user_view_indexes_length1;
					_tmp49_ = i;
					_tmp50_ = _tmp48_[_tmp49_];
					_tmp46_[_tmp47_] = _tmp50_;
					_tmp51_ = _tmp46_[_tmp47_];
				}
			}
		}
		_tmp52_ = new_indexes;
		_tmp52__length1 = new_indexes_length1;
		_tmp53_ = user_slide_number;
		_tmp54_ = slide_number;
		_tmp52_[_tmp53_ + 1] = _tmp54_;
		_tmp55_ = _tmp52_[_tmp53_ + 1];
		{
			gint _tmp56_;
			gint i;
			_tmp56_ = user_slide_number;
			i = _tmp56_ + 1;
			{
				gboolean _tmp57_;
				_tmp57_ = TRUE;
				while (TRUE) {
					gboolean _tmp58_;
					gint _tmp60_;
					gint _tmp61_;
					gint* _tmp62_;
					gint _tmp62__length1;
					gint _tmp63_;
					gint* _tmp64_;
					gint _tmp64__length1;
					gint _tmp65_;
					gint _tmp66_;
					gint _tmp67_;
					_tmp58_ = _tmp57_;
					if (!_tmp58_) {
						gint _tmp59_;
						_tmp59_ = i;
						i = _tmp59_ + 1;
					}
					_tmp57_ = FALSE;
					_tmp60_ = i;
					_tmp61_ = l;
					if (!(_tmp60_ < _tmp61_)) {
						break;
					}
					_tmp62_ = new_indexes;
					_tmp62__length1 = new_indexes_length1;
					_tmp63_ = i;
					_tmp64_ = self->priv->user_view_indexes;
					_tmp64__length1 = self->priv->user_view_indexes_length1;
					_tmp65_ = i;
					_tmp66_ = _tmp64_[_tmp65_];
					_tmp62_[_tmp63_ + 1] = _tmp66_;
					_tmp67_ = _tmp62_[_tmp63_ + 1];
				}
			}
		}
		_tmp68_ = new_indexes;
		_tmp68__length1 = new_indexes_length1;
		_tmp69_ = (_tmp68_ != NULL) ? _vala_array_dup4 (_tmp68_, _tmp68__length1) : ((gpointer) _tmp68_);
		_tmp69__length1 = _tmp68__length1;
		self->priv->user_view_indexes = (g_free (self->priv->user_view_indexes), NULL);
		self->priv->user_view_indexes = _tmp69_;
		self->priv->user_view_indexes_length1 = _tmp69__length1;
		self->priv->_user_view_indexes_size_ = self->priv->user_view_indexes_length1;
		_tmp71_ = self->priv->end_user_slide;
		if (_tmp71_ >= 0) {
			gint _tmp72_;
			gint _tmp73_;
			_tmp72_ = user_slide_number;
			_tmp73_ = self->priv->end_user_slide;
			_tmp70_ = _tmp72_ < _tmp73_;
		} else {
			_tmp70_ = FALSE;
		}
		_tmp74_ = _tmp70_;
		if (_tmp74_) {
			gint _tmp75_;
			_tmp75_ = self->priv->end_user_slide;
			self->priv->end_user_slide = _tmp75_ + 1;
		}
		offset = +1;
		new_indexes = (g_free (new_indexes), NULL);
	}
	result = offset;
	return result;
}


/**
         * Transform from user slide numbers to real slide numbers
         */
gint pdfpc_metadata_pdf_user_slide_to_real_slide (pdfpcMetadataPdf* self, gint number) {
	gint result = 0;
	gint _tmp0_;
	gint* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = number;
	_tmp1_ = self->priv->user_view_indexes;
	_tmp1__length1 = self->priv->user_view_indexes_length1;
	if (_tmp0_ < _tmp1__length1) {
		gint* _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->user_view_indexes;
		_tmp2__length1 = self->priv->user_view_indexes_length1;
		_tmp3_ = number;
		_tmp4_ = _tmp2_[_tmp3_];
		result = _tmp4_;
		return result;
	} else {
		guint _tmp5_;
		_tmp5_ = self->page_count;
		result = (gint) _tmp5_;
		return result;
	}
}


gint pdfpc_metadata_pdf_real_slide_to_user_slide (pdfpcMetadataPdf* self, gint number) {
	gint result = 0;
	gint user_slide;
	g_return_val_if_fail (self != NULL, 0);
	user_slide = 0;
	{
		gint u;
		u = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_ = 0;
				gint _tmp5_;
				gint _tmp6_ = 0;
				gint real_slide;
				gint _tmp7_;
				gint _tmp8_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = u;
					u = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = u;
				_tmp4_ = pdfpc_metadata_pdf_get_user_slide_count (self);
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp5_ = u;
				_tmp6_ = pdfpc_metadata_pdf_user_slide_to_real_slide (self, _tmp5_);
				real_slide = _tmp6_;
				_tmp7_ = number;
				_tmp8_ = real_slide;
				if (_tmp7_ == _tmp8_) {
					gint _tmp9_;
					_tmp9_ = u;
					user_slide = _tmp9_;
					break;
				} else {
					gint _tmp10_;
					gint _tmp11_;
					_tmp10_ = number;
					_tmp11_ = real_slide;
					if (_tmp10_ < _tmp11_) {
						gint _tmp12_;
						_tmp12_ = u;
						user_slide = _tmp12_ - 1;
						break;
					}
				}
			}
		}
	}
	result = user_slide;
	return result;
}


/**
         * Return the width of the first page of the loaded pdf document.
         *
         * In presentations all pages will have the same size in most cases,
         * therefore this value is assumed to be useful.
         */
gdouble pdfpc_metadata_pdf_get_page_width (pdfpcMetadataPdf* self) {
	gdouble result = 0.0;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->page_width;
	result = _tmp0_;
	return result;
}


/**
         * Return the height of the first page of the loaded pdf document.
         *
         * In presentations all pages will have the same size in most cases,
         * therefore this value is assumed to be useful.
         */
gdouble pdfpc_metadata_pdf_get_page_height (pdfpcMetadataPdf* self) {
	gdouble result = 0.0;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->page_height;
	result = _tmp0_;
	return result;
}


/**
         * Return the Poppler.Document associated with this file
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


PopplerDocument* pdfpc_metadata_pdf_get_document (pdfpcMetadataPdf* self) {
	PopplerDocument* result = NULL;
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->document;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
         * Return the notes for the presentation
         */
pdfpcslides_notes* pdfpc_metadata_pdf_get_notes (pdfpcMetadataPdf* self) {
	pdfpcslides_notes* result = NULL;
	pdfpcslides_notes* _tmp0_;
	pdfpcslides_notes* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->notes;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
         * Get the duration of the presentation
         */
guint pdfpc_metadata_pdf_get_duration (pdfpcMetadataPdf* self) {
	guint result = 0U;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->duration;
	result = _tmp0_;
	return result;
}


/**
         * Get the duration of the presentation
         */
void pdfpc_metadata_pdf_set_duration (pdfpcMetadataPdf* self, guint d) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = d;
	self->duration = _tmp0_;
}


/**
         * Open a given pdf document url and return a Poppler.Document for it.
         */
PopplerDocument* pdfpc_metadata_pdf_open_pdf_document (pdfpcMetadataPdf* self, const gchar* url) {
	PopplerDocument* result = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	PopplerDocument* document;
	GMutex* _tmp2_;
	GMutex* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (url != NULL, NULL);
	_tmp0_ = url;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	file = _tmp1_;
	document = NULL;
	_tmp2_ = pdfpc_mutex_locks_poppler;
	g_mutex_lock (_tmp2_);
	{
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		PopplerDocument* _tmp5_;
		PopplerDocument* _tmp6_;
		PopplerDocument* _tmp7_;
		_tmp3_ = g_file_get_uri (file);
		_tmp4_ = _tmp3_;
		_tmp5_ = poppler_document_new_from_file (_tmp4_, NULL, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		_g_object_unref0 (document);
		document = _tmp7_;
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e->message;
		g_error ("pdf.vala:462: Unable to open pdf file: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (document);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = pdfpc_mutex_locks_poppler;
	g_mutex_unlock (_tmp9_);
	result = document;
	_g_object_unref0 (file);
	return result;
}


static void pdfpc_metadata_pdf_class_init (pdfpcMetadataPdfClass * klass) {
	pdfpc_metadata_pdf_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (pdfpcMetadataPdfPrivate));
	PDFPC_METADATA_BASE_CLASS (klass)->get_slide_count = pdfpc_metadata_pdf_real_get_slide_count;
	G_OBJECT_CLASS (klass)->finalize = pdfpc_metadata_pdf_finalize;
}


static void pdfpc_metadata_pdf_instance_init (pdfpcMetadataPdf * self) {
	self->priv = PDFPC_METADATA_PDF_GET_PRIVATE (self);
	self->pdf_fname = NULL;
	self->pdf_url = NULL;
	self->pdfpc_url = NULL;
	self->priv->end_user_slide = -1;
}


static void pdfpc_metadata_pdf_finalize (GObject* obj) {
	pdfpcMetadataPdf * self;
	self = PDFPC_METADATA_PDF (obj);
	_g_free0 (self->pdf_fname);
	_g_free0 (self->pdf_url);
	_g_free0 (self->pdfpc_url);
	_g_object_unref0 (self->document);
	_g_object_unref0 (self->notes);
	self->priv->user_view_indexes = (g_free (self->priv->user_view_indexes), NULL);
	G_OBJECT_CLASS (pdfpc_metadata_pdf_parent_class)->finalize (obj);
}


/**
     * Metadata for Pdf files
     */
GType pdfpc_metadata_pdf_get_type (void) {
	static volatile gsize pdfpc_metadata_pdf_type_id__volatile = 0;
	if (g_once_init_enter (&pdfpc_metadata_pdf_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (pdfpcMetadataPdfClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdfpc_metadata_pdf_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (pdfpcMetadataPdf), 0, (GInstanceInitFunc) pdfpc_metadata_pdf_instance_init, NULL };
		GType pdfpc_metadata_pdf_type_id;
		pdfpc_metadata_pdf_type_id = g_type_register_static (PDFPC_METADATA_TYPE_BASE, "pdfpcMetadataPdf", &g_define_type_info, 0);
		g_once_init_leave (&pdfpc_metadata_pdf_type_id__volatile, pdfpc_metadata_pdf_type_id);
	}
	return pdfpc_metadata_pdf_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



