/* $Id: meshMovement.h,v 1.16 2000/10/17 13:49:33 knepley Exp $ */

/*
    Routines for working with moving meshes
*/

#ifndef __MESH_MOVEMENT_H
#define __MESH_MOVEMENT_H

#include "grid.h"

typedef struct _MeshMover *MeshMover;

#define MESH_MOVER_TRIANGULAR_2D  "tri2d"
typedef char *MeshMoverType;

typedef enum {MESH_LAPLACIAN, MESH_WEIGHTED_LAPLACIAN} MeshSolveMethod;

/* Mesh Movement Functions */
extern int MeshSetMover(Mesh, MeshMover);
extern int MeshGetMover(Mesh, MeshMover *);
extern int MeshMoveMesh(Mesh, double);
extern int MeshReform(Mesh, PetscTruth, PointFunction, PetscTruth, Mesh *);

/* Mesh Mover Functions */
  /* Generic Operations */
extern int MeshMoverCreate(Mesh, MeshMover *);
extern int MeshMoverSetup(MeshMover);
extern int MeshMoverSetFromOptions(MeshMover);
extern int MeshMoverPrintHelp(MeshMover);
extern int MeshMoverDuplicate(MeshMover, MeshMover *);
extern int MeshMoverConvert(MeshMover, Mesh, MeshMover *);
extern int MeshMoverView(MeshMover, PetscViewer);
extern int MeshMoverDestroy(MeshMover);
  /* MeshMover Specific Operations */
extern int MeshMoverCalcVelocityBCValues(MeshMover);
extern int MeshMoverCalcAccelerationBCValues(MeshMover);
extern int MeshMoverCalcNodeVelocities(MeshMover, PetscTruth);
extern int MeshMoverCalcNodeAccelerations(MeshMover, PetscTruth);
extern int MeshMoverSetNodeVelocities(MeshMover, PointFunction, PetscScalar, void *);
extern int MeshMoverSetNodeAccelerations(MeshMover, PointFunction, PetscScalar, void *);
extern int MeshMoverUpdateNodeValues(MeshMover, Vec, Vec, Vec);
  /* MeshMover Query Functions */
extern int MeshMoverSetMesh(MeshMover, Mesh);
extern int MeshMoverGetMesh(MeshMover, Mesh *);
extern int MeshMoverGetMovement(MeshMover, MeshSolveMethod *, MeshSolveMethod *, PetscObject *);
extern int MeshMoverSetMovement(MeshMover, MeshSolveMethod, MeshSolveMethod, PetscObject);
extern int MeshMoverGetVelocityGrid(MeshMover, Grid *);
extern int MeshMoverGetAccelerationGrid(MeshMover, Grid *);
extern int MeshMoverSetVelocityBC(MeshMover, int, PointFunction, PetscTruth);
extern int MeshMoverAddVelocityBC(MeshMover, int, PointFunction, PetscTruth);
extern int MeshMoverSetVelocityBCContext(MeshMover, void *);
extern int MeshMoverSetAccelerationBC(MeshMover, int, PointFunction, PetscTruth);
extern int MeshMoverAddAccelerationBC(MeshMover, int, PointFunction, PetscTruth);
extern int MeshMoverSetAccelerationBCContext(MeshMover, void *);
extern int MeshMoverSetMovementCaption(MeshMover, char *);

/* Dynamic creation and loading functions */
extern PetscFList MeshMoverList;
extern int MeshMoverRegisterAllCalled;
extern int MeshMoverSetType(MeshMover, MeshMoverType);
extern int MeshMoverGetType(MeshMover, MeshMoverType *);
extern int MeshMoverRegister(const char[],const char[],const char[],int(*)(MeshMover));
extern int MeshMoverRegisterAll(const char []);
extern int MeshMoverRegisterDestroy(void);
#if defined(PETSC_USE_DYNAMIC_LIBRARIES)
#define MeshMoverRegisterDynamic(a,b,c,d) MeshMoverRegister(a,b,c,0)
#else
#define MeshMoverRegisterDynamic(a,b,c,d) MeshMoverRegister(a,b,c,d)
#endif

#include "gvec.h"
/* Special Mesh Operations */
extern int MeshUpdateNodeValues(Mesh, GVec, Vec, Vec);

#endif /* __MESH_MOVEMENT_H */
