# -*- Python -*-

if __name__ == '__main__':
    import sys, petsc4py
    petsc4py.init(sys.argv)
    del sys, petsc4py
    

from petsc4py import PETSc
import numpy as array

COMM = PETSc.COMM_WORLD
SIZE = COMM.size
RANK = COMM.rank

opts = PETSc.Options()

USE_SCHUR = opts.getBool('schur',   False)
USE_MATIS = opts.getBool('matis',   False)
MONITOR   = opts.getBool('monitor', True)
VIEW   =   opts.getBool('view',    True)

if USE_SCHUR:
    if SIZE > 1:
        USE_MATIS = True
    opts['ksp_type'] = 'preonly'
    opts['pc_type']  = 'schur'
    opts['sub_ksp_type'] = 'fgmres'
    if MONITOR:
        opts['sub_ksp_monitor'] = None
    if VIEW:
        opts['pc_schur_print_stats'] = 1
else:
    opts['ksp_type'] = 'cg'
    if MONITOR:
        opts['ksp_monitor'] = None
    if USE_MATIS:
        opts['pc_type'] = 'jacobi'
    else:
        opts['pc_type'] = 'jacobi'

#M, N = (100,100)
#M, N = (50,50)
#M, N = (20,20)
#M, N = (10,10)
M, N = (7,7)
#M, N = (5,5)

hx = 1.0/(M-1)
hy = 1.0/(N-1)
ndof = M*N

A = PETSc.Mat()
A.create(comm=COMM)
A.setSizes(ndof)
if USE_MATIS:
    ldofs = array.arange(0,M*N)
    lgmap = PETSc.LGMapping(ldofs, comm=A.comm)
    A.setType(PETSc.Mat.Type.IS)
    A.setLGMapping(lgmap)
    A.setPreallocation(5)
else:
    A.setType(PETSc.Mat.Type.AIJ)
    A.setPreallocation([5, 1])

Istart,Iend = A.getOwnershipRange();

for I in xrange(Istart,Iend) :
    v = -1.0; i = I/N; j = I - i*N;
    if i>0   : J = I - N; A[I,J] = v
    if i<M-1 : J = I + N; A[I,J] = v
    if j>0   : J = I - 1; A[I,J] = v
    if j<M-1 : J = I + 1; A[I,J] = v
    v = 4.0;              A[I,I] = v
A.assemble()

#A.Scale(1/h)

x, b = A.getVecs()

x.set(0)

#f = lambda x,y : x*y;
f = lambda x,y : 1
for j in xrange(N):
    for i in xrange(M):
        b[i+j*N] = f(i*hx,j*hy)
del i,j
b.assemble();
#b.Scale(h)


#r,c = A.getOrdering('nd')
#A = A.permute(r,c)

ksp = PETSc.KSP().create(comm=COMM)
ksp.setOperators(A,A,PETSc.Mat.Structure.SAME)
ksp.setFromOptions()

try:
    ksp.solve(b,x)
except PETSc.Error:
    PETSc.Error.view()

if VIEW:
    ksp.view()

#draw = PETSc.ViewerDraw(title='Matrix');
info = PETSc.ViewerASCII(name='stdout',format='info');

grid = array.arange(M*N).reshape(M,N)

def sep(string):
    indices = [int(i) for i in string.split()]
    grid = array.zeros((M,N))
    grid.flat[indices] = 1
    return grid
