/** 
 * -- useful additional primitives for K12xx platforms
 *
 *  Copyright (C) Tektronix, Inc. 1998 - 2001. All rights reserved.
 *
 *  @see     GNU LGPL
 *  @author  Tektronix CTE              @(#) %derived_by: guidod %
 *  @version %version: 1.13 %
 *    (%date_modified: Mon Jul 23 18:14:05 2001 %)
 *
 *  @description
 *              This wordset adds some additional primitives that
 *		are useful in K12xx environments.
 */
/*@{*/
#if defined(__version_control__) && defined(__GNUC__)
static char* id __attribute__((unused)) = 
"@(#) $Id: %full_filespec:  host-k12.c~1.13:csrc:bln_12xx!1 % $";
#endif
 
#define _P4_SOURCE 1
#include <pfe/pfe-base.h>
#include <string.h>
#ifdef VxWorks
#include <fcntl.h>
#include <ioLib.h>
#endif
#include <pfe/term-k12.h>
#include <pfe/logging.h>

/* -------------------------------------------------------------------- */

#ifdef _K12_SOURCE
#include <pfe/main-k12.h>
#endif

/** BOOT-SCRIPT@ ( -- s-a s-n )
 * the file that will be include on next => COLD boot
 * DO NOT USE! will vanish w/o warning in the next version!
 */
FCode (p4_boot_script_fetch)
{
    if (PFE.set->include_file)
    {
        FX_PUSH (PFE.set->include_file);
        FX_PUSH (strlen (PFE.set->include_file));
    }else{
        FX_PUSH (0);
        FX_PUSH (0);
    }
}

/** BOOT-SCRIPT: ( "string" -- )
 * DO NOT USE! will vanish w/o warning in the next version!
 * see => BOOT-SCRIPT@
 */
FCode (p4_boot_script_colon)
{
    p4_word_parseword (' '); *DP=0; /* PARSE-WORD-NOHERE */
    
# ifdef _K12_SOURCE
    { 
        register p4_emu_t* p4 = P4_K12_EMUL(p4TH);

        strncpy (p4->includes, PFE.word.ptr, PFE.word.len);
        PFE.set->include_file = p4->includes;
    }
# else
    {
        p4_throw (P4_ON_OBSOLETED);
    }
#endif
}

/** OPEN-TERMINAL-LOGFILE ( s-buf s-len -- )
 * open terminal logfile named by the string-buffer
 * all further output to the terminal window is also logged into
 * this file. This is especially useful in embedded environments
 * where the terminal connection is often not used or it is
 * directed to a different location that does not easily allow to
 * redirect the forth output to a file for further examination.
 */
FCode (p4_open_terminal_logfile)
{
    char* filename = p4_pocket_filename ((p4char*) SP[1], (p4ucell) SP[0]);
    FX_2DROP;
    if (! filename || ! strlen (filename)) return;
# ifdef _K12_SOURCE
    {
        p4_emu_t* p4 = P4_K12_EMUL(p4TH);
        p4->private.tx_logfile = open (filename, O_WRONLY|O_CREAT, 0640);
        if (p4->private.tx_logfile == -1)
        {
            P4_warn1 ("could not open terminal logfile %s", filename);
            p4->private.tx_logfile = 0;
        }
    }
# endif    
}

/** CLOSE-TERMINAL-LOGFILE ( -- )
 * close terminal logfile opened with => OPEN-TERMINAL-LOGFILE
 */
FCode (p4_close_terminal_logfile)
{
#  ifdef _K12_SOURCE
    {
        p4_emu_t* p4 = P4_K12_EMUL(p4TH);
        if (p4->private.tx_logfile)
        {
            close (p4->private.tx_logfile);
            p4->private.tx_logfile = 0;
        }
    }
#  endif
}

FCode(p4_terminal_emulation_state)
{
    register k12_priv* k12p = P4_K12_PRIV(p4TH);
    FX_PUSH(&k12p->state);
}

P4_LISTWORDS (host_k12) =
{
    P4_INTO ("FORTH", 0),
    P4_FXco ("BOOT-SCRIPT:",   p4_boot_script_colon),
    P4_FXco ("BOOT-SCRIPT@",   p4_boot_script_fetch),
# ifdef _K12_SOURCE
    P4_OCoN ("#K1297-G20",     _K12_SOURCE+100),
# endif

    P4_INTO ("EXTENSIONS", "FORTH"),
    P4_FXco ("OPEN-TERMINAL-LOGFILE", p4_open_terminal_logfile),
    P4_FXco ("CLOSE-TERMINAL-LOGFILE", p4_close_terminal_logfile),
    P4_FXco ("TERMINAL-EMULATION-STATE", p4_terminal_emulation_state),
};
P4_COUNTWORDS (host_k12, "HOST-K12 extensions");

/*@}*/

/* 
 * Local variables:
 * c-file-style: "stroustrup"
 * End:
 */
