#ifndef IMAGESOURCE_UTIL_H
#define IMAGESOURCE_UTIL_H

#include "imagesource.h"

enum IS_ScalingQuality
{
	IS_SCALING_AUTOMATIC,
	IS_SCALING_NEARESTNEIGHBOUR,
	IS_SCALING_BILINEAR,
	IS_SCALING_LANCZOSSINC,
	IS_SCALING_MAX
};

struct IS_ScalingQualityDescription
{
	const char *Name;
	const char *Description;
};


ImageSource *ISLoadImage(const char *filename);
ImageSource *ISScaleImageByResolution(ImageSource *source,double xres,double yres,IS_ScalingQuality quality);
ImageSource *ISScaleImageBySize(ImageSource *source,int w,int h,IS_ScalingQuality quality);
const IS_ScalingQualityDescription *DescribeScalingQuality(IS_ScalingQuality quality);

#endif
