// FIXME - need a destructor to clean up the printer queue strings.

#include <iostream>

#include <string.h>

#include <gtk/gtkframe.h>
#include <gtk/gtksizegroup.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkcontainer.h>

#include "pp_printoutput.h"

using namespace std;

enum {
	CHANGED_SIGNAL,
	LAST_SIGNAL
};

static guint pp_printoutput_signals[LAST_SIGNAL] = { 0 };

static void pp_printoutput_class_init (pp_PrintOutputClass *klass);
static void pp_printoutput_init (pp_PrintOutput *stpuicombo);


static void printersel_changed(GtkWidget *wid,gpointer *ob)
{
	cerr << "In printersel_changed()" << endl;
	pp_PrintOutput *lo=(pp_PrintOutput *)ob;

	const char *driver=stpui_printerselector_get_driver(STPUI_PRINTERSELECTOR(wid));
	lo->po->SetString("Driver",driver);

	g_signal_emit(G_OBJECT (ob),pp_printoutput_signals[CHANGED_SIGNAL], 0);
}


static void command_changed(GtkWidget *wid,gpointer *ob)
{
	cerr << "In command_changed()" << endl;
	pp_PrintOutput *lo=(pp_PrintOutput *)ob;

	const char *command=gtk_entry_get_text(GTK_ENTRY(wid));
	lo->po->SetString("Command",command);
}


static void pp_printoutput_queue_changed(GtkEntry *entry,gpointer *ud)
{
	cerr << "In pp_printoutput_queue_changed()" << endl;

	pp_PrintOutput *ob=PP_PRINTOUTPUT(ud);
	PrintOutput *po=ob->po;

	const char *val=gtk_entry_get_text(entry);
	if(val && strlen(val))
	{
		po->SetString("Queue",val);
		char *driver=po->GetPrinterDriver(val);
		if(driver)
		{
			cerr << "Got driver: " << driver << " from Queue" << endl;
			po->SetString("Driver",driver);
			stpui_printerselector_set_driver(STPUI_PRINTERSELECTOR(ob->printersel),driver);
			free(driver);
		}
//		char *command=po->GetPrintCommand(val);
//		if(command)
//		{
//			po->SetString("Command",command);
//			gtk_entry_set_text(GTK_ENTRY(ob->string),command);
//			free(command);
//		}
		g_signal_emit(G_OBJECT (ob),pp_printoutput_signals[CHANGED_SIGNAL], 0);
	}
}



void pp_printoutput_refresh(pp_PrintOutput *ob)
{
	cerr << "In pp_printoutput_refresh()" << endl;
	PrintOutput *po=ob->po;

	char *driver=po->FindString("Driver");
	if(driver)
	{
		cerr << "Setting driver to " << driver << endl;
		stpui_printerselector_set_driver(STPUI_PRINTERSELECTOR(ob->printersel),driver);
	}
	char *command=po->FindString("Command");
	if(command)
	{
		gtk_entry_set_text(GTK_ENTRY(ob->string),command);
	}
}


GtkWidget*
pp_printoutput_new (PrintOutput *po)
{
	pp_PrintOutput *ob=PP_PRINTOUTPUT(g_object_new (pp_printoutput_get_type (), NULL));
	gtk_box_set_spacing(GTK_BOX(ob),5);

	ob->po=po;

	GtkWidget *label;

	GtkWidget *table=gtk_table_new(2,3,FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table),5);
	gtk_box_pack_start(GTK_BOX(ob),table,FALSE,FALSE,0);
	gtk_widget_show(table);

	label=gtk_label_new("Print Queue:");
	gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,0,1);
	gtk_widget_show(label);

	ob->combo=gtk_combo_new();
	gtk_combo_set_value_in_list(GTK_COMBO(ob->combo),TRUE,FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table),ob->combo,1,2,0,1);
	gtk_widget_show(ob->combo);

	int count,j;

	ob->queues=NULL;
	count=po->GetPrinterCount();
	
	for(j=0;j<count;++j)
	{
		char *queue=po->GetPrinterName(j);
		ob->queues=g_list_append(ob->queues,(void *)queue);
	}
	
	if(ob->queues)
	{
		gtk_combo_set_popdown_strings(GTK_COMBO(ob->combo),ob->queues);
		gtk_widget_set_sensitive(GTK_WIDGET(ob->combo),TRUE);
	}
	else
		gtk_widget_set_sensitive(GTK_WIDGET(ob->combo),FALSE);

	char *queue=po->FindString("Queue");
	if(queue && g_list_find_custom(ob->queues,queue,(GCompareFunc)strcmp))
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(ob->combo)->entry),queue);

	g_signal_connect(GTK_COMBO(ob->combo)->entry,"changed",G_CALLBACK(pp_printoutput_queue_changed),ob);


	label=gtk_label_new("Printer Model:");
	gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,1,2);
	gtk_widget_show(label);

	ob->printersel=stpui_printerselector_new();
	gtk_table_attach_defaults(GTK_TABLE(table),ob->printersel,1,2,1,2);
	g_signal_connect(G_OBJECT(ob->printersel),"changed",G_CALLBACK(printersel_changed),ob);

	stpui_printerselector_set_driver(STPUI_PRINTERSELECTOR(ob->printersel),po->FindString("Driver"));
	gtk_widget_show(ob->printersel);


	label=gtk_label_new("Print command:");
	gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,2,3);
	gtk_widget_show(label);

	ob->string=gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table),ob->string,1,2,2,3);
	gtk_widget_show(ob->string);
	gtk_entry_set_text(GTK_ENTRY(ob->string),po->FindString("Command"));
	g_signal_connect(G_OBJECT(ob->string),"changed",G_CALLBACK(command_changed),ob);
	
	return(GTK_WIDGET(ob));
}


GType
pp_printoutput_get_type (void)
{
	static GType stpuic_type = 0;

	if (!stpuic_type)
	{
		static const GTypeInfo pp_printoutput_info =
		{
			sizeof (pp_PrintOutputClass),
			NULL, /* base_init */
			NULL, /* base_finalize */
			(GClassInitFunc) pp_printoutput_class_init,
			NULL, /* class_finalize */
			NULL, /* class_data */
			sizeof (pp_PrintOutput),
			0,
			(GInstanceInitFunc) pp_printoutput_init,
		};
		stpuic_type = g_type_register_static (GTK_TYPE_VBOX, "pp_PrintOutput", &pp_printoutput_info, (GTypeFlags)0);
	}
	return stpuic_type;
}


static void
pp_printoutput_class_init (pp_PrintOutputClass *klass)
{
	pp_printoutput_signals[CHANGED_SIGNAL] =
	g_signal_new ("changed",
		G_TYPE_FROM_CLASS (klass),
		GSignalFlags(G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION),
		G_STRUCT_OFFSET (pp_PrintOutputClass, changed),
		NULL, NULL,
		g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void
pp_printoutput_init (pp_PrintOutput *ob)
{
	ob->po=NULL;
}
