#!/usr/bin/perl
#  make_binary_tree.pl
#    $Last modified: Wed Apr 19 03:25:44 2000$
#                   Copyright (c) 1999 kamop
#  $Id: make_binary_tree.pl,v 1.1 1999/12/06 09:50:15 kamop Exp $
# 

use strict;
use KDEB;

my($kdeb) = new KDEB;

## եɤ߹
my($conf_file) = $ARGV[0];
if(! -f $conf_file){
  die "No such input file $conf_file.";
}
my($fileconf_debug) = 0;
my($conf) = $kdeb->conf_read(file=>$conf_file,
                             debug=>$fileconf_debug);

## ǥХå٥
my($debug) = $conf->{'make_debimaru_tree_debug'};

## ϥե
my($input_file) = $ARGV[1];
if(! -f $input_file){
  $input_file = $conf->{'expand_file'};
  if(! -f $input_file){
    die "No such input file $input_file.";
  }
}

my($output_file) = $conf->{'script_bin'};

## ѥåեɤ߹
my($pacf) = $kdeb->PACF_new(conf=>$conf);
$kdeb->PACF_read_packages(PACF=>$pacf);

#my($packages) = &read_input_packages(PACF=>$pacf, input_file=>$input_file);
#&generate_debimaru_tree(packages=>$packages);
&generate_script(PACF=>$pacf,input_file=>$input_file, output_file=>$output_file);

exit;

#######################################################################
#######################################################################
#######################################################################
sub generate_script{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($input_file) = $ref{'input_file'};
  my($output_file) = $ref{'output_file'};
  my($pacf) = $ref{'PACF'};
##
  my($file, $base_dir, $dir, $arch_dir, $section, $debfile, $fh);
  my($arch);
  my($res, $info, $fhin, $fhout);
  my($check_dir) = {};
  my($to_dir, $from_dir, $real_to_dir, $real_from_dir);
  my($to_bin_dir, $real_to_bin_dir);
  my($size) = 0;
  my($tag_info);
##
  ($fhin, $res) = $kdeb->open_file(file=>$input_file);
  ($fhout, $res) = $kdeb->open_file(file=>"> $output_file");
##
  &output_header(fhout=>$fhout, PACF=>$pacf);
  while(<$fhin>){
    chomp;
    ($res, $file, $info) = $kdeb->PACF_get_info(PACF=>$pacf, name=>$_,
                                       info=>'Filename');
    $base_dir = $pacf->[$info]->{"base_dir"};
    $tag_info = $kdeb->PACN_info(name=>$_, info=>'Size');
    $size += $pacf->[$info]->{'PAC'}->{$tag_info};
    $file =~ /(.*)\/([^\/]+)\/([^\/]+)\/([^\/]+)$/;
    $dir = $1;
    $arch_dir = $2;
    $section = $3;
    $debfile = $4;
#    print $file."\n";
#    print "  ".$1." ".$2." ".$3." ".$4."\n";
## quick-hack
#    {
#      my($version) = $kdeb->PACF_get_info(PACF=>$pacf, name=>$_,
#                                          info=>'Version');
#      my($vera, $verb) = $kdeb->divide_version(ver=>$version);
#      $debfile = $_."_"."*.deb";
#    }
    ($res, $arch, $info) = $kdeb->PACF_get_info(PACF=>$pacf, name=>$_,
                                         info=>'Architecture');
    if($section eq "binary-i386"){
      ## slink
      #$from_dir = "$base_dir/dists/frozen/non-US/binary-$arch";
      #$to_dir = "$base_dir/dists/frozen/non-US/binary-$arch";
      ## woody
      $from_dir = "$base_dir/dists/woody/non-US/".$arch_dir."/binary-$arch";
      $to_dir = $from_dir;
      ## woody
      $from_dir = "$base_dir/dists/woody/non-US/".$arch_dir."/binary-$arch";
      $to_dir = $from_dir;
    }else{
      $dir =~ s/unstable/woody/g;
      $to_dir = $from_dir = $base_dir."/".$dir."/binary-".$arch."/".$section;
    }
    ##
    $real_to_dir = "\$\{TO_DIR\}/$to_dir";
    $real_from_dir = "\$\{FROM_DIR\}/$to_dir";
    ##
    if($file eq ""){
      die "Not found $_\n";
    }
#    print "  ".$base_dir."  ".$dir."  ".$arch."  ".$section."  ".$debfile."\n";
#    print "  ".$real_from_dir."/".$debfile."\n";
    if($check_dir->{$to_dir} eq ""){
      print $fhout "if [ ! -x $real_to_dir ]; then\n";
      print $fhout "  mkdir -p $real_to_dir\n";
      print $fhout "fi\n";
      $check_dir->{$to_dir} = "OK";
    }
    print $fhout "cp $real_from_dir/$debfile $real_to_dir/\n";
    if($arch eq "all"){
      if($section eq "binary-i386"){
        ## slink
#        $to_bin_dir = "$base_dir/dists/frozen/non-US/binary-i386";
        ## woody
        $to_bin_dir = "$base_dir/dists/woody/non-US/".$arch_dir."/binary-i386";
        ## woody
        $to_bin_dir = "$base_dir/dists/woody/non-US/".$arch_dir."/binary-i386";
      }else{
        $to_bin_dir = $base_dir."/".$dir."/binary-i386/".$section;
      }
      $real_to_bin_dir = "\$\{TO_DIR\}/$to_bin_dir";
      if($check_dir->{$to_bin_dir} eq ""){
        print $fhout "if [ ! -x $real_to_bin_dir ]; then\n";
        print $fhout "  mkdir -p $real_to_bin_dir\n";
        print $fhout "fi\n";
        $check_dir->{$to_bin_dir} = "OK";
      }
      if($section eq "binary-i386"){
        print $fhout "(cd $real_to_bin_dir && ln -s ../binary-all/$debfile . )\n";
      }else{
        print $fhout "(cd $real_to_bin_dir && ln -s ../../binary-all/$section/$debfile . )\n";
      }
    }
    print $fhout "\n";
  }
  &output_foot(fhout=>$fhout, PACF=>$pacf);
  print $fhout "\n# SIZE: ".$size."\n";
  $fhin->close();
  $fhout->close();
} ## generate_script()

sub output_header{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($fhout) = $ref{'fhout'};
  my($pacf) = $ref{'PACF'};
##
  print $fhout "#!/bin/sh\n";
  print $fhout "\n";
  print $fhout "FROM_DIR=".$conf->{"from_dir"}."\n";
  print $fhout "TO_DIR=".$conf->{"to_dir"}."\n";
  print $fhout "\n\n";

} ## output_header()

sub output_foot{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($fhout) = $ref{'fhout'};
  my($pacf) = $ref{'PACF'};
##
  print $fhout "function make_package () \{\n";
  print $fhout "  DIST_DIR=\$1\n";
  print $fhout "  OVERRIDE=\$2\n";
  print $fhout "  OFFSET=\$3\n";
  print $fhout "  if [ -x \$\{DIST_DIR\} ]; then\n";
  print $fhout "    (cd \$\{DIST_DIR\} && \n";
  print $fhout "      dpkg-scanpackages binary-i386 \$\{OVERRIDE\} \$\{OFFSET\}".
    " > \$\{DIST_DIR\}/binary-i386/Packages \n";
  print $fhout "    gzip -f \$\{DIST_DIR\}/binary-i386/Packages \n";
  print $fhout "    )\n";
  print $fhout "  else\n";
  print $fhout "    mkdir -p \$\{DIST_DIR\}/binary-i386\n";
  print $fhout "    touch \$\{DIST_DIR\}/binary-i386/Packages\n";
  print $fhout "  fi\n";
  print $fhout "\}\n\n";
  print $fhout "if [ \"x\$\{ONLYCOPY\}\" = \"x\" ]; then\n";
  print $fhout "  make_package \$\{TO_DIR\}/debian/dists/woody/main \\\n";
  print $fhout "       \$\{FROM_DIR\}/debian/indices/override.woody.gz \\\n";
  print $fhout "       dists/woody/main/ \n";
  print $fhout "  make_package \$\{TO_DIR\}/debian/dists/woody/contrib \\\n";
  print $fhout "       \$\{FROM_DIR\}/debian/indices/override.woody.contrib.gz \\\n";
  print $fhout "       dists/woody/contrib/ \n";
  print $fhout "  make_package \$\{TO_DIR\}/debian/dists/woody/non-free \\\n";
  print $fhout "       \$\{FROM_DIR\}/debian/indices/override.woody.non-free.gz \\\n";
  print $fhout "       dists/woody/non-free/ \n";
  print $fhout "  make_package \$\{TO_DIR\}/debian-jp/dists/woody-jp/main \\\n";
  print $fhout "       \$\{FROM_DIR\}/debian-jp/indices-jp/override.woody-jp \\\n";
  print $fhout "       dists/woody-jp/main/ \n";
  print $fhout "  make_package \$\{TO_DIR\}/debian-jp/dists/woody-jp/contrib \\\n";
  print $fhout "       \$\{FROM_DIR\}/debian-jp/indices-jp/override.woody-jp.contrib\\\n";
  print $fhout "       dists/woody-jp/contrib/ \n";
  print $fhout "  make_package \$\{TO_DIR\}/debian-jp/dists/woody-jp/non-free \\\n";
  print $fhout "       \$\{FROM_DIR\}/debian-jp/indices-jp/override.woody-jp.non-free \\\n";
  print $fhout "       dists/woody-jp/non-free/ \n";
  print $fhout "  make_package \$\{TO_DIR\}/debian-non-US/dists/woody/non-US/main \\\n";
  print $fhout "       \$\{FROM_DIR\}/debian-non-US/indices-non-US/override.woody.gz \\\n";
  print $fhout "       dists/woody/non-US/main/ \n";
  print $fhout "  make_package \$\{TO_DIR\}/debian-non-US/dists/woody/non-US/contrib \\\n";
  print $fhout "       \$\{FROM_DIR\}/debian-non-US/indices-non-US/override.woody.gz \\\n";
  print $fhout "       dists/woody/non-US/contrib/ \n";
  print $fhout "  make_package \$\{TO_DIR\}/debian-non-US/dists/woody/non-US/non-free \\\n";
  print $fhout "       \$\{FROM_DIR\}/debian-non-US/indices-non-US/override.woody.gz \\\n";
  print $fhout "       dists/woody/non-US/non-free/ \n";
  print $fhout "fi\n";
} ## output_foot()

# Local Variables:
# End:
