/*
  Plee the Bear

  Copyright (C) 20052011 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file corrupting_bonus.hpp
 * \brief A corrupting bonus. Get a lot of them to avoid fighting the boss.
 * \author Angibaud Sebastien
 */
#ifndef __PTB_CORRUPTING_BONUS_HPP__
#define __PTB_CORRUPTING_BONUS_HPP__

#include "engine/base_item.hpp"
#include "engine/item_brick/basic_renderable_item.hpp"
#include "engine/item_brick/item_with_decoration.hpp"
#include "engine/export.hpp"

namespace ptb
{
  /**
   * \brief A corrupting bonus. Get a lot of them to avoid fighting the boss.
   *
   * The valid fields for this item are
   *  - any field supported by the parent classes.
   *
   * \author Sebastien Angibaud
   */
  class corrupting_bonus:
    public bear::engine::item_with_decoration
      < bear::engine::basic_renderable_item<bear::engine::base_item> >
  {
    DECLARE_BASE_ITEM(corrupting_bonus);

  public:
    /** \brief The type of the parent class. */
    typedef
    bear::engine::item_with_decoration
      < bear::engine::basic_renderable_item<bear::engine::base_item> > super;

  public:
    corrupting_bonus();

    void pre_cache();
    void attract(bear::universe::physical_item& attractor);

  private:
     void collision_check_and_apply
    ( bear::engine::base_item& that, bear::universe::collision_info& info );

    virtual void collision
    ( bear::engine::base_item& that, bear::universe::collision_info& info );

    void create_decoration();
    void create_floating_score(unsigned int index);

  private:
    /** \brief Indicates if the bonus is already given. */
    bool m_bonus_given;
  }; // class corrupting_bonus
} // namespace ptb

#endif // __PTB_CORRUPTING_BONUS_HPP__
