# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pmh@zadka.site.co.il>
import UserDict, rfc822, re, string
from cStringIO import StringIO

class Message(UserDict.UserDict):

	def __init__(self, fp=None):
		UserDict.UserDict.__init__(self)
		if fp is None:
			fp = StringIO()
		self.fp = fp

class RFC822(Message):

	def __init__(self, fp):
		Message.__init__(self, fp)
		self.__line = None
		self.__parse()

	def __readline(self):
		if self.__line is not None:
			try:
				return self.__line
			finally:
				self.__line = None
		return self.fp.readline()

	def __pushline(self, line):
		assert self.__line is None
		self.__line = line

	def __read_header(self):
		line = self.__readline()
		try:
			header, content = string.split(line, ':', 1)
		except ValueError:
			header, content = line, ''
		header = string.lower(header)
		content = string.lstrip(content)
		while 1:
			line = self.__readline()
			if not line:
				break
			if line[0] not in ' \t' or line=='\n' or line=='\r\n':
				self.__pushline(line)
				break
			content = content+line
		self[header] = string.rstrip(content)

	def __parse(self):
		while 1:
			line = self.__readline()
			if not line or line=='\n' or line=='\r\n':
				break
			self.__pushline(line)
			self.__read_header()

def parse(fp):
	return RFC822(fp)

_beginning  = re.compile(r"\b[A-Za-z]")

def _upper(m):
	return string.upper(m.group())

def capitalize_header(header):
	return _beginning.sub(_upper, header)
