#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <errno.h>

#include "sys/wcetypes.h"
#include "sys/wcefile.h"
#include "sys/wceerror.h"
#include "sys/wcetrace.h"

int
access(const char *fname, int mode)
{
  struct stat st;

  if (fname == NULL)
    return(-1);

  if (stat(fname, &st) < 0)
    return(-1);

  return(0);
}

int
mkdir(const char *dirname, mode_t mode)
{
  wchar_t dirnamew[MAX_PATH];
  BOOL    res;

  mbstowcs(dirnamew, dirname, MAX_PATH);
  res = CreateDirectoryW(dirnamew, NULL);

  if (res != TRUE) {
      errno =_winerr2errno(GetLastError());
      return(-1);
    }

  return(0);
}

int
rmdir(const char *dirname)
{
  wchar_t dirnamew[MAX_PATH];
  BOOL res;

  if (dirname == NULL)
    return(-1);

  mbstowcs(dirnamew, dirname, MAX_PATH);
  res = RemoveDirectoryW(dirnamew);

  if (res != TRUE) {
    errno =_winerr2errno(GetLastError());
    return(-1);
  }

  return(0);
}

int
rename(const char *old, const char *new)
{
  struct stat st;
  wchar_t oldw[MAX_PATH], neww[MAX_PATH];
  BOOL res;

  if (old == NULL || new == NULL)
    return(-1);

  if (stat(new, &st) == 0) {
    if (remove(new) < 0) {
	     return(-1);
    }
  }

  mbstowcs(neww, new, MAX_PATH);
  mbstowcs(oldw, old, MAX_PATH);
  res = MoveFileW(oldw, neww);

  if (res != TRUE) {
    errno =_winerr2errno(GetLastError());
    return(-1);
  }

  return(0);
}

int
remove(const char *path)
{
  wchar_t pathw[MAX_PATH];
  BOOL res;

  if (path == NULL)
    return(-1);

  mbstowcs(pathw, path, MAX_PATH);
  res = DeleteFileW(pathw);

  if (res != TRUE) {
    errno = _winerr2errno(GetLastError());
    return(-1);
  }

  return(0);
}

int
_unlink_r(struct _reent *reent, const char *path)
{
  wchar_t pathw[MAX_PATH];
  BOOL res;

  if (path == NULL)
    return(-1);

  mbstowcs(pathw, path, MAX_PATH);
  res = DeleteFileW(pathw);

  if (res == FALSE) {
    errno = _winerr2errno(GetLastError());
    return(-1);
  }

  return(0);
}
