/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include "polyxcalc-calcctxt.h"
#include "polyxcalc-ui-calculator.h"

PxmCalcCtxt *
polyxcalc_calcctxt_new (void)
{
  PxmCalcCtxt *calcctxt = g_malloc0 (sizeof (PxmCalcCtxt));
  
  calcctxt->masspair_init = libpolyxmass_masspair_new ();
  calcctxt->masspair_temp = libpolyxmass_masspair_new ();
  calcctxt->masspair_res = libpolyxmass_masspair_new ();
  
  calcctxt->atomGPA = g_ptr_array_new ();
  
  calcctxt->propGPA = g_ptr_array_new ();

  return calcctxt;
}


gboolean 
polyxcalc_calcctxt_free (PxmCalcCtxt *calcctxt)
{
  gint count = 0;
  
  g_assert (calcctxt != NULL);
  
  /* Start with most internal data.
   */
  libpolyxmass_prop_GPA_free (calcctxt->propGPA);
  
  /* We do not free the polchemdefctxt (was not necessarily allocated
     when constructing or setting up the calcctxt), we just unref it,
     so that if there are other contexts using it they still can. When
     the count will reach 0, the polchemdefctxt will be automagically
     freed.
  */
  if (calcctxt->polchemdefctxt != NULL)
    {
      if (-1 == polyxmass_polchemdefctxt_unref (calcctxt->polchemdefctxt))
	{
	  g_critical (_("%s@%d: failed unref'ing polymer definition "
			"context from main global array: '%s'\n"),
		      __FILE__, __LINE__, 
		      calcctxt->polchemdefctxt->polchemdef->type);
	  
	  return FALSE;
	}

      /* We do not free the calcctxt->atomGPA array of atoms, because
	 it was not allocated, it just points to
	 calcctxt->polchemdefctxt->polchemdef->atomGPA.
      */
    }
  else
    {
      /* If the calcctxt->polchemdefctxt was not allocated, then the
	 array of tatoms was effectively allocated, and does not
	 belong to the calcctxt->polchemdefctxt. So we have to free
	 it.
      */
      if (calcctxt->atomGPA)
	pxmchem_atom_GPA_free (calcctxt->atomGPA);
    }
  
  
  if (calcctxt->masspair_init != NULL)
    libpolyxmass_masspair_free (calcctxt->masspair_init);
  
  if (calcctxt->masspair_temp != NULL)
    libpolyxmass_masspair_free (calcctxt->masspair_temp);
  
  if (calcctxt->masspair_res != NULL)
    libpolyxmass_masspair_free (calcctxt->masspair_res);
  
  if (calcctxt->chempad_wnd != NULL)
    gtk_object_destroy (GTK_OBJECT (calcctxt->chempad_wnd));
  
  if (calcctxt->recorder_wnd != NULL)
    gtk_object_destroy (GTK_OBJECT (calcctxt->recorder_wnd));

  if (calcctxt->calculator_wnd != NULL)
    {
      
      count = polyxmass_timeoutmsg_messages_remove 
	((GtkWindow *) calcctxt->calculator_wnd);
      
      /*
	debug_printf (("Removed %d timed-out messages\n",
	count));
      */

      gtk_object_destroy (GTK_OBJECT (calcctxt->calculator_wnd));
    }

  g_free (calcctxt);
  
  return TRUE;
}




/* GPtrArray-RELATED FUNCTIONS
 */
gint
polyxcalc_calcctxt_GPA_free (GPtrArray *GPA)
{
  gint count = 0;
  
  PxmCalcCtxt *calcctxt = NULL;

  g_assert (GPA != NULL);
  
  while (GPA->len > 0)
    {
      calcctxt = g_ptr_array_remove_index (GPA, 0);
      g_assert (calcctxt != NULL);
      polyxcalc_calcctxt_free (calcctxt);
      count++;
    }
  
  g_ptr_array_free (GPA, TRUE);

  return count;
}












