/*
Authentication.h
*/

#ifndef __AUTHENTICATION_H
#define __AUTHENTICATION_H

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>

#include "xdb.h"
#include "Utils.h"
#include "Config.h"
#include "Configuration.h"
#include "XString.h"
#include "XVector.h"
#include "Cookie.h"
#include "CCLIENT.h"
#include "ClientLDAP.h"

typedef XVector<XString> StringList;

class Authentication
  {
  private:
    XString username, password, tmp_password, server;
    int iservice, port;
    Cookie *cookie;
    TBuffer ErrorString;
    bool IS_AUTHENTICATED;
    bool imap_authentication (void);
    bool ldap_authentication (void);    
    void do_store_password (void);
  public:
    Authentication (int aservice, const char *aserver, int aport, const char *ausername, const char *apassword, const char *connid);
    virtual ~Authentication ();
    const char *getErrorMsg (void);   
    bool doFirstAuthentication (void);  
    const char *cookie_getSetFullCookieLine (void);
    const char *cookie_getSetClearFullCookieLine(void);    
    bool isGoodCookie (const char *acookie);
  };

#endif

