/*           
UserOptions.cc
*/

#include "UserOptions.h"

extern CCLIENT *thecclient;
extern Skin *skin;

UserOptions::UserOptions (const char *abasepath, const char *auser, const char *aimapserver)
  {
  TBuffer tmpbuffer;
  validator = 0;
  WorkingWithCookies = false;
  UseJavaScript = true;
  ShowCalendarTodayEvents = true;
  ConfirmPurge = DEFOPT_CONFIRMPURGE;
  ConfirmLogout = DEFOPT_CONFIRMLOGOUT;
  timeout = DEFTIMEOUT;
  InitStatusLine ();
  user = auser;
  imapserver = aimapserver;
  basepath = abasepath;
  AuthSMTP = 0;
  userdir = ReturnUsersDir (abasepath, auser, aimapserver, tmpbuffer);
  fnuseroptions = ReturnUserOptionsFileName(abasepath, auser, aimapserver, tmpbuffer);
  fnsignature = ReturnSignatureFileName(abasepath, auser, aimapserver, tmpbuffer);
  fnsubscribedgroups = ReturnSubscribedNNGroupsFileName(abasepath, auser, aimapserver, tmpbuffer); 
  fnrcgroups = ReturnRcNNGroupsFileName(abasepath, auser, aimapserver, tmpbuffer);   
  fnsavedmsg  = ReturnUserSavedMsgFileName (abasepath, auser, aimapserver, tmpbuffer);
  fnsavednntpmsg  = ReturnUserSavedNNTPMsgFileName (abasepath, auser, aimapserver, tmpbuffer);
  userattdir = ReturnUserAttachsDir(abasepath, auser, aimapserver, tmpbuffer);
  userdatabasesdir = ReturnUserDatabasesDir(abasepath, auser, aimapserver, tmpbuffer);    
  fnsieve = ReturnSieveFileName (abasepath, auser, aimapserver, tmpbuffer);
  TheConf = new Configuration (fnuseroptions.cstr(), false);
  signature = "";
  sort_ab = 0;
  SLSubscribedGroups = new StringList ();
  SLAllowedServices = new StringList ();
  CurrentPosition = -1;
  IMAPPORT = DEFIMAPPORT;
  initStr (MAILDOMAIN);
  initStr (IMAPSERVER);
  initStr (SMTPSERVER);
  initStr (NNTPSERVER);
  initStr (POPPASSSERVER);
  initStr (FORWARDSSERVER);
  initStr (SIEVESERVER);
  initStr (LDAPSERVER);
  pageid = -1;
  lastcmd = -1;
  SentmailName = DEFOPT_SENTMAILBOX;
  MAILBOXSIZE = -1;
  BeginPage = 1;
  LoadOptions ();
  msgtoanswer = -1;
  trueemail = "";
  IconsSize = ICONS_SIZE_SMALL;
  ShowIconsLabels = false;
  }
  
UserOptions::~UserOptions ()  
  {
  delete SLSubscribedGroups;
  delete TheConf;
  delete SLAllowedServices;
  }  

bool UserOptions::IsWorkingWithCookies (void)
  {
  return WorkingWithCookies;
  }  

void UserOptions::setWorkingWithCookies (bool b)
  {
  WorkingWithCookies = b;
  }  

bool UserOptions::get_use_javascript (void)
  {
  return UseJavaScript;
  }

void UserOptions::set_use_javascript (bool b)
  {
  UseJavaScript = b;
  }
  
void UserOptions::leeConf ()
  {
  if (TheConf->Reload() == false) {TheConf->newFile (DEF_USEROPT_FILE); LoadOptions ();}  
  }

void UserOptions::setMailboxPrefix (const char *amailboxprefix)
  {
  xstrncpy (MAILBOXPREFIX, CMAXBUFFER, amailboxprefix);
  }
  
const char *UserOptions::getMailboxPrefix (void)
  {
  return MAILBOXPREFIX;
  }      

void UserOptions::setMailDomain (const char *amaildomain)
  {
  xstrncpy (MAILDOMAIN, CMAXIPNAME, amaildomain);
  }
  
const char *UserOptions::getMailDomain (void)
  {
  return MAILDOMAIN;
  }      
   
void UserOptions::setAuthService (const char *aservice)
  {
  xstrncpy (AUTHSERVICE, CMAXBUFFER, aservice);
  iAUTHSERVICE = TranslateService (AUTHSERVICE);
  }
  
const char *UserOptions::getAuthService (void)
  {
  return AUTHSERVICE;
  }
        
int UserOptions::getiAuthService (void)
  {
  return iAUTHSERVICE;
  }
 
void UserOptions::setAuthSMTP (int value)
  {
  AuthSMTP = value;
  if ((AuthSMTP < 0) || (AuthSMTP > 2)) AuthSMTP = 0;
  }
  
int UserOptions::getAuthSMTP (void)
  {
  return AuthSMTP;
  }
  
void UserOptions::setImapServer (const char *aimapserver)
  {
  TBuffer tmpbuffer;
  xstrncpy (IMAPSERVER, CMAXIPNAME, aimapserver);
  imapserver = aimapserver;
  userdir = ReturnUsersDir                     (basepath.cstr(), user.cstr(), IMAPSERVER, tmpbuffer);
  fnuseroptions = ReturnUserOptionsFileName    (basepath.cstr(), user.cstr(), IMAPSERVER, tmpbuffer);
  fnsignature = ReturnSignatureFileName        (basepath.cstr(), user.cstr(), IMAPSERVER, tmpbuffer); 
  fnsubscribedgroups = ReturnSubscribedNNGroupsFileName (basepath.cstr(), user.cstr(), IMAPSERVER, tmpbuffer);  
  fnsavedmsg  = ReturnUserSavedMsgFileName     (basepath.cstr(), user.cstr(), IMAPSERVER, tmpbuffer);
  fnsavednntpmsg  = ReturnUserSavedNNTPMsgFileName (basepath.cstr(), user.cstr(), IMAPSERVER, tmpbuffer);
  userattdir = ReturnUserAttachsDir            (basepath.cstr(), user.cstr(), IMAPSERVER, tmpbuffer);
  userdatabasesdir  = ReturnUserDatabasesDir   (basepath.cstr(), user.cstr(), IMAPSERVER, tmpbuffer);
  fnsieve = ReturnSieveFileName (basepath.cstr(), user.cstr(), IMAPSERVER, tmpbuffer);
  TheConf = new Configuration (fnuseroptions.cstr(), false);
  TheConf->setFileName (fnuseroptions.cstr());
  delete TheConf;
  TheConf = new Configuration (fnuseroptions.cstr(), false);
  LoadOptions ();
  }  
  
const char *UserOptions::getImapServer (void)
  {
  return IMAPSERVER;
  }
  
void UserOptions::setImapPort (int aimapport)
  {
  IMAPPORT = aimapport;
  }
  
int UserOptions::getImapPort (void)
  {
  return IMAPPORT;
  }

void UserOptions::setSMTPServer (const char *asmtpserver)
  {
  xstrncpy (SMTPSERVER, CMAXIPNAME, asmtpserver);
  }
  
const char *UserOptions::getSMTPServer (void)
  {
  return SMTPSERVER;
  }
  
void UserOptions::setPoppassServer (const char *apoppassserver)
  {
  xstrncpy (POPPASSSERVER, CMAXIPNAME, apoppassserver);
  }
  
const char *UserOptions::getPoppassServer (void)
  {
  return POPPASSSERVER;
  }  
  
void UserOptions::setPoppassPort (int apoppassport)
  {
  POPPASSPORT = apoppassport;
  }
  
int UserOptions::getPoppassPort (void)
  {
  return POPPASSPORT;
  }      
  
void UserOptions::setDeniedServices (const char *adeniedservices)
  {
  deniedservices = adeniedservices;
  }
  
const char *UserOptions::getDeniedServices (void)
  {
  return deniedservices.cstr();
  }        
   
bool UserOptions::isDeniedService (const char *aservice)
  {
  TBuffer abuf;
  xsnprintf (abuf, CMAXBUFFER, ".%s.", aservice);
  if (NCstrstr(deniedservices.cstr(), abuf) > 0) return true;
  else return false;
  }           
 
const char *UserOptions::getTrueEmail (void)
  {
  return trueemail.cstr();
  }  
  
void UserOptions::setTrueEmail (const char *atrueemail)
  {
  trueemail = atrueemail;
  }
  
void UserOptions::setSieveServer (const char *asieveserver)
  {                                                 
  xstrncpy (SIEVESERVER, CMAXIPNAME, asieveserver);
  }
  
const char *UserOptions::getSieveServer (void)
  {
  return SIEVESERVER;
  }  
  
void UserOptions::setSievePort (int asieveport)
  {
  SIEVEPORT = asieveport;
  }
  
int UserOptions::getSievePort (void)
  {
  return SIEVEPORT;
  }      
  
void UserOptions::setForwardsServer (const char *aforwardsserver)
  {
  xstrncpy (FORWARDSSERVER, CMAXIPNAME, aforwardsserver);
  }
  
const char *UserOptions::getForwardsServer (void)
  {
  return FORWARDSSERVER;
  }    

void UserOptions::setLDAPServer (const char *aldapserver)
  {
  xstrncpy (LDAPSERVER, CMAXIPNAME, aldapserver);
  }
  
const char *UserOptions::getLDAPServer (void)
  {
  return LDAPSERVER;
  }    

void UserOptions::setLDAPPort (int aldapport)
  {
  LDAPPORT = aldapport;
  }
int UserOptions::getLDAPPort (void)
  {
  return LDAPPORT;
  }  

void UserOptions::setForwardsPort (int aforwardsport)
  {
  FORWARDSPORT = aforwardsport;
  }
  
int UserOptions::getForwardsPort (void)
  {
  return FORWARDSPORT;
  }  
  
void UserOptions::setNNTPServer (const char *anntpserver)
  {
  xstrncpy (NNTPSERVER, CMAXIPNAME, anntpserver);
  }
  
const char *UserOptions::getNNTPServer (void)
  {
  return NNTPSERVER;
  }
  
void UserOptions::setCurrentPosition (long pos, long total)
  {
  CurrentPosition = pos;
  TotalMsgs       = total;
  if (CurrentPosition == 0) CurrentPosition = TotalMsgs;
  if (CurrentPosition > TotalMsgs) CurrentPosition = TotalMsgs;
  if (CurrentPosition < 1) CurrentPosition = 1;
  }

long UserOptions::getCurrentPosition (void)
  {
  return CurrentPosition;
  }
  
long UserOptions::getBeginPage (void)
  {
  long p;
  ldiv_t ld;
  if (getMsgsPerIndexPage() == 0)
    {
    BeginPage = 1;
    }
  else
    {
    ld = ldiv (CurrentPosition - 1, getMsgsPerIndexPage());
    p = ld.quot * getMsgsPerIndexPage();
    BeginPage = p + 1;
    }
  return BeginPage;
  }        

long UserOptions::getTotalMsgs (void)
  {
  return TotalMsgs;
  }

void UserOptions::setMailboxSize (long asize)
  {
  MAILBOXSIZE = asize;
  }
  
long UserOptions::getMailboxSize (void)    
  {
  return MAILBOXSIZE;
  }      

void UserOptions::InitStatusLine (void)
  {
  xstrncpy (StatusLine, CMAXBUFFER, HTML_SP);
  }

const char *UserOptions::getUsername (void)
  {
  return user.cstr();
  }  

const char *UserOptions::getUserDir (void)
  {
  return userdir.cstr();
  }  

const char *UserOptions::getAttachDir (void)
  {
  return userattdir.cstr();
  }  

const char *UserOptions::getDatabasesDir (void)
  {
  return userdatabasesdir.cstr();
  }  

const char *UserOptions::getStatusLine (void)
  {
  return StatusLine;
  }  

void UserOptions::setNumMsgToReply (int value)
  {
  msgtoanswer = value;
  }
  
int UserOptions::getNumMsgToReply(void)
  {
  return msgtoanswer;
  } 

void UserOptions::setStatusLine (const char *newstatusline, const char *htmlcolor)
  {
  sprintf (StatusLine, "<FONT face=\"%s\" size=\"%d\" color=\"%s\">%s</FONT>", 
           skin->getSkinAtribProp ("FONT_STATUS"), skin->getSkinAtribPropI ("FONT_STATUS_SIZE"),
           htmlcolor, newstatusline);
  }
        
int UserOptions::getValidator (void)
  {
  return validator;
  }  
  
void UserOptions::IncValidator (void)
  {
  ++validator;
  }  

void UserOptions::setInsertSignatureInNewMsg (bool value)
  {
  InsertSignatureInNewMsg = value;
  }
  
bool UserOptions::getInsertSignatureInNewMsg (void)
  {
  return InsertSignatureInNewMsg;
  }  
  
  
bool UserOptions::getShowClock (void)
  {
  return ShowClock;
  }
  
void UserOptions::setShowClock (bool value)
  {
  ShowClock = value;
  }                           
  
bool UserOptions::getShowIconsLabels (void)
  {
  return ShowIconsLabels;
  }
  
void UserOptions::setShowIconsLabels (bool value)
  {
  ShowIconsLabels = value;
  }            
  
int UserOptions::getIconsSize (void)
  {
  return IconsSize;
  }
  
void UserOptions::setIconsSize (int value)
  {
  IconsSize = value;
  }              
  
void UserOptions::setMsgsPerIndexPage (long value)
  {
  if (value < 0) MsgsPerIndexPage = DEFOPT_MSGSPERINDEXPAGE;
  else MsgsPerIndexPage = value;
  }

long UserOptions::getMsgsPerIndexPage (void)
  {
  return MsgsPerIndexPage;
  }
  
void UserOptions::setPersonalName (char *value)
  {
  personalname = value;
  }

const char *UserOptions::getPersonalName (void)
  {
  return personalname.cstr();
  }  
  
void UserOptions::setSaveMsgSentMail (bool value)
  {
  SaveMsgSentMail = value;
  }
  
bool UserOptions::getDisplayPersonalInfo (void)
  {
  return DisplayPersonalInfo;
  }
  
void UserOptions::setDisplayPersonalInfo (bool value)
  {
  DisplayPersonalInfo = value;
  }  
  
bool UserOptions::getShowCalendarTodayEvents (void)
  {
  return ShowCalendarTodayEvents;
  }
  
void UserOptions::setShowCalendarTodayEvents (bool value)
  {
  ShowCalendarTodayEvents = value;
  }    
  
bool UserOptions::getSaveMsgSentMail (void)
  {
  return SaveMsgSentMail;
  }  
  
void UserOptions::setReplyFrom (bool value)
  {
  ReplyFrom = value;
  }
  
bool UserOptions::getReplyFrom (void)
  {
  return ReplyFrom;
  }    
  
void UserOptions::setForwAttachs (bool value)
  {
  ForwAttachs = value;
  }
  
bool UserOptions::getForwAttachs (void)
  {
  return ForwAttachs;
  }
        
void UserOptions::setTruncateLengthReadingMsg (int value)
  {
  TruncateLengthReadingMsg = value;
  }
  
int UserOptions::getTruncateLengthReadingMsg (void)
  {
  return TruncateLengthReadingMsg;
  }    
  
void UserOptions::setWidthWriteArea (int value)
  {
  WidthWriteArea = value;
  }
  
int UserOptions::getWidthWriteArea (void)
  {
  return WidthWriteArea;
  }  
  
void UserOptions::setHeightWriteArea (int value)
  {
  HeightWriteArea = value;
  }
  
int UserOptions::getHeightWriteArea (void)
  {
  return HeightWriteArea;
  }    
  
const char *UserOptions::getSignature (void)
  {
  return signature.cstr();  
  }
  
const char *UserOptions::getSieveFilename (void)
  {
  return fnsieve.cstr();  
  } 
   
int UserOptions::getRefreshTime (void)
  {
  return RefreshTime;
  }    
  
void UserOptions::setRefreshTime (int value)
  {
  RefreshTime = value;
  }

bool UserOptions::SaveOptions (char *tmpfilename, int cmd)
  {
  FILE *fs;
  StringList *SLTemp;
  Configuration *XConf;
  XConf = new Configuration (tmpfilename, false);
  XConf->Reload();
  SLTemp = new StringList ();
  if (cmd == CMD_CONFIG_CCLIENT)
    {
    TheConf->setInt    ("main", "msgsperindexpage",XConf->getInt("main", "msgsperindexpage", DEFOPT_MSGSPERINDEXPAGE));
    TheConf->setInt    ("main", "insigninnewmsg",  XConf->getInt("main", "insigninnewmsg", DEFOPT_INSERTSIGNATUREINNEWMSG));  
    TheConf->setString ("main", "personalname",    XConf->getString("main", "personalname", "", 100), 100);  
    TheConf->setInt    ("main", "savemsgsentmail", XConf->getInt("main", "savemsgsentmail", DEFOPT_SAVEMSGSENTMAIL));
    TheConf->setInt    ("main", "replyfrom",       XConf->getInt("main", "replyfrom", DEFOPT_REPLYFROM));
    TheConf->setInt    ("main", "forwattachs",     XConf->getInt("main", "forwattachs", DEFOPT_FORW_ATTACHS));
    TheConf->setInt    ("main", "heightwritearea", XConf->getInt("main", "heightwritearea", DEFOPT_HEIGHTWRITEAREA));
    TheConf->setInt    ("main", "widthwritearea",  XConf->getInt("main", "widthwritearea", DEFOPT_WIDTHWRITEAREA));   
    TheConf->setInt    ("main", "truncatelengthreadingmsg",  XConf->getInt("main", "truncatelengthreadingmsg", DEFOPT_TRUNCATELENGTHREADINGMSG));        
    TheConf->setInt    ("main", "refreshtime",     XConf->getInt("main", "refreshtime", DEFOPT_REFRESHTIME)); 
    TheConf->setString ("main", "sentmailname",    XConf->getString("main", "sentmailname", DEFOPT_SENTMAILBOX, 50), 50);      
    TheConf->setInt    ("main", "confirmpurge",    XConf->getInt("main", "confirmpurge",  DEFOPT_CONFIRMPURGE));  
    TheConf->ConfSave();
    //SIGNATURE
    XConf->getSection ("signature", SLTemp);
    fs = fopen ((fnsignature.cstr()), "w"); if (fs == NULL) return false;
    for (int yy=0; yy < SLTemp->Count(); ++yy)
      {
      fprintf (fs, "%s\n", SLTemp->getString(yy).cstr());  
      }
    fclose (fs);
    }
  else if (cmd == CMD_CONFIG_NNTP)  
    {  
    TheConf->ConfSave();
    }
  else if (cmd == CMD_CONFIG_APPEARANCE)
    {
    TheConf->setInt    ("main", "displaypersonalinfo", XConf->getInt("main", "displaypersonalinfo", DEFOPT_DISPLAYPERSONALINFO));  
    TheConf->setInt    ("main", "showclock",       XConf->getInt("main", "showclock", DEFOPT_SHOWCLOCK));  
    TheConf->setString ("main", "skin",            XConf->getString("main", "skin", "DEFAULT", 100), 100);  
    TheConf->setInt    ("main", "confirmlogout",   XConf->getInt("main", "confirmlogout", DEFOPT_CONFIRMLOGOUT));    
    TheConf->setInt    ("main", "showiconslabels",   XConf->getInt("main", "showiconslabels", DEFOPT_SHOWICONSLABELS));    
    TheConf->setInt    ("main", "iconssize",   XConf->getInt("main", "iconssize", DEFOPT_ICONSSIZE));        
    TheConf->ConfSave();
    }

  delete SLTemp;
  delete XConf;
  DeleteFile (tmpfilename);
  LoadOptions ();
  return true;
  }  

bool UserOptions::SaveNNTPOptions (char *tmpfilename)
  {
  Configuration *XConf;
  StringList *SLTemp;
  SLTemp = new StringList ();
  int added;
  bool boo;

  XConf = new Configuration (tmpfilename, false);
  XConf->Reload();

  //SUBSRIBEDGROUPS
  initSubscribedGroups();
  XConf->getSection ("subscribedgroups", SLTemp);
  added = MergeStringList (SLSubscribedGroups, SLTemp, true);
  boo = SaveSubscribedGroups();

  delete SLTemp;
  delete XConf;
  DeleteFile (tmpfilename);
  LoadOptions ();
  return boo;
  }  

void UserOptions::LoadOptions (void)
  {
  if (FileExists (fnuseroptions.cstr()) == false)
    {
    setMsgsPerIndexPage (DEFOPT_MSGSPERINDEXPAGE);
    setInsertSignatureInNewMsg (DEFOPT_INSERTSIGNATUREINNEWMSG);
    setShowClock (DEFOPT_SHOWCLOCK);
    setPersonalName ("");
    setSaveMsgSentMail (DEFOPT_SAVEMSGSENTMAIL);
    setReplyFrom  (DEFOPT_REPLYFROM);
    setForwAttachs (DEFOPT_FORW_ATTACHS);
    setWidthWriteArea (DEFOPT_WIDTHWRITEAREA);
    setHeightWriteArea (DEFOPT_HEIGHTWRITEAREA);
    setTruncateLengthReadingMsg (DEFOPT_TRUNCATELENGTHREADINGMSG);
    skin->setSkin (DEFOPT_SKIN);
    setRefreshTime (DEFOPT_REFRESHTIME);
    setSentMailName (DEFOPT_SENTMAILBOX);
    setConfirmPurge (DEFOPT_CONFIRMPURGE);
    setConfirmLogout (DEFOPT_CONFIRMLOGOUT);
    setShowIconsLabels (DEFOPT_SHOWICONSLABELS);
    skin->setDisplayButtonLabels (DEFOPT_SHOWICONSLABELS);
    setIconsSize (DEFOPT_ICONSSIZE);
    skin->setIconsSize (DEFOPT_ICONSSIZE);
    }
  else
    {
    int nummmsgsperpage, heightwritearea, widthwritearea, truncate;
    TheConf->Reload ();
    nummmsgsperpage = TheConf->getInt ("main", "msgsperindexpage", DEFOPT_MSGSPERINDEXPAGE); if (nummmsgsperpage < 0) nummmsgsperpage = DEFOPT_MSGSPERINDEXPAGE; setMsgsPerIndexPage(nummmsgsperpage);
    setInsertSignatureInNewMsg (TheConf->getInt ("main", "insigninnewmsg", DEFOPT_INSERTSIGNATUREINNEWMSG));
    setShowClock (TheConf->getInt ("main", "showclock", DEFOPT_SHOWCLOCK));
    setPersonalName (TheConf->getString("main", "personalname", "", 100));
    setSaveMsgSentMail(TheConf->getInt("main", "savemsgsentmail", DEFOPT_SAVEMSGSENTMAIL));
    setDisplayPersonalInfo (TheConf->getInt("main", "displaypersonalinfo", DEFOPT_DISPLAYPERSONALINFO));
    setReplyFrom (TheConf->getInt("main", "replyfrom", DEFOPT_REPLYFROM));
    setForwAttachs (TheConf->getInt("main", "forwattachs", DEFOPT_FORW_ATTACHS));
    heightwritearea = TheConf->getInt("main", "heightwritearea", DEFOPT_HEIGHTWRITEAREA); if (heightwritearea < 2) heightwritearea = DEFOPT_HEIGHTWRITEAREA; setHeightWriteArea(heightwritearea);
    widthwritearea = TheConf->getInt("main", "widthwritearea", DEFOPT_WIDTHWRITEAREA); if (widthwritearea < 2) widthwritearea = DEFOPT_WIDTHWRITEAREA; setWidthWriteArea(widthwritearea);
    truncate = TheConf->getInt("main", "truncatelengthreadingmsg", DEFOPT_TRUNCATELENGTHREADINGMSG); if (truncate < 10) truncate = DEFOPT_WIDTHWRITEAREA; setTruncateLengthReadingMsg(truncate);    
    skin->setSkin (TheConf->getString("main", "skin", "DEFAULT", MAXLENGTHSKIN));
    RefreshTime = TheConf->getInt("main", "refreshtime", DEFOPT_REFRESHTIME); if ((RefreshTime < MIN_TIME_TO_REFRESH) && (RefreshTime != 0)) RefreshTime = MIN_TIME_TO_REFRESH; 
    setSentMailName (TheConf->getString("main", "sentmailname", DEFOPT_SENTMAILBOX, 50));
    setConfirmPurge (TheConf->getInt("main", "confirmpurge", DEFOPT_CONFIRMPURGE));
    setConfirmLogout (TheConf->getInt("main", "confirmlogout", DEFOPT_CONFIRMLOGOUT));    
    setShowIconsLabels (TheConf->getInt ("main", "showiconslabels", DEFOPT_SHOWICONSLABELS));
    skin->setDisplayButtonLabels (TheConf->getInt ("main", "showiconslabels", DEFOPT_SHOWICONSLABELS));
    setIconsSize (TheConf->getInt("main", "iconssize", DEFOPT_ICONSSIZE));
    skin->setIconsSize (TheConf->getInt("main", "iconssize", DEFOPT_ICONSSIZE));
    }
    
  //SIGNATURE  
  if (FileExists (fnsignature.cstr()) == true) 
    {
    TBuffer abuf;
    FILE *fr;
    fr = fopen (fnsignature.cstr(), "r");
    signature = "";
    while (fgets (abuf, CMAXBUFFER, fr) != NULL)
      {
      signature += abuf;
      }
    fclose (fr);
    }
  else 
    {
    signature =  "********************************\n";  
    signature += user;
    signature += "\n********************************\n";
    }
    
  //SUBSCRIBEDGROUPS  
  initSubscribedGroups();
  if (FileExists (fnsubscribedgroups.cstr()) == true) 
    {
    TBuffer abuf;
    FILE *fr;    
    fr = fopen (fnsubscribedgroups.cstr(), "r");
    while (fscanf (fr, "%s\n", abuf) != EOF)
      {
      if ((SLSubscribedGroups->indexOf (abuf) < 0) && (strcmp (abuf, "") != 0))
        {
        SLSubscribedGroups->Add (abuf);
        }
      }
    fclose (fr);
    }
  }  

void UserOptions::initSubscribedGroups()
  {
  SLSubscribedGroups->Clear ();
  if (FORCE_INCLUDE_NNTP_SUBSCRIBEDGROUPS == 1)
    {
    SLSubscribedGroups->LoadFromFile (NN_DEFAULTGROUPS);
    }        
  }
 
const char *UserOptions::getFileNameRcGroups (void)
  {
  return fnrcgroups.cstr();
  }
 
int UserOptions::getObligatedGroups(TBuffer obligatedgroups)
  {
  StringList SLTemp;
  SLTemp.Clear ();
  initStr (obligatedgroups);
  if (FORCE_INCLUDE_NNTP_SUBSCRIBEDGROUPS == 1)
    {
    SLTemp.LoadFromFile (NN_DEFAULTGROUPS);
    for (int i = 0; i < SLTemp.Count (); ++i)
      {
      xstrncat (obligatedgroups, CMAXBUFFER, SLTemp.getString(i).cstr());
      if (i < SLTemp.Count() - 1) 
        {
        xstrncat (obligatedgroups, CMAXBUFFER, ", ");
        }
      }
    return SLTemp.Count();  
    } 
  else
    {
    return 0;
    }         
  }  

bool UserOptions::SaveSubscribedGroups (void)
  {
  if (SLSubscribedGroups->SaveToFile (fnsubscribedgroups.cstr(), true) != -1) return true;
  else return false;
  }  

int UserOptions::numAttachs (void)
  {
  return SLAttachList.Count ();
  }
 
const char *UserOptions::getAttachInfo (int p)
  {
  if (p >= SLAttachListInfo.Count ()) return "";
  return SLAttachListInfo.getString (p).cstr();
  }
 
const char *UserOptions::getFileNameAttach (int p)
  {
  if (p >= SLAttachList.Count ()) return "";
  return SLAttachList.getString (p).cstr();
  }      

const char *UserOptions::getTrueFileNameAttach (int p)
  {  
  TBuffer tmpbuffer;
  if (p >= SLAttachList.Count ()) return "";
  XSTrueFileNameAttach = ReturnUserAttachsDir(basepath.cstr(), user.cstr(), imapserver.cstr(), tmpbuffer); 
  XSTrueFileNameAttach += "/"; 
  XSTrueFileNameAttach += getFileNameAttach(p);
  return XSTrueFileNameAttach.cstr();
  }

int UserOptions::addFileNameAtach (const char *newfile, const char *info)
  {
  TBuffer tmpbuffer;
  if (numAttachs () >= MAXNUMATTACHSINSEND) {return 0;}
  if (IsEmpty(newfile)) {return 0;}
  XString XS;
  XS = ReturnUserAttachsDir(basepath.cstr(), user.cstr(), imapserver.cstr(), tmpbuffer); XS += "/"; XS += newfile;  
  if (!FileExists (XS.cstr())) {return 0;}
  if (FileSize (XS.cstr()) <= 0) {return 0;}
  if (!SLAttachList.contains(newfile)) 
    {
    SLAttachList.Add (newfile);
    //2 IMAGE/GIF 154387 bytes, "un comentario", "logo.gif"
    SLAttachListInfo.Add (info);
    return 1;
    }
  else return 0;  
  }

//SUPONGO QUE LA LISTA A BORRAR VIENE ORDENADA
// p.e. 1,5,8,40
int UserOptions::delFileNameAtach (const char *attachnumbers)
  {
  if (attachnumbers == NULL) return 0;
  TBuffer abuf;
  char c, letra[2];
  int res, totaltodel;
  StringList SLtoDel;
  letra[1] = '\0';
  abuf[0]  = '\0';
  SLtoDel.Clear();
  for (int i=0; i < (xsint)strlen(attachnumbers); ++i)
    {
    c = attachnumbers[i];
    if (c != ',')
      {
      letra[0] = c;
      xstrncat (abuf, CMAXBUFFER, letra);
      }
    else
      {
      res = xatoidef (abuf, -1);
      if (res > -1) SLtoDel.Add(abuf);
      abuf[0] = '\0';
      }
    }
  if ((xsint)strlen(abuf) > 0)
    {
    res = xatoidef (abuf, -1);
    if (res > -1) SLtoDel.Add(abuf);
    }  
  totaltodel = SLtoDel.Count();  
  for (int k = SLtoDel.Count() - 1;  k >= 0; --k)
    {
    int R;
    R = atoi(SLtoDel.getString(k).cstr());
    XString XS;
    XS = ReturnUserAttachsDir(basepath.cstr(), user.cstr(), imapserver.cstr(), abuf); 
    XS += "/"; XS += SLAttachList.getString(R).cstr();
    DeleteFile (XS.cstr());
    SLAttachList.removeElementAt (R);
    SLAttachListInfo.removeElementAt (R);
    } 
  return totaltodel;
  }
  
void UserOptions::delAllAttachs (void)
  {
  TBuffer tmpbuffer;
  for (int i = 0; i < SLAttachList.Count(); ++i)
    {
    XString XS;
    XS = ReturnUserAttachsDir(basepath.cstr(), user.cstr(), imapserver.cstr(), tmpbuffer); 
    XS += "/"; XS += SLAttachList.getString(i).cstr();
    DeleteFile (XS.cstr());
    }     
  SLAttachList.Clear();  
  SLAttachListInfo.Clear();
  }  

void UserOptions::setSort_ab (int value)
  {
  sort_ab = value;
  }
  
int UserOptions::getSort_ab (void)
  {
  return sort_ab;
  }                  
  
const char *UserOptions::getfnSavedMsg (void)
  {                      
  if (thecclient->getServerProtocol() == PROTOCOL_IMAP)
    {
    return fnsavedmsg.cstr();
    }
  else
    {
    return fnsavednntpmsg.cstr();
    }
  }
    
const char *UserOptions::getSentMailName (void)
  {
  if (SentmailName.cstr() == NULL) return DEFOPT_SENTMAILBOX;
  return SentmailName.cstr();
  }
  
void UserOptions::setSentMailName (const char *smname)
  {
  if ((smname == NULL) || (strcmp (smname, "") == 0)) return;
  SentmailName = smname;
  }

bool UserOptions::getConfirmPurge (void)
  {
  return ConfirmPurge;
  }
  
void UserOptions::setConfirmPurge (bool b)
  {
  ConfirmPurge = b;
  }
  
bool UserOptions::getConfirmLogout (void)
  {
  return ConfirmLogout;  
  }
  
void UserOptions::setConfirmLogout (bool b)
  {
  ConfirmLogout = b;
  }

void UserOptions::setLastService (int value)
  {
  LastService = value;
  }
  
int UserOptions::getLastService (void)
  {
  return LastService;
  }  
   
void UserOptions::setTimeout (int value)
  {
  timeout = value;
  }
  
int UserOptions::getTimeout (void)
  {
  return timeout;
  }        

void UserOptions::setMountPoints (const char *amount_points)
  {
  xstrncpy (mount_points, CMAXBUFFER, amount_points);
  }                                                    
  
const char *UserOptions::getMountPoints (void)
  {
  return mount_points;
  }                                                      
void UserOptions::setLastCmd (int value)
  {
  lastcmd = value;
  }
  
int UserOptions::getLastCmd (void)
  {
  return lastcmd;
  }                    

void UserOptions::clearPila (void)
  {
  PilaCmds.Clear();
  }

/*Vuelca la pila*/
void UserOptions::vuelcaPila (void)
  {
  DEBUG ("***************STACK SIZE=%d*******************\n", PilaCmds.Count());
  for (int j = PilaCmds.Count () - 1; j >= 0; --j)
    {
    DEBUG ("---%d %s---\n", j, PilaCmds.getString(j).cstr());
    }
  }

/*Ajusto como pageid la que me llega por el cgi*/  
void UserOptions::setPageId (int value)
  {
  pageid = value;
  if ((pageid < PilaCmds.Count ()) && (pageid > -1) && (PilaCmds.Count () > 1))
    {
    for (int j = PilaCmds.Count () - 1; j >= pageid; --j)
      {
      PilaCmds.removeElementAt(j);
      }
    }
  }

/*Devuelvo una nueva pageid para la pagina nueva*/
int UserOptions::getPageId (void)
  {
  return pageid + 1;
  }    

void UserOptions::addLastStringCmd (int cmd, const char *stcmd)
  { 
  if (cmd != CMD_SPECIAL_CHECK_COOKIE) 
    {
    //DEBUG ("anyadida=--%s--", stcmd);                            
    PilaCmds.Add(stcmd); 
    //vuelcaPila();      
    }
  }

/*Devuelve el comando back correspondiente a este pageid*/  
/*La pila va desde 0 a PilaCmds.Count () - 1*/
const char *UserOptions::getLastStringCmd (int cmdactual, const char *lang, const char *connid, bool withhtml)
  {
  TSBuffer beghtml, endhtml, linea, aconnid, stlang, ipclient, stcmd, stsubcmd, tmpfile, parm1, parm2, parm3, parm4, allparms;
  int pagprevia, aservice, cmd, otropageid, cmdcomodin, cmdcomodin2, avalidator, alastcmd;
  
  if (withhtml == true) {xstrncpy (beghtml, CSMALLBUFFER, "<A HREF=\""); xstrncpy (endhtml, CSMALLBUFFER, "\">");}
  else {initStr (beghtml); initStr (endhtml);}  
  
  sprintf (LastCmd, "%s%s/%s/mb_index/noop/%s/%s/%s/%d/%d/%d/%ld/%s", 
           beghtml, PATH_CGI, SERVICE_CCLIENT,
           lang, user.cstr(), connid, getValidator(), pageid, cmdactual, 
           thecclient->getPosListFromNumMsg(getCurrentPosition()) + 1, 
           endhtml);
  pagprevia = pageid;
  cmd = CMD_CCLIENT_MB_INDEX;
  cmdcomodin  = CMD_CCLIENT_AB_ADDFIELDS; //Uno cualquiera fijo
  cmdcomodin2 = CMD_CCLIENT_AB_ADDFIELDS; //idem  
  do
    {
    --pagprevia;
    if (pagprevia >= 0)
      {
      //Example of line
      ///cgi-bin/postman/cclient/cm_reply/noop/spa/prucor2/post.uv.es%409yg3b6xz4UodleUxr70nfbnl/1/2/101/33/
      //post.uv.es@9yg3b6xz4UodleUxr70nfbnl 1 1 117 spa 147.156.2.56 1 mg_display noop /var/postman/tmp/file0vkZJT "42" "" "" ""      
      xstrncpy (linea, CSMALLBUFFER, PilaCmds.getString(pagprevia).cstr());
      sscanf (linea, "%s %d %d %d %s %s %d %s %s %s %s %s %s %s", 
                     aconnid, &otropageid, &avalidator, &alastcmd, stlang, 
                     ipclient, &aservice, stcmd, stsubcmd, tmpfile, parm1, parm2, parm3, parm4);
      //DEBUG ("%s %s %s %s", parm1, parm2, parm3, parm4);
      sscanf (linea, "%s %d %d %d %s %s %d %s %s %s %[^]]s",      
                     aconnid, &otropageid, &avalidator, &alastcmd, stlang, 
                     ipclient, &aservice, stcmd, stsubcmd, tmpfile, allparms);
      QuitaComillas (parm1); QuitaComillas (parm2); QuitaComillas (parm3); QuitaComillas (parm4);

      cmd = TranslateCmd (aservice, stcmd);
      cmdcomodin  = CMD_CCLIENT_AB_ADDFIELDS; //Uno cualquiera fijo
      cmdcomodin2 = CMD_CCLIENT_AB_ADDFIELDS; //idem
      if (cmdactual == CMD_CCLIENT_MG_DISPLAY)          {cmdcomodin = CMD_CCLIENT_MG_DISPLAY;}
      else if (cmdactual == CMD_CCLIENT_MG_DELDISPLAY)  {cmdcomodin = CMD_CCLIENT_MG_DELDISPLAY;}
      else if (cmdactual == CMD_CCLIENT_AB_ADDFIELDS)   {cmdcomodin = CMD_CCLIENT_AB_SHOWALL; cmdcomodin2 = CMD_CCLIENT_AB_FROM_CM;}      
      else if (cmdactual == CMD_CCLIENT_AB_SHOWALL)     {cmdcomodin = CMD_CCLIENT_AB_SHOWALL; cmdcomodin2 = CMD_CCLIENT_AB_FROM_CM;}            
      else if ((cmdactual == CMD_CCLIENT_CM_SAVE)    && (thecclient->getServerProtocol() == PROTOCOL_IMAP)) {cmdcomodin = CMD_CCLIENT_CM;}
      else if ((cmdactual == CMD_CCLIENT_CM_CANCEL)  && (thecclient->getServerProtocol() == PROTOCOL_IMAP)) {cmdcomodin = CMD_CCLIENT_CM;}      
      else if ((cmdactual == CMD_CCLIENT_CM_CLEANALL)&& (thecclient->getServerProtocol() == PROTOCOL_IMAP)) {cmdcomodin = CMD_CCLIENT_CM; cmdcomodin2 = CMD_CCLIENT_CM_FORWARD;}      
      else if ((cmdactual == CMD_CCLIENT_CM_SAVE)    && (thecclient->getServerProtocol() == PROTOCOL_NNTP)) {cmdcomodin = CMD_CCLIENT_CMNNTP;}
      else if ((cmdactual == CMD_CCLIENT_CM_CANCEL)  && (thecclient->getServerProtocol() == PROTOCOL_NNTP)) {cmdcomodin = CMD_CCLIENT_CMNNTP;}      
      else if ((cmdactual == CMD_CCLIENT_CM_CLEANALL)&& (thecclient->getServerProtocol() == PROTOCOL_NNTP)) {cmdcomodin = CMD_CCLIENT_CMNNTP; cmdcomodin2 = CMD_CCLIENT_CM_FORWARD;}      
      }                                   
    }
  while (((cmd == CMD_CCLIENT_AB_ADDFIELDS) || 
          (cmd == CMD_CCLIENT_AB_SAVEENTRY) || (cmd == CMD_CCLIENT_AB_NEWENTRY) || (cmd == CMD_CCLIENT_AB_TAKEADDRESS) || 
          (cmd == CMD_CCLIENT_AB_EDITENTRY) ||
          (cmd == CMD_CCLIENT_CM_CANCEL)    || (cmd == CMD_CCLIENT_CM_CLEANALL) || (cmd == CMD_CCLIENT_CM_SAVE)        || 
          (cmd == CMD_MAIN_CONF_ACT)     ||
          (cmd == CMD_CCLIENT_MB_EXPUNGE)   || 
          (cmd == CMD_CCLIENT_AT_ERASE)     || (cmd == CMD_CCLIENT_AT_SHOW)     || (cmd == CMD_CCLIENT_AT_SAVE)        ||
          (cmd == CMD_CCLIENT_MG_DELDISPLAY)||          
          (cmd == CMD_SIEVE_FILTERS_DO)     || (cmd == CMD_SIEVE_FILTERS_CANCEL)  || (cmd == CMD_SIEVE_FILTERS_SAVE)   || (cmd == CMD_SIEVE_FILTERS_EDIT)         || 
          (cmd == CMD_SIEVE_VACATIONS_DO)   || (cmd == CMD_SIEVE_VACATIONS_CANCEL)|| (cmd == CMD_SIEVE_VACATIONS_SAVE) || 
          (cmd == CMD_CALENDAR_EVENTS_CREATE)   || (cmd == CMD_CALENDAR_EVENTS_ADD) || (cmd == CMD_CALENDAR_EVENTS_DELETE)   || (cmd == CMD_CALENDAR_EVENTS_MODIFY) ||
          (cmd == cmdcomodin)               || (cmd == cmdcomodin2) ||
          (cmd == cmdactual)) 
        && (pagprevia >= 0));
  if (pagprevia < 0) pagprevia = 0;       
  switch (cmd)
    {
    case CMD_CCLIENT_AB_FROM_CM:
      {
      sprintf (LastCmd, "%s%s/%s/ab/ab_from_cm/%s/%s/%s/%d/%d/%d/%ld/%s", 
               beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, xatoldef (parm1, 1), 
               endhtml);
      break;
      }           
    case CMD_CCLIENT_AB_SHOWALL:
      {
      sprintf (LastCmd, "%s%s/%s/ab/ab_showall/%s/%s/%s/%d/%d/%d/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, endhtml);
      break;
      }       
    case CMD_CCLIENT_CM:
      {
      sprintf (LastCmd, "%s%s/%s/cm/noop/%s/%s/%s/%d/%d/%d/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, endhtml);
      break;
      }   
    case CMD_CCLIENT_CMNNTP:
      {
      sprintf (LastCmd, "%s%s/%s/cmnntp/noop/%s/%s/%s/%d/%d/%d/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, endhtml);
      break;
      }         
    case CMD_CCLIENT_CM_FORWARD:
      {
      sprintf (LastCmd, "%s%s/%s/cm_forward/noop/%s/%s/%s/%d/%d/%d/%ld/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, xatoldef (parm1, 1), endhtml);
      break;      
      }           
    case CMD_CCLIENT_CM_REPLY:
      {
      sprintf (LastCmd, "%s%s/%s/cm_reply/noop/%s/%s/%s/%d/%d/%d/%ld/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, xatoldef (parm1, 1), endhtml);
      break;      
      }       
    case CMD_CCLIENT_CM_REPLYGROUP:
      {
      sprintf (LastCmd, "%s%s/%s/cm_replygroup/noop/%s/%s/%s/%d/%d/%d/%ld/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, xatoldef (parm1, 1), endhtml);
      break;      
      }             
    case CMD_CCLIENT_CM_REPLYALL:
      {
      sprintf (LastCmd, "%s%s/%s/cm_replyall/noop/%s/%s/%s/%d/%d/%d/%ld/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, xatoldef (parm1, 1), endhtml);
      break;      
      }             
    case CMD_CCLIENT_MG_DISPLAY: case CMD_CCLIENT_MG_DELDISPLAY:   
      {
      sprintf (LastCmd, "%s%s/%s/mg_display/noop/%s/%s/%s/%d/%d/%d/%ld/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, xatoldef (parm1, 1), endhtml);      
      break;
      }      
    case CMD_CONFIG:
      {
      sprintf (LastCmd, "%s%s/%s/config/noop/%s/%s/%s/%d/%d/%d/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, endhtml);
      break;
      }             
    case CMD_CONFIG_CCLIENT:
      {
      sprintf (LastCmd, "%s%s/%s/config_cclient/noop/%s/%s/%s/%d/%d/%d/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, endhtml);
      break;
      }                   
    case CMD_CONFIG_NNTP:
      {
      sprintf (LastCmd, "%s%s/%s/config_nntp/noop/%s/%s/%s/%d/%d/%d/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, endhtml);
      break;
      }                         
    case CMD_CONFIG_APPEARANCE:
      {
      sprintf (LastCmd, "%s%s/%s/config_appearance/noop/%s/%s/%s/%d/%d/%d/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, endhtml);
      break;
      }                               
    case CMD_SIEVE_FILTERS_SHOW:
      {
      sprintf (LastCmd, "%s%s/%s/filters_show/noop/%s/%s/%s/%d/%d/%d/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, endhtml);
      break;
      }             
    case CMD_SIEVE_VACATIONS_SHOW:
      {
      sprintf (LastCmd, "%s%s/%s/config/noop/%s/%s/%s/%d/%d/%d/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, endhtml);
      break;
      }                   
    case CMD_CALENDAR_YEAR_SHOW:
      {
      sprintf (LastCmd, "%s%s/%s/year_show/noop/%s/%s/%s/%d/%d/%d/%ld/%ld/%ld/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, xatoldef (parm1, 1), xatoldef (parm2, 1), xatoldef (parm3, 1), 
               endhtml);
      break;      
      }           
    case CMD_CALENDAR_MONTH_SHOW:
      {
      sprintf (LastCmd, "%s%s/%s/month_show/noop/%s/%s/%s/%d/%d/%d/%ld/%ld/%ld/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, xatoldef (parm1, 1), xatoldef (parm2, 1), xatoldef (parm3, 1), 
               endhtml);
      break;      
      }          
    case CMD_CALENDAR_DAY_SHOW:
      {
      sprintf (LastCmd, "%s%s/%s/day_show/noop/%s/%s/%s/%d/%d/%d/%ld/%ld/%ld/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, xatoldef (parm1, 1), xatoldef (parm2, 1), xatoldef (parm3, 1), 
               endhtml);
      break;      
      }          
    case CMD_CALENDAR_WEEK_SHOW:
      {
      sprintf (LastCmd, "%s%s/%s/week_show/noop/%s/%s/%s/%d/%d/%d/%ld/%ld/%ld/%ld/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, xatoldef (parm1, 1), xatoldef (parm2, 1), xatoldef (parm3, 1),  xatoldef (parm4, 1),
               endhtml);
      break;      
      }                
    case CMD_MAIN_ROOT:
      {
      sprintf (LastCmd, "%s%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, endhtml);
      break;
      }       
    case CMD_CCLIENT_AB: case CMD_CCLIENT_MB_INDEX: case CMD_CCLIENT_MB_SHOW:  
    default:
      {
      break;
      }  
    }         
  if ((cmdactual == CMD_CONFIG_NNTP_SAVE) || (cmdactual == CMD_CONFIG_CANCEL) ||
      (cmdactual == CMD_CONFIG_NNTP_SEARCH))
      {
      sprintf (LastCmd, "%s%s/%s/op/noop/%s/%s/%s/%d/%d/%d/%ld/%s", beghtml, PATH_CGI, TranslateServiceR(aservice), stlang,
               user.cstr(), connid, avalidator, otropageid, cmdactual, xatoldef (parm1, 1), endhtml);      
      }      
  return LastCmd;                
  }  

  
  
