                                  
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "Config.h"

#include "cgi-llist.h"
#include "cgi-lib.h"

extern char **environ;

/* symbol table for CGI encoding */
#define _NAME 0
#define _VALUE 1

short accept_image(void)
{
  if (strstr(HTTP_ACCEPT(),"image") == NULL)
    return 0;
  else
    return 1;
}

char *newstr(const char *str)
  {
  char *tempstr = (char *)malloc(sizeof(char) * strlen(str) + 1);
  if (tempstr != NULL) strncpy(tempstr,str, strlen(str)+1);
  return tempstr;
  }

char *substr(char *str, int offset, int len)
  {
  int slen, start, i;
  char *nstr;

  if (str == NULL) return NULL;
  else slen = strlen(str);
  nstr = (char *)malloc(sizeof(char) * slen + 1);
  if (offset >= 0) start = offset;
  else start = slen + offset - 1;
  if ( (start < 0) || (start > slen) ) /* invalid offset */ return NULL;
  for (i = start; i < start+len; i++) nstr[i - start] = str[i];
  nstr[len] = '\0';
  return nstr;
  }

char *replace_ltgt(char *str)
  {
  unsigned int i,j = 0;
  char *newstring;

  if (str == NULL) return NULL;
  newstring = (char *)malloc(sizeof(char) * (strlen(str) * 4 + 1));
  for (i = 0; i < strlen(str); i++) 
    {
    if (str[i] == '<') 
      {
      newstring[j] = '&';
      newstring[j+1] = 'l';
      newstring[j+2] = 't';
      newstring[j+3] = ';';
      j += 3;
      }
    else 
      if (str[i] == '>') 
        {
        newstring[j] = '&';
        newstring[j+1] = 'g';
        newstring[j+2] = 't';
        newstring[j+3] = ';';
        j += 3;
        }
      else
        newstring[j] = str[i];
    j++;
    }
  newstring[j] = '\0';
  return newstring;
  }

char *lower_case(char *buffer)
  {
  char *tempstr = buffer;
  while (*buffer != '\0') 
    {
    if (isupper(*buffer))
      *buffer = tolower(*buffer);
    buffer++;
    }
  return tempstr;
  }

/* x2c() and unescape_url() stolen from NCSA code */
char x2c(char *what)
{
  register char digit;

  digit = (what[0] >= 'A' ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
  digit *= 16;
  digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));
  return(digit);
}

void unescape_url(char *url)
{
  register int x,y;

  for (x=0,y=0; url[y]; ++x,++y) {
    if((url[x] = url[y]) == '%') {
      url[x] = x2c(&url[y+1]);
      y+=2;
    }
  }
  url[x] = '\0';
}

char *get_DEBUG(void)
{
  int bufsize = 1024;
  char *buffer = (char *)malloc(sizeof(char) * bufsize + 1);
  int i = 0;
  char ch;

  fprintf(stderr,"\n--- cgihtml Interactive Mode ---\n");
  fprintf(stderr,"Enter CGI input string.  Remember to encode appropriate ");
  fprintf(stderr,"characters.\nPress ENTER when done:\n\n");
  while ( (i<=bufsize) && ((ch = getc(stdin)) != '\n') ) {
    buffer[i] = ch;
    i++;
    if (i>bufsize) {
      bufsize *= 2;
      buffer = (char *)realloc(buffer,bufsize);
    }
  }
  buffer[i] = '\0';
  fprintf(stderr,"\n Input string: %s\nString length: %d\n",buffer,i);
  fprintf(stderr,"--- end cgihtml Interactive Mode ---\n\n");
  return buffer;
}

char *get_POST(void)
{
  unsigned int content_length;
  char *buffer = NULL;

  if (CONTENT_LENGTH != NULL) {
    content_length = atoi(CONTENT_LENGTH());
    buffer = (char *)malloc(sizeof(char) * content_length + 1);
    if (fread(buffer,sizeof(char),content_length,stdin) != content_length) {
      /* consistency error. */
      fprintf(stderr,"caught by cgihtml: input length < CONTENT_LENGTH\n");
      exit(1);
    }
    buffer[content_length] = '\0';
  }
  return buffer;
}

char *get_GET(void)
{
  char *buffer;   

  if (QUERY_STRING() == NULL) return NULL;
  buffer = newstr(QUERY_STRING());
  return buffer;
}

int parse_CGI_encoded(llist *entries, char *buffer)
{
  int i, j, num, token;
  int len = strlen(buffer);
  char *lexeme = (char *)malloc(sizeof(char) * len + 1);
  entrytype entry;
  node *window;

  list_create(entries);
  window = entries->head;
  entry.name = NULL;
  entry.value = NULL;
  i = 0;
  num = 0;
  token = _NAME;
  while (i < len) {
    j = 0;
    while ( (buffer[i] != '=') && (buffer[i] != '&') && (i < len) ) {
      lexeme[j] = (buffer[i] == '+') ? ' ' : buffer[i];
      i++;
      j++;
    }
    lexeme[j] = '\0';
    if (token == _NAME) {
      entry.name = newstr(lexeme);
      unescape_url(entry.name);
      if ( (buffer[i] != '=') || (i == len - 1) ) {
        entry.value = (char *)malloc(sizeof(char));
        strncpy (entry.value, "", 1);
        window = list_insafter(entries, window, entry);
        free(entry.name);
        entry.name = NULL;
        free(entry.value);
        entry.value = NULL;
        if (i == len - 1) /* null value at end of expression */
          num++;
        else { /* error in expression */
          free(lexeme);
          return -1;
        }
      }
      else
        token = _VALUE;
    }
    else {
      entry.value = newstr(lexeme);
      unescape_url(entry.value);
      window = list_insafter(entries, window, entry);
      free(entry.name);
      entry.name = NULL;
      free(entry.value);
      entry.value = NULL;
      token = _NAME;
      num++;
    }
    i++;
    j = 0;
  }
  free(lexeme);
  if (entry.name != NULL)
    free(entry.name);
  if (entry.value != NULL)
    free(entry.value);
  return num;
}

/* stolen from k&r and seriously modified to do what I want */

int getline(char s[], int lim)
{
  int c = 0, i=0, num;

  for (i=0; (i<lim) && ((c=getchar())!=EOF) && (c!='\n'); i++) {
    s[i] = c;
  }
  if (c == '\n') {
    s[i] = c;
  }
  if ((i==0) && (c!='\n'))
    num = 0;
  else if (i == lim)
    num = i;
  else
    num = i+1;
  return num;
}

int parse_form_encoded(llist* entries, char *UPLOADBASEDIRATTACHS)
  {
  long content_length, MAXUPLOADFILE;
  entrytype entry;
  node* window;
  FILE *uploadfile = NULL;
  char *uploadfname = NULL, *tempstr, *boundary;
  char *buffer = (char *)malloc(sizeof(char) * BUFSIZ + 1);
  char *prevbuf = (char *)malloc(sizeof(char) + BUFSIZ + 1);
  short isfile,done,start;
  int i,j,kk;
  int bytesread, prevbytesread = 0;
  int buffersize;
  int numentries = 0;
  char user[21], imapserver[201], *pos;

  if (CONTENT_LENGTH() != NULL) content_length = atol(CONTENT_LENGTH());
  else return 0;
  
  
  //get boundary
  tempstr = newstr(CONTENT_TYPE());
  boundary = strstr(tempstr,"boundary=");
  boundary += (sizeof(char) * 9);
  //create list
  list_create(entries);
  window = entries->head;
  //ignore first boundary; this isn't so robust; improve it later
  getline(buffer,BUFSIZ);
  //now start parsing
  while ((bytesread=getline(buffer,BUFSIZ)) != 0) 
    {
    start = 1;
    // this assumes that buffer contains no binary characters. if the buffer contains the first valid header, then this
    // is a safe assumption.  however, it should be improved for robustness sake.
    buffer[bytesread] = '\0';
    tempstr = newstr(buffer);
    tempstr += (sizeof(char) * 38); // 38 is header up to name
    entry.name = tempstr;
    entry.value = (char *)malloc(sizeof(char) * BUFSIZ + 1);
    buffersize = BUFSIZ;
    strncpy (entry.value, "", 1);
    while (*tempstr != '"') tempstr++;
    *tempstr = '\0';
    //fprintf (stderr, "--%s--\n", buffer);
    if (strstr(buffer,"filename=\"") != NULL) 
      {
      isfile = 1;
      tempstr = newstr(buffer);
      tempstr = strstr(tempstr,"filename=\"");
      tempstr += (sizeof(char) * 10);
      if (strlen(tempstr) >= BUFSIZ) entry.value = (char *) realloc(entry.value, sizeof(char) * strlen(tempstr)+1);
      entry.value = tempstr;
      while (*tempstr != '"') tempstr++;
      *tempstr = '\0';
      // Netscape's Windows browsers handle paths differently from its UNIX and Mac browsers.  It delivers a full path for the uploaded
      // file (which it shouldn't do), and it uses backslashes rather than forward slashes.  No need to worry about Internet Explorer, since
      // it doesn't support HTTP File Upload at all.
      if (strstr(lower_case((char *)HTTP_USER_AGENT()),"win") != 0) 
        {  
        tempstr = strrchr(entry.value, '\\');
        if (tempstr) 
          {
          tempstr++;
          entry.value = tempstr;
          }
        }
      window = list_insafter(entries,window,entry);
      numentries++;
      
      //DEBUG AGUSTIN
      //fprintf (stderr, "CGI=--%s--\n", cgi_val(*entries, "service"));
      if (strcasecmp (cgi_val(*entries, "service"), "filebrowser") == 0) MAXUPLOADFILE = FILEBROWSER_MAXUPLOADFILE;
      else MAXUPLOADFILE = MAXLONGATT;
      if (content_length > MAXUPLOADFILE) return -100;
      //fprintf (stderr, "--%d--%d--\n", content_length, MAXUPLOADFILE);
      
      if (cgi_val(*entries, "user") != NULL) strncpy (user, cgi_val(*entries, "user"), 20); else strncpy (user, "DEFAULTUSER", 20);                                              
      if (cgi_val(*entries, "connid") != NULL) 
        {
        strncpy (imapserver, cgi_val(*entries, "connid"), 200);
        pos = strstr (imapserver, "@");
        if (pos == NULL) {strcpy (imapserver, "xx.xx");}
        else {kk = pos - imapserver; imapserver [kk] = '\0';}
        }
      else strncpy (imapserver, "xx.xx", 20); 
      uploadfname = (char *) malloc (strlen(UPLOADBASEDIRATTACHS) + strlen(user) + strlen(imapserver) + strlen(entry.value) + 100);
      //
      sprintf(uploadfname, "%s/users/%s/%c%c/%s/attachs/%s", UPLOADBASEDIRATTACHS, imapserver, user[0], user[1], user, entry.value);
      //
      //AGUSTIN
      //fprintf (stderr, "--%s--\n", uploadfname);
      //
      uploadfile = fopen(uploadfname,"w");
      if (uploadfile == NULL) 
        {
        //fprintf (stderr, "--AQUI--\n");
        //null filename; for now, just don't save info.  later, save to default file
        isfile = 0;
        }
      }
    else isfile = 0;
    
    //ignore rest of headers and first blank line
    while (getline(buffer, BUFSIZ) > 1) 
      {
      //DOS style blank line?
      if ((buffer[0] == '\r') && (buffer[1] == '\n')) break;
      }
    done = 0;
    j = 0;
    while (!done) 
      {
      bytesread = getline(buffer,BUFSIZ);
      buffer[bytesread] = '\0';
      if (bytesread && strstr(buffer,boundary) == NULL) 
        {
        if (start) 
          {
          i = 0;
          while (i < bytesread) 
            {
            prevbuf[i] = buffer[i];
            i++;
            }
          prevbytesread = bytesread;
          start = 0;
          }
        else 
          {
          //flush buffer
          i = 0;
          while (i < prevbytesread) 
            {
            if (isfile) fputc(prevbuf[i],uploadfile);
            else 
              {
              if (j > buffersize) 
                {
                buffersize += BUFSIZ;
                entry.value = (char *) realloc(entry.value, sizeof(char) * buffersize+1);
                }
              entry.value[j] = prevbuf[i];
              j++;
              }
            i++;
            }
          //buffer new input
          i = 0;
          while (i < bytesread) 
            {
            prevbuf[i] = buffer[i];
            i++;
            }
          prevbytesread = bytesread;
          }
        }
      else 
        {
        done = 1;
        //flush buffer except last two characters
        i = 0;
        while (i < prevbytesread - 2) 
          {
          if (isfile) fputc(prevbuf[i],uploadfile);
          else 
            {
            if (j > buffersize) 
              {
              buffersize += BUFSIZ;
              entry.value = (char *) realloc(entry.value, sizeof(char) * buffersize+1);
              }
            entry.value[j] = prevbuf[i];
            j++;
            }
          i++;
          }
        }
      }
    if (isfile) 
      {
      fclose(uploadfile);
      if (uploadfname != NULL) chmod (uploadfname, S_IRGRP | S_IWGRP | S_IRUSR | S_IWUSR);
      }
    else 
      {
      entry.value[j] = '\0';
      window = list_insafter(entries,window,entry);
      numentries++;
      j = 0;
      }
    }
  return numentries;
  }

int read_cgi_input(llist* entries, char *UPLOADBASEDIRATTACHS)
{
  char *input;
  int status;

  /* check for form upload.  this needs to be first, because the
     standard way of checking for POST data is inadequate.  If you
     are uploading a 100 MB file, you are unlikely to have a buffer
     in memory large enough to store the raw data for parsing.
     Instead, parse_form_encoded parses stdin directly.
     In the future, I may modify parse_CGI_encoded so that it also
     parses POST directly from stdin.  I'm undecided on this issue,
     because doing so will make parse_CGI_encoded less general. */

  if ((CONTENT_TYPE() != NULL) && (strstr(CONTENT_TYPE(), "multipart/form-data") != NULL))
    {
    //AQUI ES DONDE COGE EL FICHERO UPLOADADO
    //fprintf (stderr, "--%s--\n", UPLOADBASEDIRATTACHS);
    return parse_form_encoded(entries, UPLOADBASEDIRATTACHS);
    }

  /* get the input */
  if (REQUEST_METHOD == NULL)
    {
    input = get_DEBUG();
    }
  else if (!strcmp(REQUEST_METHOD(),"POST"))
    {
    input = get_POST();
    }
  else if (!strcmp(REQUEST_METHOD(),"GET"))
    {
    input = get_GET();
    }
  else if (!strcmp(REQUEST_METHOD(),"HEAD"))
    {
    //fprintf (stderr, "Called HEAD\n");
    input = get_GET();
    }    
  else 
    { 
    /* error: invalid request method */
    fprintf(stderr,"caught by cgihtml: REQUEST_METHOD invalid\n");
    exit(1);
    }

  /* parse the input */
  if (input == NULL)
    {
    return 0;
    }
  status = parse_CGI_encoded(entries,input);
  free(input);  
  return status;
  }

char *cgi_val(llist l, char *name)
{
  short FOUND = 0;
  node* window;

  window = l.head;
  while ((window != 0) && (!FOUND))
    {
    if (!strcmp(window->entry.name,name))
      FOUND = 1;
    else
      window = window->next;
    }
  if (FOUND)
    return window->entry.value;
  else
    return NULL;
}

/* cgi_val_multi - contributed by Mitch Garnaat <garnaat@wrc.xerox.com>;
   modified by me */

char **cgi_val_multi(llist l, char *name)
{
  short FOUND = 0;
  node* window;
  char **ret_val = 0;
  int num_vals = 0, i;

  window = l.head;
  while (window != 0) {
    if (!strcmp(window->entry.name,name)) {
      FOUND = 1;
      num_vals++;
    }
    window = window->next;
  }
  if (FOUND) {
    /* copy the value pointers into the returned array */
    ret_val = (char**) malloc(sizeof(char*) * (num_vals + 1));
    window = l.head;
    i = 0;
    while (window != NULL) {
      if (!strcmp(window->entry.name,name)) {
        ret_val[i] = window->entry.value;
        i++;
      }
      window = window->next;
    }
    /* NULL terminate the array */
    ret_val[i] = 0;
    return ret_val;
  }
  else
    return NULL;
}

char *cgi_name(llist l, char *value)
{
  short FOUND = 0;
  node* window;

  window = l.head;
  while ( (window != 0) && (!FOUND) )
    if (!strcmp(window->entry.value,value))
      FOUND = 1;
    else
      window = window->next;
  if (FOUND)
    return window->entry.name;
  else
    return NULL;
}

char **cgi_name_multi(llist l, char *value)
{
  short FOUND = 0;
  node* window;
  char **ret_val = 0;
  int num_vals = 0, i;

  window = l.head;
  while (window != 0) {
    if (!strcmp(window->entry.value,value)) {
      FOUND = 1;
      num_vals++;
    }
    window = window->next;
  }
  if (FOUND) {
    /* copy the value pointers into the returned array */
    ret_val = (char**) malloc(sizeof(char*) * (num_vals + 1));
    window = l.head;
    i = 0;
    while (window != NULL) {
      if (!strcmp(window->entry.value,value)) {
        ret_val[i] = window->entry.name;
        i++;
      }
      window = window->next;
    }
    /* NULL terminate the array */
    ret_val[i] = 0;
    return ret_val;
  }
  else
    return NULL;
}

/* miscellaneous useful CGI routines */

int parse_cookies(llist *entries)
  {
  char *cookies = getenv("HTTP_COOKIE");
  node* window;
  entrytype entry;
  int i,len;
  int j = 0;
  int numcookies = 0;
  short NM = 1;

  if (cookies == NULL) return 0;
  list_create(entries);
  window = entries->head;
  len = strlen(cookies);
  entry.name = (char *)malloc(sizeof(char) * len + 1);
  entry.value = (char *)malloc(sizeof(char) * len + 1);
  for (i = 0; i < len; i++) 
    {
    if (cookies[i] == '=') 
      {
      entry.name[j] = '\0';
      if (i == len - 1) 
        {
        strncpy (entry.value, "", 1);
        window = list_insafter(entries,window,entry);
        numcookies++;
        }
      j = 0;
      NM = 0;
      }
    else if ( (cookies[i] == '&') || (i == len - 1) ) 
      {
      if (!NM) 
        {
        if (i == len - 1) 
          {
          entry.value[j] = cookies[i];
          j++;
          }
        entry.value[j] = '\0';
        window = list_insafter(entries,window,entry);
        numcookies++;
        j = 0;
        NM = 1;
        }
      }
    else if ( (cookies[i] == ';') || (i == len - 1) ) 
      {
      if (!NM) 
        {
        if (i == len - 1) 
          {
          entry.value[j] = cookies[i];
          j++;
          }
        entry.value[j] = '\0';
        window = list_insafter(entries,window,entry);
        numcookies++;
        i++;   /* erases trailing space */
        j = 0;
        NM = 1;
        }
      }
    else if (NM) 
      {
      entry.name[j] = cookies[i];
      j++;
      }
    else if (!NM) 
      {
      entry.value[j] = cookies[i];
      j++;
      }
    }
  return numcookies;
  }

void print_cgi_env(void)
{
  if (SERVER_SOFTWARE() != NULL)
    printf("<p>SERVER_SOFTWARE = %s<br>\n",SERVER_SOFTWARE());
  if (SERVER_NAME() != NULL)
    printf("SERVER_NAME = %s<br>\n",SERVER_NAME());
  if (GATEWAY_INTERFACE() !=NULL)
    printf("GATEWAY_INTERFACE = %s<br>\n",GATEWAY_INTERFACE());
  if (SERVER_PROTOCOL() != NULL)
    printf("SERVER_PROTOCOL = %s<br>\n",SERVER_PROTOCOL());
  if (SERVER_PORT() != NULL)
    printf("SERVER_PORT = %s<br>\n",SERVER_PORT());
  if (REQUEST_METHOD() != NULL)
    printf("REQUEST_METHOD = %s<br>\n",REQUEST_METHOD());
  if (PATH_INFO() != NULL)
    printf("PATH_INFO = %s<br>\n",PATH_INFO());
  if (PATH_TRANSLATED() != NULL)
    printf("PATH_TRANSLATED = %s<br>\n",PATH_TRANSLATED());
  if (SCRIPT_NAME() != NULL)
    printf("SCRIPT_NAME = %s<br>\n",SCRIPT_NAME());
  if (QUERY_STRING() != NULL)
    printf("QUERY_STRING = %s<br>\n",QUERY_STRING());
  if (REMOTE_HOST() != NULL)
    printf("REMOTE_HOST = %s<br>\n",REMOTE_HOST());
  if (REMOTE_ADDR() != NULL)
    printf("REMOTE_ADDR = %s<br>\n",REMOTE_ADDR());
  if (AUTH_TYPE() != NULL)
    printf("AUTH_TYPE = %s<br>\n",AUTH_TYPE());
  if (REMOTE_USER() != NULL)
    printf("REMOTE_USER = %s<br>\n",REMOTE_USER());
  if (REMOTE_IDENT() != NULL)
    printf("REMOTE_IDENT = %s<br>\n",REMOTE_IDENT());
  if (CONTENT_TYPE() != NULL)
    printf("CONTENT_TYPE = %s<br>\n",CONTENT_TYPE());
  if (CONTENT_LENGTH() != NULL)
    printf("CONTENT_LENGTH = %s<br></p>\n",CONTENT_LENGTH());
  if (HTTP_USER_AGENT() != NULL)
    printf("HTTP_USER_AGENT = %s<br></p>\n",HTTP_USER_AGENT());
}

void print_entries(llist l)
{
  node* window;

  window = l.head;
  printf("<dl>\n");
  while (window != NULL) {
    printf("  <dt> <b>%s</b>\n",window->entry.name);
    printf("  <dd> %s\n",replace_ltgt(window->entry.value));
    window = window->next;
  }
  printf("</dl>\n");
}

char *escape_input(char *str)
/* takes string and escapes all metacharacters.  should be used before
   including string in system() or similar call. */
{
  unsigned int i,j = 0;
  char *newstring = (char *)malloc(sizeof(char) * (strlen(str) * 2 + 1));

  for (i = 0; i < strlen(str); i++) {
    if (!( ((str[i] >= 'A') && (str[i] <= 'Z')) ||
           ((str[i] >= 'a') && (str[i] <= 'z')) ||
           ((str[i] >= '0') && (str[i] <= '9')) )) {
      newstring[j] = '\\';
      j++;
    }
    newstring[j] = str[i];
    j++;
  }
  newstring[j] = '\0';
  return newstring;
}

/* boolean functions */

short is_form_empty(llist l)
{
  node* window;
  short EMPTY = 1;

  window = l.head;
  while ( (window != NULL) && (EMPTY == 1) ) {
    if (strcmp(window->entry.value,""))
      EMPTY = 0;
    window = window->next;
  }
  return EMPTY;
}

short is_field_exists(llist l, char *str)
{
  if (cgi_val(l,str) == NULL)
    return 0;
  else
    return 1;
}

/* is_field_empty returns true either if the field exists but is empty
   or if the field does not exist. */
short is_field_empty(llist l, char *str)
{
  char *temp = cgi_val(l,str);

  if ( (temp == NULL) || (!strcmp(temp,"")) )
    return 1;
  else
    return 0;
}

const char *env2file (llist l, const char *linea_separadora)
  {
  char *pc, *pc2;
  node* window;
  int i;
  char fnenv[501];
  FILE *fw;
  strncpy (fnenv, tempnam(TMP, NULL), 500);
  fw = fopen (fnenv, "w");

  //First, we print all the cgi environment variables
  for (i = 0; environ[i] != NULL; i++) 
    {
    pc = strstr (environ[i], "=");
    if (pc != NULL)
      {
      pc2 = environ[i];
      if (i == 0) fprintf (fw, "%s=", linea_separadora); else fprintf (fw, "\n%s=", linea_separadora);
      while (pc2 != pc) {fprintf (fw, "%c", pc2[0]); ++pc2;}
      fprintf (fw, "\n%s", pc + 1);
      }
    else
      {
      fprintf (fw, "%s=%s\n\n", linea_separadora, environ[i]);
      }
    }

  //One separator line 
  fprintf(fw, "\n%s", SEPLINE_ENV_INPUT);    

  //Now we print the input cgi variables
  window = l.head;
  while (window != NULL) 
    {
    fprintf(fw, "\n%s=%s", linea_separadora, window->entry.name);
    fprintf(fw, "\n%s", window->entry.value);
    window = window->next;
    }
  fprintf (fw, "\n%s=LAST_LINE\n", linea_separadora);
  fclose (fw);           
  return strdup(fnenv);
  }

const char *SERVER_SOFTWARE (void) 
  {
  ENVVAR xSERVER_SOFTWARE;
  if (getenv("SERVER_SOFTWARE") == NULL) return NULL;
  strncpy (xSERVER_SOFTWARE, getenv("SERVER_SOFTWARE"), CMAXENVVAR);
  return newstr(xSERVER_SOFTWARE);
  }

const char *SERVER_NAME (void)
  {
  ENVVAR xSERVER_NAME;
  if (getenv("SERVER_NAME") == NULL) return NULL;
  strncpy (xSERVER_NAME, getenv("SERVER_NAME"), CMAXENVVAR);
  return newstr (xSERVER_NAME);
  }

const char *GATEWAY_INTERFACE (void)
  {
  ENVVAR xGATEWAY_INTERFACE;
  if (getenv("GATEWAY_INTERFACE") == NULL) return NULL;
  strncpy (xGATEWAY_INTERFACE, getenv("GATEWAY_INTERFACE"), CMAXENVVAR);
  return newstr (xGATEWAY_INTERFACE);
  }

const char *SERVER_PROTOCOL (void)
  {
  ENVVAR xSERVER_PROTOCOL;
  if (getenv("SERVER_PROTOCOL") == NULL) return NULL;
  strncpy (xSERVER_PROTOCOL, getenv("SERVER_PROTOCOL"), CMAXENVVAR);
  return newstr (xSERVER_PROTOCOL);
  }

const char *SERVER_PORT (void)
  {
  ENVVAR xSERVER_PORT;
  if (getenv("SERVER_PORT") == NULL) return NULL;
  strncpy (xSERVER_PORT, getenv("SERVER_PORT"), CMAXENVVAR);
  return newstr( xSERVER_PORT);
  }

const char *REQUEST_METHOD (void)
  {
  ENVVAR xREQUEST_METHOD;
  if (getenv("REQUEST_METHOD") == NULL) return NULL;
  strncpy (xREQUEST_METHOD, getenv("REQUEST_METHOD"), CMAXENVVAR);
  return newstr (xREQUEST_METHOD);
  }

const char *PATH_INFO (void)
  {
  ENVVAR xPATH_INFO;
  if (getenv("PATH_INFO") == NULL) return NULL;
  strncpy (xPATH_INFO, getenv("PATH_INFO"), CMAXENVVAR);
  return newstr (xPATH_INFO);
  }

const char *PATH_TRANSLATED (void)
  {
  ENVVAR xPATH_TRANSLATED;
  if (getenv("PATH_TRANSLATED") == NULL) return NULL;
  strncpy (xPATH_TRANSLATED, getenv("PATH_TRANSLATED"), CMAXENVVAR);
  return newstr (xPATH_TRANSLATED);
  }

const char *SCRIPT_NAME (void)
  {
  ENVVAR xSCRIPT_NAME;
  if (getenv("SCRIPT_NAME") == NULL) return NULL;
  strncpy (xSCRIPT_NAME, getenv("SCRIPT_NAME"), CMAXENVVAR);
  return newstr (xSCRIPT_NAME);
  }

const char *QUERY_STRING (void)
  {
  ENVVAR xQUERY_STRING;
  if (getenv("QUERY_STRING") == NULL) return NULL;
  strncpy (xQUERY_STRING, getenv("QUERY_STRING"), CMAXENVVAR);
  return newstr (xQUERY_STRING);
  }

const char *REMOTE_HOST (void)
  {
  ENVVAR xREMOTE_HOST;
  if (getenv("REMOTE_HOST") == NULL) return NULL;
  strncpy (xREMOTE_HOST, getenv("REMOTE_HOST"), CMAXENVVAR);
  return newstr (xREMOTE_HOST);
  }

const char *REMOTE_ADDR (void)
  {
  ENVVAR xREMOTE_ADDR;
  if (getenv("REMOTE_ADDR") == NULL) return NULL;
  strncpy (xREMOTE_ADDR, getenv("REMOTE_ADDR"), CMAXENVVAR);
  return newstr (xREMOTE_ADDR);
  }

const char *AUTH_TYPE (void)
  {
  ENVVAR xAUTH_TYPE;
  if (getenv("AUTH_TYPE") == NULL) return NULL;
  strncpy (xAUTH_TYPE, getenv("AUTH_TYPE"), CMAXENVVAR);
  return newstr (xAUTH_TYPE);
  }

const char *REMOTE_USER (void)
  {
  ENVVAR xREMOTE_USER;
  if (getenv("REMOTE_USER") == NULL) return NULL;
  strncpy (xREMOTE_USER, getenv("REMOTE_USER"), CMAXENVVAR);
  return newstr (xREMOTE_USER);
  }

const char *REMOTE_IDENT (void)
  {
  ENVVAR xREMOTE_IDENT;
  if (getenv("REMOTE_IDENT") == NULL) return NULL;
  strncpy (xREMOTE_IDENT, getenv("REMOTE_IDENT"), CMAXENVVAR);
  return newstr (xREMOTE_IDENT);
  }

const char *CONTENT_TYPE (void)
  {
  ENVVAR xCONTENT_TYPE;
  if (getenv("CONTENT_TYPE") == NULL) return NULL;
  strncpy (xCONTENT_TYPE, getenv("CONTENT_TYPE"), CMAXENVVAR);
  return newstr (xCONTENT_TYPE);
  }

const char *CONTENT_LENGTH (void)
  {
  ENVVAR xCONTENT_LENGTH;
  if (getenv("CONTENT_LENGTH") == NULL) return NULL;
  strncpy (xCONTENT_LENGTH, getenv("CONTENT_LENGTH"), CMAXENVVAR);
  return newstr (xCONTENT_LENGTH);
  }

const char *HTTP_USER_AGENT (void)
  {
  ENVVAR xHTTP_USER_AGENT;
  if (getenv("HTTP_USER_AGENT") == NULL) return NULL;
  strncpy (xHTTP_USER_AGENT, getenv("HTTP_USER_AGENT"), CMAXENVVAR);
  return newstr (xHTTP_USER_AGENT);
  }

const char *HTTP_ACCEPT (void)
  {
  ENVVAR xHTTP_ACCEPT;
  if (getenv("HTTP_ACCEPT") == NULL) return NULL;
  strncpy (xHTTP_ACCEPT, getenv("HTTP_ACCEPT"), CMAXENVVAR);
  return newstr (xHTTP_ACCEPT);
  }


