/*****
*
* Copyright (C) 1998 - 2000 Yoann Vandoorselaere <yoann@prelude-ids.org>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef PLUGIN_DETECT_H

#define PLUGIN_DETECT_H

#include <libprelude/list.h>


typedef struct {
        proto_enum_t type;  /* protocol the plugin want */
        const char *filter; /* PF rule */
} subscribtion_t;



typedef struct {
        PLUGIN_GENERIC;
        int (*opt)(int argc, char **argv);
        void (*run)(packet_container_t *packet);
        subscribtion_t *subscribtion;

        /*
         * entry filled by Prelude.
         */
        unsigned int id;
} plugin_detect_t;

#define plugin_subscribtion(p) (p)->subscribtion
#define plugin_run_func(p) (p)->run

#define plugin_set_subscribtion(p, s) plugin_subscribtion(p) = (s)
#define plugin_set_running_func(p, func) plugin_run_func(p) = (func)


/*
 * Theses definitions are for Prelude internal API.
 */
void detect_plugins_run(packet_container_t *packet, struct list_head *list, char *proto);

int detect_plugins_init(const char *dirname, int argc, char **argv);

void detect_plugins_stats(void);

void detect_plugins_help(void);



/*
 * Plugin initialisation function.
 */
plugin_generic_t *plugin_init(int argc, char **argv);


#endif
    
