/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: htmlnode.h,v $
 * Revision 1.1.1.1  2001/01/30 18:36:51  slash
 * Initial release.
 *
 */

#ifndef HTMLNODE_H
#define HTMLNODE_H

#include "node.h"

//---------------------------------------------------------------------------
/**
 * This class represents a HTML-node.
 */
class HTMLNode : public Node { 
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the HTML-node.
     */
    HTMLNode(xmlNodePtr node);

    //-----------------------------------------------------------------------
    /**
     * Destructor
     */
    ~HTMLNode();


    //-----------------------------------------------------------------------
    /**
     * This method does nothing, because the HTML-node doesn't need to be
     * written as HTML.
     *
     * @param parameter A dummy-parameter.
     */
    void writeHTML(int parameter = 0) const;

    //-----------------------------------------------------------------------
    /**
     * This method does nothing, because the HTML-node doesn't need to be
     * written as LaTeX.
     */
    void writeLaTeX() const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be XML.
     */       
    void writeXML() const;
};

#endif //HTMLNODE_H
