#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <assert.h>
#include "except.h"


/*****************************************************************/
/* This function parses the exception string and adds all of the */
/* exceptions to the proper place in the exception table.  A '.' */
/* is used to separate octets.  Numbers are separated by any non */
/* digit other than the '.', which has special meaning.          */
/*****************************************************************/
int set_exceptions(char *exp, int octet[4][256])
{
	int i, excludeind = 0, bufferind = 0, octind = 0;
	char buffer[4];

	fill(octet);
	for(i = 0; i < strlen(exp) + 1; i++)
	{
		if( isdigit(exp[i]))
		{
			buffer[bufferind] = exp[i];
			bufferind++;
			assert(bufferind != 4); /* potential overflow... */
		}
		else
		{
			if(bufferind)
			{
				buffer[bufferind] = '\0';
				octet[octind][excludeind] = atoi(buffer);
				bufferind = 0;
				excludeind++; 
			}
			
			if(exp[i] == '.')
			{
				octind++;
				excludeind = 0;
			}
		}
	}
	return(0);
}

void fill(int octet[4][256])
{
	register int i, j;
	
	for(i = 0; i < 4; i++)
		for(j = 0; j < 256; j++)
			octet[i][j] = -1;
}

/*******************************************************************/
/* Compares each octet against the list of exceptions for that     */
/* octet.  If the octet is in the list of exceptions the 'current' */
/* argument is incremented so that the 'current' variable is moved */
/* up one octet.  I hope to God this makes sense... it's late. I'm */
/* tired.                                                          */
/*******************************************************************/
int except(unsigned long *current, int octet[4][256])
{
	register int i, j;

	for(i = 0; i < 4; i++)
	{
		for(j = 0; j < 256; j++)
		{
			switch(i)
			{
			case 0:
				if(((*current & 0xff000000) >> 24) == octet[i][j])
				{
					*current += (unsigned long)pow(2, 24) -1;
					return(1);
				}
				break;
			case 1:
				if(((*current & 0x00ff0000) >> 16) == octet[i][j])
				{
					*current += (unsigned long)pow(2, 16) -1;
					return(1);
				}
				break;
			case 2:
				if(((*current & 0x0000ff00) >> 8) == octet[i][j])
				{
				    *current += (unsigned long)pow(2, 8) -1;	
                                    return(1);
				}
				break;
			case 3:
				if((*current & 0x000000ff) == octet[i][j])
                                	return(1);
				break;

			}
		}
	}
	return(0);
}


void _spil(int octet[4][256])
{
	int i, j;
	
	for(i = 0; i < 4; i++)
	{
		for(j = 0; j < 256; j++)
		{
			if(octet[i][j] == -1)
				break;
			printf("[%d, %d]: %d\n", i, j, octet[i][j]); 
		}
	}
}
