/***************************************************************************
                          libproxychains.c  -  description
                             -------------------
    begin                : Tue May 14 2002
    copyright            : (C) 2002 by Net Creature
    email                : netcreature@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <memory.h>
#include <errno.h>
#include <netdb.h>

#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/fcntl.h>
#include <pthread.h>
//#define __USE_GNU
#include <dlfcn.h>

#include "core.h"

#define     satosin(x)      ((struct sockaddr_in *) &(x))
#define     SOCKADDR(x)     (satosin(x)->sin_addr.s_addr)
#define     SOCKADDR_2(x)     (satosin(x)->sin_addr)
#define     SOCKPORT(x)     (satosin(x)->sin_port)
#define     SOCKFAMILY(x)     (satosin(x)->sin_family)
#define     MAX_CHAIN 300

extern int __connect (int sock, const struct sockaddr *addr, socklen_t len);

int tcp_read_time_out;
int tcp_connect_time_out;
chain_type proxychains_ct;
proxy_data proxychains_pd[MAX_CHAIN];
int proxychains_proxy_count=0;
int proxychains_got_chain_data=0;

#ifdef threaded_px
int (*orig_getsockopt) (int s, int level, int optname, void *optval, socklen_t *optlen)=NULL;

int thread_up=0;
int our_p_sock;
#endif

static inline void get_chain_data(
                                proxy_data *pd,
                                unsigned int *proxy_count,
                                chain_type *ct)
{


        int count=0,port_n=0,list=0;
        char buff[1024],type[1024],host[1024],user[1024];
        FILE* file;

	if(proxychains_got_chain_data)
		return;

//Some defaults
tcp_read_time_out=4*1000;
tcp_connect_time_out=10*1000;
*ct=DYNAMIC_TYPE;

        sprintf(buff,"%s/.proxychains/proxychains.conf",getenv("HOME"));

   if(!(file=fopen("./proxychains.conf","r")))
        if(!(file=fopen(buff,"r")))
                if(!(file=fopen("/etc/proxychains.conf","r")))
                {
                        perror("1");
                        exit(1);
                }

        while(fgets(buff,sizeof(buff),file))
        {

                if(buff[strspn(buff," ")]!='#')
		  {

			if(list)
			{
			   bzero(pd[count], sizeof(proxy_data));
			   pd[count].ps=PLAY_STATE;
			   port_n=0;
			   sscanf(buff,"%s %s %d %s %s", type,host,&port_n,
					pd[count].user,pd[count].pass);
                        pd[count].ip=inet_addr(host);
                        pd[count].port=htons((unsigned short)port_n);
                        if(!strcmp(type,"http")) {
                          pd[count].pt=HTTP_TYPE;
                        }else if(!strcmp(type,"socks4")) {
                          pd[count].pt=SOCKS4_TYPE;
                        }else if(!strcmp(type,"socks5")) {
                          pd[count].pt=SOCKS5_TYPE;
                        }else continue;
                        if( pd[count].ip!=INADDR_NONE && port_n)
			   	if(++count==MAX_CHAIN)break;
			 }
			else
			{
				if(strstr(buff,"[ProxyList]"))
				{
					list=1;
				}else if(strstr(buff,"RandomChain")){
					 *ct=RANDOM_TYPE;
				}else if(strstr(buff,"StrictChain")){
					 *ct=STRICT_TYPE;
	                     }else if(strstr(buff,"DynamicChain")){
					 *ct=DYNAMIC_TYPE;
				}else if(strstr(buff,"tcp_read_time_out")){
					 sscanf(buff,"%s %d",user,&tcp_read_time_out) ;
				}else if(strstr(buff,"tcp_connect_time_out")){
					 sscanf(buff,"%s %d",user,&tcp_connect_time_out) ;
				}
			}
                }
				

        }

        fclose(file);

        *proxy_count=count;
	proxychains_got_chain_data=1;
}

static inline void free_chain_data( proxy_data *pd )
{
/*
        if (*len)
        {
                free(*ip);
                *ip=NULL;
                free(*port);
                *port=NULL;
        }*/
}




#ifdef threaded_px
void * fake_non_block(void *v_arg)
{
	int ret=-1;
 	int option=0;
 	thread_arg *arg=v_arg;

  	pthread_detach(pthread_self());
       fprintf(stdout,"Started thread .... to .. %s:%d\n",
       		inet_ntoa(SOCKADDR_2(arg->addr)),
         		ntohs(SOCKPORT(arg->addr))  );fflush(stdout);
	ret=connect_proxy_chain(
                arg->sock,
                SOCKADDR(arg->addr),
                SOCKPORT(arg->addr),
                arg->pd,
                arg->proxy_count,
                arg->ct );
       if(ret==SUCCESS)
       {	
        	fcntl(arg->sock, F_SETFL, arg->flags);
	       /*
       	if(0>setsockopt(arg->sock,SOL_SOCKET,SO_ERROR,&option,sizeof(option)) )
        	{
         		perror("setsockopt set 'success'");
           	}  */
        	 fprintf(stdout,"Thread  success.... to .. %s:%d\n",
       		inet_ntoa(SOCKADDR_2(arg->addr)),
         		ntohs(SOCKPORT(arg->addr))  );fflush(stdout);
       }
       else
       {
    	     option=ECONNREFUSED;
          // setsockopt(arg->sock,SOL_SOCKET,SO_ERROR,&option,sizeof(option)) ;	
           fprintf(stdout,"Thread  error.... to .. %s:%d\n",
       		inet_ntoa(SOCKADDR_2(arg->addr)),
         		ntohs(SOCKPORT(arg->addr))  );fflush(stdout);
       }
       free(arg->pd);
       free(arg);
       thread_up=0;
       return 0;
}

int getsockopt(int s, int level, int optname, void *optval, socklen_t *optlen)
{
	if(thread_up && (s==our_p_sock) && (level==SOL_SOCKET) && (optname==SO_ERROR) )
 	{
    		printf("fake getsockopt\n");fflush(stdout);
      		*(int*)optval=EALREADY;
      		*optlen=sizeof(int);
    	}
     else
		return orig_getsockopt (s,level,optname,optval,optlen);
  return 0;
}

void my_init(void)
{
void *p;
//printf("init here");fflush(stdout);
p=dlopen("libc.so.6",RTLD_LAZY);
orig_getsockopt=dlsym(p,"getsockopt");
dlclose(p);
}
#endif

int connect (int sock, const struct sockaddr *addr, socklen_t len)
{
  int socktype=0,optlen=0,flags=0,ret=0;
  proxy_data local_pd[MAX_CHAIN];
#ifdef threaded_px
 int option,opt_size;
if(!orig_getsockopt) my_init();


  if(thread_up && (sock==our_p_sock) )
  {
     errno=EISCONN;
     return -1;
  }

#endif
  optlen=sizeof(socktype);
 // memset(pd,0,sizeof(proxy_data));


 // check if we have to set up chain
// printf("family %d : we look for %d\n",SOCKFAMILY(*addr),AF_INET);
 getsockopt(sock,SOL_SOCKET,SO_TYPE,&socktype,&optlen);
// printf("socktype %d : we look for %d\n",socktype,SOCK_STREAM);
 if (! (SOCKFAMILY(*addr)==AF_INET  && socktype==SOCK_STREAM))
             return __connect(sock,addr,len);   // we don't have to
  // get technical data about our chain
  get_chain_data(proxychains_pd,&proxychains_proxy_count,&proxychains_ct);
//  printf("trace\n");

flags=fcntl(sock, F_GETFL, 0);
//printf("flags=%d ->",fcntl(sock, F_GETFL, 0));

if(flags & O_NONBLOCK)  //  non-blocking ... lets do the trick
{
#ifndef threaded_px
      fcntl(sock, F_SETFL, !O_NONBLOCK);
#else
        pthread_t pid_tr;
        thread_arg *arg	;

        arg=malloc(sizeof(thread_arg));
        if(!arg) {
            	//option=ECONNREFUSED;
        	errno=ECONNREFUSED;
        	//setsockopt(sock,SOL_SOCKET,SO_ERROR,&option,sizeof(option)) ;
        	return -1;
        }
        arg->pd=malloc(sizeof(pd));
         if(!arg->pd) {
        	//option=ECONNREFUSED;
        	errno=ECONNREFUSED;
        	//setsockopt(sock,SOL_SOCKET,SO_ERROR,&option,sizeof(option)) ;
         	return -1;
        }
        memcpy(arg->pd,pd,sizeof(pd));
        arg->ct=ct;
        arg->proxy_count=proxy_count;
        arg->sock=sock;
        memcpy(&arg->addr,addr,sizeof(struct sockaddr));
        arg->flags=flags;

        if(0>pthread_create(&pid_tr, NULL, fake_non_block,arg))
    	  {
       	//option=ECONNREFUSED;
        	errno=ECONNREFUSED;
//         	setsockopt(sock,SOL_SOCKET,SO_ERROR,&option,sizeof(option));
         	return -1;
        }
        thread_up=1;
        our_p_sock=sock;
      //  option=EINPROGRESS;
       // if(0>setsockopt(sock,SOL_SOCKET,SO_ERROR,&option,sizeof(option)) )
       // 	        perror(" setsockopt EINPROGRESS ");
        //sleep(7);
        getsockopt(sock,SOL_SOCKET,SO_ERROR,&option,&opt_size);
        printf("option = %d\n",option);fflush(stdout);
         sleep(5);
        errno=EINPROGRESS;
        //perror("check errno");
        return -1;
#endif
}
//printf("flags=%d\n",fcntl(sock, F_GETFL, 0));


memcpy(local_pd,proxychains_pd,sizeof(proxy_data)*proxychains_proxy_count);

ret=connect_proxy_chain(
                sock,
                SOCKADDR(*addr),
                SOCKPORT(*addr),
                local_pd,
                proxychains_proxy_count,
                proxychains_ct );
//printf("flags=%d ->",fcntl(sock, F_GETFL, 0));

//if(flags & O_NONBLOCK)  //  restore origin
       fcntl(sock, F_SETFL, flags);
     // no need to restore anymore

//printf("flags=%d\n",fcntl(sock, F_GETFL, 0));
//free_chain_data(pd);
if(ret!=SUCCESS){
		//option=ECONNREFUSED;
        	errno=ECONNREFUSED;
        	/*if(0>setsockopt(sock,SOL_SOCKET,SO_ERROR,&option,sizeof(option)) )
         		         	perror ("setsockopt  ECONNREFUSED (after failed chain)");*/
   }
   return ret;
}

