#!/usr/bin/python
#-*- coding:utf-8 -*-

#    Pybik -- A 3 dimensional magic cube game.
#    Copyright © 2009, 2011  B. Clausius <barcc@gmx.de>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


from __future__ import with_statement

import sys, os, re

def main(argv):
    arg_src = argv[0]
    arg_dst = argv[1]
    if not os.path.exists(arg_src):
        print >>sys.stderr, 'error:', arg_src, 'does not exist'
        return 1
    #if os.path.exists(arg_dst):
    #    print >>sys.stderr, 'error:', arg_dst, 'already exists'
    #    return 1
    create_pxd(arg_src, arg_dst)
    return 0

def create_pxd(src_path, dst_path):
    re_pxd = re.compile(r'( *)#pxd (.*)', re.DOTALL)
    with open(src_path,'r') as srcf:
        with open(dst_path,'w') as dstf:
            for line in srcf:
                #if line.startswith('#pxd '):
                m = re_pxd.match(line)
                if m:
                    line = m.expand(r'\1\2')
                    dstf.write(line)
            
if __name__ == '__main__':
    try:
        main(sys.argv[1:])
    except:
        sys.exit(1)
    else:
        sys.exit(0)


