#
# Superclass for Pyne mailbox io formats.
#

import time
from pyneheaders import *
from pynemsg import *

class superbox:
	def get_unique_message_id(self):
		"""
		Returns a string. unique message-id for new outgoing mail/news.
		"""
		format = "<%f@localhost>"
		return format % time.time()

	def load_article(self, msg_id):
		"""
		Return message object or None if the message is not cached.
		"""
		header, body = self._load_article(msg_id)
		if header == None:
			return None
		else:
			# create new message object
			msg = pynemsg()
			msg.body = body
			msg.parseheaders(self.user)
			msg.date = header[HEAD_DATE]
			msg.date_received = header[HEAD_DATE_RECEIVED]
			msg.opts = header[HEAD_OPTS]
			msg.senduid = header[HEAD_SENDUID]
			return msg

	def save_article(self, msg_object):
		"""
		Save msg_object to the message database. Also parses and saves
		header. Requires a msg_object.headers["message-id"].
		"""
		# Fix essential missing header
		if not msg_object.headers.has_key("message-id"):
			msg_id = self.get_unique_message_id()
			msg_object.headers["message-id"] = msg_id
			msg_object.body = "Message-Id: "+msg_id+"\n"+msg_object.body
		if not msg_object.headers.has_key("subject"):
			msg_object.headers["subject"] = "<no subject>"
			
		# make cached headers
		if msg_object.headers.has_key("newsgroups"):
			if msg_object.senduid == None:
				# incoming
				from_to = msg_object.headers["from"]
			else:
				# outgoing
				from_to = msg_object.headers["newsgroups"]
		else:
			if msg_object.senduid == None:
				# incoming
				from_to = msg_object.headers["from"]
			else:
				# outgoing
				from_to = msg_object.headers["to"]
		try:
			headers = ( msg_object.date, msg_object.date_received,
				msg_object.headers["message-id"], msg_object.headers["references"],
				msg_object.headers["subject"], from_to, msg_object.opts,
				msg_object.senduid)
		except KeyError, e:
			headers = ( msg_object.date, msg_object.date_received,
				msg_object.headers["message-id"], None,
				msg_object.headers["subject"], from_to, msg_object.opts,
				msg_object.senduid)
		# save message
		self._save_article(headers, msg_object.body, msg_object.headers["message-id"])


