# Various message sorting methods

import utils
import string
from pyneheaders import *

def date_sort_pve(a, b):
	var_a = a[HEAD_DATE]
	var_b = b[HEAD_DATE]
	if var_a < var_b:
		return 1
	elif var_a > var_b:
		return -1
	else:
		return 0

def date_sort_nve(a, b):
	var_a = a[HEAD_DATE]
	var_b = b[HEAD_DATE]
	if var_a < var_b:
		return -1
	elif var_a > var_b:
		return 1
	else:
		return 0

def fromto_sort_pve(a, b):
	var_a = string.lower(utils.split_address(a[HEAD_FROM_TO])[0])
	var_b = string.lower(utils.split_address(b[HEAD_FROM_TO])[0])
	if var_a < var_b:
		return 1
	elif var_a > var_b:
		return -1
	else:
		return 0

def fromto_sort_nve(a, b):
	var_a = string.lower(utils.split_address(a[HEAD_FROM_TO])[0])
	var_b = string.lower(utils.split_address(b[HEAD_FROM_TO])[0])
	if var_a < var_b:
		return -1
	elif var_a > var_b:
		return 1
	else:
		return 0

def subject_sort_pve(a, b):
	var_a = a[HEAD_SUBJECT]
	var_b = b[HEAD_SUBJECT]
	if var_a < var_b:
		return 1
	elif var_a > var_b:
		return -1
	else:
		return 0

def subject_sort_nve(a, b):
	var_a = a[HEAD_SUBJECT]
	var_b = b[HEAD_SUBJECT]
	if var_a < var_b:
		return -1
	elif var_a > var_b:
		return 1
	else:
		return 0

# Tuple. (positive sort, negative sort)
sort_methods = {
	0: (subject_sort_pve, subject_sort_nve),
	1: (fromto_sort_pve, fromto_sort_nve),
	2: (date_sort_pve, date_sort_nve)
}

